/**
 * 报表内容控件
 */
function KEXTReport()
{
	var _arrSheet;
	var _funHyperlinkHandler;//联查回调函数
	var _oTabs;//报表的多页签
	var _arrFusionChartId = [];//图表id，用来移出已绘制图表
	var _arrScrollers;
	var _iMaxWidth = 0;
	var _iCurrentTabIdx = 0;
	var _subReportMap = {};
	var _treeDisplayMode;
	var _bClickZoom;
	
	/**
	 * 传入报表内容数据模型
	 * @param oJson JSON格式的内容
	 */
	this.setModel = function(oJson)
	{
		_bClickZoom = oJson.clickZoom;
		_treeDisplayMode = (oJson.treeDisplayMode || "EXPAND").toUpperCase();
		parseModel(oJson);	
		var oEmbedObjectRender = new MyEmbedObjectRender();
		_iMaxWidth = 0;
		for(var i = 0; i < getSheetCount(); i++)
		{
			var oSheet = getSheet(i);
			var iTableWidth = oSheet.getWidth();
			_iMaxWidth = (iTableWidth > _iMaxWidth ? iTableWidth : _iMaxWidth);
			
			var oTable = oSheet.getTable();
			oTable.setEmbedObjectRender(oEmbedObjectRender);
			oTable.addCellClickListener(cellClickHandler);
			if(_treeDisplayMode == "DRILL")
				var oTreeHandlerRender = new KTMobileTreeDrillHandlerRender(oTable);//下钻型控制器
			else
				var oTreeHandlerRender = new KTMobileTreeSpreadHandlerRender(oTable);//收展型控制器（三角）
			oTreeHandlerRender.setHandlerSize(18);
			oTable.setTreeHandlerRender(oTreeHandlerRender);
		}
	}
	
	/**
	 * 获取当前的滚动容器，jQuery封装，可以包多个dom对象
	 */
	this.getCurrentJqScroller = function()
	{
		return $(_arrScrollers);
	}
	
	/**
	 * 获取内容的宽度(多报表就是最宽的那张报表)
	 */
	this.getContentWidth = function()
	{
		return wrapMargin(_iMaxWidth);
	}
	
	/**
	 * 是否有列部分被截掉
	 */
	this.hasColumnBeCut = function()
	{
		for(var i = 0; i < getSheetCount(); i++)
		{
			var oSheet = getSheet(i);
			var oTable = oSheet.getTable();
			if(oSheet.getWidth() > 640  && oTable.getFrozenColumns() == 0)
			{
				return true;
			}
		}
		return false;
	}
	
	this.getCurrentSheetName = function(){
		return getSheet(_iCurrentTabIdx).getName();
	}
	/**
	 * 将要展示的报表内容放置在指定的owner对象中
	 * @param jqOwner 一个jQuery封装的html元素
	 */
	this.draw = function(jqOwner, iContainerWith, isSubReport)
	{
		var iContentWidth = (this.getContentWidth() > 320 ? this.getContentWidth() : 320);
		_arrScrollers = [];
		//var isZoom = function(){
		//	return (oTable.getFrozenColumns() == 0)&&!isSubReport;
		//}
		//多页签
		if(isMultiTab() && !isSubReport)
		{
			_oTabs = new KEXTReport.MultiTabsCtrl();
			jqOwner.append(_oTabs.getUI());
			_oTabs.setTabSwitchListener(doTabSwitch);
			_oTabs.setPageWidth(Math.max(iContentWidth, KEXTUtil.getDeviceWidth()));
			_oTabs.setDeviceWidth(KEXTUtil.getDeviceWidth());
			for(var i = 0; i < getSheetCount(); i++)
			{
				var oSheet = getSheet(i);
				var oTable = oSheet.getTable();
				var isZoom = oTable.getFrozenColumns() == 0 && !isSubReport;
				var jqMiddleLayer = decorateTable(oTable, oSheet.getWidth(), isZoom, isSubReport);
		
				jqMiddleLayer.width(iContainerWith);
				_oTabs.addTab(oSheet.getName(), jqMiddleLayer, oSheet.getColor());
				var bFrozenCol = KEXTUtil.hasEnterFromStatus([KEXTUtil.CONSTANTS.Enter_From_Preview]) && oTable.getFrozenColumns() > 0;
				oTable.setScrollerVisible(isZoom ? "hidden" : "auto", "auto", createCustomScrollerDefine(_oTabs.getContentsView(), bFrozenCol));
			}
			_oTabs.updateUI(_lastTabIdx);
		}
		else
		{
			var oSheet = getSheet(0);
			var oTable = oSheet.getTable();
			var isZoom = oTable.getFrozenColumns() == 0 && !isSubReport;
			var jqMiddleLayer = decorateTable(oTable, oSheet.getWidth(), isZoom, isSubReport);
			jqMiddleLayer.css("right", "");//改成指定宽度（足够宽），让容器裁掉它，从而不出现横向滚动。（表格的overflow-x不起作用）
			jqMiddleLayer.width(iContainerWith);
			jqOwner.append(jqMiddleLayer);
			var bFrozenCol = KEXTUtil.hasEnterFromStatus([KEXTUtil.CONSTANTS.Enter_From_Preview]) && oTable.getFrozenColumns() > 0;
			oTable.setScrollerVisible(isZoom ? "hidden" : "auto", "auto", createCustomScrollerDefine(jqOwner, bFrozenCol));
			oTable.updateUI();
		}
	}
	
	var _lastTabIdx;
	var doTabSwitch = function(iTabIndex)
	{	
		getSheet(iTabIndex).updateUI();
		_lastTabIdx = iTabIndex;
		_iCurrentTabIdx = iTabIndex;
	}
	
	var wrapMargin = function(iWidth)
	{
		return iWidth;//两边留白6px;
	}

	var _iLastMouseDownTime = 0;
	var _arrLastMouseDownPosition = [-0xffff, -0xffff];	
	var _iZoomLevel = 1;
	var initialScale = 1;
	var currentScale;
	var isMoving = false;
	var decorateTable = function(oTable, iSheetWidth, bZoom, bSubReport)
	{	
		var jqTable = $(oTable.getUI());
		if(!bSubReport)
		{
			jqTable.css(
				{
					marginLeft: "6px",
					marginRight: "6px"
				});
			var getZoomLevel = function(){
				if(_iZoomLevel < 2)
				{
					_iZoomLevel = _iZoomLevel + 0.5;
				}
				else
				{
				
					_iZoomLevel = 1;
				}
				return _iZoomLevel;
			}
			iSheetWidth = wrapMargin(iSheetWidth);
			iSheetWidth = (iSheetWidth < 308 ? 308 : (iSheetWidth > 640 ? 640 : iSheetWidth));
			var iViewWidth = 0;
			if(bZoom)
			{		
				iViewWidth = 308;//fix云之家4.2.2，否则直接用jqOwner.width()（正常的话它应该就是320）。
			}
			else
			{
				iViewWidth = iSheetWidth;
			}
			zoomToFitWidth(jqTable, iSheetWidth, iViewWidth);
			
			jqTable[0].addEventListener('touchmove',function(evt){
				isMoving = true;
			});
			jqTable[0].addEventListener('touchend',function(evt){
				if(!_bClickZoom)
					return;
				
				var iTimeDiff = new Date().getTime() - _iLastMouseDownTime;
				if(!isMoving && iTimeDiff > 100 && iTimeDiff< 500 && jqTable[0].firstChild.scrollLeft == _arrLastMouseDownPosition[0] && jqTable[0].firstChild.scrollTop == _arrLastMouseDownPosition[1])
				{ 
					var iBeforeZoomLevel = _iZoomLevel;
					_iLastMouseDownTime = 0; 
					console.log("scrollTop_beforeZoom= "+jqTable[0].firstChild.scrollTop);
					zoomTo(jqTable, iSheetWidth, iViewWidth, getZoomLevel());						
					var iNoname = _iZoomLevel/iBeforeZoomLevel;
					var iName = iViewWidth/iSheetWidth;
				
					var iY = evt.changedTouches[0].pageY - jqTable.offset().top;
				
					var iX = evt.changedTouches[0].pageX;
					if(_iZoomLevel == 1.5 )
						var iTop = (iY * iNoname - iY)/(iNoname * iName);
					else if(_iZoomLevel == 2)
						var iTop = (iY * iNoname - iY)/iNoname;
					else if(_iZoomLevel == 1)
						var iTop = (iY * iNoname - iY)*(1.5);
					
				/*	var iTop = iY * (iNoname - 1);
					var iTop = (evt.changedTouches[0].pageY - 45) * iNoname - evt.changedTouches[0].pageY;
					alert($(window).height()-jqTable.parent().height())
					var iTop = (iNoname * evt.changedTouches[0].pageY -45 - evt.changedTouches[0].pageY)/(iNoname*iName);
					var iTop = (evt.changedTouches[0].pageY - 45) * iNoname - evt.changedTouches[0].pageY;*/
					var iLeft = iX * (iNoname - 1);
					jqTable[0].firstChild.scrollTop = jqTable[0].firstChild.scrollTop + iTop;	
					jqTable[0].firstChild.scrollLeft = jqTable[0].firstChild.scrollLeft + iLeft;	
				}
				else
				{
					
					_iLastMouseDownTime = new Date().getTime();
					//console.log("_iLastMouseDownTime2 = "+_iLastMouseDownTime);
					_arrLastMouseDownPosition = [jqTable[0].firstChild.scrollLeft, jqTable[0].firstChild.scrollTop];
				}
				isMoving = false;
				
				if(_iZoomLevel > 1)
				{
					oTable.setScrollerVisible("auto", "auto");
				}
				else
				{
					var isZoom = oTable.getFrozenColumns() == 0 && !bSubReport;
					oTable.setScrollerVisible(isZoom ? "hidden" : "auto", "auto");
				}
			});
		}
		var jqMiddleLayer = $("<div/>");
		jqMiddleLayer.css(
			{
				position:"absolute",
				top:"4px",
				bottom:"4px",
				left:"0px",
				right:"0px"
			});
		jqMiddleLayer.append(jqTable);
		jqMiddleLayer.bind('mousedown', 
			function(event)
			{
				event.preventDefault();
			});
		return jqMiddleLayer;
	}	
	var zoomToFitWidth = function(jqTarget, iRealWidth, iViewWidth, fFingerZoom)
	{
		var fZoom = iViewWidth / (iRealWidth + 1);
		if(fFingerZoom)
		{
			fZoom = fZoom * fFingerZoom;
		}
		
		jqTarget.css("-webkit-transform", "scale(" + fZoom + ")");
		jqTarget.css("-webkit-transform-origin", "left top");

		var fReciprocal = 1 / fZoom;
		jqTarget.css("position", "absolute");
		jqTarget.css("left", 0);
		jqTarget.css("top", 0);
		jqTarget.css("width", 308 * fReciprocal + "px");
		jqTarget.css("height", fReciprocal * 100 + "%");
	};
	var zoomTo = function(jqTarget, iRealWidth, iViewWidth, fFingerZoom)
	{
		var fZoom = iViewWidth / (iRealWidth + 1);
		if(fFingerZoom)
		{
			fZoom = fZoom * fFingerZoom;
		}
		jqTarget.css("-webkit-transform", "scale(" + fZoom + ")");
		jqTarget.css("-webkit-transform-origin", "left top");
		
		var fReciprocal = 1 / fZoom;
		jqTarget.css("position", "absolute");
		jqTarget.css("left", 0);
		jqTarget.css("top", 0);
		jqTarget.css("width", 308 * fReciprocal + "px");
		jqTarget.css("height", fReciprocal * 100 + "%");
		
		getSheet(_iCurrentTabIdx).getTable().relayoutViews();
	}

	var zoomToOrinWidh = function(jqTarget)
	{
		jqTarget.css("-webkit-transform", "");
		jqTarget.css("width", "100%");
		jqTarget.css("height", "100%");
	}

	//自定义滚动条
	var createCustomScrollerDefine = function(jqScrollbarParent, bFrozenCol)
	{
		return function(jqRealScrollTarget)
		{
			KEXTUtil.setSimScrollbar(jqRealScrollTarget, jqScrollbarParent, bFrozenCol);
			_arrScrollers.push(jqRealScrollTarget[0]);
		};
	};
	
	/**
	 * 回收内存
	 */
	this.destroy = function()
	{
		_oReport = null;
		
		//清除fusionchart已绘制图表
		for(var i = 0; i < _arrFusionChartId.length; i++)
		{
			FusionCharts(_arrFusionChartId[i]).dispose();
		}
		_arrFusionChartId.length = 0;
	}
	
	/**
	 * 设置联查回调函数
	 * funListener(sReportName, sRreportTag, oParamValues)
	 */
	this.setHyperlinkListener = function(funListener)
	{
		_funHyperlinkHandler = funListener;
	}
	this.getTreeDisplayModel = function()
	{
		return _treeDisplayMode;
	}
	/** 是否为多页签 */
	var isMultiTab = function()
	{
		return getSheetCount() > 1;
	}

	var getSheetCount = function()
	{
		return (_arrSheet ? _arrSheet.length : 0);
	}
	
	var getSheet = function(iSheetIndex)
	{
		return _arrSheet[iSheetIndex];
	};
	
	var parseModel = function(oJsonReportInfo)
	{
		_arrSheet = [];
		var arrJsonSheets = oJsonReportInfo["sheetList"];
		var arrSheetColor = oJsonReportInfo["sheetColorList"];
		for(var i = 0; i < arrJsonSheets.length; i++)
		{
			var oSheet = new KEXTReport.Sheet();
			oSheet.setColor(arrSheetColor[i]);
			oSheet.parseModel(arrJsonSheets[i], _treeDisplayMode);
			_arrSheet.push(oSheet);
		}	
	};
		
	/** 图表绘制器 */
	var MyEmbedObjectRender = function()
	{
		KTDefaultEmbedObjectRender.call(this);
		this.paintEmbedObject = function(oEmbedObject, jqOwner)
		{
			var oUserObject = oEmbedObject.getUserObject();
			if(oEmbedObject.getType() == "imageChart")
			{
				var sImg = '<img src="';
				sImg += oUserObject["dataSrc"];
				sImg += '" alt="图片不存在"';
				sImg += ' width="' + oEmbedObject.getWidth() + '"';
				sImg += ' height="' + oEmbedObject.getHeight() + '"';
				sImg += '>';
				$(sImg).appendTo(jqOwner);
			}
			else if(oEmbedObject.getType() == "flashChart")
			{
				paintChartsWithHtml5(oEmbedObject, oUserObject, jqOwner);
			}
			else if(oEmbedObject.getType() == "subReport")
			{
				paintSubReport(oEmbedObject, oUserObject, jqOwner);
			}
		};
		var paintSubReport = function(oEmbedObject, userObject, jqOwner)
		{
			jqOwner.empty();
		//	var subReport = new KEXTReport();	
			var subReport;
			if(!_subReportMap[userObject.name])
			{
				subReport = new KEXTReport();
				_subReportMap[userObject.name] = subReport;
			}
			else
			{
				subReport = _subReportMap[userObject.name];
			}
			jqOwner.css({left: oEmbedObject.getX(), top: oEmbedObject.getY(), 
							width: oEmbedObject.getWidth(), height: oEmbedObject.getHeight(), zIndex:129});			
			subReport.setHyperlinkListener(_funHyperlinkHandler);
			subReport.setModel(userObject.reportInfo);
			subReport.draw(jqOwner, oEmbedObject.getWidth(), true);	
			
		}
		var paintChartsWithHtml5 = function(oEmbedObject, oUserObject, jqOwner)
		{
			jqOwner.on("click", function(){});//fix部分android点击时高亮画偏
			var sOwnerId = jqOwner.attr("id");
			var sChartId = "kext_chart_" + sOwnerId;
			var oChart =  FusionCharts(sChartId);
			if(oChart)
			{
				oChart.setXMLData(oUserObject["dataSource"]);
			}
			else
			{
				oChart = new FusionCharts(
					{
			            id: sChartId, 
						type: oUserObject["type"],
						dataSource: oUserObject["dataSource"],
						dataFormat: 'XML',
						width : oEmbedObject.getWidth(),
						height : oEmbedObject.getHeight()
					});
				
				jqOwner.css(
					{
						left: oEmbedObject.getX(), 
						top: oEmbedObject.getY(), 
						width: oEmbedObject.getWidth(), 
						height: oEmbedObject.getHeight()
					});
				_arrFusionChartId.push(sChartId);		
				
			}
			oChart.render(sOwnerId);
			jqOwner.children().children().css({
				left:0,
				top:0
			})
		};
	};
	this.ChartsLinkHandler = function(rev)
	{
	/*	data.pageId = _pageId;
		$.ajax({ 
			type: "POST", 
			url: Constant.cloudURL + "/", 
			async: false,
			data: data, 
			success: function(rev){*/
				if(rev)
				{ 
					var oTable = getSheet(_iCurrentTabIdx).getTable();
					if(rev.linkType == "innerLink")
					{					
						var embedObjects = oTable.getEmbedObjects();
						var bSyncUI = oTable.isSyncUIWhenModelChanged()
						oTable.setSyncUIWhenModelChanged(true);
						for(var j = 0;j<rev.embedDatas.length;j++)
						{
							for(var i =0;i<embedObjects.length;i++)
							{
								var userObject = embedObjects[i].getUserObject();
								if(rev.embedDatas[j].linkTo == userObject.name)
								{
									if(embedObjects[i].getType()== "subReport")
									{
										userObject.reportInfo = rev.embedDatas[j].embedData;
										if(!userObject.reportInfo)
											return;									
										embedObjects[i].setUserObject(userObject);
									
									}
									else if(embedObjects[i].getType()== "flashChart")
									{									
										userObject.dataSource = rev.embedDatas[j].embedData;
										embedObjects[i].setUserObject(userObject);
									
									}
								}
							}
						}
						oTable.setSyncUIWhenModelChanged(bSyncUI);
					}
					else if(rev.linkType == "outterLink")
					{
						var iDefaultIndex = 0;
						var arrHyperLink = rev.hyperLinks;
						for (var i = 0; i < arrHyperLink.length; i++) 
						{
							if (arrHyperLink[i]["defaultLink"]) 
							{
								iDefaultIndex = i;
								break;
							}
						}
						var oHyperLink = arrHyperLink[iDefaultIndex];
						var sReportId = oHyperLink["reportId"];
						var oParamValues = transformHyperlinkParams(oHyperLink["paramValues"]);
						var sReportName = oHyperLink["reportName"];
						var sReportAlias = oHyperLink["reportAlias"];
						var sSystemId = oHyperLink["systemId"];
						var sDomain = oHyperLink["domain"];
						var oReportTag = 
						{
							"reportId": sReportId,
							"reportName": sReportName,
							"systemId": sSystemId,
							"domain": sDomain
						};
						var sReportTag = JSON.stringify(oReportTag);
						_funHyperlinkHandler(sReportAlias, sReportTag, oParamValues);
					}
				}
	//		}
	//	});
	}	
	/**
	 * 单元格点击事件处理
	 */
	var cellClickHandler = function(sType, oEvent)
	{
		var oCell = oEvent.getCell();
		if(!oCell || !oCell.getUserObject())
		{
			return;
		}
		
		var linkModels = oCell.getUserObject();
		if(typeof linkModels == "string" && linkModels.indexOf("callTo:") == 0)
		{
			handlerPhoneCall(oCell, linkModels);
			return;
		}
		
		var iDefaultIndex = 0;
		for(var j = 0; j < linkModels.length; j++)
		{
			if(linkModels[j].linkType == "outterLink" || linkModels[j].linkType == "billLink")
			{
				var arrHyperLink = linkModels[j].hyperLinks;
				for (var i = 0; i < arrHyperLink.length; i++) 
				{
					if (arrHyperLink[i]["defaultLink"]) 
					{
						iDefaultIndex = i;
						break;
					}
				}
				
				var oHyperLink = arrHyperLink[iDefaultIndex];
				var sReportId = oHyperLink["reportId"];
				var oParamValues = transformHyperlinkParams(oHyperLink["paramValues"]);
				var sReportName = oHyperLink["reportName"];
				var sReportAlias = oHyperLink["reportAlias"];
				var sSystemId = oHyperLink["systemId"];
				var sDomain = oHyperLink["domain"];
				var oReportTag = 
				{
					"reportId": sReportId,
					"reportName": sReportName,
					"systemId": sSystemId,
					"domain": sDomain
				};
				var sReportTag = JSON.stringify(oReportTag);
				_funHyperlinkHandler(sReportAlias, sReportTag, oParamValues);
				break;
			}
			else if(linkModels[j].linkType == "innerLink")
			{
				linkModels[j].srcType = "cell";
				KEXTInnerLinkController.excuteInnerLink(linkModels[j]);
			}
		}
	};
	
	var handlerPhoneCall = function(oCell, linkModels)
	{
		var sPhoneNum = linkModels.split(":")[1];
		if(!sPhoneNum)
			sPhoneNum = oCell.getValue();
			
		if(sPhoneNum)
		{
			var jqSpan = $("<span />");
			var jqHref = $("<a href='tel:" + sPhoneNum + "'></a>");
			jqHref[0].appendChild(jqSpan[0]);
			getSheet(_iCurrentTabIdx).getTable().getUI().appendChild(jqHref[0]);
			jqSpan.click();
			jqHref[0].remove();
		}
	}
	
	//生成过滤器认识的参数值模型对象
	var transformHyperlinkParams = function(oSrcLinkParamValues)
	{
		var sTempValues;
		var arrTempValue;
		var oMapParam = {};
		var oParamsValues = new KEXTParamsValues();
		for(var i = oSrcLinkParamValues.length - 1; i >= 0 ; i--)
		{
			var oSrcLinkParam = oSrcLinkParamValues[i];
			oMapParam[oSrcLinkParam["name"]] = oSrcLinkParam["values"];
			var iPos = oSrcLinkParam["name"].indexOf("_text"); //带_text参数的值，是不带_text参数的显示值
			if(iPos < 0)
				sTempValues = oMapParam[oSrcLinkParam["name"] + "_text"];
			if(oSrcLinkParam["values"])
			{
				var arrSrcValue = oSrcLinkParam["values"].split(/\1/);
				if(sTempValues && iPos <=0)
				{
					arrTempValue = sTempValues.split(/\1/);
					sTempValues = null;
				}
				for(var j = 0; j < arrSrcValue.length; j++)
				{
					var oValueTextModel = new KEXTValueTextModel();
					if(arrTempValue && arrTempValue[j])
						oValueTextModel.setText(arrTempValue[j]);
					else
						oValueTextModel.setText(arrSrcValue[j]);
					oValueTextModel.setValue(arrSrcValue[j]);
					oParamsValues.addValue(oSrcLinkParam["name"], oValueTextModel);
				}
			}
			else
			{
				if(sTempValues && iPos <=0)
				{
					arrTempValue = sTempValues.split(/\1/);
					sTempValues = null;
					if(arrTempValue)
					{
						for(var j = 0; j < arrTempValue.length; j++)
						{
							var oValueTextModel = new KEXTValueTextModel();
							if(arrTempValue[j])
							{
								oValueTextModel.setText(arrTempValue[j]);
								oValueTextModel.setValue(arrTempValue[j]);
							}
							oParamsValues.addValue(oSrcLinkParam["name"], oValueTextModel);
						}
					}
				}
				else
				{
					var oValueTextModel = new KEXTValueTextModel();
					oValueTextModel.setText("");
					oValueTextModel.setValue("");
					oParamsValues.addValue(oSrcLinkParam["name"], oValueTextModel);
				}
			}
			arrTempValue = null;
		}
		return oParamsValues;
	};
}


KEXTReport.MultiTabsCtrl = function()
{	
	var _arrCaptions = [];
	var _arrJqContents = [];
	var _arrColor = [];
	var _iDeviceWidth;//设备宽度，用来算页签头的位置。
	var _iPageWidth;//所有页签内容宽度的最大值，它可能大于_iDeviceWidth，“足够宽”使表格不出横向滚动条。
	
	//双测按钮
	var _jqLeftBtn;
	var _jqRightBtn;
	var _iCurPage = 0;//当前页签
	var _iLFirstIdx = 0;//左侧显示第一页签
	
	var _jqParentContainer;
	var _jqTabsContainer;
	var _jqNavLabel;
	var _jqTabsUl;
	var _jqContentsContainer;
	
	var _funTabSwitchListener;
	
	
	(function()
	{
		/** 总容器(包含页签头和内容区) */
		_jqParentContainer = $("<div>");
		_jqParentContainer.css(
			{
				position:"relative",
				width:"100%",
				height:"100%",
				overflow:"hidden"
			});
		
		/** 页签头 */
		_jqTabsContainer = $("<div>");
		_jqTabsContainer.css(
			{
				position: "relative",
				height: "40px",
				borderBottom: "1px solid #ccc",
				backgroundColor: "#fff",
				overflow: "hidden"
			});
		_jqTabsContainer.appendTo(_jqParentContainer);
		//导航标签
		_jqNavLabel = $("<div>").appendTo(_jqTabsContainer);
		_jqNavLabel.css(
			{
				position: "absolute",
				height: "41px"
			});
		$("<span>").css(
			{
				width: "100%",
				height: "3px",
				backgroundColor: "#2773B4",
				position: "absolute",
				bottom: 0
			}).appendTo(_jqNavLabel);
		//tabs
		_jqTabsUl = $("<ul>").appendTo(_jqTabsContainer);
		_jqTabsUl.css(
			{
				position: "absolute",
				left: 0,
				top: 0,
				width: "100%",
				height: "100%",
				listStyle: "none",
				margin:0,
				padding:0,
				color: "#727A82",
				whiteSpace: "nowrap"
			});
		
		
		/** 内容区 */
		_jqContentsContainer = $("<div>");
		_jqContentsContainer.css(
			{
				position: "absolute",
				height: "100%"
			});
		
		var jqContentsView = $("<div>");
		jqContentsView.css(
			{
				position: "absolute",
				top: "41px",
				bottom: "0px",
				left: "0px",
				width: "100%",
				overflow: "hidden"
			});
		jqContentsView.append(_jqContentsContainer);
		jqContentsView.appendTo(_jqParentContainer);
		jqContentsView.bind('mousedown', 
			function(event)
			{
				event.preventDefault();
			});
	})();
	
	this.addTab = function(sName, jqContent, sColor)
	{
		_arrCaptions.push(sName);
		_arrJqContents.push(jqContent);
		_arrColor.push(sColor);
	}
	
	//funAction 页签切换回调函数 形如funAction(iTabIndex);
	this.setTabSwitchListener = function(funAction)
	{
		_funTabSwitchListener = funAction;			
	}
	
	/** 更新界面 */
	this.updateUI = function(lastTabIdx)
	{
		if (lastTabIdx>=0)
		{
			_iCurPage = lastTabIdx;
		}
		else
		{
			_iCurPage = 0;
		}
		_jqTabsUl.children().remove();
		_jqContentsContainer.children().remove();
		if(_jqLeftBtn)
		{
			_jqLeftBtn.remove();
			_jqRightBtn.remove();	
		}
		
		var iTabCount = _arrCaptions.length;
		var iLiWidth = _iDeviceWidth / iTabCount;
		if(iTabCount > 3)
		{
			iLiWidth = (_iDeviceWidth - 50) / 3; //25为暂定宽度
			_jqLeftBtn = $("<div><<</div>");
			_jqTabsContainer.append(_jqLeftBtn);
			_jqLeftBtn.css(
				{
					position: "absolute",
					height: "42px",
					display: "none",
					width: "25px",
					lineHeight: "42px",
					textAlign: "center",
					top: 0,
					backgroundColor: "#fff"
				});
			_jqLeftBtn.click(innerBtnLeftHandler);
			_jqRightBtn = $("<div>>></div>");
			_jqTabsContainer.append(_jqRightBtn);
			_jqRightBtn.css(
				{
					position: "absolute",
					height: "42px",
					width: "50px",
					lineHeight: "42px",
					textAlign: "center",
					right: 0,
					top: 0,
					backgroundColor: "#fff"
				});
			_jqRightBtn.click(innerBtnRightHandler);
			if(_iLFirstIdx == iTabCount - 3)//右侧状态
			{
				_jqLeftBtn.css(
					{
						width: '50px',
						display: 'block'
					});
				_jqRightBtn.css('display', 'none');
			}
			if(_iLFirstIdx > 0 && _iLFirstIdx < iTabCount - 3)//中间状态
			{
				_jqLeftBtn.css('display', 'block');
				_jqRightBtn.css('width', '25px');
			}
			//console.log('_iLFirstIdx' + _iLFirstIdx + '>>>' + '_iCurPage' + _iCurPage);
		}
		for(var i = 0; i < iTabCount; i++)
		{
			var jqLi = $("<li class='tabTitle'>");
			jqLi.text(_arrCaptions[i]);
			jqLi.css(
				{
					margin:0,
					display: "inline-block",
					lineHeight: "40px",
					textAlign: "center",
					overflow: "hidden",//保证省略号出现
					whiteSpace: "nowrap",
					textOverflow: "ellipsis",
					transition: "color 100"//颜色渐变css3支持
				});
			_jqTabsUl.append(jqLi);
			jqLi.width(iLiWidth);
			jqLi.prop('pageIdx', i);
			jqLi.click(
				function()
				{
					_iCurPage = $(this).prop('pageIdx');
					_jqNavLabel.css('width', iLiWidth);
					innerSwitchPage();
					_funTabSwitchListener(_iCurPage);
				});
			
			var jqContent = _arrJqContents[i];
			var jqDiv = $("<div>");
			jqDiv.append(jqContent);
			jqDiv.css(
				{
					position: "relative",
					height: "100%",
					display: "inline-block"
				});
			_jqContentsContainer.append(jqDiv);
			jqDiv.width(_iPageWidth);
		}
		
		if(!_jqNavLabel.width())
		{
			_jqNavLabel.width(iLiWidth);
		}
		_jqContentsContainer.width(_iPageWidth * iTabCount);
		innerSwitchPage();
		_funTabSwitchListener(_iCurPage);
	};
	
	//内部接口
	var innerBtnRightHandler = function()
	{
		var iPageCount = _arrCaptions.length;
		var iLiWidth = (_iDeviceWidth - 50) / 3;
		// 标志位移动
		if(_iLFirstIdx < iPageCount - 3)
		{
			_iLFirstIdx++;
		}
		//调整当前页(第一种策略)
		/* 用来调整游标 */
		if(_iCurPage < _iLFirstIdx)
		{
			//_iCurPage = _iLFirstIdx;//第一种策略
			if(_iLFirstIdx == iPageCount - 3)
			{
				_jqNavLabel.css('width', '50px');	
			}
			else
			{
				_jqNavLabel.css('width', '25px');
			}
			_jqNavLabel.animate({left: 0}, 100);
		}
		else if(_iCurPage > _iLFirstIdx + 2 && _iLFirstIdx == 1)//在左侧刚启动,并且游标在右侧
		{
			_jqNavLabel.css('width', '25px');
			_jqNavLabel.animate({left: _iDeviceWidth - _jqNavLabel.width()}, 100);
		}
		else
		{
			_jqNavLabel.css('width', iLiWidth);
		}
		//两侧按钮状态
		_jqLeftBtn.css('display', 'block');
		_jqRightBtn.css('width', '25px');
		if(_iLFirstIdx == iPageCount - 3)
		{
			_jqLeftBtn.css('width', '50px');
			_jqRightBtn.css('display', 'none');
		}
		//调整页签
		var iUlLeft = parseInt(_jqTabsUl.css('left'));
		if(_iLFirstIdx == iPageCount - 3)//右边到头
		{
			_jqTabsUl.css("left", (iUlLeft - iLiWidth + (iPageCount == 4 ? 50 : 25) + "px"));
		}
		else if(_iLFirstIdx == 1)//刚起步
		{
			_jqTabsUl.css("left", (25 - iLiWidth) + "px");
		}
		else
		{
			_jqTabsUl.css("left", (iUlLeft - iLiWidth) + "px");
		}
		//调整内容
		innerSwitchPage();
	}
	
	var innerBtnLeftHandler = function()
	{
		var iPageCount = _arrCaptions.length;
		var iLiWidth = (_iDeviceWidth - 50) / 3;
		//标志位移动
		if(_iLFirstIdx > 0)
		{
			_iLFirstIdx--;
		}
		//调整当前页(第一种策略)
		/* 用来调整游标 */
		if(_iCurPage > _iLFirstIdx + 2)
		{
			//_iCurPage= _iLFirstIdx + 2;//第一种策略
			if(_iLFirstIdx == 0)
			{
				_jqNavLabel.css('width', '50px');	
			}
			else
			{
				_jqNavLabel.css('width', '25px');
			}
			_jqNavLabel.animate({left: _iDeviceWidth - _jqNavLabel.width()}, 100);
		}
		else if(_iCurPage < _iLFirstIdx)
		{
			_jqNavLabel.css('width', '25px');
		}
		else
		{
			_jqNavLabel.css('width', iLiWidth);
		}
		//两侧按钮状态
		_jqRightBtn.css('display', 'block');
		_jqLeftBtn.css('width', '25px');
		if(_iLFirstIdx == 0)
		{
			_jqLeftBtn.css('display', 'none');
			_jqRightBtn.css('width', '50px');
		}
		//调整页签
		var iUlLeft = parseInt(_jqTabsUl.css('left'));
		if(_iLFirstIdx == 0)//左边到头
		{
			_jqTabsUl.css("left", 0);
		}
		else if(_iLFirstIdx == iPageCount - 4)//刚起步
		{
			_jqTabsUl.css("left", (iUlLeft + iLiWidth - 25) + "px");
		}
		else
		{
			_jqTabsUl.css("left", (iUlLeft + iLiWidth) + "px");
		}
		//调整内容
		innerSwitchPage();
	}
	/**
	 * 此方法公用、慎改
	 */
	var innerSwitchPage = function()
	{//3个以内的多页签也会使用这个，所以这里不允许使用 变量
		//console.log('切换页签' + _iCurPage);
		var iSheetContainerPositionX = _iCurPage * _iPageWidth;
		_jqContentsContainer.animate({left: 0 - iSheetContainerPositionX}, 100);
		
		var fontColor = "#727A82";
		var jqLis = _jqTabsUl.children();
		for(var i = 0, iTabCount = jqLis.length; i < iTabCount; i++)
		{
			if(i != _iCurPage)
			{
				var jqLi = $(jqLis[i]);
				if(KEXTCommonUtil.isDarkColor(_arrColor[i]))
					fontColor = "#fff";
				else
					fontColor = "#727A82";
				jqLi.css("color", fontColor);
				jqLi.css("backgroundColor", _arrColor[i]);
			}
		}
		
		fontColor = "#2773B4";
		if(_arrColor[_iCurPage])
		{
			fontColor = _arrColor[_iCurPage];
		}
		
		//jqLis.css("color", "#727A82");
		var jqLi = $(jqLis[_iCurPage]);
		jqLi.css("color", fontColor);
		jqLi.css("backgroundColor", "");
		var iUloffsetL = _jqTabsUl[0].offsetLeft;
		if(_iCurPage <= _iLFirstIdx + 2 && _iCurPage >= _iLFirstIdx)
		{
			_jqNavLabel.animate({left: iUloffsetL + jqLi[0].offsetLeft}, 100);
			_jqNavLabel.find("span").css("backgroundColor", fontColor);
		}
	}
	
	this.getUI = function()
	{
		return _jqParentContainer;
	};
	
	this.getContentsView = function()
	{
		return _jqContentsContainer.parent();
	};
	
	this.setPageWidth = function(iPageWidth)
	{
		_iPageWidth = iPageWidth;
	};
	
	this.setDeviceWidth = function(iDeviceWidth)
	{
		_iDeviceWidth = iDeviceWidth;
	}
}

KEXTReport.Sheet = function()
{
	var _sName;
	var _oTable;
	var _bPainted;
//	var _iTableRowCount;
//	var _iCurrentLoadedRowNum;
	var _iSheetWidth;
	var _sColor;
	
	this.getTable = function()
	{
		return _oTable;
	};
	
	this.getWidth = function()
	{
		return _iSheetWidth;
	};
	
	this.getName = function()
	{
		return _sName;
	};
	
	this.setColor = function(sColor)
	{
		_sColor = sColor;
	}
	
	this.getColor = function()
	{
		return _sColor;
	}
	
	this.updateUI = function()
	{
		if (!_bPainted) 
		{
			_bPainted = true;
			_oTable.updateUI();
		}
	};
	
	this.parseModel = function(oJsonSheet, treeDisplayMode)
	{
//		this.setLoadedRowNum(oJsonSheet.tableFragment.currentLoadedRowNum);
//		setTableRowCount(oJsonSheet["tableRowCount"]);
		_sName = oJsonSheet["name"];
		
		_oTable = new KTable();
		if(treeDisplayMode == "DRILL")
		{
			_oTable.addTreeStateChangedListener(treeDrillExpandHandler);
		}
		_oTable.setSyncUIWhenModelChanged(false);
		_oTable.setSyncMergeBlockWhenModelChanged(false);
		buildTable(oJsonSheet, _oTable);
	};
	
//	this.isNeedLoadTable = function()
//	{
//		//因为加载行是从0算起的，故结束条件+1
//		return (this.getLoadedRowNum() + 1) != this.getTableRowCount();
//	};

	/** 构建表格 */
	var buildTable = function(oJsonSheet, oTable)
	{
		//设置样式，表格的全局设置都放在sheet中，故在这里初始话
		if(oJsonSheet["tableStyle"])
		{
			oTable.setStyle(parseStyle(oJsonSheet["tableStyle"]));
		}
		if(oJsonSheet["tableBorder"])
		{
			oTable.setBorder(parseBorder(oJsonSheet["tableBorder"]));
		}
		
		//设置冻结
		if(oJsonSheet["header"])
		{
			oTable.setFrozenRows(oJsonSheet["header"]["row"]);
			oTable.setFrozenColumns(oJsonSheet["header"]["col"]);
		}
		//设置行高自适应
		oTable.setAutoAdjustRowHeight(oJsonSheet["resized"]);
		
		var oJsonTable = oJsonSheet["tableFragment"];
		buildColumn(oJsonTable, oTable);
		buildRow(oJsonTable, oTable, oJsonSheet["tree"]);
		buildEmbedChart(oJsonTable, oTable);
		buildMergeBlock(oJsonSheet, oTable);
	};
	
	/** 构建融合块 */
	var buildMergeBlock = function(oJsonSheet, oTable)
	{
		var arrJsonMergeBlocks = oJsonSheet["mergeBlocks"];
		if(arrJsonMergeBlocks)
		{
			for(var i = 0; i < arrJsonMergeBlocks.length; i++)
			{
				var oJsonMergeBlock = arrJsonMergeBlocks[i];
				var iRowFrom = oJsonMergeBlock["rowFrom"];
				var iRowTo = oJsonMergeBlock["rowTo"];
				var iColFrom = oJsonMergeBlock["colFrom"];
				var iColTo = oJsonMergeBlock["colTo"];
				var oMergeBlock = new KTMergeBlock(iRowFrom, iRowTo, iColFrom, iColTo);
				oTable.addMergeBlock(oMergeBlock);
			}
		}
	};
	
	/** 构建列 */
	var buildColumn = function(oJsonTable, oTable)
	{
		var arrJsonCols = oJsonTable["colList"];
		var iTableWidth = 0;
		if(arrJsonCols)
		{
			for(var i = 0; i < arrJsonCols.length; i++)
			{
				var oJsonCol = arrJsonCols[i];
				var oCol = oTable.addColumn();
				
				oCol.setWidth(oJsonCol["width"]);
				oCol.setHide(oJsonCol["hided"]);
				if(!oJsonCol["hided"])
				{
					iTableWidth += oJsonCol["width"];// + 1; 去掉+1 因为重复加1导致报表宽度计算有误报表右边出现空白
				}
				if(oJsonCol["style"])
				{
					oCol.setStyle(parseStyle(oJsonCol["style"]));
				}
				if(oJsonCol["border"] && oJsonCol["border"] != "null")
				{
					oCol.setBorder(parseBorder(oJsonCol["border"]));
				}
			}
		}
		_iSheetWidth = iTableWidth + 1;
	};
	
	/** 构建行 */
	var buildRow = function(oJsonTable, oTable, bHasTree)
	{
		var arrJsonRows = oJsonTable["rowList"];
		if(arrJsonRows)
		{
			for(var i = 0; i < arrJsonRows.length; i++)
			{
				var oJsonRow = arrJsonRows[i];
				var oRow = oTable.addRow();
				
				oRow.setHeight(oJsonRow["height"]);
				oRow.setHide(oJsonRow["hided"]);
				if(oJsonRow["style"])
				{
					oRow.setStyle(parseStyle(oJsonRow["style"]));
				}
				if(oJsonRow["border"] && oJsonRow["border"] != "null")
				{
					oRow.setBorder(parseBorder(oJsonRow["border"]));
				}
				
				if(oJsonRow["cellList"])
				{
					buildCell(oJsonRow, oRow);
				}
				if(bHasTree)
				{
					//如果是树将此行的原始idx reserve
					oRow.setUserObject(oJsonRow["index"]);
				}
			}
		}
	};

	/** 构建单元格*/
	var buildCell = function(oJsonRow, oRow)
	{
		var arrJsonCells = oJsonRow["cellList"];
		for(var i = 0; i < arrJsonCells.length; i++)
		{
			var oJsonCell = arrJsonCells[i];
			var oCell = oRow.getCell(oJsonCell["col"]);//与kbi的不同之处
			if(oJsonCell["diagonal"])
			{
				var oJsonDiagonal = oJsonCell["diagonal"];
				var oDiagonalModel = new KTDiagonalModel();
				oDiagonalModel.setCrossRows(oJsonDiagonal["crossRowSum"]);
				oDiagonalModel.setCrossColumns(oJsonDiagonal["crossColSum"]);
				oDiagonalModel.setLinkToRows(oJsonDiagonal["linkToRows"]);
				oDiagonalModel.setLinkToColumns(oJsonDiagonal["linkToCols"]);
				var arrTriangle = oJsonDiagonal["triangles"];
				for(var j = 0; j < arrTriangle.length; j++)
				{
					oDiagonalModel.setText(arrTriangle[j]["text"], j);
					oDiagonalModel.setLean(arrTriangle[j]["lean"], j);
					var jsonStyle = arrTriangle[j]["style"];
					if(jsonStyle)
					{
						var oStyle = parseStyle(jsonStyle);
						oDiagonalModel.setStyle(oStyle, j);
					}
					var jsonBorder = arrTriangle[j]["slashStyle"];
					if(jsonBorder)
					{
						var oBorder = parseDiagonal(jsonBorder);
						oDiagonalModel.setSlashBorder(oBorder, j);
					}
				}
				oCell.setValue(oDiagonalModel);		
			}
			else
			{
				oCell.setValue(oJsonCell["value"].replace(" ", "\240"));
			}
			
			if(!isNullString(oJsonCell["linkModels"]) && oJsonCell["linkModels"].length > 0)
			{
				oCell.setUserObject(oJsonCell["linkModels"]);
			}
			else if(oJsonCell["linkTo"])
			{
				oCell.setUserObject(oJsonCell["linkTo"]);
			}
			
			if(oJsonCell["cellTree"])
			{
				var oJsonTree = oJsonCell["cellTree"];
				var oTreeModel = new KTCellTreeModel(oJsonTree["level"], oJsonTree["horizontal"]);
				oTreeModel.setExpanded(oJsonTree["expanded"]);
				oTreeModel.setHaveHandlerAlways(oJsonTree["haveHandler"]);
				oCell.setTreeModel(oTreeModel);
			}
			
			if(oJsonCell["style"])
			{
				var oStyle = parseStyle(oJsonCell["style"]);
				oCell.setStyle(oStyle);
		//		oCell.getUserObject() && oStyle.setCursor("pointer");
				oCell.getUserObject() &&oStyle.setUnderLine(false);//是超链去掉下划线
			}
			
			if(oJsonCell["border"])
			{
				oCell.setBorder(parseBorder(oJsonCell["border"]));
			}
		}
	};
	
	//目前使用java的json转换会把null对象转化成"null"
	//排除程序干扰要确认这个对象是否是空
	var isNullString = function(obj)
	{
		return (typeof obj == "string" && obj == "null");
	};
	
	/** 构建嵌入对象 */
	var buildEmbedChart = function(oJsonTable, oTable)
	{
		var arrJsonEmbeds = oJsonTable["embedChartList"];
		if(arrJsonEmbeds)
		{
			for(var i = 0; i < arrJsonEmbeds.length; i++)
			{
				var oJsonEmbed = arrJsonEmbeds[i];
				var sId = oJsonEmbed["name"];
				var iX = oJsonEmbed["left"];
				var iY = oJsonEmbed["top"];
				var iW = oJsonEmbed["width"];
				var iH = oJsonEmbed["height"];
				var oEmbed = new KTEmbedObject(sId, iX, iY, iW, iH);
				oEmbed.setType(oJsonEmbed["embedType"]);
				oEmbed.setUserObject(
					{
						"type": oJsonEmbed["type"],
						"dataSource": oJsonEmbed["dataSource"],
						"dataSrc": oJsonEmbed["dataSrc"],
						"name": sId,
						"reportInfo": oJsonEmbed["reportInfo"]
					});
				
				if(oJsonEmbed["frozenFixed"])
						oEmbed.setFrozenFixed(oJsonEmbed["frozenFixed"])
				oTable.addEmbedObject(oEmbed);
			}
		}
	};
	
	var parseStyle = function(oJsonStyle)
	{
		var oStyle = new KTStyle();
		oStyle.setFontName(oJsonStyle["fontName"]);
		oStyle.setFontSize(oJsonStyle["fontSize"]);
		oStyle.setBold(oJsonStyle["bold"]);
		oStyle.setItalic(oJsonStyle["italic"]);
		oStyle.setLineThrough(oJsonStyle["lineThrough"]);
		oStyle.setColor(oJsonStyle["color"]);
		oStyle.setBackgroundColor(oJsonStyle["backgroundColor"]);
		oStyle.setTextAlign(oJsonStyle["textAlign"]);
		oStyle.setVerticalAlign(oJsonStyle["verticalAlign"]);
		oStyle.setWrapText(oJsonStyle["wrapText"]);
		oStyle.setIndent(oJsonStyle["indentation"]);
		return oStyle;
	};
	
	var parseDiagonal = function(oJsonBorder)
	{
		var oBorder = new KTBorderStyle();
		oBorder.setLeftBorderPen(oJsonBorder["pen"]);
		oBorder.setLeftBorderWidth(oJsonBorder["width"]);
		oBorder.setLeftBorderColor(oJsonBorder["color"]);
		return oBorder;
	}
		
	var parseBorder = function(oJsonBorder)
	{
		var oBorder = new KTBorderStyle();
		oBorder.setTopBorderPen(oJsonBorder["top"]["pen"]);
		oBorder.setRightBorderPen(oJsonBorder["right"]["pen"]);
		oBorder.setBottomBorderPen(oJsonBorder["bottom"]["pen"]);
		oBorder.setLeftBorderPen(oJsonBorder["left"]["pen"]);
		
		oBorder.setTopBorderWidth(oJsonBorder["top"]["width"]);
		oBorder.setRightBorderWidth(oJsonBorder["right"]["width"]);
		oBorder.setBottomBorderWidth(oJsonBorder["bottom"]["width"]);
		oBorder.setLeftBorderWidth(oJsonBorder["left"]["width"]);
		
		oBorder.setTopBorderColor(oJsonBorder["top"]["color"]);
		oBorder.setRightBorderColor(oJsonBorder["right"]["color"]);
		oBorder.setBottomBorderColor(oJsonBorder["bottom"]["color"]);
		oBorder.setLeftBorderColor(oJsonBorder["left"]["color"]);
		return oBorder;
	};
}

function treeDrillExpandHandler(evenType, oEventWrap)
{
	var bOriSyncUI;
	var oCell = oEventWrap.getCell();
	var oTable = oEventWrap.getTable();
	oEventWrap.preventDefault();
	if(oTable)
	{
		//记录原状态并关闭自动同步UI
		bOriSyncUI = oTable.isSyncUIWhenModelChanged();
		oTable.setSyncUIWhenModelChanged(false);
	}
	var bAnimate = false; // 动画效果开关
	
	var oTreeModel = oCell.getTreeModel();
	var bHorizontalTree = oTreeModel.isHorizontal();
	var iLoopFrom = (bHorizontalTree ? oEventWrap.getColIndex() + 1 : oEventWrap.getRowIndex() + 1);
	var iLoopTo = (bHorizontalTree ? oTable.getColumnsCount() : oTable.getRowsCount());
	var iStopLevel = 0x7fff;
	var bFindedFather;
	var bFindedBrother = false;
	var fatherIdx = 0;
	var iTreeFrom = 0;
	var oTopTarget;//本树的顶端（root）
	var oFatherTarget;
	var iTargetFather = -1;//点击节点父亲的行号
	var iLeft = 0;
	var iTargetTop = 0;
	var iTime1 = 0;
	var I_TREE_LEFT = 26;//树的默认缩进是26
	
	//打开自动同步UI，并修改模型使触发
	var setTableSyncUI = function(oTarget)
	{
		var bHided = oTarget.isHide();
		oTarget.setHide(!bHided);
		oTable.setSyncUIWhenModelChanged(true);
		oTarget.setHide(bHided);
		//恢复回原状态
		oTable.setSyncUIWhenModelChanged(bOriSyncUI);
	}
	
	var addAnimate = function(oHideTarget, iNextColIdx, sLfetPosition, speed, funCallback)
	{
		if(!bAnimate)
			return;
		var jqOChild = $(oTable.getUI()).find("#"+oEventWrap.createCellId(oHideTarget, oEventWrap.getCol())).clone();
		var sRowClassName = oEventWrap.getTable().getStyleManager().getShareStyleId(oHideTarget.getStyle(), KTStyleManager.PRIORITY_ROW);
		var sColClassName = oEventWrap.getTable().getStyleManager().getShareStyleId(oEventWrap.getCol().getStyle(), KTStyleManager.PRIORITY_COLUMN);
		var sCellClassName = oEventWrap.getTable().getStyleManager().getShareStyleId(oHideTarget.getCell(iNextColIdx).getStyle(),KTStyleManager.PRIORITY_CELL);
		if(sCellClassName != sRowClassName)
		{
			if(sCellClassName != sColClassName)
			{
				sCellClassName = sCellClassName + " " + sColClassName;
			}
			if(sRowClassName != sColClassName)
			{
				sCellClassName = sCellClassName + " " + sRowClassName;
			}
		}
		else if(sCellClassName != sColClassName)
		{
			sCellClassName = sCellClassName + " " + sColClassName;
		}
		var sHtml = "<div>"+oHideTarget.getCell(iNextColIdx).getValue()+"</div>";
		var jqOChild = $(sHtml);
		jqOChild.attr("class", sCellClassName);
		iTargetTop += oHideTarget.getHeight();
		$(oTable.getUI()).append(jqOChild);
		jqOChild.css({
		left:sLfetPosition,
		//opacity:'0',
		position: "absolute",
		top: iTargetTop+"px"	
		});
		iTime1++;
		
		(function(jqOChild1, iTime2)
		{
			jqOChild.animate(
			{
				left: I_TREE_LEFT + iLeft + "px",
				//opacity:'1'
			},
			speed
			,function()
			{					
				if(iTime2 == iTime1)
				{			
					funCallback();
				}							
										
				jqOChild1.remove();
			});
		})(jqOChild, iTime1);			
	}
	for(var i = iLoopFrom; i >= 0; i--)
	{
		var iLastRowIdx = (bHorizontalTree ? oEventWrap.getRowIndex() : i);
		var iLastColIdx = (bHorizontalTree ? i : oEventWrap.getColIndex());
		var oRow = oTable.getRow(iLastRowIdx);
		var oLastCell = oRow.getCell(iLastColIdx);
		var oHideTarget = (bHorizontalTree ? oTable.getColumn(iLastColIdx) : oRow);
		if(!oLastCell || !oLastCell.getTreeModel())
		{
			break;
		}
		if(iTargetFather < 0 && oLastCell.getTreeModel().getLevel() < oTreeModel.getLevel())
		{
			iTargetFather = i;
		}
		iTreeFrom = i;
		if(!oHideTarget.isHide())
		{
			oTopTarget = oHideTarget;
		}					
	}
	
	var iChangeCount = 0;
	var bToExpand = oTreeModel.isExpanded();
	iLeft = parseFloat($(oTable.getUI()).find("#"+oEventWrap.createCellId(oTopTarget, oEventWrap.getCol())).css("left"));
	iTargetTop = parseFloat($(oTable.getUI()).find("#"+oEventWrap.createCellId(oTopTarget, oEventWrap.getCol())).css("top"));
	if(bToExpand)
	{
		for(var i = iTreeFrom; i < iLoopTo; i++)
		{
			var iNextRowIdx = (bHorizontalTree ? oEventWrap.getRowIndex() : i);
			var iNextColIdx = (bHorizontalTree ? i : oEventWrap.getColIndex());
			var oRow = oTable.getRow(iNextRowIdx);
			var oNextCell = oRow.getCell(iNextColIdx);
			var oHideTarget = (bHorizontalTree ? oTable.getColumn(iNextColIdx) : oRow);
			if(!oNextCell || !oNextCell.getTreeModel())
			{
				break;
			}
			var oNextTreeModel = oNextCell.getTreeModel();
			
			if (i + 1 < iLoopFrom)
			{
				if(!oHideTarget.isHide())
					iChangeCount--;
					
				oHideTarget.setHide(true);
			//	oNextTreeModel.setExpanded(false);
			}
			else if(i + 1 == iLoopFrom)
			{
				oFatherTarget = oHideTarget;
				if(bAnimate)
				{
					var jqO = $(oTable.getUI()).find("#"+oEventWrap.createCellId(oHideTarget, oEventWrap.getCol())).clone();
					$(oTable.getUI()).append(jqO);
					jqO.css({
						borderColor: "rgb(253, 179, 97)",
						borderWidth: "1px"
					});
					
					jqO.animate(
					{
						top: iTargetTop
					},
					300
					,function()
					{					
						//oFatherTarget.setHide(false);	
						jqO.remove();
					});
					//oHideTarget.setHide(true);
				}
				else
				{
					if(oHideTarget.isHide())
						iChangeCount++;
						
					oFatherTarget.setHide(false);
				}
			}
			else if(!bFindedBrother && i + 1 > iLoopFrom && oNextTreeModel.getLevel() == oTreeModel.getLevel() + 1)
			{
				addAnimate(oHideTarget, iNextColIdx, "100px", 300, function(){
					setTableSyncUI(oTopTarget);
				});
				
				if(oHideTarget.isHide())
					iChangeCount++;
				
				oHideTarget.setHide(false);
			}
			else if(i + 1 > iLoopFrom && oNextTreeModel.getLevel() <= oTreeModel.getLevel())
			{
				bFindedBrother = true;
				if(!oHideTarget.isHide())
					iChangeCount--;
						
				oHideTarget.setHide(true);
			}
			
			$(oTable.getUI()).find("#"+oEventWrap.createCellId(oHideTarget, oEventWrap.getCol())).css({display:"none"});
						
			if(oNextTreeModel.getLevel() <= oTreeModel.getLevel()
				|| bHorizontalTree != oNextTreeModel.isHorizontal())
			{
				continue;
			}
		}
	}
	else
	{
		for(var i = iTreeFrom;i < iLoopTo; i++)
		{
			var iNextRowIdx = (bHorizontalTree ? oEventWrap.getRowIndex() : i);
			var iNextColIdx = (bHorizontalTree ? i : oEventWrap.getColIndex());
			var oRow = oTable.getRow(iNextRowIdx);
			var oNextCell = oRow.getCell(iNextColIdx);
			var oHideTarget = (bHorizontalTree ? oTable.getColumn(iNextColIdx) : oRow);
			if(!oNextCell || !oNextCell.getTreeModel())
			{
				break;
			}
			var oNextTreeModel = oNextCell.getTreeModel();
			if(oNextTreeModel.getLevel() > oTreeModel.getLevel())
			{	
				if(!oHideTarget.isHide())
					iChangeCount++;
					
				oHideTarget.setHide(true);
			}
			
			else if(oNextTreeModel.getLevel() < oTreeModel.getLevel())
			{
				if(i > iTargetFather)
				{
					break;
				}
				else if(i == iTargetFather)
				{
					iTargetTop = parseFloat($(oTable.getUI()).find("#"+oEventWrap.createCellId(oTopTarget, oEventWrap.getCol())).css("top")) - oHideTarget.getHeight();
					addAnimate(oHideTarget, iNextColIdx, "-100px", 300);
					if(oHideTarget.isHide())
						iChangeCount--;
						
					oHideTarget.setHide(false);
				}
				else
				{
					if(!oHideTarget.isHide())
						iChangeCount++;
						
					oHideTarget.setHide(true);
				}
			}
			else if(oNextTreeModel.getLevel() == oTreeModel.getLevel() && i > iTargetFather)
			{
				addAnimate(oHideTarget, iNextColIdx, "-100px", 300, function(){
					var oTarget = (bHorizontalTree ? oTable.getCol(0) : oTable.getRow(0));
					setTableSyncUI(oTarget);
				});
				
				if(oHideTarget.isHide())
					iChangeCount--;
					
				oHideTarget.setHide(false);
			}
			else if(oNextTreeModel.getLevel() < oTreeModel.getLevel() && i > iTargetFather)
			{
				break;
			}
			
			$(oTable.getUI()).find("#"+oEventWrap.createCellId(oHideTarget, oEventWrap.getCol())).css({display:"none"});
		}
	}
	
	if(oTable && !bAnimate)
	{
		var oTarget = (bHorizontalTree ? oTable.getCol(0) : oTable.getRow(0));
		setTableSyncUI(oTarget);
	}
	
	// 嵌入对象跟着树的伸展改变位置
	(function()
	{
		var arrEmbedObject = oTable.getEmbedObjects();
		if(arrEmbedObject.length <= 0)
			return;
		
		var iCurrentIdx = iLoopFrom;
		var iWH = bHorizontalTree ? oTable.getColumn(iLoopFrom).getWidth() : oTable.getRow(iLoopFrom).getHeight();
		iWH = (bToExpand ? iWH : -iWH) * iChangeCount;
		
		for(var i=0; i<arrEmbedObject.length; i++)
		{
			var oEmbedObject = arrEmbedObject[i];
			if(bHorizontalTree && oEmbedObject.getColFrom() > iCurrentIdx)
				oEmbedObject.setX(oEmbedObject.getX() + iWH);
			else if(oEmbedObject.getRowFrom() > iCurrentIdx)
				oEmbedObject.setY(oEmbedObject.getY() + iWH);
		}
		
		oTable.updateUI();
	})();
}	
	
function KTMobileTreeDrillHandlerRender(oTable) //下钻方式 >>控制器
{
	var HANDLER_SIZE = 9;//收展操作的方框大小，不含边框
	var TAB_SIZE = 17;
	var MARGIN_BEFORE = 2;
	var MARGIN_AFTER = 4;
	
	var _oTable = oTable;
	var _oUiDependence;
	
	this.setMergeBlock = function(oMergeBlock)
	{
	}
	
	this.setHandlerSize = function(iHandlerSize)
	{
		HANDLER_SIZE = iHandlerSize;
	}
	
	var getTable = function()
	{
		return _oTable;
	}
	
	this.setUiDependence = function(oUiDependence)
	{
		_oUiDependence = oUiDependence;
	}
	var getUiDependence = function()
	{
		return _oUiDependence;
	}

	/**
	 * 创建一个树操作柄，以及相同单元格里的文字容器
	 * @return [htmlTreeHandler, htmlTextArea] 其中htmlTreeHandler可能为空
	 */
	this.create = function(oTreeModel, iRowIdx, iColIdx, iWidth, iHeight)
	{
		var arrResult = createTreeHandler(oTreeModel, iRowIdx, iColIdx, iWidth, iHeight);
		var iTextX = arrResult[1];
		var iTextY = arrResult[2];
		var iTextW = iWidth - iTextX;
		if((oTreeModel.isHaveHandlerAlways() || isTreeNodeHasChildren(oTreeModel, iRowIdx, iColIdx))
		   && !oTreeModel.isExpanded())
		{
			iTextW = iWidth - 2*iTextX;
		}
		var iTextH = iHeight - iTextY;
		var htmlTextArea = createAbsoluteHtmlElement("span", iTextX, iTextY, iTextW, iTextH);
		return [arrResult[0], htmlTextArea];
	}
	
	//return [htmlTreeHandler, iTextX, iTextY]
	var createTreeHandler = function(oTreeModel, iRowIdx, iColIdx, iWidth, iHeight)
	{
		var iX, iY, iW, iH, iTextX, iTextY;
		if(oTreeModel.isHorizontal())
		{
			iX = 0;
			iY = oTreeModel.getLevel() * TAB_SIZE;
			iW = iWidth;
			iH = MARGIN_BEFORE + HANDLER_SIZE + 2 + MARGIN_AFTER;//2是方框的边框
			iTextX = 0;
			iTextY = iY + iH;
		}
		else
		{
			iX = 0//oTreeModel.getLevel() * TAB_SIZE;
			iY = 0;
			iW = MARGIN_BEFORE + HANDLER_SIZE + 2 + MARGIN_AFTER;//2是方框的边框
			iH = iHeight;
			iTextX = iX + iW;
			iTextY = 0;
		}
		var htmlTreeHandler = null;
		if(oTreeModel.isHaveHandlerAlways() || isTreeNodeHasChildren(oTreeModel, iRowIdx, iColIdx))
		{
			//最外层不可见，包含边距使点击的响应范围更大
			htmlTreeHandler = createAbsoluteHtmlElement("div", iX, iY, iW, iH);
			htmlTreeHandler.style.fontSize = "12pt";
			//方框
			if(oTreeModel.isHorizontal())
			{
				iX = ((iWidth - HANDLER_SIZE - 2) >> 1);
				iY = MARGIN_BEFORE;
			}
			else
			{
				iX = MARGIN_BEFORE;
				iY = ((iHeight - HANDLER_SIZE - 2) >> 1);
			}
			var htmlRect = createAbsoluteHtmlElement("div", iX, iY, HANDLER_SIZE, HANDLER_SIZE);
			if(typeof(htmlRect.style.borderRadius) != "undefined")//IE6连圆角属性都没有
			{
				htmlRect.style.borderRadius = "3px";
			}
			htmlTreeHandler.appendChild(htmlRect);
			
			var PADDING = 1;//加减号坐标主动向内缩，不是容器的padding属性
			iX = PADDING;
			iY = PADDING;
			if(oTreeModel.isExpanded())//减号
			{
				htmlRect.innerText = "<<";
			}
			else//加号
			{
				htmlRect.innerText = ">>";
				$(htmlTreeHandler).css({
					right:"-7px",
					left:""
				});
			}
			$(htmlRect).css({
				color: "rgb(58, 195, 238)",
				fontWeight: "bold"
			});
		}
		return [htmlTreeHandler, iTextX, iTextY];
	}
	
	var isTreeNodeHasChildren = function(oTreeModel, iRowIdx, iColIdx)
	{
		var oNextCell;
		if(oTreeModel.isHorizontal())
		{
			if(iColIdx == _oTable.getColumnsCount() - 1)
			{
				return false;
			}
			oNextCell = _oTable.getRow(iRowIdx).getCellForDraw(iColIdx + 1);
		}
		else
		{
			if(iRowIdx == _oTable.getRowsCount() - 1)
			{
				return false;
			}
			oNextCell = _oTable.getRow(iRowIdx + 1).getCellForDraw(iColIdx);
		}
		return (oNextCell && oNextCell.getTreeModel() 
			&& oNextCell.getTreeModel().getLevel() > oTreeModel.getLevel());
	}
	
	var createAbsoluteHtmlElement = function(sType, iX, iY, iWidth, iHeight)
	{
		var htmlDiv = document.createElement(sType);
		htmlDiv.style.overflow = "hidden";
		htmlDiv.style.position = "absolute";
		htmlDiv.style.left = iX + 'px';
		htmlDiv.style.top = iY + 'px';
		htmlDiv.style.width = iWidth + 'px';
		htmlDiv.style.height = iHeight + 'px';
		return htmlDiv;
	}
	
	this.protectedMethod = 
	{
		"getTable": getTable,
		"getUiDependence": getUiDependence,
		"isTreeNodeHasChildren": isTreeNodeHasChildren,
		"createAbsoluteHtmlElement": createAbsoluteHtmlElement
	}
}

/**
 * 树节点操作柄绘制器 //收展方式 三角控制器
 */
function KTMobileTreeSpreadHandlerRender(oTable)
{
	var HANDLER_SIZE = 9;//收展操作的方框大小，不含边框
	var TAB_SIZE = 17;
	var MARGIN_BEFORE = 2;
	var MARGIN_AFTER = 4;
	
	var _oTable = oTable;
	var _oUiDependence;
	
	this.setMergeBlock = function(oMergeBlock)
	{
	}
	
	this.setHandlerSize = function(iHandlerSize)
	{
		HANDLER_SIZE = iHandlerSize;
	}
	
	var getTable = function()
	{
		return _oTable;
	}
	
	this.setUiDependence = function(oUiDependence)
	{
		_oUiDependence = oUiDependence;
	}
	var getUiDependence = function()
	{
		return _oUiDependence;
	}

	/**
	 * 创建一个树操作柄，以及相同单元格里的文字容器
	 * @return [htmlTreeHandler, htmlTextArea] 其中htmlTreeHandler可能为空
	 */
	this.create = function(oTreeModel, iRowIdx, iColIdx, iWidth, iHeight)
	{
		var arrResult = createTreeHandler(oTreeModel, iRowIdx, iColIdx, iWidth, iHeight);
		var iTextX = arrResult[1];
		var iTextY = arrResult[2];
		var iTextW = iWidth - iTextX;
		var iTextH = iHeight - iTextY;
		var htmlTextArea = createAbsoluteHtmlElement("span", iTextX, iTextY, iTextW, iTextH);
		return [arrResult[0], htmlTextArea];
	}
	
	//return [htmlTreeHandler, iTextX, iTextY]
	var createTreeHandler = function(oTreeModel, iRowIdx, iColIdx, iWidth, iHeight)
	{
		var iX, iY, iW, iH, iTextX, iTextY;
		if(oTreeModel.isHorizontal())
		{
			iX = 0;
			iY = oTreeModel.getLevel() * TAB_SIZE;
			iW = iWidth;
			iH = MARGIN_BEFORE + HANDLER_SIZE + 2 + MARGIN_AFTER;//2是方框的边框
			iTextX = 0;
			iTextY = iY + iH;
		}
		else
		{
			iX = oTreeModel.getLevel() * TAB_SIZE;
			iY = 0;
			iW = MARGIN_BEFORE + HANDLER_SIZE + 2 + MARGIN_AFTER;//2是方框的边框
			iH = iHeight;
			iTextX = iX + iW;
			iTextY = 0;
		}
		var htmlTreeHandler = null;
		if(oTreeModel.isHaveHandlerAlways() || isTreeNodeHasChildren(oTreeModel, iRowIdx, iColIdx))
		{
			//最外层不可见，包含边距使点击的响应范围更大
			htmlTreeHandler = createAbsoluteHtmlElement("div", iX, iY, iW, iH);
			//方框
			if(oTreeModel.isHorizontal())
			{
				iX = ((iWidth - HANDLER_SIZE - 2) >> 1);
				iY = MARGIN_BEFORE;
			}
			else
			{
				iX = MARGIN_BEFORE;
				iY = ((iHeight - HANDLER_SIZE - 2) >> 1);
			}
			var htmlRect = createAbsoluteHtmlElement("div", iX, iY, HANDLER_SIZE, HANDLER_SIZE);
			if(typeof(htmlRect.style.borderRadius) != "undefined")//IE6连圆角属性都没有
			{
				htmlRect.style.borderRadius = "3px";
			}
			htmlTreeHandler.appendChild(htmlRect);
			
			var PADDING = 1;//加减号坐标主动向内缩，不是容器的padding属性
			iX = PADDING;
			iY = PADDING;
			if(oTreeModel.isExpanded())//减号
			{
				iW = HANDLER_SIZE - PADDING * 2;
				iH = (iW >> 1);
				var htmlMinus = createAbsoluteHtmlElement("div", iX, iY, iW, iH);
				$(htmlMinus).css({
						width: "0",
						height: "0",
						top: "3px",
						borderTop: "10px solid #aaa",
						borderLeft: "8px solid transparent",
						borderRight: "8px solid transparent"
				})
				htmlRect.appendChild(htmlMinus);
				
			}
			else//加号
			{
				iW = HANDLER_SIZE - PADDING * 2;
				iH = (iW >> 1);
				var htmlPlus = createAbsoluteHtmlElement("div", iX, iY, iW, iH);
				$(htmlPlus).css({
					width: "0",
					height: "0",
					borderTop: "8px solid transparent",
					borderLeft: "10px solid #aaa",
					borderBottom: "8px solid transparent"
				});
				htmlRect.appendChild(htmlPlus);
			}
		}
		return [htmlTreeHandler, iTextX, iTextY];
	}
	
	var isTreeNodeHasChildren = function(oTreeModel, iRowIdx, iColIdx)
	{
		var oNextCell;
		if(oTreeModel.isHorizontal())
		{
			if(iColIdx == _oTable.getColumnsCount() - 1)
			{
				return false;
			}
			oNextCell = _oTable.getRow(iRowIdx).getCellForDraw(iColIdx + 1);
		}
		else
		{
			if(iRowIdx == _oTable.getRowsCount() - 1)
			{
				return false;
			}
			oNextCell = _oTable.getRow(iRowIdx + 1).getCellForDraw(iColIdx);
		}
		return (oNextCell && oNextCell.getTreeModel() 
			&& oNextCell.getTreeModel().getLevel() > oTreeModel.getLevel());
	}
	
	var createAbsoluteHtmlElement = function(sType, iX, iY, iWidth, iHeight)
	{
		var htmlDiv = document.createElement(sType);
		htmlDiv.style.overflow = "hidden";
		htmlDiv.style.position = "absolute";
		htmlDiv.style.left = iX + 'px';
		htmlDiv.style.top = iY + 'px';
		htmlDiv.style.width = iWidth + 'px';
		htmlDiv.style.height = iHeight + 'px';
		return htmlDiv;
	}
	
	this.protectedMethod = 
	{
		"getTable": getTable,
		"getUiDependence": getUiDependence,
		"isTreeNodeHasChildren": isTreeNodeHasChildren,
		"createAbsoluteHtmlElement": createAbsoluteHtmlElement
	}
}