//扩展报表轻应用通用控件
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖： 
//jQuery 2.1.0 (http://jquery.com)
//jQueryMobile 1.4.2 (http://jquerymobile.com)
//

var kdlight = {};

/**
 * 工具栏
 */
kdlight.Toolbar = function()
{
	var _this = this;
	var _jqBar;
	
	(function()
	{
		_jqBar = $("<div>");
		_jqBar.addClass("kdlight-toolbar");
	})();
	
	this.getJqUi = function()
	{
		return _jqBar;
	}
	
	this.addButton = function(iPos, sName, sTextOrIconUrl, funAction)
	{
		var jqBtn = createButton(sName, sTextOrIconUrl);
		jqBtn.on("click", 
			function()
			{
				funAction(sName);
			});
		var sPos = posToPostfix(iPos);
		jqBtn.addClass("kdlight-toolbar-btn-" + sPos);
	}
	this.addTitle = function(sTitle)
	{
		var jqBtns = _jqBar.find(".kdlight-toolbar-btn");
		var iBtnsWidth = 0;
		var iLeft = 0;
		for(var i = 0; i < jqBtns.length; i++)
		{
			if("none" != $(jqBtns[i]).css("display"))
			{	
				if($(jqBtns[i]).hasClass("kdlight-toolbar-btn-left"))
					iLeft += $(jqBtns[i]).outerWidth(true);
				iBtnsWidth += $(jqBtns[i]).outerWidth(true);
			}
		}
		var iAvalibleWidth = $(_jqBar).width() - iBtnsWidth;
		if(($(_jqBar).width() == 100 && iBtnsWidth == 0) || iAvalibleWidth <= 0) //没办法，找不到原因
		{
			iAvalibleWidth = $(window).width() - iBtnsWidth; 
		}
		var jqTitleContainer = _jqBar.find(".kdlight-toolbar-title:first");
		if (!jqTitleContainer || jqTitleContainer.length == 0)
		{
			jqTitleContainer= $("<div class='kdlight-toolbar-title fontWeightBold'>");
			_jqBar.append(jqTitleContainer);
		}
		jqTitleContainer.css({
			"width": iAvalibleWidth,
			"left": iLeft
		});
		jqTitleContainer.text(sTitle);
	}
	this.addSeperator = function(iPos)
	{
		var jqSeperator = createSeperator();
		var sPos = posToPostfix(iPos);
		jqSeperator.addClass("kdlight-toolbar-seperator-" + sPos);
	}
	
	this.setButtonVisible = function(sName, bVisible)
	{
		var jqBtn = _this.getButton(sName);
		if(jqBtn)
		{
			jqBtn.css("display", (bVisible ? "" : "none"));
		}
	}
	
	this.getButton = function(sName)
	{
		var jqBtns = _jqBar.find(".kdlight-toolbar-btn");
		for(var i = 0; i < jqBtns.length; i++)
		{
			var jqBtn = $(jqBtns[i]);
			if(jqBtn.data("buttonName") == sName)
			{
				return jqBtn;
			}
		}
		return null;
	}
	
	var posToPostfix = function(iPos)
	{
		var sPos;
		if(iPos == kdlight.Toolbar.POS_LEFT)
		{
			sPos = "left";
		}
		else if(iPos == kdlight.Toolbar.POS_RIGHT)
		{
			sPos = "right";
		}
		else
		{
			throw new Error("Illegal argument");
		}	
		return sPos;
	}
	
	var createButton = function(sName, sTextOrIconUrl)
	{
		var jqBtn = $('<div>');
		jqBtn.addClass("kdlight-toolbar-btn");
		jqBtn.data("buttonName", sName);
		if(sTextOrIconUrl.indexOf("/") >= 0)//简单以带有斜杆就认为是url
		{
			if(sTextOrIconUrl.indexOf("url(") != 0)
			{
				sTextOrIconUrl = "url(" + sTextOrIconUrl + ")";
			}
			jqBtn.css("background-image", sTextOrIconUrl);
			jqBtn.addClass("kdlight-toolbar-imgbtn");
		}
		else
		{
			jqBtn.text(sTextOrIconUrl);
			jqBtn.addClass("kdlight-toolbar-txtbtn");
		}
		_jqBar.append(jqBtn);
		return jqBtn;
	}
	
	var createSeperator = function()
	{
		var jqSeperator = $('<div>');
		jqSeperator.addClass("kdlight-toolbar-seperator");
		_jqBar.append(jqSeperator);
		return jqSeperator;
	}
}
kdlight.Toolbar.POS_LEFT = 1
kdlight.Toolbar.POS_RIGHT = 2;

/**
 * 自定义页签
 */
kdlight.CustomTabContainer = function()
{
	var TAB_CONTENT_NAME = "CustomTabContainer_TabContentName"
	var ITEM_ORDER = "OrderFrom1";
	var ORDER_TEXT_ARRAY = ["", "①", "②", "③"];
	
	var _this = this;
	var _arrAllTabNames;
	var _arrAppearedTabNames;
	var _iMaxTabsAppear = 3;
	var _jqUi;
	var _jqHeader = $("<div>");
	var _jqContentOwner = $("<div>");
	var _bForceTooQuick;

	var _sMoreItemTitle;
	var _jqOwnerForMore;
	var _oConfirmBar;
	var _funAppearedChangeListener;
	var _funSelectedChangeListener;
	var _funMoreItemShowListener;
	
	(function()
	{
		var jqBtnMore = $("<div>");
		jqBtnMore.addClass("kdlight-csttab-head-more");
		jqBtnMore.text("更多");
		_jqHeader.addClass("kdlight-csttab-header");
		_jqHeader.append(jqBtnMore);
		_jqHeader.on("click", function(evt){doHeaderClick(evt);});

		_jqContentOwner.addClass("kdlight-csttab-body");
	})();
	
	/** 设置总共有多少页签和当前要显示哪几页 */
	this.setTabNames = function(arrAllNames, arrAppearedNames)
	{
		_arrAllTabNames = arrAllNames;
		_arrAppearedTabNames = (arrAppearedNames ? arrAppearedNames : arrAllNames);
		updateHeaderUi();
	}
	
	/** 获取所有页的名称 */
	this.getAllTabNames = function()
	{
		return _arrAllTabNames;
	}
	
	/** 获取当前显示哪几页的名称 */
	this.getAppearedTabNames = function()
	{
		return _arrAppearedTabNames;
	}
	
	/** 设置一页的内容 */
	this.setTabContent = function(sTabName, jqPanel)
	{
		if(jqPanel)
		{
			jqPanel.data(TAB_CONTENT_NAME, sTabName);
			jqPanel.css("display", "none");
			jqPanel.css("position", "absolute");
			jqPanel.css("left", 0);
			jqPanel.css("right", 0);
			jqPanel.css("top", 0);
			jqPanel.css("bottom", 0);
			jqPanel.css("z-index", 0);
			_jqContentOwner.append(jqPanel);
		}
		else
		{
			jqPanel = getTabPanel(sTabName);
			if(jqPanel)
			{
				jqPanel.remove();
			}
		}
	}
	
	/** 获取指定名称的一页的内容 */
	this.getTabContent = function(sTabName)
	{
		return getTabPanel(sTabName);
	}
	
	/** 获取jQuery封装的界面 */
	this.getJqUi = function()
	{
		if(!_jqUi)
		{
			_jqUi = $("<div>");
			_jqUi.append(_jqHeader);
			_jqUi.append(_jqContentOwner);
		}
		return _jqUi;
	}
	
	/** 设置当前选中的是哪一页 */
	this.setCurrentTabName = function(sTabName)
	{
		var jqTabHeadButton;
		var arrHeadItems = _jqHeader.find(".kdlight-csttab-head-item");
		for(var i = 0; i < arrHeadItems.length; i++)
		{
			if($(arrHeadItems[i]).text() == sTabName)
			{
				jqTabHeadButton = $(arrHeadItems[i]);
				break;
			}
		}
		if(jqTabHeadButton)
		{
			var sTabNameOld = updateHeadButtonSelected(jqTabHeadButton);
			changeTabContent(sTabNameOld, sTabName);
			return true;
		}
		return false;
	}
	
	/** 获取当前选中页名称 */
	this.getCurrentTabName = function()
	{
		return getSelectedHeadItem().text();
	}
	
	/** 设置[更多]选项的标题 */
	this.setMoreItemTitle = function(sTitle)
	{
		_sMoreItemTitle = sTitle;
	}
	
	/** 设置显示哪几页改变（就是[更多]-[确定]）的响应事件，funListener无参数 */
	this.setAppearedChangeListener = function(funListener)
	{
		_funAppearedChangeListener = funListener;
	}
	
	/** 设置页签切换的响应事件，funListener形如：func(sTabNameOld, sTabName) */
	this.setSelectedChangeListener = function(funListener)
	{
		_funSelectedChangeListener = funListener;
	}
	
	/** [更多]页面展开或收起的事件监听，funListener形如：func(bShow)，bShow为true表示展开，false为收起 */
	this.setMoreItemShowListener = function(funListener)
	{
		_funMoreItemShowListener = funListener;
	}
	
	var getTabPanel = function(sTabName)
	{
		var jqChildren = _jqContentOwner.children();
		for(var i = 0; i < jqChildren.length; i++)
		{
			var jqChild = $(jqChildren[i]);
			if(jqChild.data(TAB_CONTENT_NAME) == sTabName)
			{
				return jqChild;
			}
		}
		return null;
	}
	
	var updateHeaderUi = function()
	{
		_jqHeader.find(".kdlight-csttab-head-item").remove();
		var iTabsAppear = Math.min(_iMaxTabsAppear, _arrAppearedTabNames.length);
		var bShowBtnMore = (iTabsAppear < _arrAllTabNames.length);
		_jqHeader.find(".kdlight-csttab-head-more").css("display", (bShowBtnMore ? "" : "none"));
		
		var iX = 8;
		var iWidth = (bShowBtnMore ? 250 : 302) - iTabsAppear * 2;
		iWidth = Math.floor(iWidth / iTabsAppear);
		for(var i = 0; i < iTabsAppear; i++)
		{
			var jqHeadItem = $("<div>");
			jqHeadItem.text(_arrAppearedTabNames[i]);
			jqHeadItem.addClass("kdlight-csttab-head-item");
			if(i == 0)
			{
				jqHeadItem.addClass("kdlight-csttab-head-item-first");
			}
			else
			{
				jqHeadItem.css("border-left-width", 0);
			}
			
			if(i == iTabsAppear - 1)
			{
				jqHeadItem.addClass("kdlight-csttab-head-item-last");
			}
			jqHeadItem.css("left", iX + "px");
			jqHeadItem.width(iWidth);
			_jqHeader.append(jqHeadItem);
			iX += iWidth + 2;
		}
	}
	
	var doHeaderClick = function(evt)
	{
		if(_bForceTooQuick)
		{
			return;
		}
		var jqTarget = $(evt.target);
		if(jqTarget.hasClass("kdlight-csttab-head-item"))
		{
			var sTabNameOld = updateHeadButtonSelected(jqTarget);
			if(sTabNameOld)
			{
				var sTabName = jqTarget.text();
				changeTabContent(sTabNameOld, sTabName);
				if(_funSelectedChangeListener)
				{
					_funSelectedChangeListener(sTabNameOld, sTabName);
				}
			}
		}
		else if(jqTarget.hasClass("kdlight-csttab-head-more"))
		{
			pullMore();
		}
	}

	var getSelectedHeadItem = function()
	{
		return _jqHeader.find(".kdlight-csttab-head-item_selected");
	}
	
	var updateHeadButtonSelected = function(jqTabHeadButton)
	{
		var jqOldSelected = getSelectedHeadItem();
		if(jqOldSelected.length > 0 &&  jqOldSelected[0] == jqTabHeadButton[0])
		{
			return null;
		}
		jqOldSelected.removeClass("kdlight-csttab-head-item_selected");
		jqTabHeadButton.addClass("kdlight-csttab-head-item_selected");
		return jqOldSelected.text();
	}
	
	var changeTabContent = function(sTabNameOld, sTabName)
	{
		_bForceTooQuick = true;
		var jqTabPanelOld = getTabPanel(sTabNameOld);
		var jqTabPanel = getTabPanel(sTabName);
		var funShowNew = function()
		{
			if(jqTabPanel)
			{
				jqTabPanel.fadeIn(
					function()
					{
						_bForceTooQuick = false;
					}
				);
			}
			else
			{
				_bForceTooQuick = false;
			}
		}
		if(jqTabPanelOld)
		{
			jqTabPanelOld.fadeOut(funShowNew);
		}
		else
		{
			funShowNew();
		}
	}
	
	var pullMore = function()
	{
		if(!_jqOwnerForMore)
		{
			initMore();
			_jqOwnerForMore.css("display", "none");
			_oConfirmBar.getJqUi().css("display", "none");
		}
		if(_jqOwnerForMore.css("display") == "none")
		{
			_funMoreItemShowListener && _funMoreItemShowListener(true);
			var jqMask = $("<div>");
			jqMask.addClass("kdlight-csttab-header-mask");
			_jqHeader.append(jqMask);
			_jqOwnerForMore.slideDown(
				function()
				{
					_oConfirmBar.getJqUi().css("display", "");
				});
		}
		else
		{
			_funMoreItemShowListener && _funMoreItemShowListener(false);
			_oConfirmBar.getJqUi().css("display", "none");
			_jqOwnerForMore.slideUp(
				function()
				{
					_jqHeader.find(".kdlight-csttab-header-mask").remove();
					_jqOwnerForMore.remove();
					_jqOwnerForMore = null;
					_oConfirmBar = null;
				});
		}
	}
	
	var initMore = function()
	{
		var iFlowId = kdlight.CustomTabContainer.FLOW_ID++;
		
		_jqOwnerForMore = $("<div>");
		_jqOwnerForMore.css("z-index", 65535);
		_jqOwnerForMore.addClass("kdlight-csttab-more");
		_jqContentOwner.append(_jqOwnerForMore);
		
		var jqTitle = $("<div>");
		jqTitle.text(_sMoreItemTitle);
		
		var jqList = $("<fieldset>");
		jqList.attr("data-role", "controlgroup");
		for(var i = 0; i < _arrAllTabNames.length; i++)
		{
			var sTabName = _arrAllTabNames[i];
			var sKey = "kdlight.CustomTabContainer_" + iFlowId + "_" + i;
			
			var jqInput = $("<input type='checkbox'/>");
			jqInput.attr("id", sKey);
			jqInput.attr("name", sTabName);
			
			var jqLabel = $("<label>");
			jqLabel.attr("for", sKey);
			jqLabel.text(sTabName);
			
			jqList.append(jqInput);
			jqList.append(jqLabel);
		}
		jqList.controlgroup();		
		jqList.on("change", doMoreItemCheckedStateChanging);
		
		_oConfirmBar = new kdlight.ConfirmBar();
		_oConfirmBar.setActionListener(doConfirmBarClicked);
		var jqBar = _oConfirmBar.getJqUi();
		
		jqList.css("z-index", 1);
		jqBar.css("z-index", 2);
		_jqOwnerForMore.append(jqTitle);
		_jqOwnerForMore.append(jqList);
		_jqOwnerForMore.append(jqBar);
		_jqOwnerForMore.append($("<div style='height:50px'>"));
		
		for(var j = 0; j < _arrAppearedTabNames.length; j++)
		{
			var sAppearedTabName = _arrAppearedTabNames[j];
			setMoreItemChecked(sAppearedTabName, true);
		}
	}
	
	var doMoreItemCheckedStateChanging = function(evt)
	{
		var iCount = _jqOwnerForMore.find("label.ui-checkbox-on").length;
		var jqTargetInput = $(evt.target);
		var bStateBeforeChange = jqTargetInput.attr("checked");
		if(bStateBeforeChange)//uncheck
		{
			var iCurrentOrder = jqTargetInput.data(ITEM_ORDER);
			updateMoreItemText(jqTargetInput, -1);
			refreshMoreItemsState(iCurrentOrder, 1);
			_oConfirmBar.setOkVisible(iCount > 1);
		}
		else
		{
			updateMoreItemText(jqTargetInput, iCount + 1);
			if(iCount >= _iMaxTabsAppear)
			{
				var iReOrderDelta = iCount - _iMaxTabsAppear + 1;//其实都是1
				refreshMoreItemsState(-1, iReOrderDelta);
			}
			_oConfirmBar.setOkVisible(true);
		}
	}
	
	var refreshMoreItemsState = function(iReOrderFrom, iReOrderDelta)
	{
		var jqAllInputs = _jqOwnerForMore.find("input");
		for(var i = 0; i < jqAllInputs.length; i++)
		{
			var jqInput = $(jqAllInputs[i]);
			var iOrder = jqInput.data(ITEM_ORDER);
			if(iOrder > iReOrderFrom)
			{
				updateMoreItemText(jqInput, (iOrder - iReOrderDelta));
			}
		}
	}
	
	var setMoreItemChecked = function(sTabName, bChecked)
	{
		var jqInput = _jqOwnerForMore.find("input[name='" + sTabName + "']");
		var bState = jqInput.attr("checked");
		if((bState && bChecked) || (!bState && !bChecked))
		{
			return;
		}
		var iOrder = _jqOwnerForMore.find("label.ui-checkbox-on").length + 1;
		if(bState)
		{
			updateMoreItemText(jqInput, -1);
		}
		else
		{
			updateMoreItemText(jqInput, iOrder);
		}
	}
	
	var updateMoreItemText = function(jqInput, iOrder)
	{
		var jqLabel = _jqOwnerForMore.find("label[for='" + jqInput.attr("id") + "']");
		if(iOrder > 0)
		{
			jqInput.attr("checked", true);
			jqInput.data(ITEM_ORDER, iOrder);
			jqLabel.text(ORDER_TEXT_ARRAY[iOrder] + " - " + jqInput.attr("name"));
		}
		else
		{
			jqInput.attr("checked", false);
			jqInput.removeData(ITEM_ORDER);
			jqLabel.text(jqInput.attr("name"));
		}
		jqInput.checkboxradio("refresh");
	}
	
	var doConfirmBarClicked = function(bOk)
	{
		if(bOk)
		{
			var sOldSelectedTabName = _this.getCurrentTabName();
			
			_arrAppearedTabNames = [];
			var jqAllInputs = _jqOwnerForMore.find("input");
			for(var i = 0; i < jqAllInputs.length; i++)
			{
				var jqInput = $(jqAllInputs[i]);
				var iOrder = jqInput.data(ITEM_ORDER);
				if(iOrder)
				{
					var sTabName = jqInput.attr("name");
					_arrAppearedTabNames[iOrder - 1] = sTabName;
				}
			}
			updateHeaderUi();

			var jqTabPanel = getTabPanel(sOldSelectedTabName);
			if(jqTabPanel)
			{
				jqTabPanel.css("display", "none");
			}
			var sNewSelectedTabName = _arrAppearedTabNames[_arrAppearedTabNames.length - 1];
			_this.setCurrentTabName(sNewSelectedTabName);
			
			if(_funAppearedChangeListener)
			{
				_funAppearedChangeListener();
			}
		}
		pullMore();
	}
}
kdlight.CustomTabContainer.FLOW_ID = 0;


/**
 * [确定][取消]栏
 */
kdlight.ConfirmBar = function()
{
	var _jqBar;
	var _jqOk;
	var _jqCancel;
	var _funAction;
	
	(function init()
	{
		_jqCancel = $("<div>");
		_jqCancel.text("取消");
		_jqCancel.addClass("kdlight-confirmbar-btn-cancel");
		_jqCancel.on("click", 
			function()
			{
				_funAction(false);
			});
		
		var jqSeperator = $("<div>");
		jqSeperator.addClass("kdlight-confirmbar-seperator");

		_jqOk = $("<div>");
		_jqOk.text("确定");
		_jqOk.addClass("kdlight-confirmbar-btn-ok");
		_jqOk.on("click", 
			function()
			{
				_funAction(true);
			});
		
		_jqBar = $("<div>");
		_jqBar.addClass("kdlight-confirmbar");
		_jqBar.append(_jqCancel);
		_jqBar.append(jqSeperator);
		_jqBar.append(_jqOk);
	})();
	
	this.getJqUi = function()
	{
		return _jqBar;
	}
	
	/**
	 * 设置按钮点击后的回调函数，形如func(bOk)
	 * 其中bOk为true表示按了[确定]，否则为[取消]
	 */
	this.setActionListener = function(funListener)
	{
		_funAction = funListener;
	}
	
	this.setOkVisible = function(bVisible)
	{
		_jqOk.css("display", (bVisible ? "" : "none"));
	}
	
	this.setCancelVisible = function(bVisible)
	{
		_jqCancel.css("display", (bVisible ? "" : "none"));
	}
}


/**
 * 点点点滑动页签 
 */
kdlight.SwipableTabContainer = function()
{
	var _jqUi;
	var _jqContainer;
	var _jqDotDotDot;
	var _iTabIndex = 0;
	
	var _iDotDotDotSize = 10;
	var _iDotDotDotMargin = 6;
	var _iDotDotDotBottom = 40;
	
	var _arrDragStartPos = null;
	
	(function init()
	{
		_jqContainer = $("<div>");
		_jqContainer.css("position", "absolute");
		_jqContainer.css("top", 0);
		_jqContainer.css("bottom", 0);
		_jqContainer.css("left", 0);
		_jqContainer.css("z-index", 1);
		
		_jqDotDotDot = $("<div>");
		_jqDotDotDot.css("position", "absolute");
		_jqDotDotDot.css("z-index", 2);

		_jqUi = $("<div>");
		_jqUi.addClass("kdlight-swipabletab");
		_jqUi.append(_jqContainer);
		_jqUi.append(_jqDotDotDot);
		
		_jqUi.on("vmousedown", function(evt){doPress(evt)});
		_jqUi.on("vmousemove", function(evt){doDrag(evt)});
		_jqUi.on("vmouseup", function(evt){doCancel(evt)});
		_jqUi.on("mouseleave", function(evt){doCancel(evt)});
		_jqUi.on("touchmove", function(evt){evt.preventDefault();});//防止iOS浏览器下拉
	})();
	
	this.getJqUi = function()
	{
		return _jqUi;
	}
	
	this.clearAllTabs = function()
	{
		_jqContainer.children().remove();
		_jqDotDotDot.children().remove();
		_iTabIndex = 0;
		_jqContainer.css("left", 0);
	}
	
	this.addTabContent = function(jqPanel)
	{
		var iCount = getTabCount();
		var iWidth = _jqUi.width();
		jqPanel.css("position", "absolute");
		jqPanel.css("top", 0);
		jqPanel.css("bottom", 0);
		jqPanel.css("left", iWidth * iCount);
		jqPanel.css("width", iWidth);
		
		iCount++;
		_jqContainer.css("width", iWidth * iCount);
		_jqContainer.append(jqPanel);
		
		var jqDot = $("<div>");
		jqDot.css("position", "relative");
		jqDot.css("float", "left");
		jqDot.css("margin", _iDotDotDotMargin + "px");
		jqDot.css("width", _iDotDotDotSize + "px");
		jqDot.css("height", _iDotDotDotSize + "px");
		jqDot.css("border-radius", (_iDotDotDotSize >> 1) + "px");
		jqDot.addClass("kdlight-swipabletab-dot");
		_jqDotDotDot.append(jqDot);
		
		if(iCount == 1)
		{
			_jqDotDotDot.css("display", "none");
		}
		else
		{
			_jqDotDotDot.css("display", "block");
			var iWidthForDdd = (_iDotDotDotMargin * 2 + _iDotDotDotSize) * iCount;
			_jqDotDotDot.width(iWidthForDdd);
			_jqDotDotDot.css("left", "50%");
			_jqDotDotDot.css("margin-left", -(iWidthForDdd >> 1));
			_jqDotDotDot.css("bottom", _iDotDotDotBottom);
			updateDotDotDotSelected();
		}
	}
	
	this.setDotDotDotContext = function(iSize, iMargin, iBottom)
	{
		_iDotDotDotSize = iSize;
		_iDotDotDotMargin = iMargin;
		_iDotDotDotBottom = iBottom;
	}
	
	var updateDotDotDotSelected = function()
	{
		var jqChildren = _jqDotDotDot.children();
		jqChildren.removeClass("kdlight-swipabletab-dot_selected");
		$(jqChildren[_iTabIndex]).addClass("kdlight-swipabletab-dot_selected");
	}
	
	var getTabCount = function()
	{
		return _jqContainer.children().length;
	}
	
	var swipeLeft = function()
	{
		if(_iTabIndex == getTabCount() - 1)
		{
			return;
		}
		_iTabIndex++;
		swiping();
	}
	
	var swipeRight = function()
	{
		if(_iTabIndex == 0)
		{
			return;
		}
		_iTabIndex--;
		swiping();
	}
	
	var swiping = function()
	{
		var iSwipeToX = -_jqUi.width() * _iTabIndex;
		_jqContainer.animate(
			{
				left: iSwipeToX
			});
		updateDotDotDotSelected();
	}
	
	var doPress = function(evt)
	{
		_arrDragStartPos = [evt.screenX, evt.screenY];
	}
		
	var doDrag = function(evt)
	{
		if(!_arrDragStartPos)
		{
			return;
		}
		var iDeltaX = Math.abs(evt.screenX - _arrDragStartPos[0]);
		var iDeltaY = Math.abs(evt.screenY - _arrDragStartPos[1]);
		if(iDeltaX > 40 && iDeltaX * 0.58 > iDeltaY)//约30度
		{
			if(evt.screenX < _arrDragStartPos[0])
			{
				swipeLeft();
			}
			else
			{
				swipeRight();
			}
			doCancel();
		}
	}
		
	var doCancel = function(evt)
	{
		_arrDragStartPos = null;
	}
}

kdlight.SimScrollbar = function()
{
	var THUMB_PADDING = 2;
	var TRACK_EDGE_DISTANCE = 2;
	var THUMB_MIN_LEN = 20;
	
	var _jqReal;
	var _jqOwner;
	var _jqHThumb;
	var _jqVThumb;
	var _iLastScrollLeft = 0;//用于判断横滚还是竖滚
	var _iLastScrollingTime = 0;
	var _iTimerTag;

	var _nVTrackParam;
	var _nVThumbParam;
	var _nHTrackParam;
	var _nHThumbParam;
	
	var _iMinX = 0;
	var _bDraging = false;
	var _iDragingStartX = 0;
	var _iScrollStartLeft = 0;
	var _iScrollStartX = 0;
		
	this.setHBarVisible = function(bVisible)
	{
		var jqNew = null;
		if(bVisible)
		{
			jqNew = $("<div>");
			jqNew.css("display", "none");
			jqNew.addClass("kdlight-simscrollbar-h-thumb");
		}
		resetHBar(_jqHThumb, jqNew);
	}
	
	this.setVBarVisible = function(bVisible)
	{
		var jqNew = null;
		if(bVisible)
		{
			jqNew = $("<div>");
			jqNew.css("display", "none");
			jqNew.addClass("kdlight-simscrollbar-v-thumb");
		}
		resetVBar(_jqVThumb, jqNew);
	}
	
	this.bindRealScroller = function(jqDiv)
	{
		_jqReal = jqDiv;
		_jqReal.on("scroll", doScrolling);
		
		if(_jqHThumb)
		{
			_jqReal.on("mousedown", doMouseDown);
			_jqReal.on("mousemove", doMouseDrag);
			_jqReal.on("mouseup", doMouseUp);
			_jqReal.on("mouseleave", doMouseLeave)
		}
	}
	
	this.bindScrollbarOwner = function(jqOwner)
	{
		_jqOwner = jqOwner;
		resetHBar(_jqHThumb, _jqHThumb);
		resetVBar(_jqVThumb, _jqVThumb);
	}
	
	var resetHBar = function(jqOld, jqNew)
	{
		if(jqOld)
		{
			jqOld.remove();
		}
		if(_jqOwner && jqNew)
		{
			_jqOwner.append(jqNew);
		}
		_jqHThumb = jqNew;
	}
	
	var resetVBar = function(jqOld, jqNew)
	{
		if(jqOld)
		{
			jqOld.remove();
		}
		if(_jqOwner && jqNew)
		{
			_jqOwner.append(jqNew);
		}
		_jqVThumb = jqNew;
	}

	var doScrolling = function(evt)
	{
		if(_iLastScrollingTime == 0)
		{
			if(_jqHThumb && isHBarShown())
			{
				_jqHThumb.css("display", "block");
				startUpdateHBar();
			}
			if(_jqVThumb && isVBarShown())
			{
				_jqVThumb.css("display", "block");
				startUpdateVBar();
			}
			updatingVBar();
			updatingHBar();
			restartTimer();
		}
		
		_iLastScrollingTime = new Date().getTime();
		if(_iLastScrollLeft == _jqReal.prop("scrollLeft"))//纵向滚动
		{
			updatingVBar();
		}
		else//横向滚动
		{
			_iLastScrollLeft = _jqReal.prop("scrollLeft");
			updatingHBar();
		}
	}
	
	var startUpdateVBar = function()
	{
		var iContentHeight = _jqReal.prop("scrollHeight");
		var iViewHeight = _jqReal.prop("clientHeight");
		
		var iTrackLen = _jqOwner.prop("clientHeight");
		if(_jqHThumb && isHBarShown())
		{
			iTrackLen -= _jqHThumb.prop("offsetHeight");
		}
		_nVTrackParam = iTrackLen / iContentHeight;
		var iThumbLen = parseInt(iViewHeight * _nVTrackParam) - THUMB_PADDING * 2 - TRACK_EDGE_DISTANCE;
		if(iThumbLen < THUMB_MIN_LEN)
		{
			_nVThumbParam = (THUMB_MIN_LEN - iThumbLen) / iContentHeight;
			iThumbLen = THUMB_MIN_LEN;
		}
		_jqVThumb.css("height", iThumbLen);
	}
	
	var updatingVBar = function()
	{
		if(_jqVThumb)
		{
			var iScrollTop = _jqReal.prop("scrollTop");
			var iVThumbDelta = 0;
			if(_nVThumbParam)
			{
				iVThumbDelta = parseInt(iScrollTop * _nVThumbParam);
			}
			var iVThumbStart = parseInt(iScrollTop * _nVTrackParam) + _jqOwner.prop("scrollTop") + THUMB_PADDING - iVThumbDelta;
			_jqVThumb[0].style["-webkit-transform"] = "translateX(0) translateY("+ iVThumbStart +"px) translateZ(0)";
		}
		if(_jqHThumb)
		{
			var iHThumbTop = _jqOwner.prop("scrollTop") + _jqOwner.prop("clientHeight") - _jqHThumb.prop("offsetHeight") - TRACK_EDGE_DISTANCE;
			_jqHThumb.css("top", iHThumbTop);
		}
	}
	
	var startUpdateHBar = function()
	{
		var iContentWidth = _jqReal.prop("scrollWidth");
		var iViewWidth = _jqReal.prop("clientWidth");
		
		var iTrackLen = _jqOwner.prop("clientWidth");
		if(_jqVThumb && isVBarShown())
		{
			iTrackLen -= _jqVThumb.prop("offsetWidth");
		}
		_nHTrackParam = iTrackLen / iContentWidth;
		var iThumbLen = parseInt(iViewWidth * _nHTrackParam) - THUMB_PADDING * 2 - TRACK_EDGE_DISTANCE;
		if(iThumbLen < THUMB_MIN_LEN)
		{
			_nHThumbParam = (THUMB_MIN_LEN - iThumbLen) / iContentWidth;
			iThumbLen = THUMB_MIN_LEN;
		}
		_jqHThumb.css("width", iThumbLen);
	}
	
	var updatingHBar = function()
	{
		if(_jqHThumb)
		{
			var iScrollLeft = _jqReal.prop("scrollLeft");
			var iHThumbDelta = 0;
			if(_nHThumbParam)
			{
				iHThumbDelta = parseInt(iScrollLeft * _nHThumbParam);
			}
			var iHThumbStart = parseInt(iScrollLeft * _nHTrackParam) + _jqOwner.prop("scrollLeft") + THUMB_PADDING - iHThumbDelta;
			_jqHThumb[0].style["-webkit-transform"] = "translateX("+ iHThumbStart +"px) translateY(0) translateZ(0)";
		}
		if(_jqVThumb)
		{
			var iVThumbLeft = _jqOwner.prop("scrollLeft") + _jqOwner.prop("clientWidth") - _jqVThumb.prop("offsetWidth") - TRACK_EDGE_DISTANCE;
			_jqVThumb.css("left", iVThumbLeft);
		}
	}
	
	var isHBarShown = function()
	{
		return  _jqReal.prop("scrollWidth") > _jqReal.prop("clientWidth");
	}
	
	var isVBarShown = function()
	{
		return _jqReal.prop("scrollHeight") > _jqReal.prop("clientHeight");
	}
		
	var tryToHideBar = function()
	{
		if(new Date().getTime() - _iLastScrollingTime > 500)
		{
			setTimeout(
				function()
				{
					_iLastScrollingTime = 0;
				},
				100);
			if(_jqHThumb)
			{
				_jqHThumb.css("display", "none");
			}
			if(_jqVThumb)
			{
				_jqVThumb.css("display", "none");
			}
			clearTimeout(_iTimerTag);
		}
		else
		{
			restartTimer();
		}
	}
	
	var restartTimer = function()
	{
		clearTimeout(_iTimerTag);
		_iTimerTag = setTimeout(tryToHideBar, 500);
	}
	
	//--列冻结横向滚动条 start--
	var doMouseLeave = function(evt)
	{
		doMouseUp(evt);
	}

	var doMouseDown = function(evt)
	{
		_bDraging = true;
		_iScrollStartLeft = _iScrollStartX;
		_iDragingStartX = evt.screenX;
		_iMinX = _jqOwner.prop("clientWidth") - _jqReal.prop("scrollWidth") - 12/*两边留白宽度*/;
	}

	var doMouseDrag = function(evt)
	{
		if(_bDraging)
		{
			updatingHBarDesktop(evt);
		}
	}
	
	var doMouseUp = function(evt)
	{
		_bDraging = false;
		_iDragingStartX = 0;
	}
	
	var updatingHBarDesktop = function(evt)
	{
		if(_jqHThumb)
		{
			var iScrollLeft = _iScrollStartLeft + evt.screenX - _iDragingStartX
			if(iScrollLeft < _iMinX || iScrollLeft > 0)
			{
				iScrollLeft = iScrollLeft > 0 ? 0 : _iMinX;
			}
			_iScrollStartX = iScrollLeft;
			_jqReal.prop("scrollLeft", -iScrollLeft);
		}
	}
	//--列冻结横向滚动条 end--
}

/** 支持下拉刷新的容器 */
kdlight.PulldownContainer = function()
{
	var _jqUi = $("<div>");
	var _jqContent;
	var _jqPrompt;
	
	var _iEffectDistance = 70;//拉多远放开才起作用的阀值
	var _funEffectListener;
	
	(function()
	{
		_jqUi.on("vmousedown", function(evt){doPress(evt);});
		_jqUi.on("vmouseup", function(evt){doRelease(evt)});
		_jqUi.on("vmousemove", function(evt){doDrag(evt)});
	})();
	
	/**
	 * 拉到大于阀值后放开的事件
	 */
	this.setEffectListener = function(funAction)
	{
		_funEffectListener = funAction;
	}
	
	/**
	 * 设置是否显示刷新提示
	 */
	this.setShowPrompt = function(bShow)
	{
		if(!bShow)
		{
			if(_jqPrompt)
			{
				_jqPrompt.remove();
			}
			_jqPrompt = null;
			return;
		}
		var jqPulldown = $("<div>");
		jqPulldown.text("↓ 下拉刷新");
		jqPulldown.addClass("kdlight-pulldown-prompt");
		
		var jqEnough = $("<div>");
		jqEnough.text("↑ 释放立即刷新");
		jqEnough.addClass("kdlight-pulldown-prompt");
		
		var iTop = -40;
		_jqPrompt = $("<div>");
		_jqPrompt.data("kdlight-sys-top", iTop);
		_jqPrompt.css({
			position: "absolute",
			top: iTop + "px",
			width: "100%",
		});
		_jqPrompt.append(jqPulldown);
		_jqPrompt.append(jqEnough);
		_jqUi.append(_jqPrompt);
	}
	
	/**
	 * 将滚动容器传进来
	 */
	this.setJqContent = function(jqContent)
	{
		_jqContent = jqContent;
		_jqUi.append(jqContent);
		jqContent.css("position", "absolute");
		jqContent.width("100%");
		jqContent.height("100%");
	}
	
	this.getJqUi = function()
	{
		return _jqUi;
	}
	
	var _bPressed;
	var _iPressY = -1;
	var _iStartY = -1;
	var _bEnough;
	var doPress = function(evt)
	{
		_bPressed = true;
		_iPressY = evt.clientY;
		_bEnough = false;
	}
	
	var doRelease = function(evt)
	{
		_bPressed = false;
		_iPressY = -1;
		if(_iStartY > 0)
		{
			_iStartY = -1;
			_jqContent.animate({"top": 0}, "fast");
			_jqPrompt.animate({"top": _jqPrompt.data("kdlight-sys-top")}, "fast");
			_jqContent.css("overflow", _jqContent.data("kdlight-sys-overflow"));
			if(_bEnough && _funEffectListener)
			{
				_funEffectListener();
			}
		}
	}
	
	var doDrag = function(evt)
	{
		if(!_bPressed)
		{
			return;
		}
		if(!(_jqContent.prop("scrollTop") == 0  && evt.clientY - _iPressY > 0)
			&& !(_jqContent.prop("scrollTop") + _jqContent.prop("clientHeight") == _jqContent.prop("scrollHeight") && evt.clientY - _iPressY < 0))
		{
			return;
		}
		if(_iStartY <= 0)
		{
			_jqContent.data("kdlight-sys-overflow", _jqContent.css("overflow"));
			_jqContent.css("overflow", "hidden");
			_iStartY = evt.clientY;
			return;
		}
		var iCurrentY = evt.clientY;
		var iDeltaY = (iCurrentY - _iStartY) * 0.3;
		_jqContent.css("top", iDeltaY);
		_jqPrompt.css("top", _jqPrompt.data("kdlight-sys-top") + iDeltaY);

		_bEnough = (iDeltaY > _iEffectDistance && iDeltaY > 0);
		updatePulldownPrompt(_bEnough);
	}
	
	var updatePulldownPrompt = function(bEnough)
	{
		var jqPulldown = _jqPrompt.children().first();
		var jqEnough = _jqPrompt.children().last();
		if(bEnough)
		{
			jqEnough.css("display", "block");
			jqPulldown.css("display", "none");
		}
		else
		{
			jqEnough.css("display", "none");
			jqPulldown.css("display", "block");
		}
	}
}

/**
 * 日期、时间选择器
 */
kdlight.DateTimeChooser = function()
{
	var _this = this;
	
	var _iMode;
	var _oDate = new Date();
	var _funSelectedListener;
	var _funInputFieldUpdateCallback;
	var _bDirty = false;
	
	var _oBlockYear;
	var _oBlockMonth;
	var _oBlockDay;
	var _oBlockHour;
	var _oBlockMinute;
	var _oBlockSecond;
	
	/** MODE_DATE | MODE_TIME | MODE_DATETIME */
	this.setMode = function(iMode)
	{
		_iMode = iMode;
	}
	
	/** 选中值，Date对象 */
	this.setSelectValue = function(oDate)
	{
		if(!oDate || !(oDate instanceof Date))
		{
			throw new Error("Parameter must be Date object.");
		}
		_oDate = oDate;
		
		updateBlocks(_oDate);
		if(_funInputFieldUpdateCallback)
		{
			_funInputFieldUpdateCallback();
		}
	}
	this.getSelectValue = function()
	{
		if(_bDirty)
		{
			acceptEdit();
		}
		return _oDate;
	}
	
	/**
	 * funCallback 形如：func(bOk, oDate)
	 */
	this.setSelectedListener = function(funCallback)
	{
		_funSelectedListener = funCallback;
	}
	
	/**
	 * 用法一：获取TextField风格的输入框，jQuery封装
	 * 与popup()、getSelectablePanel()三者间是互斥的用法。
	 */
	this.getInputField = function()
	{
		var jqA = $("<a href='#' style='text-align:center; white-space:pre-wrap'></a>");
		jqA.text(getTextForInputField());
		
		var jqLi = $("<li>");
		jqLi.append(jqA);
		
		var jqUL = $("<ul>");
		jqUL.attr("data-role", "listview");
		jqUL.attr("data-inset", "true");
		jqUL.attr("data-icon", "carat-d");
		jqUL.append(jqLi);
		jqUL.listview();
		
		jqUL.on("click", doInputFieldClick);
		_funInputFieldUpdateCallback = function()
		{
			jqA.text(getTextForInputField());
		}
		
		return jqUL;
	}
	
	/**
	 * 用法二：弹出选择界面
	 * 通过setSelectedListener()指定关闭时的回调
	 */
	this.popup = function()
	{
		var jqPopup = $("<div data-theme='a' data-overlay-theme='a' data-dismissible='false' data-history='false'>");
		jqPopup.css("padding", 10);
		jqPopup.popup();
		jqPopup.popup({transition: "pop"});
		
		var jqPanel = this.getSelectablePanel(jqPopup);
		jqPanel.css("position", "relative");

		var jqBtnNow = $("<div>");
		jqBtnNow.addClass("kdlight-datetime-btn");
		jqBtnNow.css("float", "left");
		jqBtnNow.text(_iMode == kdlight.DateTimeChooser.MODE_DATE ? "今天" : "现在");
		jqBtnNow.on("click", doNowClick);
		
		var jqBtnOk = $("<div>");
		jqBtnOk.addClass("kdlight-datetime-btn");
		jqBtnOk.css("float", "right");
		jqBtnOk.text("确定");
		jqBtnOk.on("click", function(evt){doOkClick(jqPopup);});

		var jqBtnCancel = $("<div>");
		jqBtnCancel.addClass("kdlight-datetime-btn");
		jqBtnCancel.css("float", "right");
		jqBtnCancel.css("margin-right", "6px");
		jqBtnCancel.text("取消");
		jqBtnCancel.on("click", function(evt){doCancelClick(jqPopup);});
		
		var jqFooter = $("<div>");
		jqFooter.addClass("kdlight-datetime-footer");
		jqFooter.append(jqBtnNow);
		jqFooter.append(jqBtnOk);
		jqFooter.append(jqBtnCancel);
		jqFooter.appendTo(jqPopup);
		
		jqPopup.popup("open");
	}
	
	/**
	 * 用法三：获取选择面板，jQuery封装
	 */
	this.getSelectablePanel = function(jqParent)
	{
		var jqPanel = $("<div>");
		jqParent.append(jqPanel);
		switch(_iMode)
		{
			case kdlight.DateTimeChooser.MODE_DATE:
				createDatePanel(jqPanel);
				break;
			case kdlight.DateTimeChooser.MODE_TIME:
				createTimePanel(jqPanel);
				break;
			case kdlight.DateTimeChooser.MODE_DATETIME:
				jqPanel.css("position", "relative");
				createFullPanel(jqPanel);
				break;
			default:
				throw new Error("setMode() please!");
		}
		return jqPanel;
	}
	
	var getTextForInputField = function()
	{
		var sText = "";
		if(_iMode == kdlight.DateTimeChooser.MODE_DATE || _iMode == kdlight.DateTimeChooser.MODE_DATETIME)
		{
			sText += _oDate.getFullYear() 
				+ "-" + makeSureDoubleDigit(_oDate.getMonth() + 1) 
				+ "-" + makeSureDoubleDigit(_oDate.getDate());
		}
		if(_iMode == kdlight.DateTimeChooser.MODE_TIME || _iMode == kdlight.DateTimeChooser.MODE_DATETIME)
		{
			sText += (sText.length > 0 ? "   " : "");
			sText += makeSureDoubleDigit(_oDate.getHours()) 
				+ ":"  + makeSureDoubleDigit(_oDate.getMinutes()) 
				+ ":"  + makeSureDoubleDigit(_oDate.getSeconds());
		}
		return sText;
	}
	
	var makeSureDoubleDigit = function(iValue)
	{
		return (iValue < 10 ? "0" : "" ) + iValue;
	}
	
	var doInputFieldClick = function(evt)
	{
		_this.popup();
	}
	
	var doNowClick = function(evt)
	{
		updateBlocks(new Date());
	}
	
	var updateBlocks = function(oDate)
	{
		if(_oBlockYear)
		{
			var iYear = oDate.getFullYear();
			var iMonth = oDate.getMonth() + 1;
			var iDay = oDate.getDate();
			var iMaxDay = confirmMonthDays(iYear, iMonth);
			
			_oBlockYear.setValue(iYear);
			_oBlockMonth.setValue(iMonth);
			_oBlockDay.setModel(1, iMaxDay, iDay);
		}
		if(_oBlockHour)
		{
			_oBlockHour.setValue(oDate.getHours());
			_oBlockMinute.setValue(oDate.getMinutes());
			_oBlockSecond.setValue(oDate.getSeconds());
		}		
	}
	
	var doOkClick = function(jqPopup)
	{
		acceptEdit();
		closePopup(jqPopup);
		if(_funInputFieldUpdateCallback)
		{
			_funInputFieldUpdateCallback();
		}
		if(_funSelectedListener)
		{
			_funSelectedListener(true, _oDate);
		}
	}
	
	var doCancelClick = function(jqPopup)
	{
		_bDirty = false;
		closePopup(jqPopup);
		if(_funSelectedListener)
		{
			_funSelectedListener(false, _oDate);
		}
	}
	
	var closePopup = function(jqPopup)
	{
		destroyBlocks();
		jqPopup.popup("close");
		jqPopup.popup("destroy");	
	}
	
	var acceptEdit = function()
	{
		var oDate = new Date();
		if(_oBlockYear)
		{
			oDate.setFullYear(_oBlockYear.getValue(), _oBlockMonth.getValue() - 1, _oBlockDay.getValue());
		}
		if(_oBlockHour)
		{
			oDate.setHours(_oBlockHour.getValue());
			oDate.setMinutes(_oBlockMinute.getValue());
			oDate.setSeconds(_oBlockSecond.getValue());
		}
		_oDate = oDate;
		_bDirty = false;
	}
	
	var createFullPanel = function(jqParent)
	{
		var jqGroupDate = $("<div>");
		jqParent.append(jqGroupDate);
		
		var jqGroupTime = $("<div>");
		jqParent.append(jqGroupTime);
		
		createDatePanel(jqGroupDate);
		createTimePanel(jqGroupTime);
	}
	
	var createDatePanel = function(jqGroup)
	{
		var iYear = _oDate.getFullYear();
		var iMonth = _oDate.getMonth() + 1;
		var iDay = _oDate.getDate();
		var iMaxDay = confirmMonthDays(iYear, iMonth);
		
		jqGroup.addClass("kdlight-datetime-group");
		_oBlockYear = createBlock(jqGroup, "kdlight-datetime-left", "年", 1900, 2099, iYear);
		_oBlockMonth = createBlock(jqGroup, "kdlight-datetime-center", "月", 1, 12, iMonth);
		_oBlockDay = createBlock(jqGroup, "kdlight-datetime-right", "日", 1, iMaxDay, iDay);
		
		_oBlockYear.setValueChangedListener(
			function(iYear)
			{
				makeDirty();
				if(_oBlockMonth.getValue() == 2)
				{
					var iMaxDay = (isLeapYear(iYear) ? 29 : 28);
					var iDay = _oBlockDay.getValue();
					iDay = (iDay > iMaxDay ? iMaxDay : iDay);
					_oBlockDay.setModel(1, iMaxDay, iDay);
				}
			}
		);
		_oBlockMonth.setValueChangedListener(
			function(iMonth)
			{
				makeDirty();
				var iMaxDay = confirmMonthDays(_oBlockYear.getValue(), iMonth);
				var iDay = _oBlockDay.getValue();
				iDay = (iDay > iMaxDay ? iMaxDay : iDay);
				_oBlockDay.setModel(1, iMaxDay, iDay);
			}
		);
		_oBlockDay.setValueChangedListener(makeDirty);
	}
	
	var createTimePanel = function(jqGroup)
	{
		jqGroup.addClass("kdlight-datetime-group");
		_oBlockHour = createBlock(jqGroup, "kdlight-datetime-left", "时", 0, 23, _oDate.getHours());
		_oBlockMinute = createBlock(jqGroup, "kdlight-datetime-center", "分", 0, 59, _oDate.getMinutes());
		_oBlockSecond = createBlock(jqGroup, "kdlight-datetime-right", "秒", 0, 59, _oDate.getSeconds());
		_oBlockHour.setValueChangedListener(makeDirty);
		_oBlockMinute.setValueChangedListener(makeDirty);
		_oBlockSecond.setValueChangedListener(makeDirty);
	}
	
	var createBlock = function(jqParent, sClass, sTitle, iMin, iMax, iValue)
	{
		var jqTitle = $("<div>");
		jqTitle.addClass("kdlight-datetime-blocktitle");
		jqTitle.addClass(sClass);
		jqTitle.text(sTitle);
		jqParent.append(jqTitle);
		
		var jqBlockOwner = $("<div>");
		jqBlockOwner.addClass("kdlight-datetime-blockowner");
		jqBlockOwner.addClass(sClass);
		jqParent.append(jqBlockOwner);
		
		var oBlock = new SelectableBlock();
		oBlock.setModel(iMin, iMax, iValue);
		oBlock.create(jqBlockOwner);
		return oBlock;
	}
	
	var destroyBlocks = function()
	{
		if(_oBlockYear)
		{
			_oBlockYear.destroy();
			_oBlockYear = null;
			_oBlockMonth.destroy();
			_oBlockMonth = null;
			_oBlockDay.destroy();
			_oBlockDay = null;
		}
		if(_oBlockHour)
		{
			_oBlockHour.destroy();
			_oBlockHour = null;
			_oBlockMinute.destroy();
			_oBlockMinute = null;
			_oBlockSecond.destroy();
			_oBlockSecond = null;
		}
	}
	
	var isLeapYear = function(iYear)
	{
		return ((iYear % 4 == 0 && iYear % 100 != 0) || iYear % 400 == 0);
	}

	var confirmMonthDays = function(iYear, iMonth)
	{
		var iMaxDay = 28;
		if(iMonth == 2)
		{
			if(isLeapYear(iYear))
			{
				iMaxDay = 29;
			}
		}
		else if(iMonth < 8)
		{
			iMaxDay = (iMonth % 2 == 0 ? 30 : 31);
		}
		else
		{
			iMaxDay = (iMonth % 2 == 0 ? 31 : 30);
		}
		return iMaxDay;
	}
	
	var makeDirty = function()
	{
		_bDirty = true;
	}
	
	/**
	 * 一个选择块可能是年、月、日或时、分、秒任何之一
	 */
	function SelectableBlock()
	{
		var _iMin = 1;
		var _iMax = 60;
		var _iValue = 1;
		
		var _funValueChanged;
		
		var _jqBlock;
		var _jqItemsContainer;
		
		var _iItemHeight;
		var _bPressed = false;
		var _iStartY;
		var _iStartDragingTime = -1;
		var _iContainerTop;
		
		this.setModel = function(iMin, iMax, iValue)
		{
			_iMin = iMin;
			_iMax = iMax;
			_iValue = iValue;
			if(_jqBlock)
			{
				updateItems();
				scrollToValue(_iValue, 100);
			}
		}
		
		this.setValueChangedListener = function(funCallback)
		{
			_funValueChanged = funCallback;
		}
		
		this.setValue = function(iValue)
		{
			_iValue = iValue;
			if(_jqBlock)
			{
				updateItems();
				scrollToValue(_iValue, 200);
			}
		}
		
		this.getValue = function()
		{
			return _iValue;
		}
		
		this.create = function(jqOwner)
		{
			_jqBlock = createUi();
			jqOwner.append(_jqBlock);
			_iItemHeight = parseInt($(_jqItemsContainer.children()[0]).height());
			scrollToValue(_iValue, 10);
		}
		
		this.destroy = function()
		{
			if(_jqBlock)
			{
				_jqBlock.remove();
			}
		}
		
		var createUi = function()
		{
			var jqBlock = $("<div>");
			jqBlock.addClass("kdlight-datetime-block");
			jqBlock.on("vmousedown", doPress);
			jqBlock.on("vmouseup", doRelease);
			jqBlock.on("vmousemove", doDrag);
			jqBlock.on("vmouseout", doCancel);
			jqBlock.on("mouseleave", doCancel);
			jqBlock.on("touchmove", function(evt){evt.preventDefault();});//防止iOS浏览器下拉
			
			var jqBackground = $("<div>");
			jqBackground.addClass("kdlight-datetime-block-back");
			jqBlock.append(jqBackground);
			
			var jqMidLine = $("<div>");
			jqMidLine.addClass("kdlight-datetime-block-midline");
			jqBlock.append(jqMidLine);

			_jqItemsContainer = $("<div>");
			_jqItemsContainer.addClass("kdlight-datetime-itemscontainer")
			_jqItemsContainer.css("top", 0);
			jqBlock.append(_jqItemsContainer);
		
			var jqMask = $("<div>");
			jqMask.addClass("kdlight-datetime-block-mask");
			jqBlock.append(jqMask);
			
			updateItems();
			return jqBlock;
		}
		
		var updateItems = function()
		{
			_jqItemsContainer.children().remove();
			var jqFragment = $(document.createDocumentFragment());
			for(var i = _iMin; i <= _iMax; i++)
			{
				var jqItem = $("<div>");
				jqItem.addClass("kdlight-datetime-item");
				jqItem.text(i < 10 ? "0" + i : i);
				jqFragment.append(jqItem);
			}
			_jqItemsContainer.append(jqFragment);
		}
		
		var scrollToValue = function(iValue, iMs)
		{
			var iIdx = iValue - _iMin;
			var iContainerTop = itemIndex2ContainerTop(iIdx);
			_jqItemsContainer.animate({"top": iContainerTop}, iMs);
		}

		var itemIndex2ContainerTop = function(iIdx)
		{
			var iBlockHeight = parseInt(_jqBlock.height());
			return iBlockHeight / 2 - _iItemHeight * iIdx - _iItemHeight / 2;
		}
		
		var containerTop2ItemIndex = function(iContainerTop)
		{
			var iBlockHeight = parseInt(_jqBlock.height());
			return parseInt((iBlockHeight / 2 - iContainerTop - _iItemHeight / 2) / _iItemHeight);
		}
		
		var scrollToNearest = function(iContainerTop)
		{
			var iIdx = containerTop2ItemIndex(iContainerTop);
			var iMinIdx = 0;
			var iMaxIdx = _iMax - _iMin;
			iIdx = (iIdx < iMinIdx ? iMinIdx : iIdx);
			iIdx = (iIdx > iMaxIdx ? iMaxIdx : iIdx);
			var iContainerTop = itemIndex2ContainerTop(iIdx);
			_jqItemsContainer.css("top", iContainerTop);
			
			var iOldValue = _iValue;
			_iValue = _iMin + iIdx;
			_iContainerTop = iContainerTop;
			
			if(iOldValue != _iValue && _funValueChanged)
			{
				_funValueChanged(_iValue);
			}
		}
		
		var doPress = function(evt)
		{
			_iStartY = evt.screenY;
			_iStartDragingTime = -1;
			_iContainerTop = parseInt(_jqItemsContainer.css("top"));
			_bPressed = true;

			//滚动过程中按下，变成暂停
			_jqItemsContainer.stop();
			_jqItemsContainer.dequeue();
			scrollToNearest(_iContainerTop);
		}
		
		var doDrag = function(evt)
		{
			if(!_bPressed)
			{
				return;
			}
			if(_iStartDragingTime < 0)
			{
				_iStartDragingTime = new Date().getTime();
			}
			var iY = evt.screenY;
			var iDeltaY = iY - _iStartY;
			_jqItemsContainer.css("top", _iContainerTop + iDeltaY + "px");
		}
		
		var doRelease = function(evt)
		{
			_bPressed = false;
			if(_iStartDragingTime < 0)
			{
				return;
			}
			var iEndY = evt.screenY;
			var iEndDragingTime = new Date().getTime();
			var iDeltaY = iEndY - _iStartY;
			var iDeltaTime = iEndDragingTime - _iStartDragingTime;
			var iDir = (iDeltaY > 0 ? -1 : 1);
			var fAdjustValue;
			var iAnimateDuration;
			if(iDeltaTime > 150)//抹得慢，就近停靠
			{
				fAdjustValue = Math.abs(iDeltaY) / _iItemHeight + 0.5;
				iAnimateDuration = 300;
			}
			else//抹得快，有惯性，再飞一会儿
			{
				iDeltaTime = (iDeltaTime == 0 ? 1 : iDeltaTime);
				var fSpeed = Math.abs(iDeltaY) / iDeltaTime;//实测零点几到3之间，密集在1左右。
				fAdjustValue = fSpeed * fSpeed * 9;//二次曲线，值越大变化越快。算法不唯一，可以视效果再调整。
				iAnimateDuration = 500;
			}
			var iAdjustValue = parseInt(fAdjustValue) * iDir;
			adjustValue(iAdjustValue, iAnimateDuration);
		}
		
		var doCancel = function(evt)
		{
			if(_bPressed)
			{
				doRelease(evt);
			}
		}
		
		var adjustValue = function(iDeltaValue, iAnimateDuration)
		{
			var iOldValue = _iValue;
			_iValue += iDeltaValue;
			_iValue = (_iValue < _iMin ? _iMin : _iValue);
			_iValue = (_iValue > _iMax ? _iMax : _iValue);
			scrollToValue(_iValue, iAnimateDuration);
			if(iOldValue != _iValue && _funValueChanged)
			{
				_funValueChanged(_iValue);
			}
		}
	}
}
kdlight.DateTimeChooser.MODE_DATE = 0;
kdlight.DateTimeChooser.MODE_TIME = 1;
kdlight.DateTimeChooser.MODE_DATETIME = 2;


/**
 * 底部导航栏容器
 */
kdlight.BottomTabContainer = function()
{
	var _jqUi;
	var _jqBar;
	var _arrButtons;
	var _iSelectedIndex;
	var _iHeightForBar = 44;
	var _arrTabChangedListeners = [];
	var _arrTabPreChangeListeners = [];
	
	this.getJqUi = function()
	{
		initUi();
		return _jqUi;
	}
	
	this.addTab = function(sText, sIconUrl, sIconUrlForSelected, funRedDotAnnouncer)
	{
		initUi();
		var jqBtn = createButton(sText, sIconUrl, sIconUrlForSelected);
		_jqBar.append(jqBtn);
		relayoutButton();
		
		var jqTabPanel = $("<div>");
		jqTabPanel.addClass("kdlight-bottomtab-panel");
		jqTabPanel.css({"bottom": _iHeightForBar + "px"});
		jqTabPanel.appendTo(_jqUi);
		return jqTabPanel;
	}
	
	this.setSelectedIndex = function(iIdx)
	{
		_iSelectedIndex = iIdx;
		selectButton(_iSelectedIndex);
	}
	
	this.showTabBar = function(bShow)
	{
		var jqPanel = getPanelByIndex(_iSelectedIndex);
		jqPanel.animate({"bottom": (bShow ? _iHeightForBar + "px" : 0)}, "fast");
		_jqBar.animate({"height": (bShow ? _iHeightForBar + "px" : 0)}, "fast");
	}

	/** funListener like: func(iOldIndex, sOldTitle, iNewIndex, sNewTitle) */
	this.addTabPreChangeListener = function(funListener)
	{
		_arrTabPreChangeListeners.push(funListener);
	}
		
	/** funListener like: func(iOldIndex, sOldTitle, iNewIndex, sNewTitle) */
	this.addTabChangedListener = function(funListener)
	{
		_arrTabChangedListeners.push(funListener);
	}
	
	this.showRedDot = function(sTitle, bShow, iDisplayNumber)
	{
		var jqButtons = _jqBar.find(".kdlight-bottomtab-btn");
		for(var i = 0; i < jqButtons.length; i++)
		{
			var jqBtn = $(jqButtons[i]);
			if(sTitle == jqBtn.text())
			{
				showRedDotAtButton(jqBtn, bShow, iDisplayNumber);
				break;
			}
		}
	}
	
	var initUi = function()
	{
		if(_jqUi)
		{
			return;
		}
		_jqUi = $("<div>");
		_jqUi.addClass("kdlight-bottomtab");
		
		_jqBar = $("<div>");
		_jqBar.addClass("kdlight-bottomtab-navbar");
		_jqBar.height(_iHeightForBar);
		_jqBar.appendTo(_jqUi);
		_jqBar.click(doClick);
	}
	
	var createButton = function(sText, sIconUrl, sIconUrlForSelected)
	{
		var jqBtn = $("<div>");
		jqBtn.addClass("kdlight-bottomtab-btn");
		jqBtn.text(sText);
		jqBtn.data("icon1", sIconUrl);
		jqBtn.data("icon2", sIconUrlForSelected);
		updateButtonState(jqBtn, false);
		return jqBtn;
	}
	
	var relayoutButton = function()
	{
		var jqButtons = _jqBar.find(".kdlight-bottomtab-btn");
		var fPercent = 100 / jqButtons.length;
		for(var i = 0; i < jqButtons.length; i++)
		{
			var jqBtn = $(jqButtons[i]);
			jqBtn.css("left", fPercent * i + "%");
			jqBtn.width(fPercent + "%");
		}
	}
	
	var selectButton = function(iIdx)
	{
		var jqButtons = _jqBar.find(".kdlight-bottomtab-btn");
		for(var i = 0; i < jqButtons.length; i++)
		{
			var bSelect = (i == iIdx);
			updateButtonState($(jqButtons[i]), bSelect);
			var jqTabPanel = getPanelByIndex(i);
			jqTabPanel.css("display", (bSelect ? "block" : "none"));
		}
	}
	
	var updateButtonState = function(jqBtn, bSelected)
	{
		var sUrl = jqBtn.data("icon" + (bSelected ? "2" : "1"));
		jqBtn.css("background-image", "url(" + sUrl + ")");
		if(bSelected)
		{
			jqBtn.addClass("kdlight-bottomtab-btn_selected");
		}
		else
		{
			jqBtn.removeClass("kdlight-bottomtab-btn_selected");
		}
	}
	
	var getButtonIndex = function(jqBtn)
	{
		var jqButtons = _jqBar.find(".kdlight-bottomtab-btn");
		for(var i = 0; i < jqButtons.length; i++)
		{
			if(jqButtons[i] == jqBtn[0])
			{
				return i;
			}
		}
		return -1;
	}
	
	var getPanelByIndex = function(iIdx)
	{
		var jqPanels = _jqUi.find(".kdlight-bottomtab-panel");
		return $(jqPanels[iIdx]);
	}
	
	var doClick = function(evt)
	{
		var jqBtn = $(evt.target);
		var iIdx = getButtonIndex(jqBtn);
		if(iIdx < 0 || iIdx == _iSelectedIndex)
		{
			return;
		}
		var iOldIdx = _iSelectedIndex;
		_iSelectedIndex = iIdx;
		
		var jqButtons = _jqBar.find(".kdlight-bottomtab-btn");
		var sOldTitle = $(jqButtons[iOldIdx]).text();
		var sNewTitle = jqBtn.text();
		
		for(var i = 0; i < _arrTabPreChangeListeners.length; i++)
		{
			var funListener = _arrTabPreChangeListeners[i];
			funListener(iOldIdx, sOldTitle, _iSelectedIndex, sNewTitle);
		}		
		
		selectButton(iIdx);
		
		for(var i = 0; i < _arrTabChangedListeners.length; i++)
		{
			var funListener = _arrTabChangedListeners[i];
			funListener(iOldIdx, sOldTitle, _iSelectedIndex, sNewTitle);
		}
	}
	
	var showRedDotAtButton = function(jqBtn, bShow, iDisplayNumber)
	{
		var jqRedDot = jqBtn.find(".kdlight-bottomtab-btn-reddot");
		if(bShow)
		{
			if(jqRedDot.length == 0)
			{
				jqRedDot = $("<div>");
				jqRedDot.addClass("kdlight-bottomtab-btn-reddot");
				jqRedDot.appendTo(jqBtn);
			}
			// if(iDisplayNumber)
			// {
				// jqRedDot.text(iDisplayNumber);
			// }
			// else
			// {
				// jqRedDot.text("");
			// }
		}
		else
		{
			jqRedDot.remove();
		}
	}
}

/**
 * 单选框组（jQueryMobile的checkboxradio在三星上不靠谱）
 */
kdlight.RadioGroup = function()
{
	var _jqUi;
	var _oSelectedValue;
	var _funSelectedChangedListener;
	var _funComparer = defaultItemValueComparer;
	
	this.addItem = function(sText, oValue)
	{
		init();
		var arrChildren = _jqUi.children();
		var jqFooter = $(arrChildren[arrChildren.length - 1]);
		createItem(sText, oValue).insertBefore(jqFooter);
		updateFeature();
	}
	
	this.getJqUi = function()
	{
		init();
		return _jqUi;
	}

	this.setSelected = function(oValue)
	{
		_oSelectedValue = oValue;
		updateSelected();
	}
	
	this.getSelected = function()
	{
		return _oSelectedValue;
	}
	
	this.setSelectedChangedListener = function(funListener)
	{
		_funSelectedChangedListener = funListener;
	}
	
	/** funComparer like func(oItemValue1, oItemValue2) */
	this.setItemValueComparer = function(funComparer)
	{
		_funComparer = funComparer;
	}
	
	var init = function()
	{
		if(!_jqUi)
		{
			_jqUi = $("<div>");
			_jqUi.on("click", doClick);
			_jqUi.on("vmousedown", doPress);
			_jqUi.on("vmouseup", doRelease);
			
			var jqBlankFooter = $("<div>");
			jqBlankFooter.width(1);
			jqBlankFooter.height(50);
			jqBlankFooter.appendTo(_jqUi);
		}
	}
	
	var createItem = function(sText, oValue)
	{
		var jqItem = $("<div>");
		jqItem.text(sText);
		jqItem.data("model", oValue);
		jqItem.addClass("kdlight-radiogroup-item");
		jqItem.appendTo(_jqUi);
		
		var jqCircle = $("<div>");
		jqCircle.addClass("kdlight-radiogroup-item-circle");
		jqCircle.appendTo(jqItem);
		
		return jqItem;
	}
	
	var updateFeature = function()
	{
		var arrItems = _jqUi.find(".kdlight-radiogroup-item");
		for(var i = 0; i < arrItems.length; i++)
		{
			var jqItem = $(arrItems[i]);
			if(i == 0)
			{
				jqItem.addClass("kdlight-radiogroup-item-first");
				jqItem.removeClass("kdlight-radiogroup-item-last");
			}
			else if(i == arrItems.length - 1)
			{
				jqItem.removeClass("kdlight-radiogroup-item-first");
				jqItem.addClass("kdlight-radiogroup-item-last");
			}
			else
			{
				jqItem.removeClass("kdlight-radiogroup-item-first");
				jqItem.removeClass("kdlight-radiogroup-item-last");
			}
		}
	}
	
	var updateSelected = function()
	{
		if(!_jqUi || _oSelectedValue === undefined)
		{
			return;
		}
		var arrItems = _jqUi.find(".kdlight-radiogroup-item");
		for(var i = 0; i < arrItems.length; i++)
		{
			var jqItem = $(arrItems[i]);
			var oItemValue = jqItem.data("model");
			var jqCircle = jqItem.find(".kdlight-radiogroup-item-circle");
			if(_funComparer(_oSelectedValue, oItemValue))
			{
				jqCircle.addClass("kdlight-radiogroup-item-circle_selected");
			}
			else
			{
				jqCircle.removeClass("kdlight-radiogroup-item-circle_selected");
			}
		}
	}
	
	var confirmOperatingItem = function(evt)
	{
		if(_jqUi[0] == evt.target)
		{
			return null;
		}
		var jqTarget = $(evt.target);
		while(!jqTarget.hasClass("kdlight-radiogroup-item"))
		{
			jqTarget = jqTarget.parent();
		}
		return jqTarget;
	}
	
	var doClick = function(evt)
	{
		var jqItem = confirmOperatingItem(evt);
		if(jqItem == null)
		{
			return;
		}
		var oItemValue = jqItem.data("model");
		_oSelectedValue = oItemValue;
		updateSelected();
		_funSelectedChangedListener && _funSelectedChangedListener();
	}
	
	var doPress = function(evt)
	{
		_jqUi.find(".kdlight-radiogroup-item").removeClass("kdlight-radiogroup-item_press");
		var jqItem = confirmOperatingItem(evt);
		if(jqItem == null)
		{
			return;
		}
		jqItem.addClass("kdlight-radiogroup-item_press");
	}
	
	var doRelease = function(evt)
	{
		var jqItem = confirmOperatingItem(evt);
		if(jqItem == null)
		{
			return;
		}
		jqItem.removeClass("kdlight-radiogroup-item_press");
	}
	
	function defaultItemValueComparer(oItemValue1, oItemValue2)
	{
		return oItemValue1 == oItemValue2;
	}
}
