﻿var KEXT_STORAGE_KEY_TOP_PARAM_PREFIX = "com.kingdee.bos.ext.light_report_pv_top_";
var KEXT_STORAGE_KEY_CLIENT_IS_USE_LASTSAVE_PARAM_PREFIX = "com.kingdee.bos.ext.light_report_isUseLastSaveParam_client_";
var KEXT_STORAGE_KEY_SERVER_IS_USE_LASTSAVE_PARAM_PREFIX = "com.kingdee.bos.ext.light_report_isUseLastSaveParam_server_";
function KEXTReportTopFilter()
{
	KEXTAbstractFilter.call(this);
	var _this = this;
	var _sReportId;
	var _arrCommonParams;//常用参数的名称,有序	
	var _iFirstPlace;
	var _iLastPlace;
	var _arrParamDescs;
	var _currentCtrl;
	var _funConfirmListener;
	var _funForwardToFilterPageListener;
	
	this.setForwardToFilterPageListener = function(funCallback)
	{
		_funForwardToFilterPageListener = funCallback;
	}
	
	this.setFirstPlace = function(iFirstPlace)
	{
		_iFirstPlace = iFirstPlace;
	}
	
	this.setLastPlace = function(iLastPlace)
	{
		_iLastPlace = iLastPlace;
	}
	
	this.setReportId = function(sReportId)
	{
		_sReportId = sReportId;
	}
	
	/**
	 * 传入数据模型，arrParamDescs是参数描述信息，KEXTReportParamDescription的数组
	 */
	this.setModel = function(arrCommonParams,arrParamDescs)
	{
		_this.protectedMethod._arrParamsName = [];
		_arrCommonParams = [];
		for (var index=0;index<arrCommonParams.length;index++)
		{
			var CommonParams = arrCommonParams[index];
			var percentage = CommonParams["percentage"];
			CommonParams = CommonParams["param"];
			var sParamName = CommonParams["name"];
			_arrCommonParams.push(sParamName);
			for(var index2=0;index2<arrParamDescs.length;index2++)
			{
				var ParamDescs = arrParamDescs[index2];
				var sParamName2 = ParamDescs["name"];
				if (sParamName == sParamName2)
				{
					arrParamDescs[index2]["percentage"] = percentage;
					break;
				}
			}
		}
		for (var index=0;index<arrParamDescs.length;index++)
		{
			var ParamDescs = arrParamDescs[index];
			var sParamName = ParamDescs["name"];
			_this.protectedMethod._arrParamsName.push(sParamName);
		}
		_arrParamDescs = arrParamDescs;
		initCtrl(_arrParamDescs);
	}
	
	/**
	 * 在指定的容器上展现界面 
	 */
	this.draw = function(jqOwner)
	{
		_this.protectedMethod._jqMainOwner = jqOwner;
		_jqAllFilter = createAllFilter(_this.protectedMethod._jqMainOwner);
	}
	
	var createAllFilter = function(jqParent)
	{
		var position_left = 0;
		var jqDiv = $("<div class='kdlight-top-filter-item-list'>");
		var jqLi = $("<div class='kdlight-top-filter-item'>");
		jqLi.css("width",_iFirstPlace*100+"%");
		jqLi.css({
			"position":"absolute",
			"top":0,
			"left":position_left+"%"
		});
		if (_iFirstPlace)
		{	
			position_left = _iFirstPlace*100;
		}
		jqLi.appendTo(jqDiv);
		jqDiv.appendTo(jqParent);
		for(var i = 0; i < _arrCommonParams.length; i++)
		{
			var oCtrl = _this.protectedMethod._mapCtrls[_arrCommonParams[i]];
			if(oCtrl.getParamDescription().isHide())
			{
				continue;
			}
			jqLi = $("<div class='kdlight-top-filter-item'>");
			jqLi.css({
				"position":"absolute",
				"top":0,
				"left":position_left+"%"
			});
			position_left = position_left + oCtrl.getParamDescription().getPercentage()*100;
			jqLi.appendTo(jqDiv);			
			oCtrl.createUI(jqLi);
			if (oCtrl.getParamDescription().getCtrlType()=="label")
			{
				jqLi.children().first().addClass("kdlight-top-filter-item-title-last");
			}
		}
		jqLi.children().first().addClass("kdlight-top-filter-item-title-last");
		jqDiv.appendTo(jqParent);		
		jqLi = $("<div class='kdlight-top-filter-item'>");
		if (_iLastPlace*100 != 100-position_left)
		{
			_iLastPlace = (100-position_left)/100;
		}
		jqLi.css("width",_iLastPlace*100+"%");
		jqLi.css({
			"position":"absolute",
			"top":0,
			"left":position_left+"%"
		});
		jqLi.appendTo(jqDiv);
		return jqDiv;
	}
	
	var initCtrl = function(arrParamDescs)
	{
		_this.protectedMethod._mapCtrls = {};
		//初始化过滤器控件
		for(var i = 0; i < arrParamDescs.length; i++)
		{
			//json对象转成数据模型
			var jsonParamDesc = arrParamDescs[i];
			var oParamDesc = _this.protectedMethod.decodeParamDesc(jsonParamDesc);
			var sParamName = oParamDesc.getName();
			//创建控件
			var oFilterCtrl = KEXTFilterCtrlFactory.create(oParamDesc,oParamDesc.getPercentage()?true:false);
			_this.protectedMethod._mapCtrls[sParamName] = oFilterCtrl;
			oFilterCtrl.setSuppliedValue(oParamDesc.getSuppliedValue());
			if( oFilterCtrl instanceof KEXTTopFilterLabel || oFilterCtrl instanceof FilterLabel)
			{
				continue;
			}
			var oSVD = oParamDesc.getSuppliedValueDescription();
			if(oSVD instanceof KEXTCodeDelaySuppliedValueDescription)
			{
				oFilterCtrl.setSuppliedValueDescriptionAndGetter(oSVD, oSVD.getFunction());
			}
			else
			{
				oFilterCtrl.setSuppliedValueDescriptionAndGetter(oSVD,  _this.protectedMethod.createInnerDelaySuppliedValueGetter(sParamName));
			}
			oFilterCtrl.setSelectedValue(oParamDesc.getDefaultValue());
			oFilterCtrl.setSelectedValueChangedListener(_this.protectedMethod.ctrlSelectedValueChanged);
			oFilterCtrl.setCurrentCtrlSelectedListener(currentCtrlSelectedListener);
			oFilterCtrl.setInputNextRequiredParamCallback(funInputNextRequiredParamCallback);
		}
	}
	
	this.forwardToInputCtrl = function()
	{
		funInputNextRequiredParamCallback();
	}
	
	this.setConfirmListener = function(funCallback)
	{
		_funConfirmListener = funCallback;
	}
	
	this.clearCurrentCtrl = function()
	{
		currentCtrlSelectedListener(null);
	}
	
	var currentCtrlSelectedListener = function(oCtrl)
	{
		if (_currentCtrl)
		{
			_currentCtrl.onBlur();
		}
		_currentCtrl = oCtrl;
	}
	var bShowReportFirstTime = true;
	var funInputNextRequiredParamCallback = function(oCtrl)
	{
		var storageKey = KEXT_STORAGE_KEY_TOP_PARAM_PREFIX+_sReportId;
		var oParamsValues = _this.getSelecteds();
		for(var sName in _this.protectedMethod._mapCtrls)
		{
			var oFilterCtrl = _this.protectedMethod._mapCtrls[sName];
			var oDesc = oFilterCtrl.getParamDescription();
			if (oDesc.getCtrlType() != "label" && oDesc.isRequired())
			{
				var arrSelectedValue = oFilterCtrl.getSelectedValue();
				if(!arrSelectedValue || arrSelectedValue.length == 0 || !(arrSelectedValue[0].getValue() && arrSelectedValue[0].getText()))
				{
					if(_arrCommonParams.indexOf(sName)<0)
					{
						//必填为空，并且不在常用参数中
						//弹出侧拉过滤器
						if (_funForwardToFilterPageListener)
						{
							oParamsValues.setSaveAsScheme(true);
							KEXTLocalStorage.save(storageKey, oParamsValues.toJsonStringForPersistence());
							_funForwardToFilterPageListener(bShowReportFirstTime);
							bShowReportFirstTime = false;
							return;
						}
					}
				}
			}
		}
		//打开下一个必选的参数
		for (var index=0;index<_arrCommonParams.length;index++)
		{
			var sName = _arrCommonParams[index];
			var oFilterCtrl = _this.protectedMethod._mapCtrls[sName];
			var oDesc = oFilterCtrl.getParamDescription();
			if (oDesc.getCtrlType() != "label" && oDesc.isRequired())
			{
				var arrSelectedValue = oFilterCtrl.getSelectedValue();
				var bHasValue = false;
				if(arrSelectedValue && arrSelectedValue.length > 0)
				{
					var selectedValue;
					for (var i = 0;i<arrSelectedValue.length;i++)
					{
						selectedValue = arrSelectedValue[i];
						if (selectedValue && selectedValue.getValue() && selectedValue.getText())//存在非空值
						{
							bHasValue = true;
							break;
						}
					}
				}
				if (!bHasValue)
				{
					oParamsValues.setSaveAsScheme(true);
					KEXTLocalStorage.save(storageKey, oParamsValues.toJsonStringForPersistence());
					oFilterCtrl.onFocus();
					return;
				}
			}
		}
		if (_funConfirmListener)
		{
			oParamsValues.setSaveAsScheme(false);
			KEXTLocalStorage.save(storageKey, oParamsValues.toJsonStringForPersistence());
			_funConfirmListener(true,_this.getSelecteds());
		}
		
	}
}

