﻿﻿/**
 * 输入框
 */
function KEXTTopFilterTextField(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _jqCtrl = $("<input type='text' class='kdlight-filter-text-input'/>");
	var _arrSelectValueTextModel = [];
	var _funCallBack;
	var _funConfirmCallBack = function()
	{
		var el = _jqCtrl;
		var arrValueTextModel = []
		if (el.val()!=="")
		{
			var vt = new KEXTValueTextModel();
			vt.setValue(el.prop("value"));
			vt.setText(el.val());
			arrValueTextModel.push(vt);
		}
		else
		{
			if (oReportParamDesc.isRequired())
			{
				return;
			}
		}
		_funCallBack().setValue(arrValueTextModel);
		_funCallBack().close();
		_this.setSelectedValue(arrValueTextModel,true,_this.protectedMethod.inputNextRequiredParamCallback);
	}
	
	var _funCancleCallback = function ()
	{
		if (oReportParamDesc.isRequired() && _arrSelectValueTextModel.length == 0 )
		{
			return;
		}
		_this.onBlur();
	}
	
	var _initCallBack = function()
	{
		_funCallBack().setValue([]);
		_funCallBack().updateUi();
		_this.setSelectedValue(_arrSelectValueTextModel,false,null);
	}
	
	this.createUI = function(jqParent)
	{
		_funCallBack = this.protectedMethod.createTopUiWithCtrl(jqParent, _jqCtrl,true,_initCallBack, _funConfirmCallBack,_funCancleCallback);
		_jqCtrl.css("width","280px");
		_funCallBack().setValue(_arrSelectValueTextModel);
	}
	
	this.setSuppliedValue = function(data)
	{
		//无
	}
	
	this.setSelectedValue = function(arrValueTextModel,isFireSelectedValueChanged,funCallback)
	{
		var valueTextModel = arrValueTextModel?arrValueTextModel[0]:null;
		var strValue;
		var arrSelectValueTextModel = [];
		if(valueTextModel && valueTextModel.getValue() &&valueTextModel.getText())
		{
			arrSelectValueTextModel.push(valueTextModel);
			strValue = valueTextModel.getValue();
		}
		_jqCtrl.val(strValue);
		_jqCtrl.prop("value", strValue);
		if (_this.protectedMethod.compareArrValueTextModel(arrSelectValueTextModel,_arrSelectValueTextModel))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		_arrSelectValueTextModel = arrSelectValueTextModel;
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
		}
		if (isFireSelectedValueChanged!=false)
		{
			_this.protectedMethod.fireSelectedValueChanged(funCallback);
		}
	}
	
	this.getSelectedValue = function()
	{
		if (_arrSelectValueTextModel && _arrSelectValueTextModel.length>0)
		{
			return _arrSelectValueTextModel;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.onFocus = function()
	{
		if (_funCallBack)
		{
			_funCallBack().open();
		}
	}
	
	this.onBlur = function()
	{
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
			_funCallBack().close();
		}
	}
}

/**
 * 数字输入框
 */
function KEXTTopFilterNumberInput(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _iOldValue = 0;
	var _jqContent = $("<div class='kdlight-filter-number-input-container'>");
	var _jqCtrl = $("<input type='number' class='kdlight-filter-number-input'/>");
	var _jqMinus=$("<div class='kdlight-filter-number-input-btn minus-icon kdlight-filter-activeable'></div>");
	var _jqQlus=$("<div class='kdlight-filter-number-input-btn plus-icon kdlight-filter-activeable'></div>");
	var _funCallBack;
	var _arrSelectValueTextModel = [];
	
	var _funConfirmCallBack = function()
	{
		var jqCtrl = $(_jqCtrl);
		//要重新$()包一下才能取到value.//在createUiWithLabel()时会给个id.
		var vt = new KEXTValueTextModel();
		vt.setValue(jqCtrl.prop("value"));
		vt.setText(vt.getValue());
		var arrSelectValueTextModel = [vt];
		_funCallBack().setValue(arrSelectValueTextModel);
		_funCallBack().close();
		//打开下一个必选参数
		_this.setSelectedValue(arrSelectValueTextModel, true, _this.protectedMethod.inputNextRequiredParamCallback);
	};
	
	var _funCancleCallback = function ()
	{
		if (oReportParamDesc.isRequired() && _arrSelectValueTextModel.length == 0 )
		{
			return;
		}
		_this.onBlur();
	}
	
	var _initCallBack = function()
	{
		_this.setSelectedValue(_arrSelectValueTextModel, false, null);
		_funCallBack().setValue([]);
		_funCallBack().updateUi();
		_jqMinus.off('click').on('click',function(event)
		{		
			var step = parseInt(_jqCtrl.attr("step"));
			var min = parseInt(_jqCtrl.attr("min"));
			var number = _jqCtrl.val();
			if(number == '')
			{
				number = _iOldValue ? _iOldValue : min;
			}
			number = parseInt(number, 10) - step;
			if (number < min)
			{
				number = min;
			}
			_jqCtrl.val(number);
			_iOldValue = number;
			return true;
		});
		
		_jqQlus.off('click').on('click',function(event)
		{
			var step = parseInt(_jqCtrl.attr("step"));
			var max = parseInt(_jqCtrl.attr("max"));
			var min = parseInt(_jqCtrl.attr("min"));
			var number = _jqCtrl.val();
			if(number == '')
			{
				number = _iOldValue ? _iOldValue : min;
			}
			number = parseInt(number, 10) + step;
			if (number > max)
			{
				number = max;
			}
			_jqCtrl.val(number);
			_iOldValue = number;
			return true;
		});
		
		_jqCtrl.off('blur').on("blur",function(event)
		{
			var jqCtrl = $(_jqCtrl);
			var min = parseInt(_jqCtrl.attr("min"));
			var max = parseInt(_jqCtrl.attr("max"));
			var number = jqCtrl.prop("value");
			if(number == '')
			{
				_jqCtrl.val(number);
				return;
			}
			if(!isNaN(parseInt(number, 10)))
			{
				number = parseInt(number, 10);
			}
			else
			{
				value = _iOldValue ? _iOldValue : min;
			}
			if (number > max)
			{
				number = max;
			}
			else if (number < min)
			{
				number = min;
			}
			_jqCtrl.val(number);
			_iOldValue = number;
		});
	};
	
	this.createUI = function(jqParent)
	{
		_funCallBack = this.protectedMethod.createTopUiWithCtrl(jqParent, _jqContent, true, _initCallBack, _funConfirmCallBack,_funCancleCallback);
		var width = parseInt(320/2-10);
		_jqContent.css({
			"width":width+"px",
			height:"34px"
		});
		var _jqCtrlC = $("<div>")
		_jqCtrl.css(
		{
			"float":"left",
			"width":width-70+"px"
		});
		_jqCtrlC.css(
		{
			"float":"left",
			"width":width-70+"px",
			height:"34px"
		});
		_jqMinus.css(
		{	
			"float":"left",
			"border-right":"1px solid #aeaeae"
		});
		
		_jqQlus.css(
		{
			"float":"left",
			"border-left":"1px solid #aeaeae"
		});
		_jqContent.append(_jqMinus); 
		_jqContent.append(_jqCtrlC.append(_jqCtrl)); 
		_jqContent.append(_jqQlus);
		_funCallBack().setValue(_arrSelectValueTextModel);
	}
	
	this.setSuppliedValue = function(oNumberStepperSuppliedValue)
	{
		_jqCtrl.attr("min", oNumberStepperSuppliedValue.getMin());
		_jqCtrl.attr("max", oNumberStepperSuppliedValue.getMax());
		_jqCtrl.attr("step", oNumberStepperSuppliedValue.getStep());
	}
	
	this.setSelectedValue = function(arrValueTextModel,isFireSelectedValueChanged, funCallback)
	{
		var vt = new KEXTValueTextModel();
		var oValueTextModel;
		var min = parseInt(_jqCtrl.attr("min"));
		if(arrValueTextModel && arrValueTextModel.length > 0)
		{
			oValueTextModel = arrValueTextModel[0];	
			vt = oValueTextModel;
			_jqCtrl.prop("value", oValueTextModel.getValue());
		}
		else
		{
			_jqCtrl.prop("value", min);
			vt.setValue(min);
			vt.setText(min);
		}
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelectValueTextModel,[vt]))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		_arrSelectValueTextModel = [vt];
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
		}
		if (isFireSelectedValueChanged != false)
		{
			_this.protectedMethod.fireSelectedValueChanged(funCallback);
		}
		
	}
	
	this.getSelectedValue = function()
	{
		if (_arrSelectValueTextModel && _arrSelectValueTextModel.length>0)
		{
			return _arrSelectValueTextModel;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.onFocus = function()
	{
		if (_funCallBack)
		{
			_funCallBack().open();
		}
	}
	
	this.onBlur = function()
	{
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
			_funCallBack().close();
		}
	}
}

//列表单选
function KEXTTopSingleSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var NULL_VALUE = "com.kingdee.bos.ext.light.filter.NullValue";
	
	var _this = this;
	var _jqParent;
	var _jqSelectCtrl = $("<div >");
	var _arrSelectValueTextModel = [];
	
	var _funCallBack;
	var _oDelaySuppliedValueModel;
	var _funDelaySuppliedValueGetter;
	var initCallBack =function()
	{
		var arrJqOp = $(_jqSelectCtrl).children(".kdlight-filter-Supplied-value,.kdlight-filter-Supplied-value-last");
		arrJqOp.off("click");
		arrJqOp.on("click",funSelectItemClickListener);
		_funCallBack().setValue([]);
		_funCallBack().updateUi();
		_this.setSelectedValue(_arrSelectValueTextModel, false, null);
	}
	
	var _funConfirmCallBack = function(arrValueTextModel)
	{
		if (oReportParamDesc.isRequired() && arrValueTextModel.length == 0 )
		{
			return;
		}
		_funCallBack().close();
		_funCallBack().setValue(arrValueTextModel);
		_this.setSelectedValue(arrValueTextModel, true, _this.protectedMethod.inputNextRequiredParamCallback);
	}
	
	var _funCancleCallback = function ()
	{
		if (oReportParamDesc.isRequired() && _arrSelectValueTextModel.length == 0 )
		{
			return;
		}
		_this.onBlur();
	}
	
	this.createUI = function(jqParent)
	{
		_jqParent = jqParent;
		_funCallBack = this.protectedMethod.createTopUiWithCtrl(jqParent, _jqSelectCtrl,false,initCallBack,_funConfirmCallBack,_funCancleCallback);
		_funCallBack().setValue(_arrSelectValueTextModel);
	}
	
	//选中某一项
	var funSelectItemClickListener = function(e)
	{
		var el = $(e.target);
		_jqSelectCtrl.children().removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
		el.removeClass("kdlight-radio-unchecked");
		el.addClass("kdlight-radio-checked");
		var arrValueTextModel = [];
		if(el.attr("value") && el.text() && el.attr("value") != NULL_VALUE)
		{	
			var vt = new KEXTValueTextModel();
			vt.setValue(el.attr("value"));
			vt.setText(el.text());
			arrValueTextModel.push(vt);
		}
		_funConfirmCallBack(arrValueTextModel);
	}
	
	//设置备选值
	this.setSuppliedValue = function(arrValueTextModel)
	{
		_jqSelectCtrl.children().remove();
		var hasNull = false;
		var jqOp;
		if(_this.getParamDescription().getCtrlType() == "combobox"  && !_this.getParamDescription().isRequired())
		{
			hasNull = true;
			jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable kdlight-radio-unchecked'/>");
			jqOp.attr("value", NULL_VALUE);
			jqOp.text("(空)");
			_jqSelectCtrl.append(jqOp);
		}
		
		if(arrValueTextModel)
		{
			var sPrefix = "ctrl_" + this.getParamDescription().getName() + "_" + new Date().getTime() +  "_";
			for(var i = 0; i < arrValueTextModel.length; i++)
			{
				var oValueTextModel = arrValueTextModel[i];				
				jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable kdlight-radio-unchecked'/>");
				jqOp.attr("value", oValueTextModel.getValue());
				jqOp.text(oValueTextModel.getText());
				_jqSelectCtrl.append(jqOp);
			}
		}
		if(jqOp)
		{
			jqOp.removeClass("kdlight-filter-Supplied-value");
			jqOp.addClass("kdlight-filter-Supplied-value-last");
		}
		var jqOps = _jqSelectCtrl.find(".kdlight-filter-Supplied-value,.kdlight-filter-Supplied-value-last");
		jqOps.off("click").on("click",funSelectItemClickListener);
	}
	
	//设置选中结果
	this.setSelectedValue = function(arrValueTextModel,isFireSelectedValueChanged, funCallback)
	{
		var arrSelectValueTextModel = [];
		var oValueTextModel = (arrValueTextModel && arrValueTextModel.length>0)?arrValueTextModel[0]:null;
		if (!(oValueTextModel && oValueTextModel.getValue() && oValueTextModel.getText()))
		{
			oValueTextModel = null;
		}
		
		var elChildren = _jqSelectCtrl.children();
		elChildren.removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
		for (var i=0;i<elChildren.length;i++)
		{
			var child = $(elChildren[i]);
			if (!oValueTextModel && (child.attr('value') == NULL_VALUE))
			{
				child.removeClass("kdlight-radio-unchecked");
				child.addClass("kdlight-radio-checked");
			}
			else if (oValueTextModel && child.attr('value') == oValueTextModel.getValue() && child.text() == oValueTextModel.getText())
			{
				child.removeClass("kdlight-radio-unchecked");
				child.addClass("kdlight-radio-checked");
				arrSelectValueTextModel.push(oValueTextModel);
				break;
			}
		}
		
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelectValueTextModel,arrSelectValueTextModel))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		_arrSelectValueTextModel = arrSelectValueTextModel;
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
		}
		if (isFireSelectedValueChanged != false)
		{			
			_this.protectedMethod.fireSelectedValueChanged(funCallback);
		}
	}
	
	//获取选中结果
	this.getSelectedValue = function()
	{
		if (_arrSelectValueTextModel && _arrSelectValueTextModel.length>0)
		{
			return _arrSelectValueTextModel;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.setSuppliedValueDescriptionAndGetter = function(oDelaySuppliedValueModel, funGetter)
	{
		_oDelaySuppliedValueModel = oDelaySuppliedValueModel;
		_funDelaySuppliedValueGetter = funGetter;
	}
	
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		_funDelaySuppliedValueGetter(_oDelaySuppliedValueModel.getDatasetPersistenceModel(), 
			function(oRowset)
			{
				var arrVtm = [];
				KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, 
					function(iIndex, sValue, sText)
					{
						var oVtm = new KEXTValueTextModel();
						oVtm.setValue(sValue);
						oVtm.setText(sText);
						arrVtm.push(oVtm);
					});
				_this.setSuppliedValue(arrVtm);
				_this.setSelectedValue(_this.getSelectedValue());
				if(funCallback)
				{
					funCallback(oCallbackParam);
				}
			});
	}
	
	this.onFocus = function()
	{
		if (_funCallBack)
		{
			_funCallBack().open();
		}
	}
	
	this.onBlur = function()
	{
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
			_funCallBack().close();
		}
	}
}

//列表多选
function KEXTTopMultiSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var NULL_VALUE = "com.kingdee.bos.ext.light.filter.NullValue";
	
	var _this = this;
	var _jqParent;
	var _arrSelectValueTextModel = [];
	var _jqSelectCtrl = $("<div >");
	var _funCallBack;
	var initCallBack = function()
	{
		var jqOps = _jqSelectCtrl.find(".kdlight-filter-Supplied-value,.kdlight-filter-Supplied-value-last");
		jqOps.off("click").on("click",funSelectItemClickListener);
		_this.setSelectedValue(_arrSelectValueTextModel, false, null);
		_funCallBack().setValue([]);
		_funCallBack().updateUi();
	}
	var _funConfirmCallBack = function()
	{
		var arrValueTextModel = [];
		var _arrJqCtrls = _jqSelectCtrl.children();
		for(var i=0;i<_arrJqCtrls.length;i++)
		{
			var el = $(_arrJqCtrls[i]);
			if (el.hasClass("kdlight-checkbox-checked"))
			{
				var vt = new KEXTValueTextModel();
				vt.setValue(el.attr("value"));
				vt.setText(el.text());
				arrValueTextModel.push(vt);
			}
		}
		if (oReportParamDesc.isRequired() && arrValueTextModel.length == 0 )
		{
			return;
		}
		_funCallBack().close();
		_funCallBack().setValue(arrValueTextModel);
		_this.setSelectedValue(arrValueTextModel, true, _this.protectedMethod.inputNextRequiredParamCallback);
	}
	var _funCancleCallback = function ()
	{
		if (oReportParamDesc.isRequired() && _arrSelectValueTextModel.length == 0 )
		{
			return;
		}
		_this.onBlur();
	}
	var _funDelaySuppliedValueGetter;
	this.createUI = function(jqParent)
	{
		_jqParent = jqParent;
		_funCallBack = this.protectedMethod.createTopUiWithCtrl(jqParent, _jqSelectCtrl,true,initCallBack,_funConfirmCallBack,_funCancleCallback);
		_funCallBack().setValue(_arrSelectValueTextModel);
	}
	
	var funSelectItemClickListener = function (event)
	{
		var el = $(event.target);
		if (el.hasClass("kdlight-checkbox-checked"))
		{
			el.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
		}
		else
		{
			el.removeClass("kdlight-checkbox-unchecked").addClass("kdlight-checkbox-checked");
		}
	}
	//设置备选值
	this.setSuppliedValue = function(arrValueTextModel)
	{
		_jqSelectCtrl.children().remove();
		if(arrValueTextModel)
		{
			var jqOp;
			var sPrefix = "ctrl_" + this.getParamDescription().getName() + "_" + new Date().getTime() +  "_";
			for(var i = 0; i < arrValueTextModel.length; i++)
			{
				
				var oValueTextModel = arrValueTextModel[i];
				var sValue = oValueTextModel.getValue();
				var sText = oValueTextModel.getText();
				
				var sId = sPrefix + i;	
				jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable kdlight-checkbox-unchecked'/>");
				jqOp.attr("id", sId);
				jqOp.attr("value", sValue);
				jqOp.text(sText ? sText : " ");
				
				_jqSelectCtrl.append(jqOp);
			}
			
			if(jqOp)
			{
				jqOp.removeClass("kdlight-filter-Supplied-value");
				jqOp.addClass("kdlight-filter-Supplied-value-last");
			}
		}
		var jqOps = _jqSelectCtrl.find(".kdlight-filter-Supplied-value,.kdlight-filter-Supplied-value-last");
		jqOps.off("click").on("click",funSelectItemClickListener);
	}
	//设置选中结果
	this.setSelectedValue = function(arrValueTextModel,isFireSelectedValueChanged, funCallback)
	{
		var arrSelectValueTextModel = [];
		arrValueTextModel = arrValueTextModel ? arrValueTextModel : [];
		var _arrJqCtrls = _jqSelectCtrl.children();
		_arrJqCtrls.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
		for (var i=0;i<arrValueTextModel.length;i++)
		{
			var oValueTextModel = arrValueTextModel[i];
			for (var index=0;index<_arrJqCtrls.length;index++)
			{
				var jqInput =$(_arrJqCtrls[index]);
				var bSelected = jqInput.hasClass("kdlight-checkbox-checked");
				if(oValueTextModel && jqInput.attr("value") == oValueTextModel.getValue() && jqInput.text() == oValueTextModel.getText())
				{
					if (!bSelected)
					{
						bSelected = true;
						arrSelectValueTextModel.push(oValueTextModel);
					}
				}
				if (bSelected)
				{
					jqInput.removeClass("kdlight-checkbox-unchecked");
					jqInput.addClass("kdlight-checkbox-checked");
				}
				else
				{
					jqInput.removeClass("kdlight-checkbox-checked");
					jqInput.addClass("kdlight-checkbox-unchecked");
				}
			}
		}
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelectValueTextModel,arrSelectValueTextModel))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		_arrSelectValueTextModel = arrSelectValueTextModel;
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
		}
		if (isFireSelectedValueChanged!=false)
		{
			_this.protectedMethod.fireSelectedValueChanged(funCallback);
		}
	}
	
	//获取选中结果
	this.getSelectedValue = function()
	{
		if (_arrSelectValueTextModel && _arrSelectValueTextModel.length>0)
		{
			return _arrSelectValueTextModel;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.onFocus = function()
	{
		if (_funCallBack)
		{
			_funCallBack().open();
		}
	}
	
	this.onBlur = function()
	{
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
			_funCallBack().close();
		}
	}
	
	this.setSuppliedValueDescriptionAndGetter = function(oDelaySuppliedValueModel, funGetter)
	{
		_oDelaySuppliedValueModel = oDelaySuppliedValueModel;
		_funDelaySuppliedValueGetter = funGetter;
	}
	
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		_funDelaySuppliedValueGetter(_oDelaySuppliedValueModel.getDatasetPersistenceModel(), 
			function(oRowset)
			{
				var arrVtm = [];
				KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, 
					function(iIndex, sValue, sText)
					{
						var oVtm = new KEXTValueTextModel();
						oVtm.setValue(sValue);
						oVtm.setText(sText);
						arrVtm.push(oVtm);
					});
				_this.setSuppliedValue(arrVtm);
				_this.setSelectedValue(_this.getSelectedValue());
				if(funCallback)
				{
					funCallback(oCallbackParam);
				}
			});
	}
}

/**
 * 另出界面的选择器，相当于F7
 */
function KEXTTopFilterForwardSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var NULL_VALUE = "com.kingdee.bos.ext.light.filter.NullValue";
	var _this = this;
	var _jqSelectCtrl = $("<div >");
	var _jqCtrlUi;
	var _jqUiForMulti;
	var _jqSelectedCount;
	var _jqSelectAll;
	
	var _arrSelected;
	var _oDelaySuppliedValueModel;
	var _funDelaySuppliedValueGetter;
	
	var _funCallBack;
	var _jqFilterInput;
	var _initCallBack = function()
	{
		$(_jqUiForMulti).off("click").on("click", doItemClick);
		var jqSearchInput = $(".ui-page-active").find(".kdlight-top-filter-content .kdlight-filter-search-input");
		jqSearchInput.off("input").on("input",searchItemListener);
		var jqSearchAll = $(".ui-page-active").find(".kdlight-top-filter-content .kdlight-filter-select-all");
		jqSearchAll.off("click").on("click",selectAll);
		if(_this.getParamDescription().isMultiSelectable()) 
		{
			_funCallBack().updateUi(61+39);
		}
		else
		{
			_funCallBack().updateUi(61);
		}
		_funCallBack().setValue([]);
		_this.setSelectedValue(_arrSelected, false, null);
	}
	
	var initCallBack = function()
	{
		if (!_jqCtrlUi)
		{
			_this.resetSuppliedValue(_initCallBack);
		}
		else
		{
			_initCallBack();
		}
	}
	
	var _funConfirmCallBack = function()
	{
		var arrSelected = [];
		if(_this.getParamDescription().isMultiSelectable()) 
		{	
			var arrInputs = $(_jqUiForMulti).find(".kdlight-checkbox-checked");
			for (var i = 0; i < arrInputs.length; i++) 
			{
				var jqOp = $(arrInputs[i]);
				var oValueTextModel = new KEXTValueTextModel();
				oValueTextModel.setText(jqOp.text());
				oValueTextModel.setValue(jqOp.attr("value"));
				arrSelected.push(oValueTextModel);
			}
			
			if(arrSelected.length == 0)
			{
				if(_this.getParamDescription().isRequired())
				{
					return ;
				}
			}
		}
		else
		{
			var arrInputs = $(_jqUiForMulti).find(".kdlight-radio-checked");
			for (var i = 0; i < arrInputs.length; i++) 
			{
				var jqOp = $(arrInputs[i]);
				var oValueTextModel = new KEXTValueTextModel();
				oValueTextModel.setText(jqOp.text());
				oValueTextModel.setValue(jqOp.attr("value"));
				if (jqOp.attr("value") && jqOp.text() && jqOp.attr("value") != NULL_VALUE)
				{
					arrSelected.push(oValueTextModel);
					break;
				}
			}
		}
		
		$(_jqFilterInput).val("");
		searchItemListener();
		_funCallBack().setValue(arrSelected);
		_funCallBack().close();
		_this.setSelectedValue(arrSelected, true, _this.protectedMethod.inputNextRequiredParamCallback);
	};
	
	var _funCancleCallback = function ()
	{
		if (oReportParamDesc.isRequired() && (!_arrSelected || _arrSelected.length == 0) )
		{
			return;
		}
		$(_jqFilterInput).val("");
		searchItemListener();
		_this.onBlur();
	}
	
	this.createUI = function(jqParent)
	{
		_funCallBack = this.protectedMethod.createTopUiWithCtrl(jqParent, _jqSelectCtrl,_this.getParamDescription().isMultiSelectable(),initCallBack,_funConfirmCallBack,_funCancleCallback);
		_funCallBack().setValue(_arrSelected);
	}
	
	this.setSelectedValue = function(arrValueTextModel,isFireSelectedValueChanged, funCallback)
	{
		var arrSelectedValueTextModel = [];
		if (_jqCtrlUi)
		{
			var isMultiSelectable = _this.getParamDescription().isMultiSelectable();
			var arrSupplid = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value");
			if (isMultiSelectable)
			{
				arrSupplid.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
			}
			else
			{
				arrSupplid.removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
			}
			var isSelected;
			if (arrValueTextModel && arrValueTextModel.length>0)
			{
				for (var index2 = 0;index2<arrValueTextModel.length;index2++)
				{
					var ValueTextModel = arrValueTextModel[index2];
					var sValue2 = ValueTextModel.getValue();
					var sText2 = ValueTextModel.getText();
					for (var index = 0 ,size = arrSupplid.length;index<size;index++)
					{
						var supplid = $(arrSupplid[index]);
						isSelected = supplid.hasClass("kdlight-radio-checked") || supplid.hasClass("kdlight-checkbox-checked");
						var sValue = supplid.attr("value");
						var sText = supplid.text();
						if ((sValue==sValue2 && sText==sText2))
						{
							if (!isSelected)
							{
								arrSelectedValueTextModel.push(ValueTextModel);
								isSelected = true;
							}
						}
						else if ((sValue == NULL_VALUE && !sValue2 && !sText2))
						{
							isSelected = true;
						}
						if (isSelected)
						{
							if (isMultiSelectable)
							{
								supplid.removeClass("kdlight-checkbox-unchecked").addClass("kdlight-checkbox-checked");
							}
							else
							{
								supplid.removeClass("kdlight-radio-unchecked").addClass("kdlight-radio-checked");
								break;
							}	
						}
					}
				}
			}
			else
			{
				for (var index = 0 ,size = arrSupplid.length;index<size;index++)
				{
					var supplid = $(arrSupplid[index]);
					var sValue = supplid.attr("value");
					var sText = supplid.text();
					if(sValue == NULL_VALUE)
					{
						supplid.removeClass("kdlight-radio-unchecked").addClass("kdlight-radio-checked");
						break;
					}
				}
			}
			showCount();
		}
		else
		{
			//设置默认值时，无法获取当前备选值
			arrValueTextModel = arrValueTextModel?arrValueTextModel:[];
			arrSelectedValueTextModel = arrValueTextModel;
		}
		
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelected,arrSelectedValueTextModel))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		_arrSelected = arrSelectedValueTextModel;
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelected);	
		}
		if (isFireSelectedValueChanged!=false)
		{
			_this.protectedMethod.fireSelectedValueChanged(funCallback);
		}
	}
	
	this.getSelectedValue = function()
	{
		if (_arrSelected && _arrSelected.length>0)
		{
			return _arrSelected;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.onFocus = function()
	{
		if (_funCallBack)
		{
			_funCallBack().open();
		}
	}
	
	this.onBlur = function()
	{
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelected);
			_funCallBack().close();
		}
	}
	
	this.setSuppliedValue = function(arrValueTextModel)
	{
		//nothing
	}

	this.setSuppliedValueDescriptionAndGetter = function(oDelaySuppliedValueModel, funGetter)
	{
		_oDelaySuppliedValueModel = oDelaySuppliedValueModel;
		_funDelaySuppliedValueGetter = funGetter;
	}
	
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		getDelaySuppliedValue(
				function(jqForwardUi)
				{
					_jqCtrlUi = jqForwardUi;
					_jqSelectCtrl.empty().append(_jqCtrlUi);
					_this.setSelectedValue(_this.getSelectedValue());
					if (funCallback)
					{
						funCallback(oCallbackParam);
					}
				});
	}
	
	//funCallback like func(jqUi)
	var getDelaySuppliedValue = function(funCallback)
	{
		_funDelaySuppliedValueGetter(_oDelaySuppliedValueModel.getDatasetPersistenceModel(), 
			function(oRowset)
			{
				var jqForwardUi;
				if(_this.getParamDescription().isMultiSelectable()) 
				{
					jqForwardUi = createForwardUiForMultiSelectable(oRowset);
				}
				else
				{
					jqForwardUi = createForwardUIForSingleSelectable(oRowset);
				}
				funCallback(jqForwardUi);
			});
	}
	
	var createForwardUIForSingleSelectable = function(oRowset)
	{
		//选项
		var jqUL = $("<div>");
		jqUL.css("margin-top", "55px");
		var funCallback = function(iIndex, sValue, sText)
			{
				var jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable'/>");
				jqOp.attr("value", sValue);
				jqOp.text(sText);
				var bSelected = false;
				if (_arrSelected && _arrSelected.length>0)
				{
					for (var index = 0 ,size = _arrSelected.length;index < size; index++)
					{
						var selected = _arrSelected[index];
						if (sText == selected.getText() && sValue == selected.getValue())
						{
							bSelected = true;
							break;
						}
					}
				}
				else if (sValue == NULL_VALUE && '(空)' == sText)
				{
					bSelected = true;
				}
				
				if(bSelected)
				{
					jqOp.addClass("kdlight-radio-checked");
				}
				else
				{
					jqOp.addClass("kdlight-radio-unchecked");
				}
				jqUL.append(jqOp);
			}

		if(!_this.getParamDescription().isRequired())
		{
			funCallback(0, NULL_VALUE, "(空)");
		}
		KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, funCallback);
		_jqUiForMulti = jqUL;
		
		//过滤输入
		var jqDiv = $("<div>");
		jqDiv.css("background", "#ffffff");
		jqDiv.css("border-bottom", "1px solid #dadada");
		jqDiv.css("position","absolute");
		jqDiv.css("top","0px");
		jqDiv.css("left","0px");
		jqDiv.css("right","0px");
		jqDiv.css("z-index",4);
	
		var jqSearchDiv = $("<div class='kdlight-filter-search'>");		
		var jqFilterInputC = $("<div>");
		jqFilterInputC.css({
			"float":"left",
			"width":"262px"
		});
		_jqFilterInput = $("<input type='text' class='kdlight-filter-search-input'/>");
		
		_jqFilterInput.css("width","262px");
		jqSearchDiv.append(jqFilterInputC.append(_jqFilterInput));
		jqSearchDiv.append("<label class='search-icon'>");
		jqSearchDiv.css({
			"float":"left"
		});
		jqDiv.append(jqSearchDiv);
		
		var jqUIDiv = $("<div>");
		jqUIDiv.css("background", "#ffffff");
		jqUIDiv.append(jqDiv);
		jqUIDiv.append(jqUL);
		return jqUIDiv;
	}
	
	var createForwardUiForMultiSelectable = function(oRowset)
	{
		var jqUL = $("<div>");
		jqUL.css("margin-top", "101px");
		var sIdPrefix = "ctrl_" + _this.getParamDescription().getName() + "_" + new Date().getTime() + "_";
		KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, 
			function(iIndex, sValue, sText)
			{
				var sId = sIdPrefix + iIndex;
				var jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable'/>");
				jqOp.attr("id", sId);
				jqOp.attr("value", sValue);
				jqOp.text(sText);
				
				var bSelected = false;
				if (_arrSelected && _arrSelected.length>0)
				{
					for (var index = 0 ,size = _arrSelected.length;index < size; index++)
					{
						var selected = _arrSelected[index];
						if (sText == selected.getText())
						{
							bSelected = true;
							break;
						}
					}
				}
				if(bSelected)
				{
					jqOp.addClass("kdlight-checkbox-checked");
				}
				else
				{
					jqOp.addClass("kdlight-checkbox-unchecked");
				}
				jqUL.append(jqOp);
			});
		_jqUiForMulti = jqUL;
		
		var jqDiv = $("<div>");
		jqDiv.css("background", "#ffffff");
		jqDiv.css("border-bottom", "1px solid #dadada");
		jqDiv.css("position","absolute");
		jqDiv.css("top","0px");
		jqDiv.css("left","0px");
		jqDiv.css("right","0px");
		jqDiv.css("z-index",4);
	
		//过滤输入
		var jqSearchDiv = $("<div class='kdlight-filter-search'>");		
		var jqFilterInputC = $("<div>");
		jqFilterInputC.css({
			"float":"left",
			"width":"262px"
		});
		_jqFilterInput = $("<input type='text' class='kdlight-filter-search-input'/>");
		
		_jqFilterInput.css("width","262px");
		jqSearchDiv.append(jqFilterInputC.append(_jqFilterInput));
		jqSearchDiv.append("<label class='search-icon'>")
		jqDiv.append(jqSearchDiv);
		jqSearchDiv.css({
			"float":"left"
		});
		//全选
		var jqSelectDiv = $("<div>");
		jqSelectDiv.css("background", "#ffffff");
		jqSelectDiv.css("border-bottom", "1px solid #dadada");
		jqSelectDiv.css("padding", "10px");
		jqSelectDiv.css("position","absolute");
		jqSelectDiv.css("top","61px");
		jqSelectDiv.css("width","300px");
		jqSelectDiv.css("height","23px");
		jqSelectDiv.css("z-index",4);
		var selectCount = 0;
		if (_arrSelected && _arrSelected.length>0)
		{
			selectCount = _arrSelected.length;
		}
		_jqSelectedCount = $("<label class='kdlight-filter-select-count'>已选择:"+selectCount+"项</lable>");
		_jqSelectAll = $("<label class='kdlight-filter-select-all kdlight-checkbox-unchecked fontWeightBold'>全选</lable>");
		jqSelectDiv.append(_jqSelectedCount);
		jqSelectDiv.append(_jqSelectAll);
		
		var jqUIDiv = $("<div>");
		jqUIDiv.css("background", "#ffffff");
		jqUIDiv.append(jqDiv);
		jqUIDiv.append(jqSelectDiv);
		
		jqUIDiv.append(jqUL);
		return jqUIDiv;
	}
	
	var selectAll = function(evt)
	{
		if(isBeyondMaxRestrictNumber(true))
		{
			showBeyondMaxTip();
			return;
		}
		
		var el = $(evt.target);
		var arrSupplid = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value:visible");
		if  (el.hasClass("kdlight-checkbox-unchecked"))
		{
			el.removeClass("kdlight-checkbox-unchecked");
			el.addClass("kdlight-checkbox-checked");
			for (var index = 0 ,size = arrSupplid.length;index<size;index++)
			{
				var supplid = $(arrSupplid[index]);
				if (supplid.hasClass("kdlight-checkbox-unchecked"))
				{
					supplid.removeClass("kdlight-checkbox-unchecked");
					supplid.addClass("kdlight-checkbox-checked");
				}
			}
		}
		else
		{
			el.removeClass("kdlight-checkbox-checked");
			el.addClass("kdlight-checkbox-unchecked");
			for (var index = 0 ,size = arrSupplid.length;index<size;index++)
			{
				var supplid = $(arrSupplid[index]);
				if (supplid.hasClass("kdlight-checkbox-checked"))
				{
					supplid.removeClass("kdlight-checkbox-checked");
					supplid.addClass("kdlight-checkbox-unchecked");
				}
			}
		}
		showCount();
	}
	
	var isBeyondMaxRestrictNumber = function(isSelectAll)
	{
		var iSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-checked").length;
		var iUnSelectCount = 0;
		var iMaxRestrictNumber = oReportParamDesc.getMaxRestrictNumber();
		if(isSelectAll)
		{
			iUnSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-unchecked").length;
		}
		if(iMaxRestrictNumber <= iSelectCount + iUnSelectCount)
		{
			return true;
		}
		return false;
	}
	
	var showBeyondMaxTip = function()
	{
		var maxRNumber = oReportParamDesc.getMaxRestrictNumber();
		_jqSelectedCount.text("超过限制,最多可选" + maxRNumber + "项");
	}
	
	var showCount = function()
	{
		if (_this.getParamDescription().isMultiSelectable())
		{
			var iVisibleCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value:visible").length;
			var iSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-checked").length;
			var iVisibleSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-checked:visible").length;
			if (_jqSelectedCount)
			{
				_jqSelectedCount.text("已选择:"+iSelectCount+"项");
				if (iVisibleCount == iVisibleSelectCount)
				{
					_jqSelectAll.removeClass("kdlight-checkbox-unchecked");
					_jqSelectAll.addClass("kdlight-checkbox-checked");
				}
				else
				{
					_jqSelectAll.removeClass("kdlight-checkbox-checked");
					_jqSelectAll.addClass("kdlight-checkbox-unchecked");
				}
			}
		}
	}
	
	var doItemClick = function(evt)
	{
		var jqA = $(evt.target);
		if (!jqA.hasClass("kdlight-filter-Supplied-value"))
		{
			return;
		}
		if (_this.getParamDescription().isMultiSelectable())
		{
			if (jqA.hasClass("kdlight-checkbox-unchecked"))
			{
				if(isBeyondMaxRestrictNumber(false))
				{
					showBeyondMaxTip();
					return;
				}
				jqA.removeClass("kdlight-checkbox-unchecked");
				jqA.addClass("kdlight-checkbox-checked");
			}
			else
			{
				jqA.removeClass("kdlight-checkbox-checked");
				jqA.addClass("kdlight-checkbox-unchecked");
			}
			showCount();
		}
		else
		{
			$(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-radio-checked").removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
			jqA.removeClass("kdlight-radio-unchecked");
			jqA.addClass("kdlight-radio-checked");
			_funConfirmCallBack();
		}
	}
	
	var searchItemListener = function ()
	{
		var sText = $(_jqFilterInput).val().toLocaleLowerCase();
		var arrSupplied = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value");
		var bSelectAll = true;
		for (var index = 0,size = arrSupplied.length;index<size;index++)
		{
			var supplied = $(arrSupplied[index]);
			if (sText)
			{
				if (supplied.text().toLocaleLowerCase().indexOf(sText) > -1)
				{
					supplied.show();
					if (supplied.hasClass("kdlight-checkbox-unchecked"))
					{
						bSelectAll = false;
					}
				}
				else
				{
					supplied.hide();
				}
			}
			else
			{
				supplied.show();
				if (supplied.hasClass("kdlight-checkbox-unchecked"))
				{
					bSelectAll = false;
				}
			}
		}
		if (_jqSelectAll)
		{
			if (bSelectAll)
			{
				_jqSelectAll.removeClass("kdlight-checkbox-unchecked");
				_jqSelectAll.addClass("kdlight-checkbox-checked");
			}
			else
			{
				_jqSelectAll.removeClass("kdlight-checkbox-checked");
				_jqSelectAll.addClass("kdlight-checkbox-unchecked");
			}
		}
	}
}


/**
 * 独立多选框
 */
function KEXTTopFilterFlipInput(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _jqCtrl = $("<div class='kdlight-filter-flip-input kdlight-top-filter-item-title2'>");
	var _jqItem1 = $("<div class='kdlight-filter-flip-input-item'>");
	var _jqItem2 =$("<div class='kdlight-filter-flip-input-item'>");
	var _arrSelectValueTextModel = [];
	var percentage = oReportParamDesc.getPercentage();
	var maxCtrlWidth = 320*percentage-14;
	var maxWidth = parseInt(maxCtrlWidth/2);
	var maxTextLength = 18;
	
	var mouseOnClickListener = function(event)
	{
		var el = $(event.target);
		var vt = new KEXTValueTextModel();
		vt.setValue(el.attr("value"));
		vt.setText(el.text());
		_this.protectedMethod.fireCtrlSelectedChanged(_this);
		_this.setSelectedValue([vt],_this.protectedMethod.inputNextRequiredParamCallback);
	}
	this.createUI = function(jqParent)
	{
		if(oReportParamDesc.getPercentage()>0)
		{
			jqParent.css("width",percentage*100+"%");
		}
		jqParent.append(_jqCtrl);
		_jqItem1.css({
			"width":maxWidth+"px"
		});
		_jqItem2.css({
			"width":maxWidth+"px",
			"left":maxWidth+2+"px",
			"top":"-30px",
			"margin-left":"-1px"
		});
		var left = parseInt(maxCtrlWidth*0.5-maxWidth);
		if (left<=0)
		{
			left = -2;
		}
		_jqCtrl.css({
			"width":320*percentage-3+"px",
			"position":"relative",
			"left":left+"px"
		});
	}
	
	this.setSuppliedValue = function(arrValueTextModel)
	{
		_jqCtrl.children().remove();
		arrValueTextModel = arrValueTextModel?arrValueTextModel:[];
		for(var i = 0; i < arrValueTextModel.length; i++)
		{
			var oValueTextModel = arrValueTextModel[i];
			var textLength=1;
			var jqOp;
			var sText;
			if (i==0)
			{
				jqOp = _jqItem1;
				sText = oValueTextModel.getText();
				var textLength = oValueTextModel.getText().length;
				maxTextLength = textLength>maxTextLength?textLength:maxTextLength;
			}
			else if (i==1)
			{
				jqOp = _jqItem2;
			}
			
			if (jqOp)
			{
				var ele_font_size = $(jqOp).css('font-size');  
				var ele_font_family = $(jqOp).css('font-family'); 
				sText = oValueTextModel.getText();
				var textWidth = sText.width(ele_font_size+" "+ele_font_family);
				maxTextLength = textWidth>maxTextLength?textWidth:maxTextLength;
				jqOp.attr("value", oValueTextModel.getValue());
				jqOp.text(sText);
				jqOp.on("click",mouseOnClickListener);
				_jqCtrl.append(jqOp);
				jqOp = null;
			}
		}
		if (maxWidth>150)
		{
			if(maxTextLength<80)
			{
				maxWidth = 80;
			}
			else if (maxTextLength<maxWidth)
			{
				maxWidth = maxTextLength;
			}
		}
	}
	
	this.setSelectedValue = function(arrValueTextModel,funCallback)
	{
		var oValueTextModel =arrValueTextModel?arrValueTextModel[0]:null;
		var jqOps = _jqCtrl.children();
		for(var i = 0; i < jqOps.length; i++)
		{
			var jqOp = $(jqOps[i]);
			var bSelected = ((oValueTextModel && jqOp.attr("value") == oValueTextModel.getValue()) ? true : false);
			if (bSelected)
			{
				jqOp.addClass("kdlight-filter-flip-input-item-selected");
			}
			else
			{
				jqOp.removeClass("kdlight-filter-flip-input-item-selected");
			}
		}
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelectValueTextModel,arrValueTextModel))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		_arrSelectValueTextModel = [oValueTextModel];
		_this.protectedMethod.fireSelectedValueChanged(funCallback);
	}
	
	this.getSelectedValue = function()
	{
		if (_arrSelectValueTextModel && _arrSelectValueTextModel.length>0)
		{
			return _arrSelectValueTextModel;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	this.onFocus = function()
	{
		//无
	}
	this.onBlur = function()
	{
		//无
	}
}

/**
 * 日期选择
 */
function KEXTTopFilterDateSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _jqParent;	
	var _jqSelectCtrl = $("<div class='selector'>");
	var _jqConfirmButton = $("<div class='themeBBtn kdlight-btn-ok' >确定</div>");
	var _jqSelectBtn = $("<div class='themeBBtn'>")
	var _funCallBack;
	var _arrSelectValueTextModel = [];
	var _oCtrl = new kdlight.DateTimeChooser();
	var initCallBack = function()
	{
		var oParamDesc = oReportParamDesc;
		if(oParamDesc.getDataType()== "date")
		{
			_oCtrl.setMode(kdlight.DateTimeChooser.MODE_DATE);
			_jqSelectBtn.text("今天");
			if (!_jqSelectCtrl.hasClass("themeA"))
			{
				_jqSelectCtrl.addClass("themeA");
				_jqSelectCtrl.css({
					"margin":"0px",
					"border":"0px"
				});
			}
			
		}
		else if(oParamDesc.getDataType()== "time")
		{
			_oCtrl.setMode(kdlight.DateTimeChooser.MODE_TIME);
			_jqSelectBtn.text("现在");
			if (!_jqSelectCtrl.hasClass("themeA"))
			{
				_jqSelectCtrl.addClass("themeA");
				_jqSelectCtrl.css({
					"margin":"0px",
					"border":"0px"
				});
			}
		}
		else if(oParamDesc.getDataType()== "datetime")
		{
			_oCtrl.setMode(kdlight.DateTimeChooser.MODE_DATETIME);
			_jqSelectBtn.text("现在");
			if (!_jqSelectCtrl.hasClass("themeB"))
			{
				_jqSelectCtrl.addClass("themeB");
			}
		}		
		_jqSelectCtrl.empty();
		var jqCtrl = _oCtrl.getSelectablePanel(_jqSelectCtrl);
		var _jqSelectCtrlBar = _funCallBack().getButtonBar();
		_jqSelectCtrlBar.empty();
		_jqSelectCtrlBar.append(_jqSelectBtn);
		_jqSelectCtrlBar.append(_jqConfirmButton);
		_jqSelectBtn.off("click");
		_jqSelectBtn.on("click",function(){
			_oCtrl.setSelectValue(new Date());
			_jqConfirmButton.click();
		});
		_jqSelectBtn.css("position","relative");
		_jqSelectBtn.css("left","0");
		_jqConfirmButton.css("position","relative");
		_jqConfirmButton.css("left",_jqSelectCtrlBar.width()-_jqConfirmButton.width()*2+"px");
		
		jqCtrl.css("display","inline-block");
		jqCtrl.css("position","relative");
		jqCtrl.css("left",(_jqSelectCtrl.width()-jqCtrl.width())/2+"px");
		_jqConfirmButton.off("click");
		_jqConfirmButton.on("click",_funConfirmCallBack);
		_funCallBack().setValue([]);
		_funCallBack().updateUi();
		$(".kdlight-datetime-blocktitle").removeClass("fontWeightBold").addClass("fontWeightBold");
		_this.setSelectedValue(_arrSelectValueTextModel,false,null);
	}
	var _funConfirmCallBack = function()
	{
		var sDataType = _this.getParamDescription().getDataType();
		var oDate = _oCtrl.getSelectValue();
		var sValue = KEXTFilterDataUtil.parseDate2String(oDate, sDataType);
		var oValueTextModel = new KEXTValueTextModel();
		oValueTextModel.setValue(sValue);
		oValueTextModel.setText(sValue);
		var arrValueTextModel=[oValueTextModel];
		_funCallBack().setValue(arrValueTextModel);
		_funCallBack().close();
		_this.setSelectedValue(arrValueTextModel,true,_this.protectedMethod.inputNextRequiredParamCallback);
	}
	var _funCancleCallback = function ()
	{
		if (oReportParamDesc.isRequired() && _arrSelectValueTextModel.length == 0 )
		{
			return;
		}
		_this.onBlur();
	}
	this.createUI = function(jqParent)
	{
		_jqParent = jqParent;
		_funCallBack = this.protectedMethod.createTopUiWithCtrl(jqParent, _jqSelectCtrl,true,initCallBack,_funConfirmCallBack,_funCancleCallback);
		_funCallBack().setValue(_arrSelectValueTextModel);
	}
	
	this.setSuppliedValue = function(data)
	{
		//nothing
	}
	
	this.setSelectedValue = function(arrValueTextModel,isFireSelectedValueChanged,funCallback)
	{
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelectValueTextModel,arrValueTextModel))
		{
			if (funCallback)
			{
				funCallback();
			}
			return;
		}
		var strValue;
		if(arrValueTextModel && arrValueTextModel.length > 0)
		{
			strValue = arrValueTextModel[0].getValue();
		}
		if (strValue)
		{
			var oValueTextModel = new KEXTValueTextModel();
			var oDate = KEXTFilterDataUtil.parseString2Date(strValue);
			_oCtrl.setSelectValue(oDate);
			oValueTextModel.setValue(strValue);
			oValueTextModel.setText(strValue);
			_arrSelectValueTextModel = [oValueTextModel];
		}
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
		}
		if (isFireSelectedValueChanged != false)
		{
			_this.protectedMethod.fireSelectedValueChanged(funCallback);
		}
	}
	
	this.getSelectedValue = function()
	{	
		if (_arrSelectValueTextModel && _arrSelectValueTextModel.length>0)
		{
			return _arrSelectValueTextModel;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.onFocus = function()
	{
		if (_funCallBack)
		{
			_funCallBack().open();
		}
	}
	this.onBlur = function()
	{
		if (_funCallBack)
		{
			_funCallBack().setValue(_arrSelectValueTextModel);
			_funCallBack().close();
		}
	}
}


/**
 * 标签控件
 */
function KEXTTopFilterLabel(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	this.createUI = function(jqParent)
	{
		this.protectedMethod.createTopUiWithLabel(jqParent);
	}
	
	this.setSuppliedValue = function(data)
	{
		//无
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		//无
	}
	
	this.getSelectedValue = function()
	{
		//无
		return [];		
	}
}
