//扩展报表轻应用过滤器框架
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖： 
//jQuery 2.1.0 (http://jquery.com)
//jQueryMobile 1.4.2 (http://jquerymobile.com)
//
/**
* 报表过滤器抽象类
*/
function KEXTAbstractFilter()
{
	var _this = this;
	var _arrParamsName;//所有参数的名称，有序
	var _funDelayedSuppliedValueGetter;//延迟取备选值(如F7)的回调函数
	var _mapCtrls;//key是参数名，value是控件封装对象（KEXTAbstractFilterCtrl）
	var _bSaveAsScheme = true;
	var _oAssociateModel;//KEXTParamsAssociateModel
	
	var _jqMainOwner;//过滤器的容器，外部提供；过滤器的界面切换在这里面进行。
	var _jqAllFilter;//过滤器的主界面，堆放所有参数对应的控件。
	/**
	 * 设置参数间依赖关系
	 */
	this.setAssociate = function(oAssociate)
	{
		_oAssociateModel = oAssociate;
	}
	
	/**
	 * 设置延迟取备选值的函数
	 * 函数形如：func(sDatasetXml, sJsonParamsValues, funCallback)
	 * 其中回调funCallback形如：func(oData)
	 */
	this.setDelayedSuppliedValueGetter = function(funCall)
	{
		_funDelayedSuppliedValueGetter = funCall;
	}
	
	/**
	 * 上一次的参数值，KEXTParamsValues对象，可以为空。 
	 */
	this.setLastTimeValue = function(oParamsValues)
	{
		if(!_this.protectedMethod._mapCtrls || !_funDelayedSuppliedValueGetter)
		{
			throw new Error("Call me after setModel() & setDelayedSuppliedValueGetter().");
		}
		if(oParamsValues)
		{
			_this.protectedMethod._bSaveAsScheme = oParamsValues.isSaveAsScheme();
			initLastTimeValue(oParamsValues);
		}
	}
	
	var initLastTimeValue = function(oParamsValues)
	{
		//串成同步
		var funForOneParamCreator = function(oFilterCtrl, arrValues, funNextStep)
		{
			var funForOneParam = function()
			{
				oFilterCtrl.setSelectedValue(arrValues);
				fireCtrlSelectedValueChanged(oFilterCtrl, funNextStep);
			}
			return funForOneParam;
		}
		
		var funRoot;
		for(var index=_this.protectedMethod._arrParamsName.length-1;index>=0;index--)
		{
			var sParamName = _this.protectedMethod._arrParamsName[index];
			var oFilterCtrl = _this.protectedMethod._mapCtrls[sParamName];
			var arrValues = oParamsValues.getValues(sParamName);
			if(arrValues)
			{
				funRoot = funForOneParamCreator(oFilterCtrl, arrValues, funRoot);
			}
			else
			{
				funRoot = funForOneParamCreator(oFilterCtrl, oFilterCtrl.getParamDescription().getDefaultValue(), funRoot);
			}
		}
		if(funRoot)
		{
			funRoot();
		}
	}
	
	/**
	 * 必填的参数没有值，返回参数显示名称的数组
	 */
	this.getRequiredEmpty = function()
	{
		var arrEmptyParamNames = [];
		for(var i = 0; i < _this.protectedMethod._arrParamsName.length; i++)
		{
			var oCtrl = _this.protectedMethod._mapCtrls[_this.protectedMethod._arrParamsName[i]];
			var oDesc = oCtrl.getParamDescription();
			if (oDesc.getCtrlType() != "label" && oDesc.isRequired())
			{
				var arrSelectedValue = oCtrl.getSelectedValue();
				if(!arrSelectedValue || arrSelectedValue.length == 0)//空数组
				{
					arrEmptyParamNames.push(oDesc.getCaption())
				}
				else
				{
					var bHasValue = false;
					for (var index = 0;index<arrSelectedValue.length;index++)
					{
						var selectedValue = arrSelectedValue[index];
						if (selectedValue.getValue() && selectedValue.getText())//存在非空值
						{
							bHasValue = true;
							break;
						}
					}
					if (!bHasValue)
					{
						arrEmptyParamNames.push(oDesc.getCaption())
					}
				}
			}
		}
		return arrEmptyParamNames;
	}
	
	/**
	 * 获取经过用户操作之后，最终各过滤参数的值，KEXTParamsValues对象
	 */
	this.getSelecteds = function()
	{
		var oParamsValues = new KEXTParamsValues();
		for(var sName in _this.protectedMethod._mapCtrls)
		{
			pickOneFilterValue(sName, oParamsValues);
		}
		oParamsValues.setSaveAsScheme(_this.protectedMethod._bSaveAsScheme);
		return oParamsValues;
	}
	
	/** 返回指定名称的控件的当前值 [ValueTextModel] */
	this.getSelectedValueForCtrl = function(sName)
	{
		var oCtrl = _this.protectedMethod._mapCtrls[sName];
		return oCtrl.getSelectedValue();
	}
	
	var pickOneFilterValue = function(sParamName, oParamsValues)
	{
		var oCtrl = _this.protectedMethod._mapCtrls[sParamName];
		var arrSelectedValue = oCtrl.getSelectedValue();
		if(arrSelectedValue)
		{
			for(var i = 0; i < arrSelectedValue.length; i++)
			{
				var oValueTextModel = arrSelectedValue[i];
				oParamsValues.addValue(sParamName, oValueTextModel);
			}
		}
	}
	
	/**
	 * 销毁 
	 */
	this.destroy = function()
	{
		//暂无
	}
	
	//将服务端取来的参数描述VO（json对象）转成客户端模型（类），与服务端的耦合只到这里。
	var decodeParamDesc = function(jsonParamDesc)
	{
		var oParamDesc = new KEXTReportParamDescription();
		if (jsonParamDesc["percentage"])
		{
			oParamDesc.setPercentage(jsonParamDesc["percentage"]);
		}
		oParamDesc.setName(jsonParamDesc["name"]);
		oParamDesc.setText(jsonParamDesc["text"]);
		oParamDesc.setDataType(jsonParamDesc["dataType"]);
		oParamDesc.setCtrlType(jsonParamDesc["ctrlType"]);
		oParamDesc.setRequired(jsonParamDesc["required"]==true);
		oParamDesc.setMultiSelectable(jsonParamDesc["multiSelectable"]==true);
		oParamDesc.setHide(jsonParamDesc["state"]=="Hidden");
		oParamDesc.setReadOnly(jsonParamDesc["state"]=="ReadOnly");
		oParamDesc.setMaxRestrictNumber(jsonParamDesc["maxRestrictNumber"]);
		
		var oSuppliedValue = decodeSuppliedValue(jsonParamDesc["suppliedValue"]);
		oParamDesc.setSuppliedValue(oSuppliedValue);

		var arrDefaultValue = decodeDefaultValue(
			jsonParamDesc["defaultValue"],  oParamDesc.getCtrlType(), oParamDesc.getDataType());
		oParamDesc.setDefaultValue(arrDefaultValue);

		var oSVD = decodeSuppliedValueDescription(jsonParamDesc["suppliedValueDescription"]);
		oParamDesc.setSuppliedValueDescription(oSVD);

		return oParamDesc;
	}
	
	//将服务端的ListValue对象或Entry的数组转成ValueTextModel的数组
	var decodeListValue = function(jsonList)
	{
		var arrValueTextModel = [];
		for(var i = 0; i < jsonList.length; i++)
		{
			var jsonEntry = jsonList[i];
			var oVTM = new KEXTValueTextModel();
			oVTM.setValue(jsonEntry["value"]);
			oVTM.setText(jsonEntry["text"]);
			arrValueTextModel.push(oVTM);
		}
		return arrValueTextModel;
	}
	
	//转备选值
	var decodeSuppliedValue = function(jsonSuppliedValue)
	{
		if(!jsonSuppliedValue)
		{
			return null;
		}
		//ListValue
		if(jsonSuppliedValue instanceof Array)
		{
			return decodeListValue(jsonSuppliedValue);
		}
		//NumberStepperValue
		var strMin = jsonSuppliedValue["min"];
		var strMax = jsonSuppliedValue["max"];
		var strStep = jsonSuppliedValue["step"];
		if(strMin && strMax && strStep)
		{
			var oData = new KEXTNumberStepperSuppliedValue();
			oData.setMin(strMin);
			oData.setMax(strMax);
			oData.setStep(strStep);
			return oData;
		}
		//CheckBoxValue
		var jsonChecked = jsonSuppliedValue["checked"];
		var jsonUnChecked = jsonSuppliedValue["unChecked"];
		if(jsonChecked && jsonUnChecked)
		{
			return decodeListValue([jsonChecked, jsonUnChecked]);
		}
		else
		{
			throw new Error("TODO here");
		}
		return null;
	}
	
	//转备选值来源描述
	var decodeSuppliedValueDescription = function(jsonSuppliedValueDesc)
	{
		if(!jsonSuppliedValueDesc)
		{
			return null;
		}
		var strDatasetXml = jsonSuppliedValueDesc["persistenceModel"];
		var strValueField = jsonSuppliedValueDesc["valueFieldName"];
		var strTextField = jsonSuppliedValueDesc["textFieldName"];
		if(strDatasetXml && strValueField && strTextField)
		{
			var oDelayDesc = new KEXTListDelaySuppliedValueDescription();
			oDelayDesc.setDatasetPersistenceModel(strDatasetXml);
			oDelayDesc.setValueField(strValueField);
			oDelayDesc.setTextField(strTextField);
			return oDelayDesc;
		}
		else if(jsonSuppliedValueDesc["function"])
		{
			var oCodeDesc = new KEXTCodeDelaySuppliedValueDescription();
			oCodeDesc.setFunction(jsonSuppliedValueDesc["function"]);
			return oCodeDesc;
		}
		else
		{
			throw new Error("TODO here");
		}
		return null;
	}
	
	//转缺省值，返回值统一为ValueTextModel的数组
	var decodeDefaultValue = function(jsonDefaultValue, sCtrlType, sDataType)
	{
		//修改jsonDefaultValue为0时判断出错的问题 alex_shen 2016/4/28
		if(jsonDefaultValue == null)
		{
			return null;
		}
		//DateTimeValue
		if(sCtrlType == "datetime")
		{
			return decodeDateTimeValue(jsonDefaultValue, sDataType);
		}
		//ListValue & F7
		if(jsonDefaultValue instanceof Array)
		{
			return decodeListValue(jsonDefaultValue);
		}
		//Entry(独立多选框)
		var strValue = jsonDefaultValue["value"];
		var strText = jsonDefaultValue["text"];
		if(typeof(strValue) != "undefined" && typeof(strText) != "undefined")
		{
			var oVTM = new KEXTValueTextModel();
			oVTM.setValue(strValue);
			oVTM.setText(strText);
			return [oVTM];
		}
		//数字 或 字符串
		var strDefaultValue = jsonDefaultValue.toString();
		var oVTM = new KEXTValueTextModel();
		oVTM.setValue(strDefaultValue);
		oVTM.setText(strDefaultValue);
		return [oVTM];
	}
	
	var decodeDateTimeValue = function(iMilliSeconds, sDataType)
	{
		var oDate = new Date(iMilliSeconds);
		var sValue = KEXTFilterDataUtil.parseDate2String(oDate, sDataType);
		var oVTM = new KEXTValueTextModel();
		oVTM.setValue(sValue);
		oVTM.setText(sValue);
		return [oVTM];		
	}
	
	var createInnerDelaySuppliedValueGetter = function(sParamName)
	{
		return function(sDatasetXml, funCallback)
		{
			var sJsonParamsValues = "";
			if(_oAssociateModel)
			{
				var oParamsValues = new KEXTParamsValues();
				for(var i = 0; i < _this.protectedMethod._arrParamsName.length; i++)
				{
					var sPn = _this.protectedMethod._arrParamsName[i];
					if(sPn != sParamName && _oAssociateModel.isOneAffectedByAnother(sParamName, sPn))
					{
						pickOneFilterValue(sPn, oParamsValues);
					}
				}
				sJsonParamsValues = oParamsValues.toJsonStringForExecute();
			}
			_funDelayedSuppliedValueGetter(sParamName,sDatasetXml, sJsonParamsValues, funCallback);
		};
	}
	
	var ctrlSelectedValueChanged = function(oCtrl, funCallback)
	{
		fireCtrlSelectedValueChanged(oCtrl, funCallback);
	}
	
	var fireCtrlSelectedValueChanged = function(oCtrl, funCallback)
	{
		var sTargetParam = oCtrl.getParamDescription().getName();
		if(_oAssociateModel && _oAssociateModel.isOneAffectOthers(sTargetParam))
		{
			var mapAllReady;
			var funAllReady;
			if(funCallback)
			{
				//所有受影响的参数重置完成后再回调
				mapAllReady = {};
				funAllReady = function(sKey)
				{
					mapAllReady[sKey] = true;
					var bAllReady = true;
					for(var sOneKey in mapAllReady)
					{
						if(!mapAllReady[sOneKey])
						{
							bAllReady = false;
							break;
						}
					}
					if(bAllReady)
					{
						funCallback();
					}
				}
			}
			
			for(var i = 0; i < _this.protectedMethod._arrParamsName.length; i++)
			{
				var sParam = _this.protectedMethod._arrParamsName[i];
				if(_oAssociateModel.isOneAffectAnother(sTargetParam, sParam))
				{
					var oCtrl = _this.protectedMethod._mapCtrls[sParam];
					if(funCallback)
					{
						mapAllReady[i] = false;
						oCtrl.resetSuppliedValue(funAllReady, i);
					}
					else
					{
						oCtrl.resetSuppliedValue();
					}
				}
			}
		}
		else
		{
			if(funCallback)
			{
				funCallback();
			}
		}
	}
	this.protectedMethod = 
	{
		"_mapCtrls":_mapCtrls,
		"_arrParamsName":_arrParamsName,
		"_bSaveAsScheme":_bSaveAsScheme,
		"_jqMainOwner":_jqMainOwner,
		"decodeParamDesc":decodeParamDesc,
		"createInnerDelaySuppliedValueGetter":createInnerDelaySuppliedValueGetter,
		"ctrlSelectedValueChanged":ctrlSelectedValueChanged
	}
}
/**
 * 报表过滤器主类
 */
function KEXTReportFilter()
{
	KEXTAbstractFilter.call(this);
	var _this = this;
	var _funUiChangeListener;//界面内部切换，向外通知
	var _objCurrentForwardCtrl;//使界面切换的控件，如果是显示AllFilter主界面，它应该为空。
	
	/**
	 * 传入数据模型，arrParamDescs是参数描述信息，KEXTReportParamDescription的数组
	 */
	this.setModel = function(arrParamDescs)
	{
		initCtrl(arrParamDescs);
	}
	
	/**
	 * 在指定的容器上展现界面 
	 */
	this.draw = function(jqOwner)
	{
		_objCurrentForwardCtrl = null;
		_this.protectedMethod._jqMainOwner = jqOwner;
		_jqAllFilter = createAllFilter(_this.protectedMethod._jqMainOwner);
		$.mobile.activePage.css("background-color", "#ffffff");
	}
	
	/**
	 * 设置界面切换的事件监听 
	 * 回调函数形如：func(bAllFilterLayer, bSubLayerCanFinish)
	 */
	this.setUiChangeListener = function(funCallback)
	{
		_funUiChangeListener = funCallback;
	}
	
	/**
	 * 回退
	 * 返回true表示可以退出过滤界面；否则只引起内部界面做一次回退
	 */
	this.askBackward = function()
	{
		if(_objCurrentForwardCtrl)
		{
			var jqUi = _objCurrentForwardCtrl.backward();
			if(jqUi)
			{
				var bCanFinish = jqUi.data("backupAttr_isCanFinish");
				updateUi(true, _objCurrentForwardCtrl, jqUi, bCanFinish);//回退到控件众子界面的上一层
			}
			else
			{
				updateUi(true);//回退到过滤器主界面
			}
			return false;
		}
		return true;
	}
	
	/**
	 * 外部按下[完成/确定/打勾]，如果是在控件的子界面，拦截处理并返回true，否则返回false
	 */
	this.interceptConfirm = function(funPromptRequired)
	{
		if(_objCurrentForwardCtrl)
		{
			if(_objCurrentForwardCtrl.confirmed(funPromptRequired))
			{
				updateUi(true);
			}
			return true;
		}
		return false;
	}
	
	var initCtrl = function(arrParamDescs)
	{
		_this.protectedMethod._arrParamsName = [];
		_this.protectedMethod._mapCtrls = {};
		//初始化过滤器控件
		for(var i = 0; i < arrParamDescs.length; i++)
		{
			//json对象转成数据模型
			var jsonParamDesc = arrParamDescs[i];
			var oParamDesc = _this.protectedMethod.decodeParamDesc(jsonParamDesc);
			var sParamName = oParamDesc.getName();
			_this.protectedMethod._arrParamsName.push(sParamName);
			//创建控件
			var oFilterCtrl = KEXTFilterCtrlFactory.create(oParamDesc);
			_this.protectedMethod._mapCtrls[sParamName] = oFilterCtrl;

			oFilterCtrl.setSuppliedValue(oParamDesc.getSuppliedValue());
			
			if( oFilterCtrl instanceof FilterLabel)
			{
				continue;
			}
			var oSVD = oParamDesc.getSuppliedValueDescription();
			if(oSVD instanceof KEXTCodeDelaySuppliedValueDescription)
			{
				oFilterCtrl.setSuppliedValueDescriptionAndGetter(oSVD, oSVD.getFunction());
			}
			else
			{
				oFilterCtrl.setSuppliedValueDescriptionAndGetter(oSVD,  _this.protectedMethod.createInnerDelaySuppliedValueGetter(sParamName));
			}
			
			oFilterCtrl.setSelectedValue(oParamDesc.getDefaultValue());
			
			oFilterCtrl.setUiChangeCallback(forwardUiForCtrl, backwardUiForCtrl);
			oFilterCtrl.setSelectedValueChangedListener(_this.protectedMethod.ctrlSelectedValueChanged);
		}
	}
	
	//将服务端取来的参数描述VO（json对象）转成客户端模型（类），与服务端的耦合只到这里。
	var decodeParamDesc = function(jsonParamDesc)
	{
		var oParamDesc = new KEXTReportParamDescription();
		oParamDesc.setName(jsonParamDesc["name"]);
		oParamDesc.setText(jsonParamDesc["text"]);
		oParamDesc.setDataType(jsonParamDesc["dataType"]);
		oParamDesc.setCtrlType(jsonParamDesc["ctrlType"]);
		oParamDesc.setRequired(jsonParamDesc["required"]==true);
		oParamDesc.setMultiSelectable(jsonParamDesc["multiSelectable"]==true);
		oParamDesc.setHide(jsonParamDesc["state"]=="Hidden");
		oParamDesc.setReadOnly(jsonParamDesc["state"]=="ReadOnly");
		
		var oSuppliedValue = decodeSuppliedValue(jsonParamDesc["suppliedValue"]);
		oParamDesc.setSuppliedValue(oSuppliedValue);

		var arrDefaultValue = decodeDefaultValue(jsonParamDesc["defaultValue"],  oParamDesc.getCtrlType(), oParamDesc.getDataType());
		oParamDesc.setDefaultValue(arrDefaultValue);

		var oSVD = decodeSuppliedValueDescription(jsonParamDesc["suppliedValueDescription"]);
		oParamDesc.setSuppliedValueDescription(oSVD);

		return oParamDesc;
	}
	
	var forwardUiForCtrl = function(oFilterCtrl, jqUi, bCanFinish, funcAfterUpdateUi)
	{
		jqUi.data("backupAttr_isCanFinish", bCanFinish);
		updateUi(false, oFilterCtrl, jqUi, bCanFinish,funcAfterUpdateUi);
	}
	
	var backwardUiForCtrl = function(funcAfterUpdateUi)
	{
		updateUi(true,null,null,null,funcAfterUpdateUi);
	}
	
	var _oStackForLastScrollTop = [];
	var keepScrollState = function()
	{
		//依赖于提供滚动的容器是谁
		_oStackForLastScrollTop.push(_this.protectedMethod._jqMainOwner.prop("scrollTop"));
	}
	
	var resetScrollState = function()
	{
		var iValue = _oStackForLastScrollTop.pop();
		setScrollState(iValue);
	}
	
	var setScrollState = function(iScrollTop)
	{
		_this.protectedMethod._jqMainOwner.animate(
			{
				"scrollTop": iScrollTop
			});
	}
	
	var updateUi = function(bBackward, oFilterCtrl, jqUi, bCanFinish, funcAfterUpdateUi)
	{		
		_objCurrentForwardCtrl = oFilterCtrl;
		var funChangeUiTo = function(jqUi)
		{
			if(bBackward)
			{
				var jqOldUi = _this.protectedMethod._jqMainOwner.children();
				jqOldUi.css("position", "absolute");
				jqOldUi.css("top", 0);
				jqOldUi.css("left", 0);
				jqOldUi.css("width", _this.protectedMethod._jqMainOwner.width());
				jqOldUi.css("z-index", 1024);
				_this.protectedMethod._jqMainOwner.append(jqUi);
				jqOldUi.animate({left: _this.protectedMethod._jqMainOwner.width()},
					function()
					{
						jqOldUi.detach();
						resetScrollState();
						if(funcAfterUpdateUi)
						{
							funcAfterUpdateUi();
						}
					});
			}
			else
			{
				keepScrollState();	
				var jqOldUi = _this.protectedMethod._jqMainOwner.children();
				_this.protectedMethod._jqMainOwner.append(jqUi);
				jqUi.css("position", "absolute");
				jqUi.css("top", 0);
				jqUi.css("left", _this.protectedMethod._jqMainOwner.width());
				jqUi.css("width", _this.protectedMethod._jqMainOwner.width());
				jqUi.css("z-index", 1024);
				jqUi.animate({left: 0},
					function()
					{
						jqUi.css("z-index", 0);
						jqUi.css("position", "");
						jqUi.css("top", "");
						jqUi.css("left", "");
						jqUi.css("width", "");
						jqOldUi.detach();
						setScrollState(0);
						if(funcAfterUpdateUi)
						{
							funcAfterUpdateUi();
						}
					});
			}
		}
		
		var bAllFilterLayer;
		var bSubLayerCanFinish;
		if(oFilterCtrl && jqUi)
		{
			bAllFilterLayer = false;
			bSubLayerCanFinish = bCanFinish;
			funChangeUiTo(jqUi);
		}
		else
		{
			bAllFilterLayer = true;
			funChangeUiTo(_jqAllFilter);
		}
		_funUiChangeListener(bAllFilterLayer, bSubLayerCanFinish);
	}
	
	var createAllFilter = function(jqParent)
	{
		var jqDiv = $("<div class='kdlight-filter-item-list'>");
		jqDiv.appendTo(jqParent);
		var jqSaveAsScheme = createSaveAsScheme();
		jqSaveAsScheme.appendTo(jqDiv);
		for(var i = 0; i < _this.protectedMethod._arrParamsName.length; i++)
		{
			var oCtrl = _this.protectedMethod._mapCtrls[_this.protectedMethod._arrParamsName[i]];
			if(oCtrl.getParamDescription().isHide())
			{
				continue;
			}
			var jqLi = $("<div class='kdlight-filter-item'>");
			jqLi.appendTo(jqDiv);			
			oCtrl.createUI(jqLi);
		}
		
		jqDiv.appendTo(jqParent);		

		return jqDiv;
	}
	
	var createSaveAsScheme = function()
	{
		var jqCheck = $("<span>");
		jqCheck.data("sys-checked", true);
		jqCheck.css({
			position: "absolute",
			left: "16px",
			width: "20px",
			height: "20px",
			border: "1px solid #ccc",
			borderRadius: "5px",
			textAlign: "center",
			lineHeight: "20px",
			fontSize: "16px",
			color: "#393"
		});

		var jqSaveAsScheme = $("<div>");
		jqSaveAsScheme.text("下次打开报表时使用当前过滤条件");
		jqSaveAsScheme.css({
			padding: "10px 0px 10px 45px",
			color: "#369",
			fontSize: "14px",
			lineHeight: "24px"
		});
		jqSaveAsScheme.on("click", 
			function(evt)
			{
				_this.protectedMethod._bSaveAsScheme = !_this.protectedMethod._bSaveAsScheme;
				funSyncCheck();
			});
		jqSaveAsScheme.append(jqCheck);
			
		var funSyncCheck = function()
		{
			jqCheck.text(_this.protectedMethod._bSaveAsScheme ? "√" : "");
			jqSaveAsScheme.css("color", (_this.protectedMethod._bSaveAsScheme ? "#369" : "#999"));
		};
		funSyncCheck();
		return jqSaveAsScheme;
	}
	
}

/**
 * 创建过滤控件的工厂
 */
var KEXTFilterCtrlFactory = new (function()
{
	this.create = function(oReportParamDesc,bIsTopFilter)
	{
		if(!(oReportParamDesc instanceof KEXTReportParamDescription))
		{
			throw new Error("Illegal argument.");
		}
		if (bIsTopFilter)
		{
			//顶部过滤器
			switch(oReportParamDesc.getCtrlType())
			{
				case "combobox":
				case "checkboxgroup":
					if (oReportParamDesc.isMultiSelectable())
					{
						return new KEXTTopMultiSelector(oReportParamDesc);
					}
					else
					{
						return new KEXTTopSingleSelector(oReportParamDesc);
					}
				case "f7":
					return new KEXTTopFilterForwardSelector(oReportParamDesc);
				case "checkbox":
					return new KEXTTopFilterFlipInput(oReportParamDesc);
				case "datetime":
					return new KEXTTopFilterDateSelector(oReportParamDesc);
				case "numberstepper":
					return new KEXTTopFilterNumberInput(oReportParamDesc);
				case "label": 
					return new KEXTTopFilterLabel(oReportParamDesc);
				default:
					return new KEXTTopFilterTextField(oReportParamDesc);
			}
		}
		else
		{
			switch(oReportParamDesc.getCtrlType())
			{
				case "checkbox":
					return new KEXTFilterFlipInput(oReportParamDesc);
				case "combobox":
				case "checkboxgroup":
					if (oReportParamDesc.isMultiSelectable())
					{
						return new KEXTMultiSelector(oReportParamDesc);
					}
					else
					{
						return new KEXTSingleSelector(oReportParamDesc);
					}
				case "f7":
					return new KEXTFilterForwardSelector(oReportParamDesc);
				case "numberstepper":
					return new KEXTFilterNumberInput(oReportParamDesc);
				case "checkboxgroup":
					return new KEXTFilterCheckBoxGroup(oReportParamDesc);
				case "datetime":
					return new KEXTFilterDateSelector(oReportParamDesc);
				case "label": 
					return new FilterLabel(oReportParamDesc); 
				default:
					return new KEXTFilterTextField(oReportParamDesc);
			}
		}
	}
})();

/**
 * 过滤器控件的抽象基类
 * 对普通UI的封装，可看作是带过滤器逻辑的控件。
 */
function KEXTAbstractFilterCtrl(objReportParamDesc)
{
	var _this = this;
	var _objReportParamDesc = objReportParamDesc;
	var _funSelectedValueChangedListener;
	var _funinputNextRequiredParamCallback;//用于顶部过滤器，触发下一个必选参数
	var _funCurrentCtrlSelectedListener;
	/**
	 * 取得参数描述信息
	 */	
	this.getParamDescription = function()
	{
		return _objReportParamDesc;
	}
	
	/**
	 * 创建UI
	 * 参数jqParent为父对象，是jQuery封装的HTML DOM对象
	 */
	this.createUI = function(jqParent)
	{
		throw new Error("Override me.");
	}
	
	/**
	 * 设置备选值或定义取值区间
	 */
	this.setSuppliedValue = function(data)
	{
		throw new Error("Override me.");
	}
	
	/**
	 * 设置选中值
	 * 不管什么类型的控件，都统一成ValueTextModel的数组
	 */
	this.setSelectedValue = function(arrValueTextModel)
	{
		throw new Error("Override me.");
	}
	
	/**
	 * 获取选中值
	 * 返回ValueTextModel的数组，单选就是数组中只有一个元素
	 */
	this.getSelectedValue = function()
	{
		throw new Error("Override me.");
	}

	/**
	 * 设置备选值描述信息，和延迟取数的回调函数
	 * funGetter形如：func(sDatasetXml, funCallback)
	 * 其中回调funCallback形如：func(oData)
	 */
	this.setSuppliedValueDescriptionAndGetter = function(objSuppliedValueDescription, funGetter)
	{
		//非必须
	}
	
	/**
	 * 设置界面前进和后退的回调函数
	 * funForwardCallback形如：func(oFilterCtrl, jqUi, bCanFinish, funcAfterUpdateUi)
	 *     其中oFilterCtrl是本类实例；jqUi是要更新的界面；bCanFinish是否允许按[完成]回到过滤器主界面；funcAfterUpdateUi是界面更新后处理函数，无参。
	 * funBackwardCallback形如：func()
	 */
	this.setUiChangeCallback = function(funForwardCallback, funBackwardCallback)
	{
		//非必须
	}
	
	/**
	 * 外部唤起界面回退，返回界面的jQuery封装，如果退到头，返回null
	 */	
	this.backward = function()
	{
		//非必须
	}
	
	/**
	 * 按[确定]唤起的界面回退
	 * 返回true退到过滤器主界面；返回false表示校验不通过，仍停留在当前界面。
	 * 实现时只做逻辑处理，不管界面切换。
	 * funPromptRequired形如：func(sParamCaption)
	 */
	this.confirmed = function(funPromptRequired)
	{
		//非必须
	}
	
	/**
	 *  受其它参数值变化影响，重置备选值（同时清空选中值并发事件），用于联动
	 *  实现时注意如果有funCallback，则异步回调funCallback(oCallbackParam)
	 */
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		//非必须
	}
	
	/**
	 * 设置值改变事件
	 * funListener形如：func(oCtrl) 
	 */
	this.setSelectedValueChangedListener = function(funListener)
	{
		_funSelectedValueChangedListener = funListener;
	}
	
	var fireSelectedValueChanged = function(funCallback)
	{
		if(_funSelectedValueChangedListener)
		{
			_funSelectedValueChangedListener(_this, funCallback);
		}
	}
	
	this.setCurrentCtrlSelectedListener = function(funListener)
	{
		_funCurrentCtrlSelectedListener = funListener;
	}
	
	var fireCtrlSelectedChanged = function ()
	{
		if (_funCurrentCtrlSelectedListener)
		{
			_funCurrentCtrlSelectedListener(_this);
		}
	}
	
	this.setInputNextRequiredParamCallback = function(funListener)
	{
		_funinputNextRequiredParamCallback = funListener;
	}
	
	var  inputNextRequiredParamCallback= function()
	{
		if(_funinputNextRequiredParamCallback)
		{
			_funinputNextRequiredParamCallback(_this);
		}
	}
	//创建用label实现的带标签的控件
	var createUiWithLabel = function(jqParent, jqCtrl)
	{
		var strCtrlId = "ctrl_" + _objReportParamDesc.getName();
		jqCtrl.attr("id", strCtrlId);
		var jqLabel = $("<div class='kdlight-filter-item-title kdlight-filter-activeable'></div>");
		jqLabel.text(_objReportParamDesc.getCaption());
		if (_objReportParamDesc.isRequired())
		{
			jqLabel.append("<em>*</em>");
		}
		jqLabel.attr("for", strCtrlId);
		
		var jqDiv = $("<div class='kdlight-filter-item-content'>")
		jqDiv.attr("for", strCtrlId);
		jqDiv.append(jqCtrl);
		
		addCtrlDisableClass(jqLabel, jqDiv);
		
		jqParent.append(jqLabel);
		jqParent.append(jqDiv);
	}
	
	var addCtrlDisableClass = function(jqLabel, jqDiv)
	{
		if(_objReportParamDesc.isReadOnly())
		{
			if(jqLabel)
				jqLabel.addClass("kdlight-filter-disable");
			if(jqDiv)
				jqDiv.addClass("kdlight-filter-disable");
		}
	}
	
	var createUiWithLabelAndCtrl = function(jqParent, jqShowValue, jaSelectCtrl,isDefaultExtend,funExtendEventHandler)
	{
		var strCtrlId = "ctrl_" + _objReportParamDesc.getName();		
		//标题区域
		var jqLabel = $("<div class='kdlight-filter-item-title kdlight-filter-activeable'></div>");
		if (isDefaultExtend)
		{
			jqLabel.addClass("kdlight-filter-item-title-icon-d");
		}
		else
		{
			jqLabel.addClass("kdlight-filter-item-title-icon-l");
		}
		jqLabel.text(_objReportParamDesc.getCaption());
		if (_objReportParamDesc.isRequired())
		{
			jqLabel.append("<em>*</em>");
		}
		var _jqSelectCtrl=jaSelectCtrl;
		jqLabel.on('click',function(e){
			var isShowValue = false;
			if ($(e.target).hasClass('kdlight-filter-item-title-icon-d'))
			{
				isShowValue = false;
			}
			else
			{
				isShowValue = true;
			}
			funExtendEventHandler(isShowValue);		
			_funExtendEventCallBack(isShowValue);		
		});
		jqLabel.attr("for", strCtrlId);
		
		//内容区域
		jaSelectCtrl.attr("id", strCtrlId);
		jqShowValue.attr("for", strCtrlId);
		var jqDiv = $("<div class='kdlight-filter-item-content'>")
		jqDiv.attr("for", strCtrlId);
		jqDiv.append(jqShowValue);
		jqDiv.append(jaSelectCtrl);
		
		addCtrlDisableClass(jqLabel, jqDiv);
		
		jqParent.append(jqLabel);
		jqParent.append(jqDiv);
		var	_funExtendEventCallBack = function (isShowValue)
		{	
			var jqScrollContainer = $(_jqSelectCtrl.parents(".scrollContainer")[0]);
			if (isShowValue)
			{
				jqLabel.addClass('kdlight-filter-item-title-icon-d');
				jqLabel.removeClass('kdlight-filter-item-title-icon-l');
				
				var jqScrollView = $(_jqSelectCtrl.parents(".scrollView")[0]);
				var iScrollViewHeight = jqScrollView.height();
				
				var iLabel = jqLabel.offset().top - 45;
				var iSelectCtrl = jqDiv.offset().top - 45 + jqDiv.height();
				if (iSelectCtrl>iScrollViewHeight)
				{
					var iMove = iSelectCtrl-iScrollViewHeight;
					if (iMove>iLabel)
					{
						iMove = jqScrollContainer.scrollTop()+iLabel;
					}
					else
					{
						iMove = jqScrollContainer.scrollTop()+iMove+jqLabel.height();
					}
					jqScrollContainer.animate({
						scrollTop: iMove
					}, 0);
				}
			}
			else
			{
				jqLabel.removeClass('kdlight-filter-item-title-icon-d');
				jqLabel.addClass('kdlight-filter-item-title-icon-l');
				if (jqLabel.hasClass("kdlight-filter-item-title-fixed"))
				{
					jqLabel.removeClass("kdlight-filter-item-title-fixed");
					jqDiv.css("margin-top",0+"px");
					jqScrollContainer.animate({
						scrollTop: jqScrollContainer.scrollTop()-0.1
					}, 0);
				}
			}
		};
		return _funExtendEventCallBack;
	}
	
	//创建用fieldset、legend实现的带标签的控件
	//@param jqCtrl 可以是jQuery包装的HTML元素，也可以是其数组
	var createUiWithFieldset = function(jqParent, jqCtrl)
	{
		var jqFieldset = $("<fieldset>");
		jqFieldset.attr("data-role", "controlgroup");
		
		var jqLegend = $("<legend>");
		jqLegend.text(_objReportParamDesc.getCaption());
		
		jqFieldset.append(jqLegend);
		if(jqCtrl instanceof Array)
		{
			for(var i = 0; i < jqCtrl.length; i++)
			{
				jqFieldset.append(jqCtrl[i]);
			}
		}
		else
		{
			var strCtrlId = "ctrl_" + _objReportParamDesc.getName();
			jqCtrl.attr("id", strCtrlId);
			jqFieldset.append(jqCtrl);
		}
		
		jqParent.append(jqFieldset);
	}
	
	//侧拉过滤器标签类型
	var createUiWithLabel2 = function(jqParent, jqCtrl)
	{
		var strCtrlId = "ctrl_" + _objReportParamDesc.getName();
		jqCtrl.attr("id", strCtrlId);
		jqParent.append(jqCtrl);
	}
	
	var createTopUiWithLabel = function(jqParent)
	{
		var strCtrlId = "ctrl_" + _objReportParamDesc.getName();
		var jqLabel = $("<div class='kdlight-top-filter-item-title'></div>");
		jqLabel.css({"color":"#000"});
		jqLabel.append($(_objReportParamDesc.getDefaultValue()[0].getValue()));
		jqLabel.attr("for", strCtrlId);
		
		var percentage = _objReportParamDesc.getPercentage();
		if(_objReportParamDesc.getPercentage()>0)
		{
			jqParent.css("width",percentage*100+"%");
		}
		
		addCtrlDisableClass(jqLabel);
		jqParent.append(jqLabel);
	}
	
	var createTopUiWithCtrl = function(jqParent, jqCtrl,bButtonBar, initCallBack,funConfirmCallback,funCancleCallback)
	{
		var strCtrlId = "ctrl_" + _objReportParamDesc.getName();
		jqCtrl.attr("id", strCtrlId);
		var jqLabel = $("<div class='kdlight-top-filter-item-title kdlight-top-filter-closed'></div>");
		jqLabel.attr("for", strCtrlId);
		var percentage = _objReportParamDesc.getPercentage();
		if(_objReportParamDesc.getPercentage()>0)
		{
			jqParent.css("width",percentage*100+"%");
		}
		addCtrlDisableClass(jqLabel);
		
		jqLabel.text(_objReportParamDesc.getCaption());
		jqParent.append(jqLabel);
		var jqOpenedMark = $("<div class='kdlight-top-filter-item-opened-mark'><img src='resource/arrows-up.png'/></div>");
		jqOpenedMark.hide();
		jqParent.append(jqOpenedMark);
		var funClose = function (target)
		{
			if (!target)
			{
				target = jqLabel;
			}
			target.removeClass("kdlight-top-filter-opened");
			target.addClass("kdlight-top-filter-closed");
			target.parent().find(".kdlight-top-filter-item-opened-mark").hide();	
			$(".ui-page-active .kdlight-top-filter-content").hide();
		};
		var _jqScrollView = $("<div class='content scrollView'>");
		var funOpen = function(target)
		{
			fireCtrlSelectedChanged(_this);
			if (!target)
			{
				target = jqLabel;
			}
			var jqFilterContent = $(".ui-page-active .kdlight-top-filter-content");
			jqFilterContent.attr("for", strCtrlId);
			jqFilterContent.empty();
			jqFilterContent.off('click');
			jqFilterContent.on('click',function(e){
				if ($(e.target).hasClass("kdlight-top-filter-content"))
				{
					if (funCancleCallback)
					{
						funCancleCallback();
					}
					return true;
				}
				return false;
			});
			_jqScrollView.empty();
			_jqScrollView.css("position", "relative");
			jqFilterContent.append(_jqScrollView);
			
			var _jqScrollContainer = $("<div class='scrollContainer'>");
			_jqScrollContainer.css("position", "absolute");
			_jqScrollContainer.css("top", "0px");
			_jqScrollContainer.css("bottom", "0");
			_jqScrollContainer.css("left", "0");
			_jqScrollContainer.css("right", "0");
			_jqScrollContainer.css("overflow-x", "hidden");
			_jqScrollContainer.css("overflow-y", "auto");
			_jqScrollView.append(_jqScrollContainer);
			_jqScrollContainer.append(jqCtrl);
			if (bButtonBar)
			{
				var buttonBar = $("<div class='buttonBar'></div>");
				var confirmButton = $("<div class='button'>确定</div>");
				confirmButton.on('click',function(e){
					if (funConfirmCallback)
					{
						funConfirmCallback();
					}
				});
				buttonBar.append(confirmButton);
				jqFilterContent.append(buttonBar);
			}
			if (_objReportParamDesc.isRequired())
			{
				jqFilterContent.append("<div class='tips'>* 请选择"+_objReportParamDesc.getCaption()+"(此为必选项)</div>");
			}
			target.removeClass("kdlight-top-filter-closed");
			target.addClass("kdlight-top-filter-opened");
			target.parent().find(".kdlight-top-filter-item-opened-mark").show();
			jqFilterContent.show();
			initCallBack();
			KEXTUtil.setSimScrollbar(_jqScrollContainer, _jqScrollView);
		}
		jqLabel.on('click',function(e){
			var target = $(e.target);
			if (!target.hasClass("kdlight-top-filter-item-title"))
			{				
				target = target.parent(".kdlight-top-filter-item-title");
			}
			var isShowValue = true;
			if (target.hasClass('kdlight-top-filter-closed'))
			{
				isShowValue = true;
				funOpen(target);
			}
			else
			{
				isShowValue = false;
				if (funCancleCallback)
				{
					funCancleCallback();
				}
			}
		});
		var funCallBack = function()
		{
			return {
				open:funOpen,
				close:funClose,
				updateUi:function(iHeight)
				{
					var maxHeight = parseInt($(".ui-page-active .kdlight-top-filter-content").css("height"));
					if (bButtonBar)
					{
						var buttonBar = $(".ui-page-active .kdlight-top-filter-content .buttonBar");
						maxHeight = maxHeight - parseInt(buttonBar.css("height"))-parseInt(buttonBar.css("padding-top"))-parseInt(buttonBar.css("padding-bottom"));
					}
					if (_objReportParamDesc.isRequired())
					{
						var tips = $(".ui-page-active .kdlight-top-filter-content .tips");
						maxHeight = maxHeight - parseInt(tips.css("height"))-parseInt(tips.css("padding-top"))-parseInt(tips.css("padding-bottom"));
					}
					iHeight = iHeight?iHeight:0;
					var jqCtrlHeight = parseInt(jqCtrl.css("height"))+parseInt(jqCtrl.css("margin-top"))+parseInt(jqCtrl.css("margin-bottom"))+iHeight+1;
					if (jqCtrlHeight>maxHeight)
					{
						$(".ui-page-active .kdlight-top-filter-content>.scrollView").css("height", maxHeight+"px");
					}
					else
					{
						$(".ui-page-active .kdlight-top-filter-content>.scrollView").css("height", jqCtrlHeight+"px");
					}
				},
				setValue:function(arrValueTextModel)
				{
					var strValueText="";
					if (arrValueTextModel)
					{
						for (var index=0;index<arrValueTextModel.length;index++)
						{
							var valueTextModel = arrValueTextModel[index];
							if (strValueText)
							{
								strValueText= strValueText + ";"+valueTextModel.getText();
							}
							else
							{
								strValueText= valueTextModel.getText();
							}
						}
					}
					
					var ele_font_size = jqParent.css('font-size');  
					var ele_font_family = jqParent.css('font-family');
					if (strValueText && strValueText.length>0)
					{
						jqLabel.text(strValueText);
						if(!jqLabel.hasClass("kdlight-top-filter-item-title-value"))
						{
							jqLabel.addClass("kdlight-top-filter-item-title-value");
						}
					}
					else
					{
						jqLabel.text(_objReportParamDesc.getCaption());
						if(jqLabel.hasClass("kdlight-top-filter-item-title-value"))
						{
							jqLabel.removeClass("kdlight-top-filter-item-title-value");
						}
					}
				},
				getButtonBar:function()
				{
					return $(".ui-page-active .kdlight-top-filter-content>.buttonBar");
				}
			};
		}
		return funCallBack;
	}
	
	var compareArrValueTextModel = function(arrValueTextModel1, arrValueTextModel2)
	{
		var null1 = false;
		var null2 = false;
		if (!arrValueTextModel1 || arrValueTextModel1.length == 0)//空数组
		{
			null1 = true;
		}
		else if (arrValueTextModel1.length == 1 && !arrValueTextModel1[0].getValue())//单个值，且为空
		{
			null1 = true;
		}
		
		if (!arrValueTextModel2 || arrValueTextModel2.length==0)//空数组
		{
			null2 = true;
		}
		else if (arrValueTextModel2.length == 1 && !arrValueTextModel2[0].getValue())//单个值，且为空
		{
			null2 = true;
		}
		
		if (null1 || null2)
		{
			return null1 && null2;
		}
		 
		if (arrValueTextModel2.length != arrValueTextModel1.length)
		{
			return false;
		}
		for(var index1 = 0;index1 < arrValueTextModel1.length; index1++)
		{
			var found = false;
			var value1 = arrValueTextModel1[index1];
			for(var index2 = 0;index2 < arrValueTextModel2.length; index2++)
			{
				var value2 = arrValueTextModel2[index2];
				if (value1.getText() == value2.getText() && value1.getValue() ==value2.getValue())
				{
					found = true;
					break;
				}
			}
			if (!found)
			{
				return false;
			}
		}
		return true;
	}
	this.protectedMethod = 
	{
		"fireSelectedValueChanged": fireSelectedValueChanged,
		"inputNextRequiredParamCallback":inputNextRequiredParamCallback,
		"fireCtrlSelectedChanged":fireCtrlSelectedChanged,
		"compareArrValueTextModel":compareArrValueTextModel,
		"createUiWithLabel": createUiWithLabel,
		"createUiWithLabelAndCtrl": createUiWithLabelAndCtrl,
		"createUiWithFieldset": createUiWithFieldset,
		"createUiWithLabel2": createUiWithLabel2,
		"createTopUiWithLabel":createTopUiWithLabel,
		"createTopUiWithCtrl":createTopUiWithCtrl,
		"addCtrlDisableClass":addCtrlDisableClass
	}
}
