//扩展报表轻应用过滤器数据模型
//Copyright (c) 2015 金蝶软件(中国)有限公司
//

/**
 * 值+显示值的数据对象
 */
function KEXTValueTextModel()
{
	var _strValue;
	var _strText;
	
	/** 值 */
	this.setValue = function(strValue)
	{
		_strValue = strValue;
	}
	this.getValue = function()
	{
		return _strValue;
	}
	
	/** 显示值 */
	this.setText = function(strText)
	{
		_strText = strText;
	}
	this.getText = function()
	{
		return _strText;
	}
	
	/**
	 * 转成Json格式的对象
	 */
	this.toJsonObject = function()
	{
		return {"value":_strValue, "text":_strText};
	}
	
	/**
	 * 从Json格式的对象取属性给当前实例
	 */
	this.fromJsonObject = function(oJson)
	{
		_strValue = oJson["value"];
		_strText = oJson["text"];
	}
}

/**
 * 记录参数值的对象
 */
function KEXTParamsValues()
{
	var _mapParams = {};
	var _bSaveAsScheme = true;
	
	/**
	 * 添加一个参数的一个值 
	 */
	this.addValue = function(sParamName, oValueTextModel)
	{
		var arrValues = _mapParams[sParamName];
		if(!arrValues)
		{
			arrValues = [];
			_mapParams[sParamName] = arrValues;
		}
		arrValues.push(oValueTextModel);
	}
	
	/**
	 * 获取一个参数的值，ValueTextModel的数组 
	 */
	this.getValues = function(sParamName)
	{
		return _mapParams[sParamName];
	}
	
	/**
	 * （适用于组织合到过滤的场景） 
	 */
	this.disjoinParam = function(sParamName)
	{
		var arrValues = _mapParams[sParamName];
		delete _mapParams[sParamName];
		return arrValues;
	}
	
	/**
	 * 生成用于报表执行的JSON字符串，格式如下： 
	 * [{"paramName":"p1", "paramValues":["v1","v2",...]},
	 * {"paramName":"p1_text", "paramValues":["值1","值2",...]},...];
	 */
	this.toJsonStringForExecute = function()
	{
		var arrJson = [];
		for(var sParamName in _mapParams)
		{
			var arrValues = [];
			var arrTexts = [];
			var oOneParam = {"paramName": sParamName, "paramValues": arrValues};
			var oOneParamForText = {"paramName": sParamName + "_text", "paramValues": arrTexts};
			arrJson.push(oOneParam);
			arrJson.push(oOneParamForText);
			var arrVTM = _mapParams[sParamName];
			if(arrVTM.length == 1 && arrVTM[0].getValue() == null)
			{
				continue;
			}
			for(var i = 0; i < arrVTM.length; i++)
			{
				var oVTM = arrVTM[i];
				arrValues.push(oVTM.getValue());
				arrTexts.push(oVTM.getText());
			}
		}
		return JSON.stringify(arrJson);
	}
	
	/**
	 * 生成用于持久化的JSON字符串，格式如下： 
	 * [{"name":"p1", "values":[{"value":"v1","text":"值1"},{"value":"v2","text":"值2"},...]},...];
	 */
	this.toJsonStringForPersistence = function()
	{
		if(_bSaveAsScheme)
		{
			var arrAll = [];
			for(var sParamName in _mapParams)
			{
				var arrValues = [];
				var oOneParam = {"name": sParamName, "values": arrValues};
				arrAll.push(oOneParam);
				var arrVTM = _mapParams[sParamName];
				for(var i = 0; i < arrVTM.length; i++)
				{
					var oVTM = arrVTM[i];
					arrValues.push(oVTM.toJsonObject());
				}
			}
			return JSON.stringify(arrAll);
		}
		else
		{
			return "NO_SCHEME";
		}
	}
	
	/**
	 * 从持久化的JSON字符串解析回当前实例，toJsonStringForPersistence()的逆
	 */
	this.fromPersistenceJsonString = function(sJson)
	{
		if(sJson == "NO_SCHEME")
		{
			_bSaveAsScheme = false;
		}
		else
		{
			_bSaveAsScheme = true;
			var arrAll = JSON.parse(sJson);
			this.fromPersistenceJsonObject(arrAll);
		}
	}
	
	/**
	 * 从用于持久化的JSON对象解析回当前实例
	 */
	this.fromPersistenceJsonObject = function(arrJson)
	{
		for(var i = 0; i < arrJson.length; i++)
		{
			var oOneParam = arrJson[i];
			var sName = oOneParam["name"];
			var arrValues = oOneParam["values"];
			for(var j = 0; j < arrValues.length; j++)
			{
				var oOneValue = arrValues[j];
				var oVTM = new KEXTValueTextModel();
				oVTM.fromJsonObject(oOneValue);
				this.addValue(sName, oVTM);
			}
		}
	}
	
	this.setSaveAsScheme = function(bSaveAsScheme)
	{
		_bSaveAsScheme = bSaveAsScheme;
	}
	this.isSaveAsScheme = function()
	{
		return _bSaveAsScheme;
	}
}


/**
 * 报表（一个）参数的数据模型
 */
function KEXTReportParamDescription()
{
	var _strName;//名称
	var _strText;//别名（显示名称）
	var _bolRequired;//必填
	var _strDataType;//数据类型
	var _strCtrlType;//控件类型
	var _bolMultiSelectable;//允许多选（非通用）
	var _bolHide;//隐藏
	var _bolReadOnly;//只读
	
	var _objSuppliedValue;//轻量的备选数据，由控件类型决定数据对象，C/S端约定相同的规则
	var _arrDefaultValues;//缺省值。注意，JS客户端统一为ValueTextModel的数组！
	
	var _objSuppliedValueDescription;//备选数据的描述，用于延迟取数（类似F7虚模式）

	var _nPercentage;//顶部过滤器中，占比
	
	var _maxRestrictNumber;
	
	/** 名称 */
	this.setMaxRestrictNumber = function(maxRestrictNumber)
	{
		if(maxRestrictNumber== "null")
		{
			_maxRestrictNumber = "";
		}
		else
		{
			_maxRestrictNumber = maxRestrictNumber;
		}
	}
	this.getMaxRestrictNumber = function()
	{
		return _maxRestrictNumber;
	}
	
	/** 名称 */
	this.setName = function(strName)
	{
		_strName = strName;
	}
	this.getName = function()
	{
		return _strName;
	}
	
	/** 别名（显示名称） */
	this.setText = function(strText)
	{
		_strText = strText;
	}
	this.getText = function()
	{
		return _strText;
	}
	
	/** 非空显示名称 */
	this.getCaption = function()
	{
		return (_strText ? _strText : _strName);
	}
	
	/** 必填 */
	this.setRequired = function(bolRequired)
	{
		_bolRequired = bolRequired;
	}
	this.isRequired = function()
	{
		return _bolRequired;
	}
	
	/** 数据类型 */
	this.setDataType = function(strDataType)
	{
		_strDataType = (strDataType ? strDataType.toLowerCase() : null);
	}
	this.getDataType = function()
	{
		return _strDataType;
	}
	
	/** 控件类型 */
	this.setCtrlType = function(strCtrlType)
	{
		_strCtrlType = (strCtrlType ? strCtrlType.toLowerCase() : null);;
	}
	this.getCtrlType = function()
	{
		return _strCtrlType;
	}
	
	/** 允许多选（非通用） */
	this.setMultiSelectable = function(bolMultiSelectable)
	{
		_bolMultiSelectable = bolMultiSelectable;
	}
	this.isMultiSelectable = function()
	{
		return _bolMultiSelectable;
	}
	
	/** 隐藏 */
	this.setHide = function(bolHide)
	{
		_bolHide = bolHide;
	}
	this.isHide = function()
	{
		return _bolHide;
	}
	
	this.setReadOnly = function(bolReadOnly)
	{
		_bolReadOnly = bolReadOnly;
	}
	this.isReadOnly = function()
	{
		return _bolReadOnly;
	}
	
	/** 轻量的备选数据 */
	this.setSuppliedValue = function(objSuppliedValue)
	{
		_objSuppliedValue = objSuppliedValue;
	}
	this.getSuppliedValue = function()
	{
		return _objSuppliedValue;
	}
	
	/** 缺省值，为ValueTextModel的数组 */
	this.setDefaultValue = function(arrDefaultValues)
	{
		_arrDefaultValues = arrDefaultValues;
	}
	this.getDefaultValue = function()
	{
		return _arrDefaultValues;
	}
	
	/** 备选数据的描述，用于延迟取数 */
	this.setSuppliedValueDescription = function(objSuppliedValueDescription)
	{
		_objSuppliedValueDescription = objSuppliedValueDescription;
	}
	this.getSuppliedValueDescription = function()
	{
		return _objSuppliedValueDescription;
	}
	
	/**顶部过滤器中，占比 */
	this.setPercentage = function(nPercentage)
	{
		_nPercentage = nPercentage;
	}
	this.getPercentage = function()
	{
		return _nPercentage;
	}
}

/**
 * 描述参数间依赖关系的数据模型 
 */
function KEXTParamsAssociateModel()
{
	var _mapEffects = {};//正向影响
	var _mapAffecteds = {};//反向被影响
	
	/** 添加一个sSrcParam影响sAffectedParam的关系 */
	this.addOneAffectAnother = function(sSrcParam, sAffectedParam)
	{
		put(_mapEffects, sSrcParam, sAffectedParam);
		put(_mapAffecteds, sAffectedParam, sSrcParam);
	}
	
	/** 指定参数是否会影响其它 */
	this.isOneAffectOthers = function(sParam)
	{
		return (_mapEffects[sParam] ? true : false);
	}
	
	/** 前者是否影响后者 */
	this.isOneAffectAnother = function(sParam, sAnother)
	{
		return check(_mapEffects, sParam, sAnother);
	}
	
	/** 前者是否受后者影响 */
	this.isOneAffectedByAnother = function(sParam, sAnother)
	{
		return check(_mapAffecteds, sParam, sAnother);
	}
	
	var put = function(mapAssociate, sP1, sP2)
	{
		var mapOne = mapAssociate[sP1];
		if(!mapOne)
		{
			mapOne = {};
			mapAssociate[sP1] = mapOne;
		}
		mapOne[sP2] = true;
	}
	
	var check = function(mapAssociate, sP1, sP2)
	{
		var mapOne = mapAssociate[sP1];
		if(mapOne)
		{
			return (mapOne[sP2] ? true : false);
		}
		return false;
	}
}

/**
 * 数值范围（数字微调、滑块等）的数据模型
 */
function KEXTNumberStepperSuppliedValue()
{
	var _numMin;
	var _numMax;
	var _numStep;
	
	/** 取值区间下限 */
	this.setMin = function(numMin)
	{
		_numMin = numMin;
	}
	this.getMin = function()
	{
		return _numMin;
	}
	
	/** 取值区间上限 */
	this.setMax = function(numMax)
	{
		_numMax = numMax;
	}
	this.getMax = function()
	{
		return _numMax;
	}
	
	/** 步长 */
	this.setStep = function(numStep)
	{
		_numStep = numStep;
	}
	this.getStep = function()
	{
		return _numStep;
	}
}

/**
 * 延迟取数的列表的备选数据描述
 */
function KEXTListDelaySuppliedValueDescription()
{
	var _strValueFieldName;
	var _strTextFieldName;
	var _strDatasetPersistenceModel;
	
	/** 取值字段 */
	this.setValueField = function(strValueFieldName)
	{
		_strValueFieldName = strValueFieldName;
	}
	this.getValueField = function()
	{
		return _strValueFieldName;
	}
	
	/** 显示字段 */
	this.setTextField = function(strTextFieldName)
	{
		_strTextFieldName = strTextFieldName;
	}
	this.getTextField = function()
	{
		return _strTextFieldName;
	}
	
	/** 数据集模型的持久化，客户端不解析，只管拿到后再丢回服务端执行 */
	this.setDatasetPersistenceModel = function(strDatasetPersistenceModel)
	{
		_strDatasetPersistenceModel = strDatasetPersistenceModel;
	}
	this.getDatasetPersistenceModel = function()
	{
		return _strDatasetPersistenceModel;
	}
}

/**
 * 代码级的延迟取数备选数据描述，适用于内部场景
 */
function KEXTCodeDelaySuppliedValueDescription()
{
	KEXTListDelaySuppliedValueDescription.call(this);
	
	var _this = this;
	var _funSuppliedValueGetter;
	
	(function(){
		_this.setValueField("value");
		_this.setTextField("text");
		_this.setDatasetPersistenceModel("");
	})();
	
	this.setFunction = function(funGetter)
	{
		_funSuppliedValueGetter = funGetter;
	}
	this.getFunction = function()
	{
		return _funSuppliedValueGetter;
	}
}
