//扩展报表轻应用过滤器控件实现
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖： 
//jQuery 2.1.0 (http://jquery.com)
//jQueryMobile 1.4.2 (http://jquerymobile.com)
//
/**
 * 输入框
 */
function KEXTFilterTextField(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _jqCtrl = $("<input type='text' class='kdlight-filter-text-input'/>");

	this.createUI = function(jqParent)
	{
		this.protectedMethod.createUiWithLabel(jqParent, _jqCtrl);
		_jqCtrl.css("width",jqParent.width()-20-18+"px");
		this.protectedMethod.addCtrlDisableClass(_jqCtrl);
	}
	
	this.setSuppliedValue = function(data)
	{
		//无
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		if (_this.protectedMethod.compareArrValueTextModel(_this.getSelectedValue(),arrValueTextModel))
		{
			return;
		}
		var strValue;
		if(arrValueTextModel && arrValueTextModel.length > 0 && arrValueTextModel[0].getValue())
		{
			strValue = arrValueTextModel[0].getValue();
		}
		_jqCtrl.prop("value", strValue);
		_this.protectedMethod.fireSelectedValueChanged();
	}
	
	this.getSelectedValue = function()
	{
		var strValue = _jqCtrl.prop("value");
		var oValueTextModel = new KEXTValueTextModel();
		oValueTextModel.setValue(strValue);
		oValueTextModel.setText(strValue);
		return [oValueTextModel];
	}
}
//列表多选
function KEXTMultiSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var NULL_VALUE = "com.kingdee.bos.ext.light.filter.NullValue";
	
	var _this = this;
	var _jqParent;
	
	var _jqValueContent = $("<div>");
	var _jqSelectCtrl = $("<div >");
	var _jqSelectCtrlContent = $("<div>");
	
	var _jqSelectCtrlBar = $("<div class='themeABar'>");
	var _jqConfirmButton = $("<div class='themeABtn kdlight-btn-ok'>确定</div>");
	var _funExtendEventCallBack;
	var _oDelaySuppliedValueModel;
	var _funDelaySuppliedValueGetter;
	
	(function ()
	{
		_jqSelectCtrl.append(_jqSelectCtrlContent);
		_jqSelectCtrlBar.append(_jqConfirmButton);
		_jqSelectCtrl.append(_jqSelectCtrlBar);
		_jqConfirmButton.on('click',function(event){
			var arrValueTextModel = [];
			var _arrJqCtrls = _jqSelectCtrlContent.children();
			for(var i=0;i<_arrJqCtrls.length;i++)
			{
				var el = $(_arrJqCtrls[i]);
				if (el.hasClass("kdlight-checkbox-checked"))
				{
					var vt = new KEXTValueTextModel();
					vt.setValue(el.attr("value"));
					vt.setText(el.text());
					arrValueTextModel.push(vt);
				}
			}
			confirmSelectItem(arrValueTextModel);
		});
	})();
	
	this.createUI = function(jqParent)
	{
		var isDefaultExtend = false;
		_jqParent = jqParent;
		_jqConfirmButton.css({
			"width": "100px",
			"left": (_jqParent.width()-100)/2+"px",
			"position": "relative"
		});
		_funExtendEventCallBack = this.protectedMethod.createUiWithLabelAndCtrl(jqParent, _jqValueContent, _jqSelectCtrl,isDefaultExtend,funExtendEventHandler);
		funExtendEventHandler(isDefaultExtend);
	}
	
	//切换显示结果和选择控件
	var funExtendEventHandler = function (isExtend)
	{
		if (isExtend)
		{
			_jqValueContent.hide();
			_jqSelectCtrl.show();
		}
		else
		{	
			_jqSelectCtrl.hide();		
			_jqValueContent.show();
			_this.setSelectedValue(_this.getSelectedValue());
		}
	}
	
	//确定选择项
	var confirmSelectItem = function (arrValueTextModel)
	{
		_this.setSelectedValue(arrValueTextModel);
		funExtendEventHandler(false);
		_funExtendEventCallBack(false);
	}
	
	var funSelectItemClickListener = function (event)
	{
		var el = $(event.target);
		if (el.hasClass("kdlight-checkbox-checked"))
		{
			el.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
		}
		else
		{
			el.removeClass("kdlight-checkbox-unchecked").addClass("kdlight-checkbox-checked");
		}
	}
	
	//设置备选值
	this.setSuppliedValue = function(arrValueTextModel)
	{
		_jqSelectCtrlContent.children().remove();
		if(arrValueTextModel)
		{
			var jqOp;
			var sPrefix = "ctrl_" + this.getParamDescription().getName() + "_" + new Date().getTime() +  "_";
			for(var i = 0; i < arrValueTextModel.length; i++)
			{
				
				var oValueTextModel = arrValueTextModel[i];
				var sValue = oValueTextModel.getValue();
				var sText = oValueTextModel.getText();
				
				var sId = sPrefix + i;	
				jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable kdlight-checkbox-unchecked'/>");
				jqOp.attr("id", sId);
				jqOp.attr("value", sValue);
				jqOp.text(sText ? sText : " ");
				jqOp.on("click",funSelectItemClickListener);
				_jqSelectCtrlContent.append(jqOp);
			}
			
			if(jqOp)
			{
				jqOp.removeClass("kdlight-filter-Supplied-value");
				jqOp.addClass("kdlight-filter-Supplied-value-last");
			}
		}	
	}
	
	//设置选中结果
	this.setSelectedValue = function(arrValueTextModel)
	{
		var arrSelectValueTextModelBefore = _this.getSelectedValue();
		arrValueTextModel = arrValueTextModel ? arrValueTextModel : [];
		var arrSelectValueTextModelAfter = [];
		var _arrJqCtrls = _jqSelectCtrlContent.children();
		_arrJqCtrls.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
		for (var i=0;i<arrValueTextModel.length;i++)
		{
			var oValueTextModel = arrValueTextModel[i];
			for (var index=0;index<_arrJqCtrls.length;index++)
			{
				var jqInput =$(_arrJqCtrls[index]);
				var bSelected = jqInput.hasClass("kdlight-checkbox-checked");
				if(oValueTextModel && jqInput.attr("value") == oValueTextModel.getValue() && jqInput.text() == oValueTextModel.getText())
				{
					if (!bSelected)
					{
						bSelected = true;
						arrSelectValueTextModelAfter.push(oValueTextModel);
					}
				}
				if (bSelected)
				{
					jqInput.removeClass("kdlight-checkbox-unchecked");
					jqInput.addClass("kdlight-checkbox-checked");
				}
			}
		}
		
		_jqValueContent.children().remove();
		if (arrSelectValueTextModelAfter.length > 0)
		{
			var valueModel;
			for (var i=0;i<arrSelectValueTextModelAfter.length;i++)
			{
				var oValueTextModel = arrSelectValueTextModelAfter[i];
				valueModel = $("<div class='kdlight-filter-Supplied-value'>");
				valueModel.attr('value',oValueTextModel.getValue());
				valueModel.text(oValueTextModel.getText());
				_jqValueContent.append(valueModel);
			}
			if (valueModel)
			{
				valueModel.removeClass("kdlight-filter-Supplied-value");
				valueModel.addClass("kdlight-filter-Supplied-value-last");
			}
		}
		else
		{
			var valueModel = $("<div class='kdlight-filter-Supplied-value-last'>");
			valueModel.attr('value',NULL_VALUE);
			valueModel.text('(空)');
			_jqValueContent.append(valueModel);
		}
		
		if (_this.protectedMethod.compareArrValueTextModel(arrSelectValueTextModelBefore,arrSelectValueTextModelAfter))
		{
			return;
		}
		_this.protectedMethod.fireSelectedValueChanged();
	}
	
	//获取选中结果
	this.getSelectedValue = function()
	{
		var arrValueTextModel = [];
		var result = _jqValueContent.children();
		if (result)
		{
			for (var i=0;i<result.length;i++)
			{
				var el = $(result[i]);
				var vt = new KEXTValueTextModel();
				var value = el.attr("value");
				if (value != NULL_VALUE)
				{
					vt.setValue(value);
					vt.setText(el.text());
					arrValueTextModel.push(vt);
				}
			}
		}
		if (arrValueTextModel && arrValueTextModel.length>0)
		{
			return arrValueTextModel;
		}
		return [new KEXTValueTextModel()];
	}
	
	this.setSuppliedValueDescriptionAndGetter = function(oDelaySuppliedValueModel, funGetter)
	{
		_oDelaySuppliedValueModel = oDelaySuppliedValueModel;
		_funDelaySuppliedValueGetter = funGetter;
	}
	
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		_funDelaySuppliedValueGetter(_oDelaySuppliedValueModel.getDatasetPersistenceModel(), 
			function(oRowset)
			{
				var arrVtm = [];
				KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, 
					function(iIndex, sValue, sText)
					{
						var oVtm = new KEXTValueTextModel();
						oVtm.setValue(sValue);
						oVtm.setText(sText);
						arrVtm.push(oVtm);
					});
				_this.setSuppliedValue(arrVtm);
				_this.setSelectedValue(_this.getSelectedValue());
				if(funCallback)
				{
					funCallback(oCallbackParam);
				}
			});
	}
}

//列表单选
function KEXTSingleSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var NULL_VALUE = "com.kingdee.bos.ext.light.filter.NullValue";
	
	var _this = this;
	var _jqParent;
	var _jqValueContent =  $("<div class='kdlight-filter-single-value'>");
	var _jqSelectCtrl = $("<div >");
	
	var _funExtendEventCallBack;
	var _oDelaySuppliedValueModel;
	var _funDelaySuppliedValueGetter;
	
	this.createUI = function(jqParent)
	{
		var isDefaultExtend = false;
		_jqParent = jqParent;
		_funExtendEventCallBack = this.protectedMethod.createUiWithLabelAndCtrl(jqParent, _jqValueContent, _jqSelectCtrl,isDefaultExtend,funExtendEventHandler);
		funExtendEventHandler(isDefaultExtend);
	}
	
	//切换显示结果和选择控件
	var funExtendEventHandler = function (isExtend)
	{
		if (isExtend)
		{
			_jqValueContent.hide();
			_jqSelectCtrl.children(".kdlight-filter-activeable").removeClass("kdlight-filter-activeable").addClass("kdlight-filter-activeable");
			_jqSelectCtrl.show();
		}
		else
		{	
			_jqSelectCtrl.hide();		
			_jqValueContent.show();
		}
	}
	
	//选中某一项
	var funSelectItemClickListener = function(e)
	{
		var el = $(e.target);
		_jqSelectCtrl.find(".kdlight-filter-Supplied-value.kdlight-radio-checked").removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
		el.removeClass("kdlight-radio-unchecked");
		el.addClass("kdlight-radio-checked");
		var vt = new KEXTValueTextModel();
		if(el.attr("value") == NULL_VALUE)
		{
			vt.setValue(NULL_VALUE);
			vt.setText("(空)");
		}
		else
		{
			vt.setValue(el.attr("value"));
			vt.setText(el.text());
		}
		confirmSelectItem([vt]);
	}
	
	//确定选择项
	var confirmSelectItem = function (arrValueTextModel)
	{
		_this.setSelectedValue(arrValueTextModel);
		funExtendEventHandler(false);
		_funExtendEventCallBack(false);
	}
	
	//设置备选值
	this.setSuppliedValue = function(arrValueTextModel)
	{
		_jqSelectCtrl.children().remove();
		var hasNull = false;
		var jqOp;
		if(_this.getParamDescription().getCtrlType() == "combobox"  && !_this.getParamDescription().isRequired())
		{
			hasNull = true;
			jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable kdlight-radio-unchecked'/>");
			jqOp.attr("value", NULL_VALUE);
			jqOp.text("(空)");
			jqOp.on("click",funSelectItemClickListener);
			_jqSelectCtrl.append(jqOp);
		}
		
		if(arrValueTextModel)
		{
			var sPrefix = "ctrl_" + this.getParamDescription().getName() + "_" + new Date().getTime() +  "_";
			for(var i = 0; i < arrValueTextModel.length; i++)
			{
				var oValueTextModel = arrValueTextModel[i];				
				jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable kdlight-radio-unchecked'/>");
				jqOp.attr("value", oValueTextModel.getValue());
				jqOp.text(oValueTextModel.getText());
				jqOp.on("click",funSelectItemClickListener);
				_jqSelectCtrl.append(jqOp);
			}
		}
		
		if(jqOp)
		{
			jqOp.removeClass("kdlight-filter-Supplied-value");
			jqOp.addClass("kdlight-filter-Supplied-value-last");
		}
	}
	
	//设置选中结果
	this.setSelectedValue = function(arrValueTextModel)
	{
		var arrSelectValueTextModelBefore = _this.getSelectedValue();
		var oValueTextModel = (arrValueTextModel && arrValueTextModel.length>0)?arrValueTextModel[0]:null;
		if (oValueTextModel && oValueTextModel.getValue() && oValueTextModel.getText())
		{
			_jqValueContent.attr('value',oValueTextModel.getValue());
			_jqValueContent.text(oValueTextModel.getText());
		}
		else
		{
			_jqValueContent.attr('value',NULL_VALUE);
			_jqValueContent.text("(空)");
			oValueTextModel = null;
		}
		var elChildren = _jqSelectCtrl.children();
		elChildren.removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
		for (var i=0;i<elChildren.length;i++)
		{
			var child = $(elChildren[i]);
			if ((!oValueTextModel && (child.attr('value') == NULL_VALUE)) || (oValueTextModel && child.attr('value') == oValueTextModel.getValue() && child.text() == oValueTextModel.getText()))
			{
				child.removeClass("kdlight-radio-unchecked");
				child.addClass("kdlight-radio-checked");
				break;
			}
		}
		var arrSelectValueTextModelAfter = _this.getSelectedValue();
		if (_this.protectedMethod.compareArrValueTextModel(arrSelectValueTextModelBefore,arrSelectValueTextModelAfter))
		{
			return;
		}
		_this.protectedMethod.fireSelectedValueChanged();
	}
	
	//获取选中结果
	this.getSelectedValue = function()
	{
		var arrValueTextModel = [];
		var el = $(_jqValueContent);
		var vt = new KEXTValueTextModel();
		if(el.attr("value") !== NULL_VALUE)
		{
			vt.setValue(el.attr("value"));
			vt.setText(el.text());
		}		
		arrValueTextModel.push(vt);	
		return arrValueTextModel;
	}
	
	this.setSuppliedValueDescriptionAndGetter = function(oDelaySuppliedValueModel, funGetter)
	{
		_oDelaySuppliedValueModel = oDelaySuppliedValueModel;
		_funDelaySuppliedValueGetter = funGetter;
	}
	
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		_this.setSelectedValue([]);
		_funDelaySuppliedValueGetter(_oDelaySuppliedValueModel.getDatasetPersistenceModel(), 
			function(oRowset)
			{
				var arrVtm = [];
				KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, 
					function(iIndex, sValue, sText)
					{
						var oVtm = new KEXTValueTextModel();
						oVtm.setValue(sValue);
						oVtm.setText(sText);
						arrVtm.push(oVtm);
					});
				_this.setSuppliedValue(arrVtm);
				if(funCallback)
				{
					funCallback(oCallbackParam);
				}
			});
	}
}

/**
 * 另出界面的选择器，相当于F7
 */
function KEXTFilterForwardSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var NULL_VALUE = "com.kingdee.bos.ext.light.filter.NullValue";
	var _this = this;
	var _jqValueContent =  $("<div>");
	var _jqSelectCtrl = $("<div >");
	
	var _arrSelected;
	
	var _oDelaySuppliedValueModel;
	var _funDelaySuppliedValueGetter;
	
	var _jqForwardUi;
	var _funForwardCallback;
	var _funBackwardCallback;
	var _funExtendEventCallBack;
	var _jqSelectedCount;
	var _jqSelectAll;
	var _jqUiForMulti;
	var _jqFilterInput;
	this.createUI = function(jqParent)
	{
		_funExtendEventCallBack = this.protectedMethod.createUiWithLabelAndCtrl(jqParent, _jqValueContent, _jqSelectCtrl, false,doCtrlClickForward);
		getDelaySuppliedValue(
				function(jqForwardUi)
				{
					_jqForwardUi = jqForwardUi;
					_this.setSelectedValue(_this.getSelectedValue());
				});
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		var arrSelectedValueTextModel = [];
		if (_jqForwardUi)
		{
			var isMultiSelectable = _this.getParamDescription().isMultiSelectable();
			var arrSupplid = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value");
			if (isMultiSelectable)
			{
				arrSupplid.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
			}
			else
			{
				arrSupplid.removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
			}
			var isSelected;
			if (arrValueTextModel && arrValueTextModel.length>0)
			{
				for (var index2 = 0;index2<arrValueTextModel.length;index2++)
				{
					var ValueTextModel = arrValueTextModel[index2];
					var sValue2 = ValueTextModel.getValue();
					var sText2 = ValueTextModel.getText();
					for (var index = 0 ,size = arrSupplid.length;index<size;index++)
					{
						var supplid = $(arrSupplid[index]);
						isSelected = supplid.hasClass("kdlight-radio-checked") || supplid.hasClass("kdlight-checkbox-checked");
						var sValue = supplid.attr("value");
						var sText = supplid.text();

						if ((sValue==sValue2 && sText==sText2))
						{
							if (!isSelected)
							{
								arrSelectedValueTextModel.push(ValueTextModel);
								isSelected = true;
							}
						}
						else if ((sValue == NULL_VALUE && !sValue2 && !sText2))
						{
							isSelected = true;
						}
						if (isSelected)
						{
							if (isMultiSelectable)
							{
								supplid.removeClass("kdlight-checkbox-unchecked").addClass("kdlight-checkbox-checked");
							}
							else
							{
								supplid.removeClass("kdlight-radio-unchecked").addClass("kdlight-radio-checked");
								break;
							}	
						}
					}
				}
			}
			else
			{
				for (var index = 0 ,size = arrSupplid.length;index<size;index++)
				{
					var supplid = $(arrSupplid[index]);
					var sValue = supplid.attr("value");
					var sText = supplid.text();
					if(sValue == NULL_VALUE)
					{
						supplid.removeClass("kdlight-radio-unchecked").addClass("kdlight-radio-checked");
						break;
					}
				}
			}
		}
		else
		{
			//设置默认值时，无法获取当前备选值
			arrValueTextModel = arrValueTextModel?arrValueTextModel:[];
			arrSelectedValueTextModel = arrValueTextModel;
		}
		
		_jqValueContent.children().remove();
		var valueModel;
		if(arrSelectedValueTextModel && arrSelectedValueTextModel.length > 0)
		{
			var moreThen10 = false;
			for (var i=0;i<arrSelectedValueTextModel.length;i++)
			{
				var oValueTextModel = arrSelectedValueTextModel[i];
				valueModel = $("<div class='kdlight-filter-Supplied-value'>");
				valueModel.attr('value',oValueTextModel.getValue());
				valueModel.text(oValueTextModel.getText());
				_jqValueContent.append(valueModel);
				if (i >= 9)
				{
					moreThen10 = true;
					break;
				}
			}
			if (moreThen10)
			{
				valueModel = $("<div class='kdlight-filter-Supplied-value'>");
				valueModel.text("已选("+arrSelectedValueTextModel.length+")项");
				valueModel.css({
					color:'',
					"text-align":"center"
				});
				_jqValueContent.append(valueModel);
			}
			
			if (valueModel)
			{
				valueModel.removeClass("kdlight-filter-Supplied-value");
				valueModel.addClass("kdlight-filter-Supplied-value-last");
			}
		}
		else
		{
			valueModel = $("<div class='kdlight-filter-Supplied-value-last'>");
			valueModel.attr('value',NULL_VALUE);
			valueModel.text('(空)');
			_jqValueContent.append(valueModel);
		}
		
		if (_this.protectedMethod.compareArrValueTextModel(_arrSelected,arrSelectedValueTextModel))
		{
			return;
		}
		_arrSelected = arrSelectedValueTextModel;
		_this.protectedMethod.fireSelectedValueChanged();
	}
	
	this.getSelectedValue = function()
	{
		if (_arrSelected && _arrSelected.length>0)
		{
			return _arrSelected;
		}
		else
		{
			return [new KEXTValueTextModel()];
		}
	}
	
	this.setSuppliedValue = function(arrValueTextModel)
	{
		//nothing
	}

	this.setSuppliedValueDescriptionAndGetter = function(oDelaySuppliedValueModel, funGetter)
	{
		_oDelaySuppliedValueModel = oDelaySuppliedValueModel;
		_funDelaySuppliedValueGetter = funGetter;
	}
	
	this.setUiChangeCallback = function(funForwardCallback, funBackwardCallback)
	{
		_funForwardCallback = funForwardCallback;
		_funBackwardCallback = funBackwardCallback;
	}
	
	this.backward = function()
	{
		$(_jqFilterInput).val("");
		searchItemListener();
		_funExtendEventCallBack(false);
		_bIsCtrlClick = false;
	}
	
	this.confirmed = function(funPromptRequired)
	{
		// 多选时取选中值
		if(_this.getParamDescription().isMultiSelectable()) 
		{
			var arrSelected = [];
			var arrInputs = $(_jqUiForMulti).find(".kdlight-checkbox-checked");
			for (var i = 0; i < arrInputs.length; i++) 
			{
				var jqOp = $(arrInputs[i]);
				var oValueTextModel = new KEXTValueTextModel();
				oValueTextModel.setText(jqOp.text());
				oValueTextModel.setValue(jqOp.attr("value"));
				arrSelected.push(oValueTextModel);
			}
			
			if(arrSelected.length == 0)
			{
				if(_this.getParamDescription().isRequired())
				{
					funPromptRequired("“" + _this.getParamDescription().getCaption()+"”是必填项。");
					return false;
				}
			}
			_this.setSelectedValue(arrSelected);
			_funExtendEventCallBack(false);
		}
		$(_jqFilterInput).val("");
		searchItemListener();
		_bIsCtrlClick = false;
		return true;
	}
	
	this.resetSuppliedValue = function(funCallback, oCallbackParam)
	{
		getDelaySuppliedValue(
				function(jqForwardUi)
				{
					_jqForwardUi = jqForwardUi;
					_this.setSelectedValue(_this.getSelectedValue());
					if (funCallback)
					{
						funCallback(oCallbackParam);
					}
				});
	}
	
	//funCallback like func(jqUi)
	var getDelaySuppliedValue = function(funCallback)
	{
		_funDelaySuppliedValueGetter(_oDelaySuppliedValueModel.getDatasetPersistenceModel(), 
			function(oRowset)
			{
				var jqForwardUi;
				if(_this.getParamDescription().isMultiSelectable()) 
				{
					jqForwardUi = createForwardUiForMultiSelectable(oRowset);
				}
				else
				{
					jqForwardUi = createForwardUIForSingleSelectable(oRowset);
				}
				funCallback(jqForwardUi);
			});
	}
	
	var createForwardUIForSingleSelectable = function(oRowset)
	{
		//选项
		var jqUL = $("<div>");
		jqUL.css("margin-top", "55px");
		var funCallback = function(iIndex, sValue, sText)
			{
				var jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable'/>");
				jqOp.attr("value", sValue);
				jqOp.text(sText);
				var bSelected = false;
				if (_arrSelected && _arrSelected.length>0)
				{
					for (var index = 0 ,size = _arrSelected.length;index < size; index++)
					{
						var selected = _arrSelected[index];
						if (sText == selected.getText() && sValue == selected.getValue())
						{
							bSelected = true;
							break;
						}
					}
				}
				else if (sValue == NULL_VALUE && '(空)' == sText)
				{
					bSelected = true;
				}
				
				if(bSelected)
				{
					jqOp.addClass("kdlight-radio-checked");
				}
				else
				{
					jqOp.addClass("kdlight-radio-unchecked");
				}
				jqUL.append(jqOp);
			}
		if(!_this.getParamDescription().isRequired())
		{
			funCallback(0, NULL_VALUE, "(空)");
		}
		KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset,funCallback);
		_jqUiForMulti = jqUL;
		
		//过滤输入
		var jqDiv = $("<div>");
		jqDiv.css("background", "#ffffff");
		jqDiv.css("border-bottom", "1px solid #dadada");
		jqDiv.css("position","absolute");
		jqDiv.css("top","0px");
		jqDiv.css("left","0px");
		jqDiv.css("right","0px");
		jqDiv.css("z-index",4);
	
		var jqSearchDiv = $("<div class='kdlight-filter-search'>");		
		var jqFilterInputC = $("<div>");
		jqFilterInputC.css({
			"float":"left",
			"width":"232px"
		});
		_jqFilterInput = $("<input type='text' class='kdlight-filter-search-input'/>");
		_jqFilterInput.on("input",searchItemListener);
		_jqFilterInput.css("width","232px");
		jqSearchDiv.append(jqFilterInputC.append(_jqFilterInput));
		jqSearchDiv.append("<label class='search-icon'>");
		jqSearchDiv.css({
			"float":"left"
		});
		jqDiv.append(jqSearchDiv);
		
		var jqUIDiv = $("<div>");
		jqUIDiv.css("background", "#ffffff");
		jqUIDiv.append(jqDiv);
		jqUIDiv.append(jqUL);
		return jqUIDiv;
	}
	
	var createForwardUiForMultiSelectable = function(oRowset)
	{
		var jqUL = $("<div>");
		jqUL.css("margin-top", "101px");

		var sIdPrefix = "ctrl_" + _this.getParamDescription().getName() + "_" + new Date().getTime() + "_";
		KEXTFilterDataUtil.getDataFromRowset(_oDelaySuppliedValueModel, oRowset, 
			function(iIndex, sValue, sText)
			{
				var sId = sIdPrefix + iIndex;
				var jqOp = $("<div class='kdlight-filter-Supplied-value kdlight-filter-activeable'/>");
				jqOp.attr("id", sId);
				jqOp.attr("value", sValue);
				jqOp.text(sText);
				
				var bSelected = false;
				if (_arrSelected && _arrSelected.length>0)
				{
					for (var index = 0 ,size = _arrSelected.length;index < size; index++)
					{
						var selected = _arrSelected[index];
						if (sText == selected.getText())
						{
							bSelected = true;
							break;
						}
					}
				}
				if(bSelected)
				{
					jqOp.addClass("kdlight-checkbox-checked");
				}
				else
				{
					jqOp.addClass("kdlight-checkbox-unchecked");
				}
				
				
				jqOp.on("click",function (e){
					var el = $(e.target);
					if (el.hasClass("kdlight-checkbox-unchecked"))
					{
						if(isBeyondMaxRestrictNumber(false))
						{
							showBeyondMaxTip();
							return;
						}
						jqOp.removeClass("kdlight-checkbox-unchecked");
						jqOp.addClass("kdlight-checkbox-checked");
					}
					else
					{
						jqOp.removeClass("kdlight-checkbox-checked");
						jqOp.addClass("kdlight-checkbox-unchecked");
					}
					showCount();
				});
				jqUL.append(jqOp);
			});
		_jqUiForMulti = jqUL;
		
		
		var jqDiv = $("<div>");
		jqDiv.css("background", "#ffffff");
		jqDiv.css("position","absolute");
		jqDiv.css("top","0px");
		jqDiv.css("left","0px");
		jqDiv.css("right","0px");
		jqDiv.css("z-index",4);
	
		//过滤输入
		var jqSearchDiv = $("<div class='kdlight-filter-search'>");		
		var jqFilterInputC = $("<div>");
		jqFilterInputC.css({
			"float":"left",
			"width":"232px"
		});
		_jqFilterInput = $("<input type='text' class='kdlight-filter-search-input'/>");
		_jqFilterInput.on("input",searchItemListener);
		_jqFilterInput.css("width","232px");
		jqSearchDiv.append(jqFilterInputC.append(_jqFilterInput));
		jqSearchDiv.append("<label class='search-icon'>")
		jqDiv.append(jqSearchDiv);
		jqSearchDiv.css({
			"float":"left"
		});
		//全选
		var jqSelectDiv = $("<div>");
		jqSelectDiv.css("background", "#ffffff");
		jqSelectDiv.css("border-bottom", "1px solid #dadada");
		jqSelectDiv.css("border-top", "1px solid #dadada");
		jqSelectDiv.css("padding", "10px");
		jqSelectDiv.css("position","absolute");
		jqSelectDiv.css("top","57px");
		jqSelectDiv.css("width","270px");
		jqSelectDiv.css("height","23px");
		jqSelectDiv.css("z-index",4);
		var selectCount = 0;
		if (_arrSelected && _arrSelected.length>0)
		{
			selectCount = _arrSelected.length;
		}
		_jqSelectedCount = $("<label class='kdlight-filter-select-count'>已选择:"+selectCount+"项</lable>");
		_jqSelectAll = $("<label class='kdlight-filter-select-all kdlight-checkbox-unchecked fontWeightBold'>全选</lable>");
		_jqSelectAll.on("click",function(e){
			var el = $(e.target);
			
			if(isBeyondMaxRestrictNumber(true))
			{
				showBeyondMaxTip();
				return;
			}
			
			var arrSupplid = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value:visible");
			if  (el.hasClass("kdlight-checkbox-unchecked"))
			{
				el.removeClass("kdlight-checkbox-unchecked");
				el.addClass("kdlight-checkbox-checked");
				arrSupplid.removeClass("kdlight-checkbox-unchecked").addClass("kdlight-checkbox-checked");
			}
			else
			{
				el.removeClass("kdlight-checkbox-checked");
				el.addClass("kdlight-checkbox-unchecked");
				arrSupplid.removeClass("kdlight-checkbox-checked").addClass("kdlight-checkbox-unchecked");
			}
			showCount();
		});
		jqSelectDiv.append(_jqSelectedCount);
		jqSelectDiv.append(_jqSelectAll);
		
		var jqUIDiv = $("<div>");
		jqUIDiv.css("background", "#ffffff");
		jqUIDiv.append(jqDiv);
		jqUIDiv.append(jqSelectDiv);
		
		jqUIDiv.append(jqUL);
		return jqUIDiv;
	}
	
	var isBeyondMaxRestrictNumber = function(isSelectAll)
	{
		var iSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-checked").length;
		var iUnSelectCount = 0;
		var iMaxRestrictNumber = oReportParamDesc.getMaxRestrictNumber();
		if(isSelectAll)
		{
			iUnSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-unchecked").length;
		}
		if(iMaxRestrictNumber <= iSelectCount + iUnSelectCount)
		{
			return true;
		}
		return false;
	}
	
	var showBeyondMaxTip = function()
	{
		var maxRNumber = oReportParamDesc.getMaxRestrictNumber();
		_jqSelectedCount.text("超过限制,最多可选" + maxRNumber + "项");
	}
	
	var showCount = function()
	{
		if (_this.getParamDescription().isMultiSelectable())
		{
			var iVisibleCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value:visible").length;
			var iSelectCount = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-checkbox-checked").length;
			_jqSelectedCount.text("已选择:"+iSelectCount+"项");
			if (iVisibleCount == iSelectCount )
			{
				_jqSelectAll.removeClass("kdlight-checkbox-unchecked");
				_jqSelectAll.addClass("kdlight-checkbox-checked");
			}
			else
			{
				_jqSelectAll.removeClass("kdlight-checkbox-checked");
				_jqSelectAll.addClass("kdlight-checkbox-unchecked");
			}
		}
	}
	
	var _bIsCtrlClick = false;
	var _bIsItemClick = false;
	var i = 0;
	var doCtrlClickForward = function()
	{
		if (_bIsCtrlClick)
		{
			return;
		}
		_bIsCtrlClick = true;
		_bIsItemClick = false;
		var bCanFinish = _this.getParamDescription().isMultiSelectable();// 多选时给true
		_this.setSelectedValue(_this.getSelectedValue());
		_funForwardCallback(_this, _jqForwardUi, bCanFinish,
			function()
			{
				_jqUiForMulti.children(".kdlight-filter-activeable").removeClass("kdlight-filter-activeable").addClass("kdlight-filter-activeable");
				if (!bCanFinish)
				{
					_jqUiForMulti.children(".kdlight-filter-activeable").on("click", doItemClick);
				}
				showCount();
			});
	}
	
	var doItemClick = function(evt)
	{
		if(_bIsItemClick) 
		{
			//避免连击
			return;
		}
		_bIsItemClick = true;
		//移除点击事件，避免在转跳过程中，点击出现异常
		_jqUiForMulti.children(".kdlight-filter-activeable").off("click");
		var jqA = $(evt.target);
		if (!jqA.hasClass("kdlight-filter-Supplied-value"))
		{
			return;
		}
		$(_jqUiForMulti).find(".kdlight-filter-Supplied-value.kdlight-radio-checked").removeClass("kdlight-radio-checked").addClass("kdlight-radio-unchecked");
		jqA.removeClass("kdlight-radio-unchecked");
		jqA.addClass("kdlight-radio-checked");
		if (jqA.attr("value") && jqA.text() && jqA.attr("value") != NULL_VALUE)
		{
			var oValueTextModel = new KEXTValueTextModel();
			oValueTextModel.setText(jqA.text());
			oValueTextModel.setValue(jqA.attr("value"));
			_this.setSelectedValue([oValueTextModel]);
		}
		else
		{
			_this.setSelectedValue([]);
		}
		$(_jqFilterInput).val("");
		searchItemListener();
		_funBackwardCallback(function(){
			_bIsCtrlClick = false;
		});
	}
	
	var searchItemListener = function ()
	{
		var sText = $(_jqFilterInput).val().toLocaleLowerCase();
		var arrSupplied = $(_jqUiForMulti).find(".kdlight-filter-Supplied-value");
		var bSelectAll = true;
		for (var index = 0,size = arrSupplied.length;index<size;index++)
		{
			var supplied = $(arrSupplied[index]);
			if (sText)
			{
				if (supplied.text().toLocaleLowerCase().indexOf(sText) > -1)
				{
					supplied.show();
					if (supplied.hasClass("kdlight-checkbox-unchecked"))
					{
						bSelectAll = false;
					}
				}
				else
				{
					supplied.hide();
				}
			}
			else
			{
				supplied.show();
				if (supplied.hasClass("kdlight-checkbox-unchecked"))
				{
					bSelectAll = false;
				}
			}
		}
		if (_jqSelectAll)
		{
			if (bSelectAll)
			{
				_jqSelectAll.removeClass("kdlight-checkbox-unchecked");
				_jqSelectAll.addClass("kdlight-checkbox-checked");
			}
			else
			{
				_jqSelectAll.removeClass("kdlight-checkbox-checked");
				_jqSelectAll.addClass("kdlight-checkbox-unchecked");
			}
		}
	}
}

/**
 * 独立多选框
 */
function KEXTFilterFlipInput(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _jqCtrl = $("<div class='kdlight-filter-flip-input'>");
	var _jqItem1 = $("<div class='kdlight-filter-flip-input-item'>");
	var _jqItem2 =$("<div class='kdlight-filter-flip-input-item'>");
	
	var maxTextLength = 18;
	var mouseOnClickListener = function(event)
	{
		var el = $(event.target);
		var vt = new KEXTValueTextModel();
		vt.setValue(el.attr("value"));
		vt.setText(el.text());
		_this.setSelectedValue([vt]);
	}
	
	this.createUI = function(jqParent)
	{
		this.protectedMethod.createUiWithLabel(jqParent, _jqCtrl);
		if (maxTextLength+40 < 125)
		{
			var width = maxTextLength+40<80?80:maxTextLength+40;
			_jqItem1.css({
				"width":width+"px"
			});
			_jqItem2.css({
				"width":width+"px",
				"left":width+2+"px",
				"top":"-30px",
				"margin-left":"-1px"
			});
		}
		else
		{
			var width = 252;
			_jqCtrl.css({
				"height":60+"px"
			});
			_jqItem1.css({
				"width":width+"px"
			});
			_jqItem2.css({
				"width":width+"px",
				"margin-top":"-1px"
			});
		}
		
	}
	
	this.setSuppliedValue = function(arrValueTextModel)
	{
		_jqCtrl.children().remove();
		arrValueTextModel = arrValueTextModel?arrValueTextModel:[];
		for(var i = 0; i < arrValueTextModel.length; i++)
		{
			var oValueTextModel = arrValueTextModel[i];
			var textLength=1;
			var jqOp;
			var sText;
			if (i==0)
			{
				jqOp = _jqItem1;
				sText = oValueTextModel.getText();
				var textLength = oValueTextModel.getText().length;
				maxTextLength = textLength>maxTextLength?textLength:maxTextLength;
			}
			else if (i==1)
			{
				jqOp = _jqItem2;
			}
			
			if (jqOp)
			{
				var ele_font_size = $(jqOp).css('font-size');  
				var ele_font_family = $(jqOp).css('font-family'); 
				sText = oValueTextModel.getText();
				var textWidth = sText.width(ele_font_size+" "+ele_font_family);
				maxTextLength = textWidth>maxTextLength?textWidth:maxTextLength;
				if (textWidth > 212)
				{
					sText = sText.shotcut(ele_font_size+" "+ele_font_family,258);
				}
				jqOp.attr("value", oValueTextModel.getValue());
				jqOp.text(sText);
				jqOp.on("click",mouseOnClickListener);
				_jqCtrl.append(jqOp);
				jqOp = null;
			}
			
		}
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		var arrSelectValueTextModelBefore = _this.getSelectedValue();
		var oValueTextModel = arrValueTextModel && arrValueTextModel.length > 0?arrValueTextModel[0]:null;
		var jqOps = _jqCtrl.children();
		for(var i = 0; i < jqOps.length; i++)
		{
			var jqOp = $(jqOps[i]);
			var bSelected = ((oValueTextModel && jqOp.attr("value") == oValueTextModel.getValue()) ? true : false);
			if (bSelected)
			{
				jqOp.addClass("kdlight-filter-flip-input-item-selected");
			}
			else
			{
				jqOp.removeClass("kdlight-filter-flip-input-item-selected");
			}
		}
		var arrSelectValueTextModelAfter = _this.getSelectedValue();
		if (_this.protectedMethod.compareArrValueTextModel(arrSelectValueTextModelBefore,arrSelectValueTextModelAfter))
		{
			return;
		}
		_this.protectedMethod.fireSelectedValueChanged();
	}
	
	this.getSelectedValue = function()
	{
		var jqOps = _jqCtrl.children();
		var vt = new KEXTValueTextModel();
		for(var i = 0; i < jqOps.length; i++)
		{
			var jqOp = $(jqOps[i]);
			if (jqOp.hasClass("kdlight-filter-flip-input-item-selected"))
			{
				vt.setValue(jqOp.attr("value"));
				vt.setText(jqOp.text());
				break;
			}
		}
		return [vt];
	}
}

/**
 * 数字输入框
 */
function KEXTFilterNumberInput(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _iOldValue = 0;
	var _jqContent = $("<div class='kdlight-filter-number-input-container'>");
	var _jqCtrl = $("<input type='number' class='kdlight-filter-number-input'/>");
	var _jqMinus=$("<div class='kdlight-filter-number-input-btn minus-icon kdlight-filter-activeable'></div>");
	var _jqQlus=$("<div class='kdlight-filter-number-input-btn plus-icon kdlight-filter-activeable'></div>");
	
	(function(){
		_jqMinus.on('click',function(event)
		{		
			var step = parseInt(_jqCtrl.attr("step"));
			var min = parseInt(_jqCtrl.attr("min"));
			var number = _jqCtrl.val();
			if(number == '')
			{
				number = _iOldValue ? _iOldValue : min;
			}
			number = parseInt(number, 10) - step;
			if (number < min)
			{
				number = min;
			}
			_jqCtrl.val(number);
			_iOldValue = number;
		});
		_jqQlus.on('click',function(event)
		{
			var step = parseInt(_jqCtrl.attr("step"));
			var max = parseInt(_jqCtrl.attr("max"));
			var min = parseInt(_jqCtrl.attr("min"));
			var number = _jqCtrl.val();
			if(number == '')
			{
				number = _iOldValue ? _iOldValue : min;
			}
			number = parseInt(number, 10) + step;
			if (number > max)
			{
				number = max;
			}
			_jqCtrl.val(number);
			_iOldValue = number;
		});
		_jqCtrl.on("blur",function(event){
			var jqCtrl = $(_jqCtrl);
			var min = parseInt(_jqCtrl.attr("min"));
			var max = parseInt(_jqCtrl.attr("max"));
			var number = jqCtrl.prop("value");
			if(number == '')
			{
				_jqCtrl.val(number);
				return;
			}
			if(!isNaN(parseInt(number, 10)))
			{
				number = parseInt(number, 10);
			}
			else
			{
				value = _iOldValue ? _iOldValue : min;
			}
			if (number > max)
			{
				number = max;
			}
			else if (number < min)
			{
				number = min;
			}
			_jqCtrl.val(number);
			_iOldValue = number;
		});
	})();
	
	this.createUI = function(jqParent)
	{
		this.protectedMethod.createUiWithLabel(jqParent, _jqContent); 
		var width = parseInt(jqParent.width()*2/3);
		_jqContent.css({
			"width":width+"px",
			height:"34px"
		});
		var _jqCtrlC = $("<div>")
		_jqCtrl.css(
		{
			"float":"left",
			"width":width-70+"px"
		});
		_jqCtrlC.css(
		{
			"float":"left",
			"width":width-70+"px",
			height:"34px"
		});
		_jqMinus.css(
		{	
			"float":"left",
			"border-right":"1px solid #aeaeae"
		});
		
		_jqQlus.css(
		{
			"float":"left",
			"border-left":"1px solid #aeaeae"
		});
		_jqContent.append(_jqMinus); 
		_jqContent.append(_jqCtrlC.append(_jqCtrl)); 
		_jqContent.append(_jqQlus); 
		
		this.protectedMethod.addCtrlDisableClass(_jqCtrl);
	}
	
	this.setSuppliedValue = function(oNumberStepperSuppliedValue)
	{
		_jqCtrl.attr("min", oNumberStepperSuppliedValue.getMin());
		_jqCtrl.attr("max", oNumberStepperSuppliedValue.getMax());
		_jqCtrl.attr("step", oNumberStepperSuppliedValue.getStep());
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		var arrSelectValueTextModelBefore = _this.getSelectedValue();
		var min = parseInt(_jqCtrl.attr("min"));
		if(arrValueTextModel && arrValueTextModel.length > 0)
		{
			var oValueTextModel = arrValueTextModel[0];	
			_jqCtrl.prop("value", oValueTextModel.getValue());
		}
		else
		{
			_jqCtrl.prop("value", min);
		}
		var arrSelectValueTextModelAfter = _this.getSelectedValue();
		if (_this.protectedMethod.compareArrValueTextModel(arrSelectValueTextModelBefore,arrSelectValueTextModelAfter))
		{
			return;
		}
		_this.protectedMethod.fireSelectedValueChanged();
	}
	
	this.getSelectedValue = function()
	{
		var jqCtrl = $(_jqCtrl);
		//要重新$()包一下才能取到value.//在createUiWithLabel()时会给个id.
		var vt = new KEXTValueTextModel();
		vt.setValue(jqCtrl.prop("value"));
		vt.setText(vt.getValue());
		return [vt];
	}
}

/**
 * 日期选择
 */
function KEXTFilterDateSelector(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	var _this = this;
	var _jqParent;
	var _jqValueContent = $("<div>");
	var _jqSelectContainer = $("<div class='themeAContainer'>");
	
	var _jqSelectCtrl = $("<div class='themeA selector'>");
	
	var _jqSelectCtrlBar = $("<div class='themeABar'>");
	var _jqConfirmButton = $("<div class='themeABtn kdlight-btn-ok' >确定</div>");
	var _jqSelectBtn = $("<div class='themeABtn'>")
	var _funExtendEventCallBack;
	var _oCtrl = new kdlight.DateTimeChooser();
	
	this.createUI = function(jqParent)
	{
		var isDefaultExtend = false;
		_jqParent = jqParent;
		_funExtendEventCallBack = this.protectedMethod.createUiWithLabelAndCtrl(jqParent, _jqValueContent, _jqSelectCtrl,isDefaultExtend,funExtendEventHandler);
		
		var oParamDesc = this.getParamDescription();
		if(oParamDesc.getDataType()== "date")
		{
			_oCtrl.setMode(kdlight.DateTimeChooser.MODE_DATE);
			_jqSelectBtn.text("今天");
		}
		else if(oParamDesc.getDataType()== "time")
		{
			_oCtrl.setMode(kdlight.DateTimeChooser.MODE_TIME);
			_jqSelectBtn.text("现在");
		}
		else if(oParamDesc.getDataType()== "datetime")
		{
			_oCtrl.setMode(kdlight.DateTimeChooser.MODE_DATETIME);
			_jqSelectBtn.text("现在");
		}
		_jqSelectBtn.on("click",function(){
			_oCtrl.setSelectValue(new Date());
			_jqConfirmButton.click();
		});
		var jqCtrl = _oCtrl.getSelectablePanel(_jqSelectCtrl);
		_jqSelectCtrl.append(_jqSelectCtrlBar);
		_jqSelectCtrlBar.append(_jqSelectBtn);
		_jqSelectCtrlBar.append(_jqConfirmButton);
		_jqSelectBtn.css("position","relative");
		_jqSelectBtn.css("left","10px");
		_jqConfirmButton.css("position","relative");
		_jqConfirmButton.css("left",_jqSelectCtrlBar.width()-_jqConfirmButton.width()*2-10+"px");
		
		jqCtrl.css("display","inline-block");
		jqCtrl.css("position","relative");
		jqCtrl.css("left",(_jqSelectCtrl.width()-jqCtrl.width())/2+"px");
		funExtendEventHandler(isDefaultExtend);
		$(".kdlight-datetime-blocktitle").removeClass("fontWeightBold").addClass("fontWeightBold");
		_jqConfirmButton.on("click",function(){
			var sDataType = _this.getParamDescription().getDataType();
			var oDate = _oCtrl.getSelectValue();
			var sValue = KEXTFilterDataUtil.parseDate2String(oDate, sDataType);
			var oValueTextModel = new KEXTValueTextModel();
			oValueTextModel.setValue(sValue);
			oValueTextModel.setText(sValue);
			_this.setSelectedValue([oValueTextModel]);
			funExtendEventHandler(false);
			_funExtendEventCallBack(false);
		})
		
	}
	
	//切换显示结果和选择控件
	var funExtendEventHandler = function (isExtend)
	{
		if (isExtend)
		{			
			_jqValueContent.hide();
			_jqSelectCtrl.show();
			_this.setSelectedValue(_this.getSelectedValue());
		}
		else
		{
			_jqSelectCtrl.hide();
			_jqValueContent.show();	
		}
	}
	
	this.setSuppliedValue = function(data)
	{
		//nothing
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		var arrSelectValueTextModelBefore = _this.getSelectedValue();
		_jqValueContent.children().remove();
		var sValue = "";
		if(arrValueTextModel && arrValueTextModel.length > 0)
		{
			sValue = arrValueTextModel[0].getValue();
		}
		if (sValue)
		{
			var jqValue = $("<div class='kdlight-filter-single-value'>");
			var oDate = KEXTFilterDataUtil.parseString2Date(sValue);
			_oCtrl.setSelectValue(oDate);
			jqValue.attr('value',sValue);
			jqValue.text(sValue);
			_jqValueContent.append(jqValue);
		}
		var arrSelectValueTextModelAfter = _this.getSelectedValue();
		if (_this.protectedMethod.compareArrValueTextModel(arrSelectValueTextModelBefore,arrSelectValueTextModelAfter))
		{
			return;
		}
		_this.protectedMethod.fireSelectedValueChanged();		
	}
	
	this.getSelectedValue = function()
	{
		var value = $(_jqValueContent).find(".kdlight-filter-single-value");
		var oValueTextModel = new KEXTValueTextModel();
		if (value.length > 0)
		{
			var jqValue = $(value[0]);
			var sValue = jqValue.attr('value');
			oValueTextModel.setValue(sValue);
			oValueTextModel.setText(sValue);
		}
		return [oValueTextModel];
	}
}

/**
 * 标签控件
 */
function FilterLabel(oReportParamDesc)
{
	KEXTAbstractFilterCtrl.call(this, oReportParamDesc);
	
	var _jqCtrl = $(oReportParamDesc.getDefaultValue()[0].getValue())
						.css({
							padding: "0 0.2em",
							width: "19.6em",
							fontSize: "13px",
							marginTop:"1em",
							marginLeft: "0.5em",
							lineHeight: "0.5em",
							verticalAlign: "middle"
						});

	this.createUI = function(jqParent)
	{
		this.protectedMethod.createUiWithLabel2(jqParent, _jqCtrl);
	}
	
	this.setSuppliedValue = function(data)
	{
		//无
	}
	
	this.setSelectedValue = function(arrValueTextModel)
	{
		//无
	}
	
	this.getSelectedValue = function()
	{
		return []; 
	}
}

/** 工具类 */
var KEXTFilterDataUtil = new (function()
{
	var _this = this;
	
	/**
	 * 按oDelaySuppliedValueModel的“取值字段”和“显示字段”，从oRowset中取值和显示值，
	 * 通过funItemCallbak(iIndex, sValue, sText)返回。
	 */
	this.getDataFromRowset = function(oDelaySuppliedValueModel, oRowset, funItemCallbak)
	{
		var strValueField = oDelaySuppliedValueModel.getValueField();
		var strTextField = oDelaySuppliedValueModel.getTextField();
		strValueField = (strValueField ? strValueField.toLowerCase() : strValueField);
		strTextField = (strTextField ? strTextField.toLowerCase() : strTextField);
		
		//取值字段和显示字段的索引
		var iValueFieldIndex;
		var iTextFieldIndex;
		var arrCols = oRowset["meta"]["colNames"];
		for(var i = 0; i < arrCols.length; i++)
		{
			var sColName = arrCols[i];
			sColName = sColName.toLowerCase();
			if(sColName == strValueField)
			{
				iValueFieldIndex = i;
			}
			if(sColName == strTextField)
			{
				iTextFieldIndex = i;
			}
		}
		
		var arrRows = oRowset["rows"];
		var iRowsCount = (arrRows ? arrRows.length : 0);
		for(var i = 0; i < iRowsCount; i++)
		{
			var oValue = arrRows[i][iValueFieldIndex];
			var sValue = oValue ? oValue.toString() : null;
			var sText = arrRows[i][iTextFieldIndex];
			funItemCallbak(i, sValue, sText);
		}
	}
	
	/** 
	 * date object => yyyy-mm-dd hh:mm:ss 
	 * sType = "date" or "time" or "datetime" 
	 */
	this.parseDate2String = function(oDate, sType)
	{
		var iYyyy = oDate.getFullYear();
		var iMm = oDate.getMonth() + 1;
		var iDd = oDate.getDate();
		var iHh = oDate.getHours();
		var iMi = oDate.getMinutes();
		var iSs = oDate.getSeconds();
		
		var funMakeSureDoubleDigit = function(iNum)
		{
			return (iNum > 9 ? "" : "0") + iNum;
		}
		var sDate = iYyyy + "-" + funMakeSureDoubleDigit(iMm) + "-" + funMakeSureDoubleDigit(iDd);
		var sTime = funMakeSureDoubleDigit(iHh) + ":" + funMakeSureDoubleDigit(iMi) + ":" + funMakeSureDoubleDigit(iSs);
		var sValue;
		if(sType == "date")
		{
			sValue = sDate;
		}
		else if(sType == "time")
		{
			sValue = sTime;
		}
		else
		{
			sValue = sDate + " " + sTime;
		}
		return sValue;
	}
	
	/** 
	 * yyyy-mm-dd hh:mm:ss => date object 
	 */
	this.parseString2Date = function(sText)
	{
		//由于日期格式是yyyy-mm-dd，没有横杆认为是纯时间
		if(sText.indexOf("-") < 0)
		{
			sText = _this.parseDate2String(new Date(), "date") + " " + sText;//补上日期才可以构造Date
		}
		sText = sText.replace(/-/g, "/");
		var oDate = new Date(sText);
		return oDate;
	}
})();
