//扩展报表轻应用消息控件&历史消息&历史快照分析
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖： 
//jQuery 2.1.0 (http://jquery.com)
//FusionCharts 3.3.1 (http://www.fusioncharts.com)
//

function KEXTMessageModel(sId, sTitle, sDate, sText, sImgUrl, sSnapshotUrl)
{
	var _sId = sId;
	var _sTitle = sTitle;
	var _sDate = sDate;
	var _sText = sText;
	var _sImgUrl = sImgUrl;
	var _sSnapshotUrl = sSnapshotUrl;
	
	this.getId = function()
	{
		return _sId;
	}
	
	this.getTitle = function()
	{
		return _sTitle;
	}
	
	this.getDate = function()
	{
		return _sDate;
	}
	
	this.getText = function()
	{
		return _sText;
	}
	
	this.getImgUrl = function()
	{
		return _sImgUrl;
	}
	
	this.getSnapshotUrl = function()
	{
		return _sSnapshotUrl;
	}
}

function KEXTMessageUi()
{
	var _jqUi;
	var _funClickListener;
	
	this.setModel = function(oModel)
	{
		_jqUi = $("<div>");
		_jqUi.addClass("message");

		var jqTitle = $("<div>");
		jqTitle.addClass("message-title");
		jqTitle.text(oModel.getTitle());
		_jqUi.append(jqTitle);
		
		var jqDate = $("<div>");
		jqDate.addClass("message-date");
		jqDate.text(oModel.getDate());
		_jqUi.append(jqDate);
		
		var sImgUrl = oModel.getImgUrl();
		if(sImgUrl)
		{
			var jqImg = $("<div>");
			jqImg.addClass("message-img");
			jqImg.css("background-image", "url(" + sImgUrl + ")");
			_jqUi.append(jqImg);
		}
		
		var jqText = $("<div>");
		jqText.addClass("message-text");
		jqText.text(oModel.getText());
		_jqUi.append(jqText);
		
		_jqUi.on("click",
			function(evt)
			{
				if(_funClickListener)
				{
					_funClickListener(oModel.getSnapshotUrl());
				}
			});
	}
	
	this.getJqUi = function()
	{
		return _jqUi;
	}
	
	/**
	 * 设置点击时的回调函数，funAction形如：func(sSnapshotUrl)
	 */
	this.setAction = function(funAction)
	{
		_funClickListener = funAction;
	}
}

function KEXTMessageLazyList()
{
	var _jqList;
	var _funDataProvider;
	var _bStopAppend = true;
	var _bStopInsert = true;
	var _bDataLoading;
	var _jqNoDataPrompt;
	var _funClickListener;
	
	/** 没有数据时提示什么字 */
	this.setNoDataPrompt = function(sText)
	{
		if(!_jqNoDataPrompt)
		{
			_jqNoDataPrompt = $("<div>");
		}
		_jqNoDataPrompt.text(sText);
	}
	
	/** 设置向上或向下滚动懒加载模式，用常量Mode_TopLazy、Mode_BottomLazy */
	this.setLazyMode = function(iMode)
	{
		_bStopInsert = (iMode != KEXTMessageLazyList.Mode_TopLazy);
		_bStopAppend = (iMode != KEXTMessageLazyList.Mode_BottomLazy);
	}

	/**
	 * funDataProvider 形如：func(sEdgeMessageId, funCallback, funErrorCallback);
	 * 其中，
	 * 参数 sEdgeMessageId 表示已取到的消息中，边界上的消息ID；
	 * 参数 funCallback 形如：func(arrModels);
	 * 参数 funErrorCallback 形如：func();
	 */
	this.setDataProvider = function(funDataProvider)
	{
		_funDataProvider = funDataProvider;
		if(_jqList)
		{
			initData();
		}
	}
	
	/**
	 * 设置点击时的响应，函数形如：func(sSnapshotUrl)
	 */
	this.setClickListener = function(funAction)
	{
		_funClickListener = funAction;
	}
	
	/**
	 * 手动向末尾添加数据
	 */
	this.manualAppend = function(arrModels)
	{
		if(_jqNoDataPrompt)
		{
			_jqNoDataPrompt.remove();
			_jqNoDataPrompt = null;
		}
		appendDataCallback(arrModels);
	}
	
	this.getJqUi = function()
	{
		if(!_jqList)
		{
			_jqList = $("<div>");
			_jqList.css("overflow-x", "hidden");
			_jqList.css("overflow-y", "auto");
			if(_funDataProvider)
			{
				initData();
			}
		}
		return _jqList;
	}
	
	this.reload = function()
	{
		if(_jqList && _funDataProvider)
		{
			_jqList.children().remove();
			initData();
		}
	}
	
	var initData = function()
	{
		var funSuccess = function(arrModels)
		{
			if(!arrModels || arrModels.length == 0)
			{
				if(!_jqNoDataPrompt)
				{
					_jqNoDataPrompt = $("<div>");
					_jqNoDataPrompt.text("没有数据");
				}
				_jqNoDataPrompt.css("text-align", "center");
				_jqNoDataPrompt.css("width", "100%");
				_jqNoDataPrompt.css("line-height", "60px");
				_jqNoDataPrompt.css("color", "#999999");
				_jqList.append(_jqNoDataPrompt);
			}
			else
			{
				appendDataCallback(arrModels);
				if(!_bStopInsert)
				{
					_jqList.scrollTop(_jqList.prop("scrollHeight") - _jqList.prop("clientHeight"));
				}
				_jqList.scroll(doScrolling);
			}
		}
		_funDataProvider(null, funSuccess, null);
	}
	
	var appendData = function()
	{
		if(_bStopAppend || _bDataLoading)
		{
			return;
		}
		_bDataLoading = true;

		var jqDiv = createLoadingPrompt();
		_jqList.append(jqDiv);
		var iNewScrollTop = _jqList.scrollTop() + 40;
		setTimeout(
			function()
			{
				_jqList.scrollTop(iNewScrollTop);
			}, 100);
		
		var jqLast = _jqList.children(".message").last();
		var sEdgeMessageId = jqLast.data("messageId");
		var funSuccess = function(arrModels)
		{
			if(arrModels && arrModels.length > 0)
			{
				jqDiv.remove();
				appendDataCallback(arrModels);
			}
			else
			{
				_bStopAppend = true;
				updatePromptAndDelayHide(jqDiv, "没有更多内容");
			}
			_bDataLoading = false;
		}
		var funError = function()
		{
			updatePromptAndDelayHide(jqDiv, "数据加载错误！");
			_bDataLoading = false;
		}
		_funDataProvider(sEdgeMessageId, funSuccess, funError);
	}
	
	var insertData = function()
	{
		if(_bStopInsert || _bDataLoading)
		{
			return;
		}
		_bDataLoading = true;
		
		var jqFirst = _jqList.children(".message").first();
		var jqDiv = createLoadingPrompt();
		jqDiv.insertBefore(jqFirst);
		
		var sEdgeMessageId = jqFirst.data("messageId");
		var funSuccess = function(arrModels)
		{
			if(arrModels && arrModels.length > 0)
			{
				jqDiv.remove();
				insertDataCallback(arrModels);
			}
			else
			{
				_bStopInsert = true;
				updatePromptAndDelayHide(jqDiv, "没有更多内容");
			}
			_bDataLoading = false;
		}
		var funError = function()
		{
			updatePromptAndDelayHide(jqDiv, "数据加载错误！");
			_bDataLoading = false;
		}
		_funDataProvider(sEdgeMessageId, funSuccess, funError);
	}
	
	var updatePromptAndDelayHide = function(jqDiv, sText)
	{
		jqDiv.text(sText);
		setTimeout(
			function()
			{
				jqDiv.text("");
				jqDiv.slideUp("fast", 
					function()
					{
						jqDiv.remove();
					});
			}, 
			2000);
	}
	
	var appendDataCallback = function(arrModels)
	{
		var jqFragment = $(document.createDocumentFragment());
		for(var i = 0; i < arrModels.length; i++)
		{
			var oModel = arrModels[i];
			var jqUi = createMessageUi(oModel);
			jqFragment.append(jqUi);
		}
		_jqList.append(jqFragment);
	}
	
	var insertDataCallback = function(arrModels)
	{
		var jqFirst = _jqList.children(".message").first();
		var jqFragment = $(document.createDocumentFragment());
		for(var i = 0; i < arrModels.length; i++)
		{
			var oModel = arrModels[i];
			var jqUi = createMessageUi(oModel);
			jqFragment.append(jqUi);
		}
		jqFragment.insertBefore(jqFirst);
		var iTop = jqFirst.prop("offsetTop") - 50;
		_jqList.scrollTop(iTop);
		_jqList[0].scrollY = iTop;
	}

	var createMessageUi = function(oModel)
	{
		var oUi = new KEXTMessageUi();
		oUi.setAction(_funClickListener);
		oUi.setModel(oModel);
		var jqUi = oUi.getJqUi();
		jqUi.data("messageId", oModel.getId());
		jqUi.css("position", "relative");
		jqUi.css("margin", 10);
		return jqUi;
	}
	
	var doScrolling = function(evt)
	{
		var iScrollTop = _jqList.prop("scrollTop");
		if(iScrollTop == 0)
		{
			insertData();
		}
		else if(iScrollTop + _jqList.prop("clientHeight") == _jqList.prop("scrollHeight"))
		{
			appendData();
		}
	}
	
	var createLoadingPrompt = function()
	{
		var jqDiv = $("<div>");
		jqDiv.css("position", "relative");
		jqDiv.css("height", "40px");
		jqDiv.css("text-align", "center");
		jqDiv.css("line-height", "30px");
		jqDiv.css("font-size", "12px");
		jqDiv.text("数据加载中...");
		return jqDiv;
	}
}
KEXTMessageLazyList.Mode_TopLazy = 1;
KEXTMessageLazyList.Mode_BottomLazy = 2;

//===========  以上为轻应用和APP共用  =============
//===========  以下APP相关  =============

/**
 * App一个主题，与轻应用对应
 * 不包括与云之家外壳对应的标题栏，
 * 包括分析、报表、消息三个页签的封装，继承自轻应用的入口 KEXTLight 。
 */
function KEXTAppSubject()
{
	KEXTLight.call(this);
	var TAB_TITLE_MSG = "消息";
	
	var _this = this;
	var _oMessage = new KEXTAppMessagePanel();
	
	var _superSetRemoteImpl = _this.setRemoteImpl;
	this.setRemoteImpl = function(oImpl)
	{
		_superSetRemoteImpl(oImpl);
		_oMessage.setRemoteImpl(oImpl);
	}
	
	var _superCreateUi = _this.createUi;
	this.createUi = function(jqPage, sTitle, sSubjectId, bNewMsg)
	{
		_superCreateUi(jqPage, sTitle, sSubjectId);

		var oNav = _this.protectedMethod.getNavigator();
		oNav.addTabPreChangeListener(doTabPreChange);
		oNav.addTabChangedListener(doTabChanged);
		
		var jqPanel = oNav.addTab(TAB_TITLE_MSG, KEXTImg_NavMessage, KEXTImg_NavMessageSelected);
		_oMessage.createUi(jqPanel, sTitle, sSubjectId);
		_oMessage.setRequestFullScreenListener(_this.protectedMethod.showNavigatorBar);
		_oMessage.setMessageReadListener(
			function()
			{
				parent.KEXTAppForIframeFacade.fireMessageRead();
			});
		_oMessage.setMessageRefreshedListener(
			function(funCallback)
			{
				parent.KEXTAppForIframeFacade.fireMessageRefreshed(funCallback);
			}
		);
		if(bNewMsg)
		{
			oNav.showRedDot(TAB_TITLE_MSG, true);
		}
		
		oNav.setSelectedIndex(1);	
	}
	
	this.backwardFromSnapshot = function()
	{
		_oMessage.snapshotBackToMessages();
	}
	
	var doTabChanged = function(iOldIndex, sOldTitle, iNewIndex, sNewTitle)
	{
		if(sNewTitle == TAB_TITLE_MSG)
		{
			_oMessage.inTurn(true);
			_this.protectedMethod.getNavigator().showRedDot(TAB_TITLE_MSG, false);
			
			_oMessage.restoreState();
		}
		else if(sOldTitle == TAB_TITLE_MSG)
		{
			_oMessage.inTurn(false);
		}
	}
	
	var doTabPreChange = function(iOldIndex, sOldTitle, iNewIndex, sNewTitle)
	{
		if(sOldTitle == TAB_TITLE_MSG)
		{
			_oMessage.keepState();
		}
	}
}

/**
 * App消息内容面板
 * 封装消息列表及其刷新逻辑，点击消息开iframe展现快照。
 */
function KEXTAppMessagePanel()
{
	KEXTAbstractNavigatorPane.call(this);
	var POLLING_INTERVAL = 20000;//隔多长时间轮询一次	
	
	var _oRemoteCallImpl;
	var _sId;
	var _sTitle;
	var _funRequestFullScreen;
	var _funMessageRead;
	var _funMessageRefreshed;

	var _oMessageLazyList;
	var _bFirstLoaded = null;	
	var _jqNewMessagePrompt;
	var _iPollingTag;
	var _bStopPolling;
	var _sNewestMessageId;
	
	this.setRemoteImpl = function(oImpl)
	{
		_oRemoteCallImpl = oImpl;
	}
	
	this.setRequestFullScreenListener = function(funListener)
	{
		_funRequestFullScreen = funListener;
	}
	
	/** funAction like: func() */
	this.setMessageReadListener = function(funAction)
	{
		_funMessageRead = funAction;
	}
	
	/** funAction like: func(funCallback) */
	this.setMessageRefreshedListener = function(funAction)
	{
		_funMessageRefreshed = funAction;
	}	
	
	this.createUi = function(jqParent, sTitle, sSubjectId)
	{
		_sId = sSubjectId;
		_sTitle = sTitle;
		createMessagePane(jqParent);
	}
	
	this.snapshotBackToMessages = function()
	{
		KEXTUtil.setEnvTitle(_sTitle);
		snapshotBackToMessages();
	}
	
	this.inTurn = function(bInTurn)
	{
		if(bInTurn)
		{
			if(_bFirstLoaded === null)
			{
				_bFirstLoaded = false;
				firstVisitMessages(
					function(bSuccess)
					{
						_bFirstLoaded = (bSuccess ? true : null);
					});
			}
			else
			{
				setPollingWorking(true);
			}
		}
		else
		{
			setPollingWorking(false);
		}
	}
	
	this.keepState = function()
	{
		var jqScroller = _oMessageLazyList.getJqUi();
		jqScroller.data("myScrollTop", jqScroller.prop("scrollTop") - 1);
	}
	this.restoreState = function()
	{
		var jqScroller = _oMessageLazyList.getJqUi();
		var iOriValue = jqScroller.data("myScrollTop");
		if(iOriValue || iOriValue == 0)
		{
			jqScroller.prop("scrollTop", iOriValue);
		}
	}
	
	var createRemoteFacade = function(funCallback, funErrorCallback, funFinalCallback)
	{
		return new KEXTFacade(_oRemoteCallImpl, funCallback, funErrorCallback, funFinalCallback);
	}
	
	var createMessagePane = function(jqParent)
	{
		_oMessageLazyList = new KEXTMessageLazyList();
		_oMessageLazyList.setNoDataPrompt("当前主题暂无消息");
		_oMessageLazyList.setLazyMode(KEXTMessageLazyList.Mode_TopLazy);
		_oMessageLazyList.setClickListener(messageClickHandler);
		//等页面翻出来再setDataProvider让其加载数据...
		var jqList = _oMessageLazyList.getJqUi();
		jqList.addClass("app-messagepane-list");
		KEXTUtil.setSimScrollbar(jqList, jqParent);
		jqParent.append(jqList);
		
		parent.KEXTAppForIframeFacade.addBackwardToSubjectsListener(
			function()
			{
				setPollingWorking(false);
			});
	}
		
	var firstVisitMessages = function(funCallback)
	{
		_oMessageLazyList.setDataProvider(
			function(sEdgeMessageId, funCallbackForList, funErrorForList)
			{
				var funSuccess = function(arrModels)
				{
					funCallbackForList(arrModels);
					funCallback(true);
					_funMessageRead();
					polling(POLLING_INTERVAL);
				}
				var funError = function()
				{
					funErrorForList();
					funCallback(false);
				}
				remoteGetMessage(sEdgeMessageId, funSuccess, funError);
			});
	}
	
	var remoteGetMessage = function(sEdgeMessageId, funCallback, funError)
	{
		var remoteGetMessageCallback = function(arrData)
		{
			var arrModels = messagesJsonToModel(arrData);
			funCallback(arrModels);
			if(!sEdgeMessageId && arrModels.length > 0)
			{
				_sNewestMessageId = arrModels[arrModels.length - 1].getId();
			}
		}
		var remoteGetMessageError = function(iErrorCode, sErrorInfo)
		{
			funError();
		}
		var oFacade = createRemoteFacade(remoteGetMessageCallback, remoteGetMessageError);
		oFacade.getAppMessages(_sId, sEdgeMessageId, "before");
	}
	
	var messageListRefresh = function()
	{
		if(_bStopPolling)
		{
			return;
		}
		var remoteGetMessageCallback = function(arrData)
		{
			if(arrData && arrData.length > 0)
			{
				var arrModels = messagesJsonToModel(arrData);
				appendNewMessages(arrModels);
				_funMessageRefreshed(_funMessageRead);
				_sNewestMessageId = arrModels[arrModels.length - 1].getId();
			}
		}
		var remoteGetMessageError = null;
		var remoteGetMessageFinally = function()
		{
			if(!_bStopPolling)
			{
				polling(POLLING_INTERVAL);
			}			
		}
		var oFacade = createRemoteFacade(remoteGetMessageCallback, remoteGetMessageError, remoteGetMessageFinally);
		oFacade.setSilenceMode(true);
		oFacade.getAppMessages(_sId, _sNewestMessageId, "after");
	}
	
	var messagesJsonToModel = function(arrData)
	{
		var arrModels = [];
		if(arrData)
		{
			for(var i = 0; i < arrData.length; i++)
			{
				var oData = arrData[i];
				var sId = oData["id"];
				var sTitle = oData["title"];
				var sText = oData["text"];
				var sImgUrl = oData["imgUrl"];
				var sSnapshotUrl = oData["snapshotUrl"];
				
				var iDate = oData["date"];
				var oDate = new Date(iDate);
				var sDate = oDate.getFullYear() + "-" + (oDate.getMonth() + 1) + "-" + oDate.getDate() + " " + oDate.getHours() + ":" + oDate.getMinutes() + ":" + oDate.getSeconds();
				
				var oModel = new KEXTMessageModel(sId, sTitle, sDate, sText, sImgUrl, sSnapshotUrl);
				arrModels.push(oModel);
			}
		}
		return arrModels;
	}
	
	var messageClickHandler = function(sSnapshotUrl)
	{
		KEXTUtil.checkNetworkLinkedWithPrompt(
			function()
			{
				sSnapshotUrl = sSnapshotUrl.replace("extlight\-snapshot\.html", "app-snapshot.html");
				
				var jqFrame = $("<iframe>");
				jqFrame.addClass("app-messagepane-frame");
				jqFrame.css("left", "100%");
				jqFrame.attr("src", sSnapshotUrl);
				
				var jqMessageOwner = _oMessageLazyList.getJqUi().parent();
				jqMessageOwner.append(jqFrame);
				jqFrame.animate({"left": 0});
				
				setPollingWorking(false);
				_funRequestFullScreen && _funRequestFullScreen(true);
			});
	}
	
	var snapshotBackToMessages = function()
	{
		var jqMessageOwner = _oMessageLazyList.getJqUi().parent();
		var jqFrame = jqMessageOwner.find("iframe");
		jqFrame.animate({"left": "100%"}, 
			function()
			{
				jqFrame.remove();
				_funRequestFullScreen && _funRequestFullScreen(false);
			});
		setPollingWorking(true);
	}

	var polling = function(iDelayMs)
	{
		_iPollingTag = setTimeout(
			function()
			{
				messageListRefresh();
			},
			iDelayMs
		);
	}
	
	var setPollingWorking = function(bStartOtherwiseStop)
	{
		clearTimeout(_iPollingTag);
		if(bStartOtherwiseStop)
		{
			_bStopPolling = false;
			polling(1000);
		}
		else
		{
			_bStopPolling = true;
		}
	}
	
	var appendNewMessages = function(arrModels)
	{
		var jqList = _oMessageLazyList.getJqUi();
		var jqMessageOwner = jqList.parent();
		var iOldMaxScrollTop = jqList.prop("scrollHeight") - jqList.prop("clientHeight");
		_oMessageLazyList.manualAppend(arrModels);
		if(iOldMaxScrollTop - jqList.prop("scrollTop") < 20)
		{
			jqList.animate({"scrollTop": iOldMaxScrollTop + 40});
		}
		if(_jqNewMessagePrompt)
		{
			return;
		}
		_jqNewMessagePrompt = $("<div>");
		_jqNewMessagePrompt.addClass("app-messagepane-prompt");
		_jqNewMessagePrompt.css("bottom", -50);
		_jqNewMessagePrompt.text("↓ 收到新的消息 ↓");
		jqMessageOwner.append(_jqNewMessagePrompt);
		_jqNewMessagePrompt.animate({"bottom": 0}, "slow", 
			function()
			{
				var funTouched = function(evt)
				{
					jqList.unbind("scroll", funTouched);
					if(_jqNewMessagePrompt)
					{
						setTimeout(function()
						{
							_jqNewMessagePrompt.animate({"bottom": -50}, "slow",
								function()
								{
									_jqNewMessagePrompt.remove();
									_jqNewMessagePrompt = null;
								});
						}, 1000);
					}
				}
				jqList.on("scroll", funTouched);
			});
	}
}

//===========  以上APP相关  =============
//===========  以下轻应用相关  =============

/** 历史消息页面 */
function KEXTHistoryPage()
{
	KEXTAbstractPage.call(this);
	
	var _super = this.protectedMethod;

	var _sReportId;
	var _funBackward;
	var _funForwardSnapshot;
	var _jqOwner;
	
	var _oMsgPane;
	
	var _oDateChooser;
	var _arrFilterPeriods = [];
	
	(function()
	{
		_super.setCurrentJqScrollerGetter(
			function()
			{
				return _oMsgPane.getJqUi().find(".history-message-list");
			}
		);
	})();
	
	/** funCallback like: func() */
	this.setBackwardListener = function(funCallback)
	{
		_funBackward = funCallback;
	}
	
	/** funCallback like: func(sSnapshotUrl) */
	this.setForwardSnapshotListener = function(funCallback)
	{
		_funForwardSnapshot = funCallback;
	}
	
	this.createUi = function(jqOwner, sReportId)
	{
		_sReportId = sReportId;
		_jqOwner = jqOwner;
		var oBar = new kdlight.Toolbar();
		oBar.addButton(kdlight.Toolbar.POS_LEFT, "btnBack", "返回", _funBackward);
		oBar.addSeperator(kdlight.Toolbar.POS_LEFT);
		oBar.addButton(kdlight.Toolbar.POS_RIGHT, "btnDate", "./resource/btn_date.png", doSelectDate);
		jqOwner.append(oBar.getJqUi());
		
		_oMsgPane = new KEXTHistoryPage.MessagePane();
		_oMsgPane.setForwardSnapshotListener(_funForwardSnapshot);
		_oMsgPane.setRemoter(remoteGetMessages);
		_oMsgPane.getJqUi().addClass("history-message-pane");
		_oMsgPane.getJqUi().appendTo(_jqOwner);
		setTimeout(
			function()
			{
				_oMsgPane.load();
			}, 
			50);
	}
	
	var doSelectDate = function()
	{
		KEXTUtil.bindHardwareBackwardActionForLight(_funBackward, false);
		KEXTUtil.bindHardwareBackwardActionForLight(actionSelectDate, true);
		if(!_oDateChooser)
		{
			_oDateChooser = new KEXTHistoryPage.DateChooser();
			_oDateChooser.setActionListener(actionSelectDate);
			_oDateChooser.getJqUi().addClass("history-datefilter");
			_jqOwner.append(_oDateChooser.getJqUi());
		}
		_oDateChooser.getJqUi().css("left", "100%");
		_oDateChooser.getJqUi().animate({"left": ""});
	}
	
	var actionSelectDate = function(arrPeriods)
	{
		_oDateChooser.getJqUi().animate({"left": "100%"});
		if(arrPeriods && arrPeriods.length > 0)
		{
			_arrFilterPeriods = arrPeriods;
			_oMsgPane.reload();
		}
		KEXTUtil.bindHardwareBackwardActionForLight(actionSelectDate, false);
		KEXTUtil.bindHardwareBackwardActionForLight(_funBackward, true);
	}
	
	var remoteGetMessages = function(funCallback, funError, sEdgeMessageId)
	{
		var sJsonDatePeriods = JSON.stringify(_arrFilterPeriods);
		var oFacade = _super.getFacade(funCallback, funError);
		oFacade.getHistoryMessages(_sReportId, sJsonDatePeriods, sEdgeMessageId);
	}
	
	var _superKeepState = this.keepState;
	this.keepState = function()
	{
		_superKeepState();
		KEXTUtil.bindHardwareBackwardActionForLight(_funBackward, false);
	}
	
	var _superRestoreState = this.restoreState;
	this.restoreState = function()
	{
		_superRestoreState();
		KEXTUtil.bindHardwareBackwardActionForLight(_funBackward, true);
	}
}

KEXTHistoryPage.MessagePane = function()
{
	var _jqUi;
	var _oLazyList;
	var _funRemoter;
	var _funForwardSnapshot;
	
	var init = function()
	{
		_jqUi = $("<div>");
		_oLazyList = new KEXTMessageLazyList();
		_oLazyList.setNoDataPrompt("当前报表无历史消息");
		_oLazyList.setLazyMode(KEXTMessageLazyList.Mode_TopLazy);
		_oLazyList.setClickListener(messageClickHandler);
		var jqList = _oLazyList.getJqUi();
		jqList.addClass("history-message-list");
		_jqUi.append(jqList);
		KEXTUtil.setSimScrollbar(jqList, _jqUi);
	}
	
	this.setRemoter = function(funRemoter)
	{
		_funRemoter = funRemoter;
	}
	
	this.getJqUi = function()
	{
		if(!_jqUi)
		{
			init();
		}
		return _jqUi;
	}
	
	this.load = function()
	{
		_oLazyList.setDataProvider(messageListDataProvider);
	}
	
	this.reload = function()
	{
		_oLazyList.setNoDataPrompt("指定时段无历史消息");
		_oLazyList.reload();
	}
	
	this.setForwardSnapshotListener = function(funForwardSnapshot)
	{
		_funForwardSnapshot = funForwardSnapshot;
	}
	
	var messageClickHandler = function(sSnapshotUrl)
	{
		_funForwardSnapshot(sSnapshotUrl);
	}
	
	var messageListDataProvider = function(sEdgeMessageId, funCallback, funError)
	{
		var remoteGetMessageCallback = function(arrData)
		{
			var arrModels = messagesJsonToModel(arrData);
			funCallback(arrModels);
		}
		var remoteGetMessageError = function(iErrorCode, sErrorInfo)
		{
			funError();
		}
		_funRemoter(remoteGetMessageCallback, remoteGetMessageError, sEdgeMessageId);
	}
	
	var messagesJsonToModel = function(arrData)
	{
		var arrModels = [];
		if(arrData)
		{
			for(var i = 0; i < arrData.length; i++)
			{
				var oData = arrData[i];
				var sId = oData["id"];
				var sTitle = oData["title"];
				var sText = oData["text"];
				var sImgUrl = oData["imgUrl"];
				var sSnapshotUrl = oData["snapshotUrl"];
				
				var iDate = oData["date"];
				var oDate = new Date(iDate);
				var sDate = oDate.getFullYear() + "-" + (oDate.getMonth() + 1) + "-" + oDate.getDate() + " " + oDate.getHours() + ":" + oDate.getMinutes() + ":" + oDate.getSeconds();
				
				var oModel = new KEXTMessageModel(sId, sTitle, sDate, sText, sImgUrl, sSnapshotUrl);
				arrModels.push(oModel);
			}
		}
		return arrModels;
	}
}

KEXTHistoryPage.DateChooser = function()
{
	var _arrQuickItems = 
	[
		new KEXTHistoryPage.DateChooser.Recent7(),
		new KEXTHistoryPage.DateChooser.Recent30(),
		new KEXTHistoryPage.DateChooser.Recent365(),
		new KEXTHistoryPage.DateChooser.Today(),
		new KEXTHistoryPage.DateChooser.Yesterday(),
		new KEXTHistoryPage.DateChooser.ThisMonth(),
		new KEXTHistoryPage.DateChooser.LastMonth(),
		new KEXTHistoryPage.DateChooser.ThisYear(),
		new KEXTHistoryPage.DateChooser.LastYear()
	];
		
	var _jqUi;
	var _oTab;
	var _oInputFrom;
	var _oInputTo;
	var _oQuickRadioGroup;
	
	var _funAction;
	
	var _bQuickSelectedDirty = true;

	var _sQuickTag;
	var _arrPeriods;
	
	/** funCallback like: func([[iFromTime, iToTime], ...]) */
	this.setActionListener = function(funCallback)
	{
		_funAction = funCallback;
	}
	
	/** [[iFromTime, iToTime], ...] */
	this.setPeriods = function(arrPeriods)
	{
		_arrPeriods = arrPeriods;
		if(_jqUi)
		{
			updateSelection();
		}
	}
	
	/** 快捷选择的选项，null表示自定义 */
	this.setQuickTag = function(sTag)
	{
		_sQuickTag = sTag;
		_bQuickSelectedDirty = true;
		if(_jqUi)
		{
			updateSelection();
		}
	}
	
	this.getQuickTag = function()
	{
		return _sQuickTag;
	}
	
	this.getJqUi = function()
	{
		if(!_jqUi)
		{
			init();
		}
		return _jqUi;
	}
	
	this.parseQuickTagToPeriod = function(sTag)
	{
		for(var i = 0; i < _arrQuickItems.length; i++)
		{
			var oModel = _arrQuickItems[i];
			if(sTag == oModel.getTag())
			{
				return oModel.getPeriod();
			}
		}
		return [0, 1];
	}
	
	var init = function()
	{
		var arrTabNames = ["快捷选择", "自定义时间"];
		_oTab = new kdlight.CustomTabContainer();
		_oTab.setTabNames(arrTabNames);
		_oTab.setTabContent(arrTabNames[0], createQuickFilterPane());
		_oTab.setTabContent(arrTabNames[1], createCustomFilterPane());
		_oTab.setCurrentTabName(arrTabNames[0]);
		_oTab.setSelectedChangeListener(
			function(sTabNameOld, sTabName)
			{
				var bIntoCustom = (sTabNameOld == arrTabNames[0]);
				if(bIntoCustom && _bQuickSelectedDirty)
				{
					_bQuickSelectedDirty = false;
					doChangeFromQuickToCustom();
				}
			});
		
		var oConfirmBar = new kdlight.ConfirmBar();
		oConfirmBar.setActionListener(
			function(bOkClicked)
			{
				var arrResult = [];
				if(bOkClicked)
				{
					if(arrTabNames[0] == _oTab.getCurrentTabName())
					{
						_sQuickTag = getQuickSelectedTag();
						arrResult.push(getQuickSelectedPeriod());
					}
					else
					{
						_sQuickTag = null;
						arrResult.push(getCustomSelectedPeriod());
					}
				}
				_funAction(arrResult);
			}
		);
		
		_jqUi = $("<div>");
		_jqUi.append(_oTab.getJqUi());
		_jqUi.append(oConfirmBar.getJqUi());
		_oTab.getJqUi().addClass("history-datefilter-tab");
		
		updateSelection();
	}
	
	var createQuickFilterPane = function()
	{
		_oQuickRadioGroup = new kdlight.RadioGroup();
		_oQuickRadioGroup.setItemValueComparer(
			function(oModel1, oModel2)
			{
				return (oModel1.getTag() == oModel2.getTag());
			});
		_oQuickRadioGroup.setSelectedChangedListener(
			function(evt)
			{
				_bQuickSelectedDirty = true;
			});
		for(var i = 0; i < _arrQuickItems.length; i++)
		{
			var oModel = _arrQuickItems[i];
			_oQuickRadioGroup.addItem(oModel.getCaption, oModel);
		}
		var jqPane = $('<div>');
		jqPane.addClass("history-datefilter-tabpane");
		jqPane.append(_oQuickRadioGroup.getJqUi());
		return jqPane;
	}
	
	var createCustomFilterPane = function()
	{
		var jqPane = $("<div>");
		jqPane.addClass("history-datefilter-tabpane");
		_oInputFrom = createInput(jqPane, "开始日期");
		_oInputTo = createInput(jqPane, "结束日期");
		return jqPane;
	}
	
	var createInput = function(jqParent, sLabel)
	{
		var jqLabel = $("<div>");
		jqLabel.text(sLabel);
		jqLabel.css({
			"margin-top": "10px",
			"margin-bottom": "4px"
		});
		jqParent.append(jqLabel);
		
		var oCtrl = new kdlight.DateTimeChooser();
		oCtrl.setMode(kdlight.DateTimeChooser.MODE_DATE);
		jqParent.append(oCtrl.getInputField());

		return oCtrl;
	}
	
	var getQuickSelectedTag = function()
	{
		var oModel = _oQuickRadioGroup.getSelected();
		return (oModel ? oModel.getTag() : null);
	}
		
	var getQuickSelectedPeriod = function()
	{
		var oModel = _oQuickRadioGroup.getSelected();
		return (oModel ? oModel.getPeriod() : [1420041600000, 1451577600000]);//2015
	}
	
	var getCustomSelectedPeriod = function()
	{
		return [
			parseCustomInput(_oInputFrom.getSelectValue()), 
			parseCustomInput(_oInputTo.getSelectValue(), true)];
	}
	
	var parseCustomInput = function(oDate, bForEnd)
	{
		oDate.setHours(0, 0, 0, 0);
		if(bForEnd)
		{
			oDate.setDate(oDate.getDate() + 1);
		}
		return oDate.getTime();
	}
	
	var doChangeFromQuickToCustom = function()
	{
		var arrPeriod = getQuickSelectedPeriod();
		setCustomPeriod(arrPeriod);
	}
	
	var setCustomPeriod = function(arrPeriod)
	{
		_oInputFrom.setSelectValue(new Date(arrPeriod[0]));
		_oInputTo.setSelectValue(new Date(arrPeriod[1] - 1));
	}
	
	var updateSelection = function()
	{
		var bQuickNewSelectedFound = false;
		if(_sQuickTag)
		{
			for(var i = 0; i < _arrQuickItems.length; i++)
			{
				if(_arrQuickItems[i].getTag() == _sQuickTag)
				{
					bQuickNewSelectedFound = true;
					_oQuickRadioGroup.setSelected(_arrQuickItems[i]);
					
					var arrTabNames = _oTab.getAllTabNames();
					_oTab.setCurrentTabName(arrTabNames[0]);
					break;
				}
			}
		}
		
		if(!bQuickNewSelectedFound && _arrPeriods && _arrPeriods.length)
		{
			var arrPeriod = _arrPeriods[0];
			setCustomPeriod(arrPeriod);
			
			var arrTabNames = _oTab.getAllTabNames();
			_oTab.setCurrentTabName(arrTabNames[1]);
		}
	}
}

KEXTHistoryPage.DateChooser.AbstractFilter = function()
{
	/** 持久化相关的标记，定下来就不要动 */
	this.getTag = function()
	{
		throw new Error("Override me.");
	}

	this.getCaption = function()
	{
		throw new Error("Override me.");
	}
	
	this.getPeriod = function()
	{
		throw new Error("Override me.");
	}
	
	//较正为当天的0点0分0秒，以作为起始时间
	var makeStartTime = function(iTime)
	{
		return daystart(iTime);
	}
	
	//较正为当天的24点0分0秒（即次日的零点），以作为结束时间
	var makeEndTime = function(iTime)
	{
		return daystart(skipDays(iTime, 1));
	}

	var daystart = function(iTime)
	{
		var oDate = new Date(iTime);
		oDate.setHours(0, 0, 0, 0);
		return oDate.getTime();
	}
	
	//跳转iDays天，向前为负数
	var skipDays = function(iTime, iDays)
	{
		return iTime + iDays * 86400000;
	}
	
	//跳转iMonths个月
	var skipMonths = function(iTime, iMonths)
	{
		var oDate = new Date(iTime);
		oDate.setMonth(oDate.getMonth() + iMonths);
		//如果不是0~11，会自动跳年，不确定是否是ECMAScript标准特性。
		return oDate.getTime();
	}
		
	//跳转iYears年
	var skipYears = function(iTime, iYears)
	{
		var oDate = new Date(iTime);
		oDate.setFullYear(oDate.getFullYear() + iYears);
		return oDate.getTime();
	}
	
	this.protectedMethod = 
	{
		"makeStartTime": makeStartTime,
		"makeEndTime": makeEndTime,
		"skipDays": skipDays,
		"skipMonths": skipMonths,
		"skipYears": skipYears
	}
}

KEXTHistoryPage.DateChooser.Recent7 = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "recent-7day";
	}
	
	this.getCaption = function()
	{
		return "最近7天";
	}
	
	this.getPeriod = function()
	{
		var iEnd = new Date().getTime();
		var iStart = _super.skipDays(iEnd, -6);
		iStart = _super.makeStartTime(iStart);
		iEnd = _super.makeEndTime(iEnd);
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.Recent30 = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "recent-month";
	}
	
	this.getCaption = function()
	{
		return "最近1个月";
	}
	
	this.getPeriod = function()
	{
		var iEnd = new Date().getTime();
		var iStart = _super.makeStartTime(_super.skipDays(_super.skipMonths(iEnd, -1), 1));
		iEnd = _super.makeEndTime(iEnd);
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.Recent365 = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "recent-year";
	}
	
	this.getCaption = function()
	{
		return "最近1年";
	}
	
	this.getPeriod = function()
	{
		var iEnd = new Date().getTime();
		var iStart = _super.skipDays(_super.skipYears(iEnd, -1), 1);
		iStart = _super.makeStartTime(iStart);
		iEnd = _super.makeEndTime(iEnd);
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.Today = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "today";
	}
	
	this.getCaption = function()
	{
		return "今天";
	}
	
	this.getPeriod = function()
	{
		var iEnd = new Date().getTime();
		var iStart = _super.makeStartTime(iEnd);
		iEnd = _super.makeEndTime(iEnd);
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.Yesterday = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "yesterday";
	}
	
	this.getCaption = function()
	{
		return "昨天";
	}
	
	this.getPeriod = function()
	{
		var iEnd = _super.skipDays(new Date().getTime(), -1);
		var iStart = _super.makeStartTime(iEnd);
		iEnd = _super.makeEndTime(iEnd);
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.ThisMonth = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "this-month";
	}
	
	this.getCaption = function()
	{
		return "本月";
	}
	
	this.getPeriod = function()
	{
		var oDate = new Date();
		oDate.setDate(1);
		var iStart = _super.makeStartTime(oDate.getTime());
		var iEnd = _super.makeEndTime(_super.skipDays(_super.skipMonths(oDate.getTime(), 1), -1));
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.LastMonth = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "last-month";
	}
	
	this.getCaption = function()
	{
		return "上月";
	}

	this.getPeriod = function()
	{
		var oDate = new Date();
		oDate.setDate(1);
		var iStart = _super.makeStartTime(_super.skipMonths(oDate.getTime(), -1));
		var iEnd = _super.makeEndTime(_super.skipDays(oDate.getTime(), -1));
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.ThisYear = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "this-year";
	}
	
	this.getCaption = function()
	{
		return "今年";
	}
	
	this.getPeriod = function()
	{
		var oDate = new Date();
		oDate.setMonth(0);
		oDate.setDate(1);
		var iStart = _super.makeStartTime(oDate.getTime());
		var iEnd = _super.makeEndTime(_super.skipDays(_super.skipYears(oDate.getTime(), 1), -1));
		return [iStart, iEnd];
	}
}

KEXTHistoryPage.DateChooser.LastYear = function()
{
	KEXTHistoryPage.DateChooser.AbstractFilter.call(this);
	var _super = this.protectedMethod;
	
	this.getTag = function()
	{
		return "last-year";
	}
	
	this.getCaption = function()
	{
		return "去年";
	}
	
	this.getPeriod = function()
	{
		var oDate = new Date();
		oDate.setMonth(0);
		oDate.setDate(1);
		var iStart = _super.makeStartTime(_super.skipYears(oDate.getTime(), -1));
		var iEnd = _super.makeEndTime(_super.skipDays(oDate.getTime(), -1));
		return [iStart, iEnd];
	}
}

/** 分析主页 */
function KEXTAnalysisHomepage()
{
	KEXTAbstractNavigatorPane.call(this);
	
	var LocalStorageKey_Items = "com.kingdee.bos.ext.light.Analysis_preparedItems";
	var LocalStorageKey_Selecteds = "com.kingdee.bos.ext.light.Analysis_selectedItems";
	var LocalStorageKey_Date = "com.kingdee.bos.ext.light.Analysis_dateFilter";
	
	var _oRemoteCallImpl;
	
	var _sSubjectId;
	
	var _jqOwner;
	var _oItemPane;
	var _oChartPane;
	
	var _oDateChooser = new KEXTHistoryPage.DateChooser();
	var _arrFilterPeriods = [];//[[],[],...]
	var _sFilterQuickTag = "recent-year";
	
	var _funRequestFullScreen;
	
	var _mapItemDataCache = {};
	
	this.setRemoteImpl = function(oImpl)
	{
		_oRemoteCallImpl = oImpl;
	}
	
	/** funListener like: func(bFullScreen) */
	this.setRequestFullScreenListener = function(funListener)
	{
		_funRequestFullScreen = funListener;
	}
	
	this.createUi = function(jqOwner, sSubjectId)
	{
		_sSubjectId = sSubjectId;
		_jqOwner = jqOwner;

		var jqDate = $("<div>");
		jqDate.addClass("analysishome-datebutton");
		jqDate.click(doSelectDate);
		jqDate.appendTo(_jqOwner);
		
		_oItemPane = new KEXTAnalysisHomepage.ItemPane();
		_oItemPane.setMoreItemClickListener(doSelectMoreItems);
		_oItemPane.setItemSelectedListener(doSelectedItem);
		_oItemPane.getJqUi().appendTo(_jqOwner);
		
		_oChartPane = new KEXTAnalysisHomepage.ChartPane();
		_oChartPane.setPaintedListener(
			function()
			{
				KEXTProgressBar.Instance.hide();
			});
		_oChartPane.getJqUi().appendTo(_jqOwner);
		
		loadPersistentStatus();
	}
	
	this.destroy = function()
	{
		_oChartPane && _oChartPane.destroy();
	}
	
	var adjustHeight = function()
	{
		_oChartPane.getJqUi().height(_jqOwner.height() - _oItemPane.getJqUi().outerHeight());
	}

	var createRemoteFacade = function(funCallback, funErrorCallback)
	{
		return new KEXTFacade(_oRemoteCallImpl, funCallback, funErrorCallback);
	}

	var loadPersistentStatus = function()
	{
		var funStep4 = function()
		{
			setTimeout(
				function()
				{
					adjustHeight();
					clearCacheAndRefresh();
				}, 
				500);
		};
		var funStep3 = function()
		{
			loadSelectedItems(funStep4);
		};
		var funStep2 = function()
		{
			loadPreparedItems(funStep3);
		};
		loadDateFilter(funStep2);
	}
	
	var wrapLocalStorageKey = function(sKey)
	{
		return sKey + "_" + _sSubjectId;
	}
	
	var saveDateFilter = function()
	{
		var oPersistence = {};
		oPersistence["quickTag"] = _sFilterQuickTag;
		oPersistence["periods"] = _arrFilterPeriods;
		var sKey = wrapLocalStorageKey(LocalStorageKey_Date);
		KEXTLocalStorage.save(sKey, JSON.stringify(oPersistence));
	}
	
	var loadDateFilter = function(funAfter)
	{
		var sKey = wrapLocalStorageKey(LocalStorageKey_Date);
		KEXTLocalStorage.load(sKey, 
			function(sValue)
			{
				if(sValue)
				{
					var oPersistence = JSON.parse(sValue);
					_sFilterQuickTag = oPersistence["quickTag"];
					_arrFilterPeriods = oPersistence["periods"];
				}
				if(_sFilterQuickTag)
				{
					_arrFilterPeriods = [_oDateChooser.parseQuickTagToPeriod(_sFilterQuickTag)];
				}
				funAfter && funAfter();
			});
	}
	
	var savePreparedItems = function()
	{
		saveItems(_oItemPane.getModels(), LocalStorageKey_Items);
	}
	
	var loadPreparedItems = function(funAfter)
	{
		loadItems(LocalStorageKey_Items, 
			function(arrModel)
			{
				_oItemPane.setModels(arrModel);
			}, 
			funAfter);
	}
	
	var saveSelectedItems = function()
	{
		saveItems(_oItemPane.getSelectedModels(), LocalStorageKey_Selecteds);
	}
	
	var loadSelectedItems = function(funAfter)
	{
		loadItems(LocalStorageKey_Selecteds, 
			function(arrModel)
			{
				_oItemPane.setSelectedModels(arrModel);
			}, 
			funAfter);
	}
	
	var saveItems = function(arrModel, sPersistentKey)
	{
		var arrPersistence = [];
		for(var i = 0; i < arrModel.length; i++)
		{
			var oModel = arrModel[i];
			arrPersistence.push(oModel.toPersistentObject());
		}
		var sPersistence = JSON.stringify(arrPersistence);
		var sKey = wrapLocalStorageKey(sPersistentKey);
		KEXTLocalStorage.save(sKey, sPersistence);
	}
	
	var loadItems = function(sPersistentKey, funSetter, funAfter)
	{
		var sKey = wrapLocalStorageKey(sPersistentKey);
		KEXTLocalStorage.load(sKey, 
			function(sValue)
			{
				var arrModel = [];
				if(sValue)
				{
					var arrPersistence = JSON.parse(sValue);
					for(var i = 0; i < arrPersistence.length; i++)
					{
						var oPersistence = arrPersistence[i];
						var oModel = new KEXTAnalysisHomepage.ItemModel();
						oModel.fromPersistentObject(oPersistence);
						arrModel.push(oModel);
					}
				}
				funSetter(arrModel);
				funAfter && funAfter();
			});
	}
	
	var doSelectDate = function(evt)
	{
		var jqBtn = $(evt.target);
		var funAction = function(arrPeriods)
		{
			jqBtn.animate({"right": jqBtn.data("right")}, "fast");
			_oDateChooser.getJqUi().animate({"left": "100%"}, "fast");
			if(arrPeriods && arrPeriods.length > 0)
			{
				_arrFilterPeriods = arrPeriods;
				_sFilterQuickTag = _oDateChooser.getQuickTag();
				clearCacheAndRefresh();
				saveDateFilter();
			}
			KEXTUtil.bindHardwareBackwardActionForLight(funAction, false);
			_funRequestFullScreen && _funRequestFullScreen(false);
		};
		_funRequestFullScreen && _funRequestFullScreen(true);
		KEXTUtil.bindHardwareBackwardActionForLight(funAction, true);
		
		_oDateChooser.setQuickTag(_sFilterQuickTag);
		!_sFilterQuickTag && _oDateChooser.setPeriods(_arrFilterPeriods);
		if(!jqBtn.data("isUiCreated"))
		{
			jqBtn.data("isUiCreated", true);
			_oDateChooser.setActionListener(funAction);
			_oDateChooser.getJqUi().addClass("history-datefilter");
			_jqOwner.append(_oDateChooser.getJqUi());
		}
		_oDateChooser.getJqUi().css("left", "100%");
		_oDateChooser.getJqUi().animate({"left": ""}, "fast");
		jqBtn.data("right", jqBtn.css("right"));
		jqBtn.animate({"right": "100%"}, "fast");
	}
	
	var doSelectMoreItems = function(arrOriModels)
	{
		var funAction = function(arrNewModels)
		{
			jqMoreItemSelector.animate(
				{
					"left": _jqOwner.width()
				},
				"fast",
				function()
				{
					KEXTUtil.bindHardwareBackwardActionForLight(funAction, false);
					_funRequestFullScreen && _funRequestFullScreen(false);
					jqMoreItemSelector.remove();
				});
			if(arrNewModels)//no object means cancel
			{
				_oChartPane.destroy();
				_oChartPane.setModel(null);
				_oItemPane.setModels(arrNewModels);
				savePreparedItems();
			}
		};
		
		_funRequestFullScreen && _funRequestFullScreen(true);
		KEXTUtil.bindHardwareBackwardActionForLight(funAction, true);
		
		var oMoreItemSelector = new KEXTAnalysisHomepage.MoreItemSelector();
		oMoreItemSelector.setOriSelected(arrOriModels);
		oMoreItemSelector.setCloseListener(funAction);
		
		var jqMoreItemSelector = oMoreItemSelector.getJqUi();
		jqMoreItemSelector.css({"left": _jqOwner.width()});
		jqMoreItemSelector.appendTo(_jqOwner);
		jqMoreItemSelector.animate({"left": 0}, "fast");

		remoteGetAllSummaryNames(oMoreItemSelector);
	}
	
	var remoteGetAllSummaryNames = function(oMoreItemSelector)
	{
		var oFacade = createRemoteFacade(
			function(arrData)
			{
				oMoreItemSelector.setPreparedItems(parseJsonToModel(arrData));
			});
		oFacade.getAllSummaryNames();		
	}
	
	var parseJsonToModel = function(arrData)
	{
		var arrPreparedItems = [];
		for(var i = 0; i < arrData.length; i++)
		{
			var oOneReport = arrData[i];
			var sReportId = oOneReport["reportId"];
			var sReportName = oOneReport["reportName"];
			var arrOrgs = oOneReport["orgs"];
			var arrSummaryNames = oOneReport["summaryNames"];
					
			var arrModel = [];
			var oPrepared = {"reportName": sReportName, "models": arrModel};
			for(var j = 0; j < arrOrgs.length; j++)
			{
				var sOrgId = arrOrgs[j]["id"];
				var sOrgName = arrOrgs[j]["name"];
				for(var k = 0; k < arrSummaryNames.length; k++)
				{
					var sSummaryName = arrSummaryNames[k];
					var oModel = new KEXTAnalysisHomepage.ItemModel(sSummaryName, sReportId, sOrgId);
					oModel.setDescription(arrOrgs.length > 1 ? sOrgName : null);
					arrModel.push(oModel);
				}
			}
			arrPreparedItems.push(oPrepared);
		}
		return arrPreparedItems;
	}
	
	var paintChart = function()
	{
		KEXTProgressBar.Instance.show("请稍候...", true);
		setTimeout(
			function()
			{
				var oChartModel = new KEXTAnalysisHomepage.ChartModel();
				oChartModel.mergeDataFromJson(_oItemPane.getSelectedModels(), _mapItemDataCache);
				_oChartPane.setModel(oChartModel);
				KEXTProgressBar.Instance.hide();
			}, 
			10);
	}
	
	var doSelectedItem = function(bSelected, oModel)
	{
		if(bSelected && !_mapItemDataCache[oModel])
		{
			remoteGetOneReportSummaries(oModel, paintChart);
		}
		else
		{
			paintChart();
		}
		saveSelectedItems();
	}
	
	var remoteGetOneReportSummaries = function(oModel, funSeriesRun)
	{
		var sJsonDatePeriods = JSON.stringify(_arrFilterPeriods);
		var oFacade = createRemoteFacade(
			function(oData)
			{
				cacheItemJsonData(oModel.getReportId(), oModel.getOrgId(), oData);
				funSeriesRun();
			});
		oFacade.getHistorySummaries(oModel.getReportId(), oModel.getOrgId(), sJsonDatePeriods);
	}
	
	var cacheItemJsonData = function(sReportId, sOrgId, oResponseData)
	{
		var arrDate = oResponseData["date"];
		for(var i = 0; i < arrDate.length; i++)//只精确到日，便于不同报表的合并
		{
			var iDate = arrDate[i];
			var oDate = new Date(iDate);
			oDate = new Date(oDate.getFullYear() + "/" + (oDate.getMonth() + 1) + "/" + oDate.getDate());
			iDate = oDate.getTime();
			arrDate[i] = iDate;
		}
		
		var arrSummaries = oResponseData["summaries"];
		var arrItemModel = _oItemPane.getModels();
		for(var i = 0; i < arrItemModel.length; i++)//同一组织同一报表的其它指标一并获取
		{
			var oItemModel = arrItemModel[i];
			if(oItemModel.getReportId() != sReportId || oItemModel.getOrgId() != sOrgId)
			{
				continue;
			}
			var oSummary = null;
			for(var j = 0; j < arrSummaries.length; j++)
			{
				oSummary = arrSummaries[j];
				if(oItemModel.getName() == oSummary["name"])
				{
					break;
				}
				oSummary = null;
			}
			if(!oSummary)//容错
			{
				oSummary = {"name": oItemModel.getName(), "format":"", "values": []};
			}
			oSummary["date"] = arrDate;//改变了json的结构
			_mapItemDataCache[oItemModel] = oSummary;
		}
	}
	
	var clearCacheAndRefresh = function()
	{
		_mapItemDataCache = {};
		serialUpdateAllSelectedItem();
	}
	
	var serialUpdateAllSelectedItem = function()
	{
		var arrSelectedItemModel = _oItemPane.getSelectedModels();
		var bGoOnRemote = false;
		for(var i = 0; i < arrSelectedItemModel.length; i++)
		{
			var oItemModel = arrSelectedItemModel[i];
			if(!_mapItemDataCache[oItemModel])
			{
				bGoOnRemote = true;
				remoteGetOneReportSummaries(oItemModel, serialUpdateAllSelectedItem);
				break;
			}
		}
		if(!bGoOnRemote)
		{
			paintChart();
		}
	}
}

KEXTAnalysisHomepage.ItemPane = function()
{
	var _arrModels;
	var _jqUi;
	var _oItemsTabContainer;
	var _jqAddMore;
	
	var _funMoreItemClick;
	var _funItemSelected;
	
	this.getJqUi = function()
	{
		if(!_jqUi)
		{
			initUi();
		}
		return _jqUi;
	}
	
	this.setModels = function(arrModels)
	{
		_arrModels = arrModels;
		makeUniqueName();
		if(_jqUi)
		{
			updateUi();
		}
	}
	
	this.getModels = function()
	{
		return _arrModels;
	}
	
	this.setSelectedModels = function(arrModels)
	{
		var arrItems = _jqUi.find(".analysishome-selector-item");
		for(var i = 0; i < arrItems.length; i++)
		{
			var jqItem = $(arrItems[i]);
			var oModel = jqItem.data("model");
			if(!oModel)
			{
				continue;//The item [add more]
			}
			var bSelected = false;
			for(var j = 0; j < arrModels.length; j++)
			{
				if(oModel.equals(arrModels[j]))
				{
					bSelected = true;
					break;
				}
			}
			setItemSelected(jqItem, bSelected);
		}
	}
	
	this.getSelectedModels = function()
	{
		var arrItems = _jqUi.find(".analysishome-selector-item_selected");
		var arrModels = [];
		for(var i = 0; i < arrItems.length; i++)
		{
			arrModels.push($(arrItems[i]).data("model"));
		}
		return arrModels;
	}
	
	/** funListener like: func(arrModels) */
	this.setMoreItemClickListener = function(funListener)
	{
		_funMoreItemClick = funListener;
	}
	
	/** funListener like: func(bSelected, oModel) */
	this.setItemSelectedListener = function(funListener)
	{
		_funItemSelected = funListener;
	}
	
	var initUi = function()
	{
		_jqUi = $("<div>");
		_jqUi.addClass("analysishome-selector");
		
		_oItemsTabContainer = new kdlight.SwipableTabContainer();
		_oItemsTabContainer.setDotDotDotContext(6, 4, 2);
		var jqTab = _oItemsTabContainer.getJqUi();
		jqTab.css("width", "320px");
		jqTab.css("height", "100%");
		_jqUi.append(jqTab);
		
		if(_arrModels)
		{
			updateUi();
		}
	}
	
	var updateUi = function()
	{
		_oItemsTabContainer.clearAllTabs();
		var jqTabPane;
		for(var i = 0; i < _arrModels.length; i++)
		{
			var iIndexForItem = i % 4;
			if(iIndexForItem == 0)
			{
				jqTabPane = $("<div>");
				_oItemsTabContainer.addTabContent(jqTabPane);
			}
			var jqItem = createItem(_arrModels[i]);
			jqItem.addClass("analysishome-selector-item_" + iIndexForItem);
			jqTabPane.append(jqItem);
		}
		
		var iIndexForAddMore = _arrModels.length % 4;
		if(iIndexForAddMore == 0)
		{
			jqTabPane = $("<div>");
			_oItemsTabContainer.addTabContent(jqTabPane);
		}
		_jqAddMore = $("<div>");
		_jqAddMore.addClass("analysishome-selector-item");
		_jqAddMore.addClass("analysishome-selector-item_" + iIndexForAddMore);
		if(_arrModels.length == 0)
		{
			_jqAddMore.text("点击这里添加指标");
		}
		else
		{
			_jqAddMore.text("＋");
			_jqAddMore.addClass("analysishome-selector-item-addmore");
		}
		bindItemEvent(_jqAddMore, doAddMore);
		jqTabPane.append(_jqAddMore);
	}
	
	var createItem = function(oModel)
	{
		var jqItem = $("<div>");
		jqItem.data("model", oModel);
		jqItem.text(oModel.getUniqueName());
		jqItem.addClass("analysishome-selector-item");
		if(oModel.getDescription())
		{
			var jqSubhead = $("<span>");
			jqSubhead.text(oModel.getDescription());
			jqSubhead.addClass("analysishome-selector-item-subhead");
			jqSubhead.appendTo(jqItem);
			jqItem.addClass("analysishome-selector-item_multiline");
		}
		bindItemEvent(jqItem, doItemClick);
		return jqItem;
	}
	
	var bindItemEvent = function(jqItem, funClick)
	{
		jqItem.on("vmousedown", function(){jqItem.addClass("analysishome-selector-item_press")});
		jqItem.on("vmouseup", function(){jqItem.removeClass("analysishome-selector-item_press")});
		jqItem.on("vmousemove", function(){jqItem.removeClass("analysishome-selector-item_press")});
		jqItem.on("click", function(){funClick(jqItem)});
	}
	
	var doAddMore = function(jqItem)
	{
		_funMoreItemClick && _funMoreItemClick(_arrModels);
	}
	
	var doItemClick = function(jqItem)
	{
		var bSelected = (jqItem.data("selected") ? true : false);
		bSelected = !bSelected;
		setItemSelected(jqItem, bSelected);
		_funItemSelected && _funItemSelected(bSelected, jqItem.data("model"));
	}
	
	var setItemSelected = function(jqItem, bSelected)
	{
		if(bSelected)
		{
			jqItem.addClass("analysishome-selector-item_selected");
		}
		else
		{
			jqItem.removeClass("analysishome-selector-item_selected");
		}
		jqItem.data("selected", bSelected);
	}
	
	var makeUniqueName = function()
	{
		var INDEX = "①②③④⑤⑥⑦⑧⑨⑩⑾⑿⒀⒁⒂⒃⒄⒅⒆⒇";
		var mapChecker = {};
		for(var i = 0; i < _arrModels.length; i++)
		{
			var oModel = _arrModels[i];
			var sName = oModel.getName();
			var arrDuplicate = mapChecker[sName];
			if(!arrDuplicate)
			{
				arrDuplicate = [];
				mapChecker[sName] = arrDuplicate;
			}
			arrDuplicate.push(oModel);
		}
		for(var sKey in mapChecker)
		{
			var arrDuplicate = mapChecker[sKey];
			if(arrDuplicate.length > 1)
			{
				for(var i = 0; i < arrDuplicate.length; i++)
				{
					var oModel = arrDuplicate[i];
					oModel.setUniqueName(INDEX.charAt(i % 20) + oModel.getName());
				}
			}
		}
	}
}

KEXTAnalysisHomepage.ItemModel = function(sName, sReportId, sOrgId)
{
	var _sName = sName;
	var _sReportId = sReportId;
	var _sOrgId = sOrgId;
	var _sDescription;
	
	var _sUniqueName;//当图表category时名称不可重复
	
	this.getName = function()
	{
		return _sName;
	}
	
	this.getReportId = function()
	{
		return _sReportId;
	}
	
	this.getOrgId = function()
	{
		return _sOrgId;
	}
	
	this.setDescription = function(sDesc)
	{
		_sDescription = sDesc;
	}
	
	this.getDescription = function()
	{
		return _sDescription;
	}
	
	this.setUniqueName = function(sUniqueName)
	{
		_sUniqueName = sUniqueName;
	}
	
	this.getUniqueName = function()
	{
		return _sUniqueName ? _sUniqueName : _sName;
	}
	
	this.equals = function(oAnother)
	{
		if(!oAnother)
		{
			return false;
		}
		return (_sReportId == oAnother.getReportId() 
			&& _sOrgId == oAnother.getOrgId() 
			&& _sName == oAnother.getName());
	}
	
	this.toString = function()
	{
		return _sName + "_|_" + _sReportId + "_|_" + _sOrgId;
	}
	
	this.toPersistentObject = function()
	{
		var oJson = {};
		oJson["name"] = _sName;
		oJson["reportId"] = _sReportId;
		oJson["orgId"] = _sOrgId;
		oJson["description"] = _sDescription;
		return oJson;
	}
	
	this.fromPersistentObject = function(oJson)
	{
		_sName = oJson["name"];
		_sReportId = oJson["reportId"];
		_sOrgId = oJson["orgId"];
		_sDescription = oJson["description"];
	}
}

KEXTAnalysisHomepage.MoreItemSelector = function()
{
	var _jqUi;
	var _jqPane;
	var _jqCount;
	var _oToolbar;
	var _funClose;
	var _arrModels;
	
	/** funListener like func(arrModel)*/
	this.setCloseListener = function(funListener)
	{
		_funClose = funListener;
	}
	
	this.setOriSelected = function(arrOriModels)
	{
		_arrModels = arrOriModels;
		if(_jqPane && _jqPane.children().length > 0)
		{
			updateSelected();
		}
	}
	
	/** [{"reportName": "xxx", "models": [oItemModel,...]}] */
	this.setPreparedItems = function(arrPreparedItems)
	{
		updateMainPane(arrPreparedItems);
		if(_arrModels)
		{
			updateSelected();
		}
	}
	
	this.getJqUi = function()
	{
		if(!_jqUi)
		{
			initUi();
		}
		return _jqUi;
	}
	
	var initUi = function()
	{
		_jqUi = $("<div>");
		_jqUi.addClass("analysishome-moreitem-page");
		
		var jqMain = $("<div>");
		jqMain.css("z-index", 1);
		jqMain.css("z-index", 1);
		jqMain.addClass("analysishome-moreitem-mainpane");

		_jqPane = $("<div>");
		_jqPane.css("position", "absolute");
		_jqPane.width("100%")
		_jqPane.height("100%");
		_jqPane.css("overflow", "auto");
		KEXTUtil.setSimScrollbar(_jqPane, jqMain);
		
		_oToolbar = new kdlight.Toolbar();
		_oToolbar.getJqUi().css("z-index", 2);
		_oToolbar.addButton(kdlight.Toolbar.POS_RIGHT, "btnClearAll", "全部清除", doClearAll);
		
		var oConfirmBar = new kdlight.ConfirmBar();
		oConfirmBar.getJqUi().css("z-index", 2);
		oConfirmBar.setActionListener(
			function(bOk)
			{
				var arrSelectedModels = null;
				if(bOk)
				{
					arrSelectedModels = pickSelected();
				}
				_funClose(arrSelectedModels);
			});
		
		_jqCount = $("<span>");
		_jqCount.addClass("analysishome-moreitem-count");
		_jqCount.appendTo(_oToolbar.getJqUi());
		
		jqMain.append(_jqPane);
		_jqUi.append(_oToolbar.getJqUi());
		_jqUi.append(jqMain);
		_jqUi.append(oConfirmBar.getJqUi());		

		_jqPane.click(doCheck);
	}
	
	var updateMainPane = function(arrPreparedItems)
	{
		var jqFragment = $(document.createDocumentFragment());
		if(!arrPreparedItems || arrPreparedItems.length == 0)
		{
			_oToolbar.getJqUi().css("display", "none");
			var jqPrompt = createReportTitle("暂无可供分析的指标");
			jqPrompt.appendTo(jqFragment);
			var jqDetail = $("<div>");
			jqDetail.css({
				"color": "#888",
				"font-size": "14px",
				"line-height": "20px",
				"white-space": "pre-wrap",
				"padding": "20px"
			});
			jqDetail.text("数据从哪里来？\r\n" + 
				"　　移动报表的“预警与推送”功能能够定期向您发送相关指标消息，其中的数值指标将保存为历史数据，以供分析。");
			jqDetail.appendTo(jqFragment);
		}
		else
		{
			_oToolbar.getJqUi().css("display", "block");
			for(var i = 0; i < arrPreparedItems.length; i++)
			{
				var oPrepared = arrPreparedItems[i];
				var sReportName = oPrepared["reportName"];
				jqFragment.append(createReportTitle(sReportName));
				var arrModels = oPrepared["models"];
				for(var j = 0; j < arrModels.length; j++)
				{
					var oModel = arrModels[j];
					jqFragment.append(createItem(oModel));
				}
			}
		}
		_jqPane.children().remove();
		_jqPane.append(jqFragment);
	}
	
	var updateSelected = function()
	{
		var arrItems = _jqPane.find(".analysishome-moreitem-item");
		for(var i = 0; i < _arrModels.length; i++)
		{
			var oModel = _arrModels[i];
			for(var j = 0; j < arrItems.length; j++)
			{
				var jqItem = $(arrItems[j]);
				if(oModel.equals(jqItem.data("model")))
				{
					addCheck(jqItem);
					break;
				}
			}
		}
	}
	
	var createReportTitle = function(sTitle)
	{
		var jqTitle = $("<div>");
		jqTitle.addClass("analysishome-moreitem-title");
		jqTitle.text(sTitle);
		return jqTitle;
	}
	
	var createItem = function(oModel)
	{
		var jqItem = $("<div>");
		jqItem.text(oModel.getName());
		jqItem.addClass("analysishome-selector-item");
		jqItem.addClass("analysishome-moreitem-item");
		if(oModel.getDescription())
		{
			var jqSubhead = $("<span>");
			jqSubhead.text(oModel.getDescription());
			jqSubhead.addClass("analysishome-selector-item-subhead");
			jqSubhead.appendTo(jqItem);
			jqItem.addClass("analysishome-selector-item_multiline");
		}
		jqItem.data("model", oModel);
		jqItem.on("vmousedown", function(){jqItem.addClass("analysishome-selector-item_press")});
		jqItem.on("vmouseup", function(){jqItem.removeClass("analysishome-selector-item_press")});
		jqItem.on("vmousemove", function(){jqItem.removeClass("analysishome-selector-item_press")});
		return jqItem;
	}
	
	var doClearAll = function()
	{
		var arrCheck = _jqPane.find(".analysishome-moreitem-check");
		arrCheck.remove();
		updateCount(0);
	}
	
	var doCheck = function(evt)
	{
		var jqTarget = $(evt.target);
		while(!jqTarget.hasClass("analysishome-moreitem-item") && jqTarget[0] != evt.currentTarget)
		{
			jqTarget = jqTarget.parent();
		}
		if(jqTarget[0] != evt.currentTarget)
		{
			addCheck(jqTarget);
		}
	}
	
	var addCheck = function(jqItem)
	{
		var jqCheck = jqItem.find(".analysishome-moreitem-check");
		if(jqCheck && jqCheck.length)
		{
			jqCheck.remove();
		}
		else
		{
			jqCheck = $("<div>");
			jqCheck.addClass("analysishome-moreitem-check");
			jqCheck.text("√");
			jqCheck.appendTo(jqItem);
		}
		updateCount();
	}
	
	var updateCount = function(iCount)
	{
		if(!iCount && iCount !== 0)
		{
			var arrCheck = _jqPane.find(".analysishome-moreitem-check");
			iCount = arrCheck.length;
		}
		if(iCount == 0)
		{
			_jqCount.text("未选择指标");
		}
		else
		{
			_jqCount.text("已选择 " + iCount + " 项指标");
		}
	}
	
	var pickSelected = function()
	{
		var arrModel = [];
		var arrCheck = _jqPane.find(".analysishome-moreitem-check");
		for(var i = 0; i < arrCheck.length; i++)
		{
			var jqCheck = $(arrCheck[i]);
			var jqItem = jqCheck.parent();
			arrModel.push(jqItem.data("model"));
		}
		return arrModel;
	}
}

KEXTAnalysisHomepage.ChartModel = function()
{
	var _arrDate;//[k个]
	var _arrItemModel;//选中展现的count个
	var _arrFormat;//[k个]
	var _arrItemValues;//[[k个], [k个], ... count个]

	this.getDateArray = function()
	{
		return _arrDate;
	}
	
	this.getCount = function()
	{
		return _arrItemModel.length;
	}
	
	this.getName = function(iIdx)
	{
		var oItemModel = _arrItemModel[iIdx];
		return oItemModel.getUniqueName();
	}
	
	this.getFormat = function(iIdx)
	{
		return _arrFormat[iIdx];
	}
	
	this.getValues = function(iIdx)
	{
		return _arrItemValues[iIdx];
	}

	//将mapItemJsonData中如下结构：
	//  item1:{date:[date1,date3,...], values:[value1A,value1B,...]}
	//  item2:{date:[date3,date4,...], values:[value2A,value2B,...]}
	//  item3:{date:[date1,date2,date3...], values:[value3A,value3B,value3C...]}
	//转成：
	//arrMergedDate    arrValueQueue
	//    date1               {item1:value1A,                         item3:value3A}
	//    date2               {                                                 item3:value3B}
	//    date3               {item1:value1B, item2:value2A, item3:value3C}
	//    date4               {                        item2:value2B                         }
	//    ...
	this.mergeDataFromJson = function(arrSelectedItemModel, mapItemJsonData)
	{
		var arrCursor = [];
		for(var i = 0; i < arrSelectedItemModel.length; i++)
		{
			arrCursor[i] = 0;
		}
		var arrMergedDate = [];
		var arrValueQueue = [];//下标与arrMergedDate对应，每个元素是map：oItemModel->value
		while(true)
		{
			var iCompareDate = Number.MAX_VALUE;
			var iMinDateIdx = -1;//找出各队头日期最小的一个
			for(var i = 0; i < arrSelectedItemModel.length; i++)
			{
				var iCursor = arrCursor[i];
				var oItemModel = arrSelectedItemModel[i];
				var oJson = mapItemJsonData[oItemModel];
				var arrDate = oJson["date"];
				if(iCursor < arrDate.length && arrDate[iCursor] < iCompareDate)
				{
					iMinDateIdx = i;
					iCompareDate = arrDate[iCursor];
				}
			}
			if(iMinDateIdx == -1)
			{
				break;
			}
			else//加入到合并队列中
			{
				var iCursor = arrCursor[iMinDateIdx];
				var oItemModel = arrSelectedItemModel[iMinDateIdx];
				var oJson = mapItemJsonData[oItemModel];
				var arrDate = oJson["date"];
				var iDate = arrDate[iCursor];
				var iMergedTail = arrMergedDate.length - 1;
				var mapValueAtDate;
				if(iMergedTail >= 0 && arrMergedDate[iMergedTail] == iDate)
				{
					mapValueAtDate = arrValueQueue[iMergedTail];
				}
				else
				{
					arrMergedDate.push(iDate);
					iMergedTail++;
					mapValueAtDate = {};
					arrValueQueue[iMergedTail] = mapValueAtDate;
				}
				mapValueAtDate[oItemModel] = oJson["values"][iCursor];
				arrCursor[iMinDateIdx] = iCursor + 1;
			}
		}
		_arrDate = arrMergedDate;
		_arrItemModel = arrSelectedItemModel;
		keepFormat(mapItemJsonData);
		chansposValues(arrValueQueue);
	}
	
	var keepFormat = function(mapItemJsonData)
	{
		_arrFormat = [];
		for(var i = 0; i < _arrItemModel.length; i++)
		{
			var oItemModel = _arrItemModel[i];
			var oJson = mapItemJsonData[oItemModel];
			_arrFormat.push(oJson["format"]);
		}
	}

	var chansposValues = function(arrValueQueue)
	{
		_arrItemValues = [];
		for(var i = 0; i < _arrItemModel.length; i++)
		{
			var oItemModel = _arrItemModel[i];
			var arrValue = [];
			for(var j = 0; j < _arrDate.length; j++)
			{
				var mapValue = arrValueQueue[j];
				var fValue = mapValue[oItemModel];
				if(fValue || fValue == 0)
				{
					arrValue[j] = fValue;
				}
				else
				{
					arrValue[j] = null;
				}
			}
			_arrItemValues.push(arrValue);
		}
	}
}

KEXTAnalysisHomepage.ChartPane = function()
{
	var _this = this;
	var _sChartOwnerId = "extlight_analysis_chart_owner";
	var _jqUi;
	var _oChart;
	var _funPaintedListener;
	
	this.getJqUi = function()
	{
		if(!_jqUi)
		{
			initUi();
		}
		return _jqUi;
	}
	
	this.setPaintedListener = function(funListener)
	{
		_funPaintedListener = funListener;
	}
	
	this.setModel = function(oChartModel)
	{
		if(!_oChart)
		{
			createChart();
		}
		var oFusionChartData;
		if(oChartModel)
		{
			oFusionChartData = createChartData(oChartModel);
		}
		else
		{
			oFusionChartData = {"chart": {}};
		}
		_oChart.setJSONData(oFusionChartData);
		updateDisplay();
	}
	
	this.destroy = function()
	{
		_jqUi.children().remove();
		destroyChart();
	}
	
	var destroyChart = function()
	{
		if(_oChart)
		{
			_oChart.dispose();
			_oChart = null;
		}		
	}
	
	var initUi = function()
	{
		_jqUi = $("<div>");
		_jqUi.on("click", function(){});//fix部分android点击时高亮画偏
		_jqUi.attr("id", _sChartOwnerId);
		_jqUi.addClass("analysishome-chartpane");
	}
	
	var createChart = function()
	{
		var sId = "chartForHistoryAnalysis";
		var sChartType = "MSCombiDY2D";
		_oChart = new FusionCharts(
			{
				type: sChartType, 
				id: sId, 
				width: "100%", 
				height: "100%"
			});
		_oChart.setTransparent(true);
		_oChart.addEventListener("DrawComplete" , 
			function(eventObject, argumentsObject)
			{
				doAfterChartPainted();
			});
		_oChart.configure("ChartNoDataText", "请选择上列指标进行历史数据的趋势和相关性分析。");
	}

	var updateDisplay = function()
	{
		_oChart.render(_sChartOwnerId);
	}
		
	var doAfterChartPainted = function() 
	{
		var jqRects = _jqUi.find("rect");
		for(var i = 0; i < jqRects.length; i++)
		{
			var jqRect = $(jqRects[i]);
			if(parseFloat(jqRect.css("stroke-width")) < 0.001)
			{
				jqRect.css("stroke-width", 0);
				jqRect.css("stroke", "rgba(0,0,0,0)");
			}
		}
		_funPaintedListener && _funPaintedListener();
	}
	
	var createChartData = function(oChartModel)
	{
		var arrDate = oChartModel.getDateArray();
		var iCategoryCount = arrDate.length;//太长出滚动条? "ScrollCombiDY2D"

		var arrPreparedColors = KEXTAnalysisHomepage.ChartPane.ChartConfigCreator.paletteColors();
		var arrColors = [];
		
		var arrYAxis = divideYAxisIntelligently(oChartModel);
		var arrDataSets = [];
		var bShowYAxis;
		var bShowSecondaryYAxis;
		var bPercentAtYAxis;
		var bPercentAtSecondaryYAxis;
		for(var i = 0, c = oChartModel.getCount(); i < c; i++)
		{
			var sName = oChartModel.getName(i);
			var sFormat = oChartModel.getFormat(i);			
			var bPercent = (sFormat && sFormat.indexOf("%") >= 0);
			arrColors.push(arrPreparedColors[i % arrPreparedColors.length]);

			var oDataSet = {};
			oDataSet["seriesname"] = sName;
			oDataSet["renderas"] = (bPercent ? "line" : "column");
			oDataSet["parentyaxis"] = arrYAxis[i];
			if(arrYAxis[i] == "P")
			{
				bShowYAxis = true;
				bPercentAtYAxis = bPercent;
			}
			else if(arrYAxis[i] == "S")
			{
				bShowSecondaryYAxis = true;
				bPercentAtSecondaryYAxis = bPercent;
			}
			
			var arrValues = oChartModel.getValues(i);
			var arrData = [];
			for(var j = 0; j < iCategoryCount; j++)
			{
				var fValue = arrValues[j];
				arrData.push({"value": (fValue == null ? null : (bPercent ? fValue * 100 : fValue))});
			}
			oDataSet["data"] = arrData;
			arrDataSets.push(oDataSet);
		}
		
		var sDateFormatString = formatDateIntelligently(arrDate, iCategoryCount);
		var arrCategory = [];
		for(var k = 0; k < iCategoryCount; k++)
		{
			arrCategory.push({"label": KEXTNumberFormater.format(arrDate[k], sDateFormatString)});
		}

		var oConfig = KEXTAnalysisHomepage.ChartPane.ChartConfigCreator.create();
		if(bShowYAxis)
		{
			if(bPercentAtYAxis)
			{
				oConfig["numberSuffix"] = "%";	
			}
		}
		else
		{
			oConfig["showLimits"] = 0;
			oConfig["showDivLineValue"] = 0;
			oConfig["chartLeftMargin"] = 36;
		}
		if(bShowSecondaryYAxis)
		{
			if(bPercentAtSecondaryYAxis)
			{
				oConfig["sNumberSuffix"] = "%";	
			}
		}
		else
		{
			oConfig["showSecondaryLimits"] = 0;
			oConfig["showDivLineSecondaryValue"] = 0;
			oConfig["chartRightMargin"] = 10;
		}
		oConfig["paletteColors"] = arrColors.join(",");
		var oModel = {
			"chart": oConfig,
			"categories": [{"category": arrCategory}],
			"dataset": arrDataSets
		};
		return oModel;
	}
	
	//智能分析日期的显示格式(Ｘ轴的值)，返回格式化串
	var formatDateIntelligently = function(arrDate, iLength)
	{
		var iFirstYear;
		var bSameYear = true;
		var mapDay = {};
		var bDifferentDay = true;
		var mapMonth = {};
		var iMaxDay, iMinDay;
		var bDifferentMonth = true;
		for(var i = 0; i < iLength; i++)
		{
			var oDate = new Date(arrDate[i]);
			var iYear = oDate.getFullYear();
			var iDay = oDate.getDate();
			var sMonth = iYear + "-" + oDate.getMonth();
			var sDay = sMonth + "-" + iDay;
			if(i == 0)
			{
				iFirstYear = iYear;
				mapDay[sDay] = true;
				mapMonth[sMonth] = true;
				iMaxDay = iDay;
				iMinDay = iDay;
				continue;
			}
			if(iFirstYear != oDate.getFullYear())
			{
				bSameYear = false;
			}
			if(mapDay[sDay])
			{
				bDifferentDay = false;
			}
			if(mapMonth[sMonth])
			{
				bDifferentMonth = false;
			}
			iMaxDay = (iMaxDay < iDay ? iDay : iMaxDay);
			iMinDay = (iMinDay > iDay ? iDay : iMinDay);
		}
		// if(bDifferentMonth && (iMaxDay - iMinDay) < 4)//月各不同且日相近，只显示到月
		// {
			// return (bSameYear ? "m月" : "yy年m月");
		// }
		// else
		{
			if(bSameYear)//年相同，不显示年 //日各不同，不显示时间
			{
				// return (bDifferentDay ? "mm-dd" : "mm-dd hh:mm");
				return "m月d日";
			}
			else
			{
				// return (bDifferentDay ? "yyyy-mm-dd" : "yy-mm-dd hh:mm");
				return "yyyy-mm-dd";
			}
		}
	}
	
	//智能区分指标在左边主Y轴或右边副Y轴，返回与指标对应的数组，值为P或Ｓ
	var divideYAxisIntelligently = function(oChartModel)
	{
		var arrAxis = [];//分主副轴P、S
		var arrTypes = [];//分类1、2、3
		var mapFormatToType = {};//相同格式化串记为同一类
		var iTypeByFormat = 0;
		var bHavePercent = false;
		var bOnlyHavePercent = true;
		for(var i = 0, c = oChartModel.getCount(); i < c; i++)
		{
			var sFormat = oChartModel.getFormat(i);
			if(sFormat && sFormat.indexOf("%") >= 0)
			{
				bHavePercent = true;
				arrAxis[i] = "S";//百分比默认在副轴
			}
			else
			{
				bOnlyHavePercent = false;
				arrAxis[i] = "P";
			}
			
			if(!mapFormatToType[sFormat])
			{
				mapFormatToType[sFormat] = ++iTypeByFormat;
			}
			arrTypes.push(mapFormatToType[sFormat]);
		}

		if(iTypeByFormat == 1)//只有一类，全在主Y轴
		{
			if(bHavePercent)
			{
				for(var i = 0, c = oChartModel.getCount(); i < c; i++)
				{
					arrAxis[i] = "P";//修改掉前文的“百分比默认在副轴”，改成在主轴
				}
			}
		}
		else if(iTypeByFormat == 2)//两类，各一轴
		{
			if(!bHavePercent || (bHavePercent && bOnlyHavePercent))
			{
				for(var i = 0, c = oChartModel.getCount(); i < c; i++)
				{
					arrAxis[i] = (arrTypes[i] == 1 ? "P" : "S");
				}
			}
		}
		else
		{
			//多类，百分比在副轴其余主轴；无百分比则都在主轴
		}
		return arrAxis;
	}
}

KEXTAnalysisHomepage.ChartPane.ChartConfigCreator = new (function()
{
	var _arrPalette = ["f6c223", "8dbb05", "ff8f48", "028f8f", "d64747", "8f478f", "598627", "b4ab02", "018ed6", "9d0a0f", "a287bf", "b2d9f9"];
	
	this.paletteColors = function()
	{
		return _arrPalette;
	}
	
	this.create = function()
	{
		var oMap =
		{
			animation: 0,
			bgAlpha: 0,
			chartLeftMargin: 8,
			chartRightMargin: 8,
			canvasPadding: 2,
			
			showBorder: 0,
			showLabels: 1,
			showValues: 0,
			
			canvasBorderThickness: 1,
			canvasBorderColor: "c4d9ff",
			canvasBgColor: "e5ecf9",
			alternateHGridColor: "cedefa",
			divLineThickness: 0,
			
			showShadow: 1,
			plotBorderAlpha: 0,
			
			connectNullData: 0,
			
			formatNumberScale: 0,
			formatNumber: 1,
			forceDecimals: 0,
			sformatNumberScale: 0,
			sformatNumber: 1,
			sforceDecimals: 0,
						
			labelDisplay: "Rotate",
			slantLabels: 1,
			
			legendBgAlpha: 0,
			legendBorderAlpha: 0,
			legendPosition: "BOTTOM"
		}
		return oMap;
	}
})();
