
//扩展报表轻应用公共模块
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖： 
//jQuery 2.1.0 (http://jquery.com)
//jQueryMobile 1.4.2 (http://jquerymobile.com)
//
String.prototype.width = function(font) {
  var f = font || '12px arial',
      o = $('<div>' + this + '</div>')
            .css({'position': 'absolute', 'float': 'left', 'white-space': 'nowrap', 'visibility': 'hidden', 'font': f})
            .appendTo($('body')),
      w = o.width();

  o.remove();

  return w;
}
/**
 * 远程调用实现此接口 
 */
function KEXTAbstractRemoteCall()
{
	this.call = function(sRemoteMethod, oParam, networkSuccessCallback, networkErrorCallback)
	{
		throw new Error("Override me.");
	}
}

/**
 * 远程业务调用的封装
 * @param oRemoteCallImpl 远程调用的具体实现，KEXTAbstractRemoteCall接口
 * @param funCallback 回调函数，必须指定，形如：func(oBizData)
 * @param funErrorCallback 错误处理，可以省略，形如：func(iErrorCode, sErrorMessage)
 * @param funFinalCallback 不管成功失败最终总会执行的回调，可以省略，形如：func()
 */
function KEXTFacade(oRemoteCallImpl, funCallback, funErrorCallback, funFinalCallback)
{
	var _oRemoteCallImpl = oRemoteCallImpl;
	var _funCallback = funCallback;
	var _funErrorCallback = funErrorCallback;
	var _funFinalCallback = funFinalCallback;
	var _funTryAgain;
	var _bSilenceMode = false;
	
	/** 静默模式--不出等待提示，出错不提示 */
	this.setSilenceMode = function(bValue)
	{
		_bSilenceMode = bValue;
	}
	
	this.getReportsList = function(iPageStartRow, iPageLen)
	{
		var oParam = 
		{
			"userId": "",
			"pageStartRow": iPageStartRow,
			"pageLen": iPageLen
		};
		remote("extLightReports", oParam);
	}
	
	this.getReportOrgs = function(sReportId)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId
		};
		remote("extLightOrgsForReport", oParam);
	}
	
	this.getFilter = function(sOrgId, sReportId, sOutParams)
	{
		var oParam = 
		{
			"userId": "",
			"orgId": sOrgId,
			"reportId": sReportId,
			"extOutParam": sOutParams
		};
		remote("extLightFilter", oParam);
	}
	
	this.getFilterDelayData = function(sOrgId, sReportId, sParamName, sDatasetXml, sJsonParamsValues)
	{
		var oParam = 
		{
			"userId": "",
			"orgId": sOrgId,
			"reportId": sReportId,
			"paramName":sParamName,
			"datasetXml": sDatasetXml,
			"paramValues": sJsonParamsValues
		};
		remote("extLightFilterDelayData", oParam);
	}
	this.getChartInnerLinkData = function(sOrgId, sReportId, sheetName, sJsonParamsValues, chartParams)
	{	
		var oParam = 
		{
			"orgId": sOrgId,
			"reportId": sReportId,
			"sheetName": sheetName,
			"paramValues": sJsonParamsValues,
			"chartParams": chartParams,
		};
		remote("extLightChartInnerLink", oParam);
	}
	this.getCellInnerLinkData = function(sOrgId, sReportId, sheetName, sJsonParamsValues, cellParams)
	{	
		var oParam = 
		{
			"orgId": sOrgId,
			"reportId": sReportId,
			"sheetName": sheetName,
			"paramValues": sJsonParamsValues,
			"linkSrc": cellParams.linkSrc
		};
		remote("extLightCellInnerLink", oParam);
	}
	this.getReportContent = function(sReportId, sOrgId, sJsonParamsValues, sExtOutParams)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId,
			"orgId": sOrgId,
			"paramValues": sJsonParamsValues,
			"extOutParam": sExtOutParams
		};
		remote("extLightReportContent", oParam);
	}
	
	this.compositeExecute = function(sReportId, sOrgId, sParamsValues, sExtOutParams)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId,
			"orgId": sOrgId,
			"paramValues": sParamsValues,
			"extOutParam": sExtOutParams
		};
		remote("extLightExecute", oParam);
	}
	
	this.getSnapshotContent = function(sReportId, sSnapshotTag)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId,
			"snapshotTag": sSnapshotTag
		};
		remote("extLightSnapshot", oParam);
	}
	
	this.getSnapshotParamValue = function(sReportId, sSnapshotTag)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId,
			"snapshotTag": sSnapshotTag
		};
		remote("extLightSnapshotParamValue", oParam);
	}
	
	this.getHistoryMessages = function(sReportId, sJsonDateFilter, sEdgeMessageId)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId,
			"dateFilter": sJsonDateFilter,//"[[from1,to1],[from2,to2]]"
			"edgeMessageId": sEdgeMessageId
		};
		remote("extLightHistoryMessages", oParam);
	}
	
	this.getAllSummaryNames = function()
	{
		var oParam = 
		{
			"userId": ""
		};
		remote("extLightAllSummaryNames", oParam);
	}
	
	this.getHistorySummaries = function(sReportId, sOrgId, sJsonDateFilter)
	{
		var oParam = 
		{
			"userId": "",
			"reportId": sReportId,
			"orgId": sOrgId,
			"dateFilter": sJsonDateFilter//"[[from1,to1],[from2,to2]]"
		};
		remote("extLightHistorySummaries", oParam);
	}
	
	this.getAppSubjects = function(iLastRefreshTime)
	{
		var oParam = 
		{
			"userId": "",
			"lastRefreshTime": iLastRefreshTime
		};
		remote("extAppSubjects", oParam);
	}
	
	this.getAppMessages = function(sSubjectId, sEdgeMessageId, sDirection)
	{
		var oParam = 
		{
			"userId": "",
			"subjectId": sSubjectId,
			"edgeMessageId": sEdgeMessageId,
			"direction": sDirection
		};
		remote("extAppMessages", oParam);
	}
	
	this.getAccreditingManager = function()
	{
		remote("extLightManagerList", {});
	}
	
	this.getUserInfo = function()
	{
		remote("extLightUserInfo", {});
	}
	
	this.getThemeList = function()
	{
		remote("extLightThemeList", {});
	}
	
	var remote = function(sRemoteMethod, oParam)
	{
		if(!_bSilenceMode)
		{
			_funTryAgain = function()
			{
				KEXTProgressBar.Instance.show();
				setTimeout(function()
				{
					remoteCall(sRemoteMethod, oParam);
				}, 1000);
			};
			
			KEXTProgressBar.Instance.show();
		}
		remoteCall(sRemoteMethod, oParam);
	}
	
	var remoteCall = function(sRemoteMethod, oParam)
	{
		_oRemoteCallImpl.call(sRemoteMethod, oParam, remoteCallback, commonErrorHandler);
	}
	
	var remoteCallback = function(oJson)
	{
		if(oJson["errorCode"])
		{
			commonErrorHandler(oJson["errorCode"], oJson["errorMessage"]);
		}
		else
		{
			KEXTProgressBar.Instance.hide();
			_funCallback(oJson["data"]);
			finallyHandler();
		}
	}
	
	//网络错误或业务错误都回调至此
	var commonErrorHandler = function(iErrorCode, sErrorMessage)
	{
		KEXTProgressBar.Instance.hide();
		var funAfter = function()
		{
			if(_funErrorCallback)
			{
				_funErrorCallback(iErrorCode, sErrorMessage);
			}
			finallyHandler();
		};
		if(!_bSilenceMode)
		{
			var sPrompt;
			switch(iErrorCode)
			{
				case 0:
					handleNetConnectionProblem(iErrorCode, sErrorMessage);
					return;
				case 19998://检查许可出异常
				case 19999://没有移动报表工具许可
					handleLicenseProblem(iErrorCode);
					return;
				case 10000://找不到用户
					handleUserProblem();
					return;
				case 12900://云报表全局禁用
					handleCloudProblem(funAfter);
					return;
				default:
					sPrompt = "远程调用异常：" + sErrorMessage + "\r\n错误码：" + iErrorCode;
					alert(sPrompt);
			}
		}
		funAfter();
	}
	
	var finallyHandler = function()
	{
		if(_funFinalCallback)
		{
			_funFinalCallback();
		}
	}
	
	var handleNetConnectionProblem = function(iErrorCode, sErrorMessage)
	{
		KEXTUtil.promptNoNetwork(
			_funTryAgain, 
			function()
			{
				if(_funErrorCallback)
				{
					_funErrorCallback(iErrorCode, sErrorMessage);
				}
				finallyHandler();
			});
	}

	var handleLicenseProblem = function(iErrorCode)
	{
		var oPopup = new KEXTPopup();

		var jqImg = $("<img>");
		jqImg.css("position", "absolute");
		jqImg.css("margin-top", 20);
		jqImg.css("left", "50%");
		jqImg.css("margin-left", -50);
		jqImg.width(100);
		jqImg.height(100);
		jqImg.attr("src", "./resource/jiong.jpg");
		
		var jqText = $("<div>");
		jqText.css("font-size", 18);
		jqText.css("text-align", "justify");
		jqText.css("margin", 20);
		jqText.css("margin-top", 160);
		jqText.text("缺少【移动报表工具】模块的使用许可。");

		var jqCode = $("<div>");
		jqCode.css("font-size", 12);
		jqCode.css("margin", 20);
		jqCode.css("margin-top", 10);
		jqCode.text("错误码：" + iErrorCode);
		
		var jqPopup = oPopup.createUi();
		jqPopup.css("width", 240);
		jqPopup.css("min-height", 240);
		jqPopup.append(jqImg);
		jqPopup.append(jqText);
		jqPopup.append(jqCode);
		
		oPopup.show();
	}
	
	var handleUserProblem = function()
	{
		KEXTUserContext.getPersonInfo(function(oInfo)
		{
			var successUrl = location.href;
			successUrl = encodeURIComponent(successUrl);
			location.href="wxLogin.html?successUrl="+successUrl+"&info="+encodeURIComponent(JSON.stringify(oInfo.data));
		});
	}
	
	var handleCloudProblem = function(funAfterClose)
	{
		var oPopup = new KEXTPopup();
		var jqPopup = oPopup.createUiWithClose();

		var jqText = $("<div>");
		jqText.css("font-size", 16);
		jqText.css("margin", 20);
		jqText.css("white-space", "pre-wrap");
		jqText.text("　　报表管理员已禁用云报表中心。\r\n　　您可以：\r\n　　联系您所在企业的报表管理员，启用云报表中心。如果由于企业的信息安全策略而禁用云报表中心的，云报表将无法使用。");
		jqText.appendTo(jqPopup);
		
		oPopup.show();
		oPopup.setAfterCloseListener(
			function(bManualClose)
			{
				bManualClose && funAfterClose();
			});
	}
}

var KEXTLocalStorage = new (function()
{
	this.save = function(sKey, sValue)
	{
		if(window.localStorage)
		{
			window.localStorage.setItem(sKey, sValue);
		}
	}
	
	this.load = function(sKey, funCallback)
	{
		if(window.localStorage)
		{
			funCallback(window.localStorage.getItem(sKey));
		}
		else
		{
			funCallback(null);
		}
	}
})();

/**
 * 提供环境相关的用户信息，测试或演示环境可以替换掉获取实现
 */
var KEXTUserContext = new (function()
{
	var _funInsteadGetter;
	
	var GET_APPAUTH2_URL = "http://do.yunzhijia.com/openauth2/api/appAuth2";
	var GET_USERINFO_URL = "http://do.yunzhijia.com/openauth2/api/getcontext";
	
	this.getPersonInfo = function(funCallback,getKEXTAppAuth)
	{
		if(_funInsteadGetter)
		{
			_funInsteadGetter(funCallback);
		}
		else
		{
			if(XuntongJSBridge)
			{
				XuntongJSBridge.call("getPersonInfo", {},
					function(oResult)
					{
						funCallback(oResult);
					});
			}
			else if(getKEXTAppAuth)
			{
				var settting = 
				{
					url: GET_APPAUTH2_URL,
                    dataType: "html",
                    type: "post",
                    beforeSend: function(request) {
						request.setRequestHeader("authorization", getKEXTAppAuth());
					},
                    success: getAuthSuccess,
                    error:errorCallBack
				}
				$.ajax(oSettings);
			}
		}
	}
	
	var getAuthSuccess = function(oJson, funCallback)
	{
		if(oJson && oJson.data && oJson.data.access_token)
		{
			var sTicket = KEXTUtil.decodeParamFromUrl(location.search, "ticket");
			var settings = 
			{
				url: GET_USERINFO_URL,
                dataType: "html",
                data: "access_token=" + oJson.data.access_token + "&ticket=" + sTicket,
                type: "post",
                success: function(data){
                    funCallback(data);
                },
                error:errorCallBack
			}
			$.ajax(oSettings);
		}
	}
	
	var errorCallBack = function()
	{
		 alert("云之家接口错误!");
         return false;
	}
	
	/** 
	 * 替换掉用户信息获取接口
	 * funGetter形如：func(funCallback)，其中，funCallback形如：func(oResult)，oResult["data"]["eid"]等
	 */
	this.setInsteadGetter = function(funGetter)
	{
		_funInsteadGetter = funGetter;
	}
})();

/** 工具类 */
var KEXTUtil = new (function()
{
	var _this = this;
	var _iDeviceWidth;
	var _iRealPreviewWidth;
	var _iEnterFrom = 0;
	//可以指定设备宽度（针对预览的模拟器），报表等某些地方可能会依赖
	//2014-12-24，修改预览的缩放方案，此接口保留不变，所有场景都会指定为320。另见setPreviewScreenWidthAndScaleTo()。
	this.setDeviceWidth = function(iDeviceWidth)
	{
		_iDeviceWidth = iDeviceWidth;
	}
	this.getDeviceWidth = function()
	{
		return _iDeviceWidth;
	}
	this.setEnterFrom = function(iEnterFrom)
	{
		_iEnterFrom = _iEnterFrom + iEnterFrom;
	}
	this.getEnterFrom = function()
	{
		return _sEnterFrom;
	}
	this.hasEnterFromStatus = function(args)
	{
		if(!args)
			return false;
		var bHas = true;
		
		for(var o in args)
		{
			bHas = ((args[o] & _iEnterFrom) > 0) && bHas;//与运算判断当前有的状态
			if(!bHas)
				return bHas;
		}
		return bHas;
	}
	//由于预览是在PC上，浏览器不认<meta name="viewport">，而采用CSS对body缩放。（之前不缩放只setDeviceWidth会造成预览和真机不符是不对的）
	//但是jQueryMobile的page每次显示后都会自己改min-height以保证其可视区域，此最小高度显然不会考虑外层的body已做了缩放。
	//这里把预览的宽度记下来，并提供fixJqmPage()，用于每当页面显示(切换)后，修复min-height。
	this.setPreviewScreenWidthAndScaleTo = function(iRealPreviewWidth, iScaleToWidth)
	{
		_iRealPreviewWidth = iRealPreviewWidth;
		this.setDeviceWidth(iScaleToWidth);
		
		var numZoom = iRealPreviewWidth / iScaleToWidth;
		var jqBody = $(document.body);
		jqBody.css("-webkit-transform", "scale(" + numZoom + ")");
		jqBody.css("-webkit-transform-origin", "left top");
		var numReciprocal = 1 / numZoom;
		jqBody.css("width", numReciprocal * 100 + "%");
		jqBody.css("height", numReciprocal * 100 + "%");
	}
	this.fixJqmPage = function(jqPage)
	{
		if(!_iRealPreviewWidth)
		{
			return;
		}
		var iOriMinHeight = parseInt(jqPage.css("min-height"));
		var iNewMinHeight = (iOriMinHeight * _iDeviceWidth / _iRealPreviewWidth);
		jqPage.css("min-height", iNewMinHeight);
	}
	
	/**
	 * 缩放页面，使指定宽度充满屏幕
	 * @param iWidth 
	 */
	this.viewportScaleTo = function(iWidth)
	{
		this.setDeviceWidth(iWidth);
		
		var iDeviceWidth = window.screen.width;
		var numZoom = iDeviceWidth / iWidth;
		var sContent = "width="+ iWidth +", target-densitydpi=device-dpi, user-scalable=yes";
		sContent += ", initial-scale=" + numZoom + ", minimum-scale=" + numZoom + ", maximum-scale=" + numZoom;
		
		var jqViewport = $(document.head).find('meta[name="viewport"]');
		if(jqViewport.length == 0)
		{
			throw new Error('<meta name="viewport" content="..."> needed');
		}
		jqViewport.attr("content", sContent);
	}
	
	/**
	 * 设置展示环境的标题
	 * @param sTitle 标题的文字内容
	 */
	this.setEnvTitle = function(sTitle)
	{
		try
		{
			XuntongJSBridge.call('setWebViewTitle', {'title': sTitle});
		}
		catch(ex)
		{
			// alert(ex);
		}
	}
	
	/**
	 * 使硬件上的回退按钮（e.g. Android）能起作用
	 * @param funAction 按回退按钮时调用该函数，无参
	 * @param bActed 指定为true时绑定funAction，false则解除之
	 */
	this.bindHardwareBackwardActionForLight = function(funAction, bActed)
	{
		//as interface
	}
	
	/**
	 * 从URL的?p1=v1&p2=v2...中提取出参数值
	 * @param sAll 整个url串或从问号开始的参数部分
	 * @param sKey 参数名,如上例中的p1、p2
	 * @return 参数值，如上例中的v1、v2
	 */
	this.decodeParamFromUrl = function(sAll, sKey)
	{
		var sSearch = sKey + "=";
		var iBegin = -1;
		while(true)
		{
			iBegin = sAll.indexOf(sSearch, iBegin + 1);
			if(iBegin <= 0)
			{
				break;
			}
			else
			{
				var sBefore = sAll.charAt(iBegin - 1);
				if(sBefore == "&" || sBefore == "?")
				{
					break;
				}
			}
		}
		if(iBegin != -1) 
		{
			iBegin += sSearch.length;
			var iEnd = sAll.indexOf("&", iBegin);
			iEnd = (iEnd == -1 ? sAll.length : iEnd);
			return window.decodeURIComponent(sAll.substring(iBegin, iEnd));
		}
		return null;
	}
	
	/** 让jqScrollTarget出模拟的垂直滚动条，如果指定jqScrollbarOwner则滚动条出在它上面 */
	this.setSimScrollbar = function(jqScrollTarget, jqScrollbarOwner, bFrozenCol)
	{
		var oSimScrollbar = new kdlight.SimScrollbar();
		oSimScrollbar.setHBarVisible(bFrozenCol ? true : false);
		oSimScrollbar.setVBarVisible(true);
		oSimScrollbar.bindRealScroller(jqScrollTarget);
		oSimScrollbar.bindScrollbarOwner(jqScrollbarOwner ? jqScrollbarOwner: jqScrollTarget);
	}
	
	/** 提示没有网络，且在按下[再试试]按钮后调用funTryAgain()，如果叉掉，则调用funManualClosed() */
	this.promptNoNetwork = function(funTryAgain, funManualClosed)
	{
		var oPopup = new KEXTPopup();

		var jqImg = $("<img>");
		jqImg.width(200);
		jqImg.height(150);
		jqImg.attr("src", KEXTImg_NoNetwork);
		
		var jqText = $("<div>");
		jqText.css("text-align", "center");
		jqText.css("margin-top", 20);
		jqText.css("margin-bottom", 20);
		jqText.text("没有网络 或 网络信号不稳定");
		
		var jqBtn = $('<a href="#" class="ui-btn ui-corner-all ui-shadow ui-btn-a">');
		jqBtn.text("再努力试试...");
		jqBtn.on("click", 
			function(evt)
			{
				oPopup.die();
				funTryAgain();
			});
		
		var jqPopup = oPopup.createUiWithClose();
		jqPopup.css("min-width", 200);
		jqPopup.append(jqImg);
		jqPopup.append(jqText);
		jqPopup.append(jqBtn);
		
		oPopup.setAfterCloseListener(
			function(bManualClosed)
			{
				bManualClosed && funManualClosed && funManualClosed();
			});
		oPopup.show();
	}
	
	/** 如果网络正常，继续执行funContinue()；否则提示…… */
	this.checkNetworkLinkedWithPrompt = function(funContinue)
	{
		if(!window.navigator.onLine)
		{
			_this.promptNoNetwork(
				function()
				{
					KEXTProgressBar.Instance.show();
					setTimeout(
						function()
						{
							KEXTProgressBar.Instance.hide();
							_this.checkNetworkLinkedWithPrompt(funContinue);
						}, 2000);
				});
			return;
		}
		funContinue();
	}
	
	/** 可以出工程菜单--在目标对象上连按4下，位置关系必须是：4--123，则调用funAction */
	this.bindProgramerMenuListener = function(jqTarget, funAction)
	{
		(function(jqElement)
		{
			var arrRecords = [];
			jqElement.on("vmousedown", 
				function(evt)
				{
					arrRecords.push({"time": new Date().getTime(), "x":evt.clientX, "y":evt.clientY});
					if(arrRecords.length > 4)
					{
						arrRecords.shift();
					}
					if(arrRecords.length == 4)
					{
						for(var i = 1; i < 4; i++)
						{
							var iInterval = arrRecords[i]["time"] - arrRecords[i - 1]["time"];
							if(iInterval < 500 || iInterval > 1500)
							{
								return;
							}
						}
						if(arrRecords[0]["x"] < arrRecords[1]["x"] && arrRecords[0]["y"] < arrRecords[1]["y"] 
							&& arrRecords[1]["x"] < arrRecords[2]["x"] && arrRecords[1]["y"] > arrRecords[2]["y"]
							&& arrRecords[3]["x"] < arrRecords[0]["x"] - 200)
						{
							setTimeout(funAction, 500);
						}
					}
				});
		})(jqTarget);
	}
	
	this.login = function(funCallback)
	{
		var funSuccess = function(oJson)
		{
			if(oJson["errorCode"])
			{
				alert(oJson["errorCode"] + "  " + oJson["errorMessage"]);
			}
			else
			{
				var oData = oJson["data"];
				funCallback(oData);
			}
		};
		var funError = function(oXmlHttpRequest, sMessage, oException)
		{
			alert(oXmlHttpRequest.status + "  " + sMessage);
		};
		var oSettings = {
			"type": "GET",
			"dataType": "jsonp",
			"jsonpCallback": "extLightLoginCallback",
			"url": KEXTUtil.BizRemoteUrl,
			"data": {"remoteMethod": "extLightLogin"},
			"success": funSuccess,
			"error": funError
		};
		$.ajax(oSettings);
	}
	
	var _bCloudCommentCodeLoaded = false;
	/** funCallback like func(bSuccess) */
	this.loadDynamicCloudComment = function(funCallback)
	{
		if(_bCloudCommentCodeLoaded)
		{
			funCallback(true);
			return;
		}
		
		var sUrl = KEXTUtil.CloudHost + KEXTUtil.CloudDynamicCodePath + "/mobile-cloudreport-comment.js";
		
		KEXTProgressBar.Instance.show();
		var funError = function()
		{
			_bCloudCommentCodeLoaded = false;
			KEXTProgressBar.Instance.hide();
			htmlScript.remove();
			funCallback(false);
		};
		var funSuccess = function()
		{
			_bCloudCommentCodeLoaded = true;
			KEXTProgressBar.Instance.hide();
			funCallback(true);
		};
			
		var htmlScript = document.createElement("script");
		htmlScript.onload = funSuccess;
		htmlScript.onerror = funError;
		htmlScript.src = sUrl;
		document.head.appendChild(htmlScript);
	}
})();
KEXTUtil.BizRemoteUrl = "/mobile/lightapp/extRpt/resources";
KEXTUtil.CloudHost = "http://bos.kingdee.com";
KEXTUtil.CloudDynamicCodePath = "/crc/webContent/rptcenter/client-dynamic";
KEXTUtil.CONSTANTS = {		
		Enter_From_Lightapp: 1,
		Enter_From_App: 2,
		Enter_From_Snapshot: 4,
		Enter_From_NormalReport: 8,
		Enter_From_SingleReport: 16,
		Enter_From_Preview: 32
	};
var KEXTInnerLinkController = new (function() 
{
	var _funExcuteInnerLink;
	
	this.setExcuteInnerLink = function(funExcuteInnerLink)
	{
		_funExcuteInnerLink = funExcuteInnerLink;		
	}
	this.excuteInnerLink = function(params)
	{
		_funExcuteInnerLink(params);
	}
	
})();
function ExtRptFusionChartLink(params)
{
	params.srcType = "chart";
	KEXTInnerLinkController.excuteInnerLink(params);
}
/**
 * 进度条 
 */
function KEXTProgressBar()
{
	var _jqOwner;
	var _jqCover;
	
	/**
	 * 显示进度条时，缺省状态会有一个半透明的面板盖在整个页面上，防止多次点击操作。
	 * 可以通过此接口指定一个容器，则半透明面板只盖在此容器上。
	 */
	this.setOwner = function(jqOwner)
	{
		_jqOwner = jqOwner;
	}
	
	/**
	 * 显示进度条
	 * @param sText 可以设置要显示的文字
	 * @param bOnlyText 只显示文字
	 */
	this.show = function(sText, bOnlyText)
	{
		if(!_jqCover)
		{
			_jqCover = $("<div>");
			_jqCover.css("z-index", 9999999);
			_jqCover.css("position", "fixed");
			_jqCover.css("left", 0);
			_jqCover.css("right", 0);
			_jqCover.css("top", 0);
			_jqCover.css("bottom", 0);
			_jqCover.css("background", "rgba(0, 0, 0, 0.2)");

			var jqOwner = (_jqOwner ? _jqOwner : $.mobile.activePage);//$('*[data-role="page"][display="block"]'));
			jqOwner.append(_jqCover);
		}
		
		$.mobile.loading("show",
			{
				text: sText,
				textVisible: (sText ? true : false),
				theme: "b",
				textonly: (bOnlyText ? true : false),
				html: ""
			}
		);
	}
	
	/**
	 * 隐藏进度条 
	 */
	this.hide = function()
	{
		if(_jqCover)
		{
			_jqCover.remove();
			_jqCover = null;
		}
		$.mobile.loading("hide");
	}
}
KEXTProgressBar.Instance = new KEXTProgressBar();

/**
 * 通用的弹出界面
 */
function KEXTPopup()
{
	var _this = this;
	var _jqPopup;
	var _bManualClosed = false;
	
	this.createUiWithClose = function()
	{
		_this.createUi();
		var jqClose = $('<a href="#" class="ui-btn ui-corner-all ui-shadow ui-btn-a ui-icon-delete ui-btn-icon-notext ui-btn-left">');
		jqClose.on("click", 
			function(evt)
			{
				_bManualClosed = true;
				_this.die();
			});		
		_jqPopup.append(jqClose);
		return _jqPopup;
	}
	
	this.createUi = function()
	{
		_jqPopup = $("<div data-theme='a' data-overlay-theme='a' data-dismissible='false' data-history='false'>");
		_jqPopup.css("padding", 8);
		_jqPopup.css("margin-top", 12);
		_jqPopup.css("margin-bottom", 12);
		_jqPopup.popup();
		_jqPopup.popup({transition: "pop"});
		return _jqPopup;
	}
	
	this.show = function()
	{
		//slide page过程show中会偏一半在屏幕外，延迟一会儿再显示
		KEXTProgressBar.Instance.show();
		setTimeout(
			function()
			{
				KEXTProgressBar.Instance.hide();
				_jqPopup.popup("open");
			},
			500);
	}
	
	this.die = function()
	{
		_jqPopup.popup("close");
		_jqPopup.popup("destroy");
		_jqPopup = null;
	}
	
	this.setAfterCloseListener = function(funListener)
	{
		_jqPopup.on("popupafterclose", 
			function(evt)
			{
				funListener(_bManualClosed);
			});
	}
}

function KEXTBeta()
{
	var _jqOwner;
	var _iAliveUntil;
	
	this.tututu = function()
	{
		$(document.body).on("vmousedown", 
			function()
			{
				_iAliveUntil = new Date().getTime();
			});
		sickenYou();
		setInterval(areYouAlive, 40000);
	}
	
	var sickenYou = function()
	{
		_jqOwner = $("<div>");
		_jqOwner.css("z-index", 65535);
		_jqOwner.css("position", "fixed");
		_jqOwner.css("left", 0);
		_jqOwner.css("right", 0);
		_jqOwner.css("top", 0);
		_jqOwner.css("bottom", 0);
		_jqOwner.css("background", "rgba(128, 128, 128, 0.5)");
		
		var jqText = $("<div>");
		jqText.css("font-size", 88);
		jqText.css("color", "rgba(24, 54, 255, 0.2)");
		jqText.css("position", "absolute");
		jqText.css("top", "30%");
		jqText.css("left", "50%");
		jqText.css("margin-left", -128);
		jqText.text("试用版");
		jqText.css("transform", "rotate(-50deg)");
		
		_jqOwner.append(jqText);
		$(document.body).append(_jqOwner);
		
		_jqOwner.on("click",
			function()
			{
				_jqOwner.remove();
				_jqOwner = null;
			});
	}
	
	var areYouAlive = function()
	{
		if(!_jqOwner && (new Date().getTime() - _iAliveUntil > 40000))
		{
			sickenYou();
		}
	}
}

/** 信息展示控件 */
function KEXTInfoRoller()
{
	var _jqOwner;
	var _arrQueue = [];
	var _iTimeout;
	
	this.getJqUi = function()
	{
		if(!_jqOwner)
		{
			_jqOwner = $("<div>");
			_jqOwner.addClass("inforoller");
			_jqOwner.css("display", "none");
		}
		return _jqOwner;
	}
	
	/** 显示一条信息，延迟iDelayMs后开始，持续iDurationMs毫秒后消失 */
	this.pushInfo = function(sText, iDelayMs, iDurationMs)
	{
		_arrQueue.push({"text": sText, "duration": iDurationMs, "delay": iDelayMs});
		if(_arrQueue.length == 1)
		{
			startClock((iDelayMs || iDelayMs == 0) ? iDelayMs : 1000);
		}
	}
	
	var showInfo = function(sText, iMilliseconds)
	{
		var jqText = $("<div>");
		jqText.text("●  " + sText);//◎
		jqText.addClass("inforoller-text");

		_jqOwner.append(jqText);
		_jqOwner.css("display", "block");

		jqText.css("display", "none");
		jqText.fadeIn();
		setTimeout(
			function()
			{
				if(jqText.parent().length > 0)
				{
					jqText.fadeOut(
						function()
						{
							jqText.remove();
							tryToHide();
						}
					);
				}
			},
			(iMilliseconds ? iMilliseconds : 5000)
		);
	}
	
	this.clearInfos = function()
	{
		if(_iTimeout)
		{
			clearTimeout(_iTimeout);
		}
		_arrQueue.length = 0;
		_jqOwner.children().remove();
		tryToHide();
	}
	
	var tryToHide = function()
	{
		if(_jqOwner.children().length == 0)
		{
			_jqOwner.css("display", "none");
		}
	}
	
	var startClock = function(iDelay)
	{
		_iTimeout = setTimeout(
			function()
			{
				if(_arrQueue.length == 0)
				{
					return;
				}
				var oNode = _arrQueue.shift();
				showInfo(oNode["text"], oNode["duration"]);
				startClock(oNode["delay"] ? oNode["delay"] : 2000);
			},
			iDelay);
	}
}

var KEXTLocalStorageManager = new (function()
{
	var PREFIX = "com.kingdee.bos.ext.light";
			
	var _jqAll;
	var _jqKey;
	var _jqValue;
	
	this.popup = function()
	{
		_jqAll = $("<div>");
		_jqAll.css("z-index", 99999);
		_jqAll.css("position", "fixed");
		_jqAll.css("width", "100%");
		_jqAll.css("height", "100%");
		_jqAll.css("background", "#fff");
		$(document.body);
		$.mobile.activePage.append(_jqAll);
		createUi(_jqAll);
	}
	
	var createUi = function(jqAll)
	{
		var jqItems = createItemUi();
		jqItems.css("position", "absolute");
		jqItems.css("left", 10);
		jqItems.css("right", 10);
		jqItems.css("top", 10);
		jqItems.css("bottom", 180);
		jqItems.css("border-bottom", "1px solid gray");
		
		var jqShow = createDetailUi();
		jqShow.css("position", "absolute");
		jqShow.css("left", 10);
		jqShow.css("right", 10);
		jqShow.css("bottom", 0);
		jqShow.css("height", 160);
		
		jqAll.append(jqItems);
		jqAll.append(jqShow);
		return jqAll;
	}
	
	var createItemUi = function()
	{
		var jqFieldset = $("<fieldset>");
		jqFieldset.attr("data-role", "controlgroup");
		jqFieldset.on("change", doSelectItem);
		jqFieldset.controlgroup();
		rebuildItemUi(jqFieldset);
		
		var jqQuit = $('<button type="button">Quit</button>');
		jqQuit.button();
		jqQuit.on("click", 
			function()
			{
				_jqAll.remove();
			});

		var jqSelectAll = $('<button type="button">Select All</button>');
		jqSelectAll.button();
		jqSelectAll.css("float", "right");
		jqSelectAll.css("margin-right", "20px");
		jqSelectAll.on("click", 
			function()
			{
				_jqKey.text("")
				_jqValue.text("");
				var bUnSelectAll = jqFieldset.data("unselect-all");
				jqFieldset.find("input").prop("checked", !bUnSelectAll);
				jqFieldset.controlgroup("refresh");
				 jqFieldset.data("unselect-all", !bUnSelectAll);
			});
					
		var jqDelete = $('<button type="button">Delete</button>');
		jqDelete.button();
		jqDelete.css("float", "right");
		jqDelete.on("click", 
			function()
			{
				var progressBar = new KEXTProgressBar();
				progressBar.show();
				
				var jqItems = jqFieldset.find("input");
				for(var i = 0; i < jqItems.length; i++)
				{
					var jqItem = $(jqItems[i]);
					if(jqItem.prop("checked"))
					{
						window.localStorage.removeItem(jqItem.attr("id"));
					}
				}
				
				setTimeout(
					function()
					{
						rebuildItemUi(jqFieldset);
						progressBar.hide();
					}, 1000);
			});
			
		var jqScroller = $("<div style='overflow-x:hidden; overflow-y:auto'>");
		jqScroller.css("position", "absolute");
		jqScroller.css("top", 36);
		jqScroller.css("bottom", 10);
		jqScroller.css("width", "100%");
		jqScroller.append(jqFieldset);
		
		var jqOwner = $("<div>");
		jqOwner.append(jqQuit);
		jqOwner.append(jqDelete);
		jqOwner.append(jqSelectAll);
		jqOwner.append(jqScroller);
		return jqOwner;
	}
	
	var rebuildItemUi = function(jqFieldset)
	{
		jqFieldset.controlgroup("destroy");
		jqFieldset.children().remove();
		for(var sKey in window.localStorage)
		{
			if(sKey.indexOf(PREFIX) != 0)
			{
				continue;
			}
			var sValue = window.localStorage[sKey];
			
			var sId = sKey;
			var jqInput = $("<input type='checkbox'/>");
			jqInput.attr("id", sId);
			jqInput.data("value", sValue);
			
			var jqLabel = $("<label>");
			jqLabel.attr("for", sId);
			jqLabel.text("..." + sKey.substring(PREFIX.length));
			
			jqFieldset.append(jqInput);
			jqFieldset.append(jqLabel);
		}
		jqFieldset.controlgroup();
	}
	
	var createDetailUi = function()
	{
		_jqKey = $("<div>");
		_jqKey.css("height", "40px");
		_jqKey.css("white-space", "pre-wrap");
		_jqKey.text("您已进入工程人员菜单");
		
		_jqValue = $("<textarea>");
		_jqValue.css("position", "absolute");
		_jqValue.css("width", "100%");
		_jqValue.css("top", 40);
		_jqValue.css("bottom", 0);
		
		var jqShow = $("<div>");
		jqShow.append(_jqKey);
		jqShow.append(_jqValue);
		return jqShow;
	}
	
	var doSelectItem = function(evt)
	{
		var jqInput = $(evt.target);
		if(jqInput.prop("checked"))
		{
			var sKey = jqInput.attr("id");
			sKey = sKey.substring(PREFIX.length);
			if(sKey.length > 40)
			{
				sKey = sKey.substring(0, 40) + "\r\n" + sKey.substring(40);
			}
			_jqKey.text(sKey);
			_jqValue.text(jqInput.data("value"));
		}
		else
		{
			_jqKey.text("");
			_jqValue.text("");
		}
	}
})();


/**
 * 类似Excel的格式化 
 */
var KEXTNumberFormater = new (function()
{
	//原始值：
	var _oOriValue;
	//条件：
	var _arrConditionFormats;//(可能的三段条件)格式化串
	var _arrConditionFuns;//条件判断函数
	var _arrIgnoreNegativeSign;//与条件段对应的是否忽略负号
	//中间状态：
	var _bIgnoreNegativeSign;//是否忽略负号
	var _bCarryBitToInteger;//因四舍五入小数向整数进位
	//结果：
	var _sResult;
	var _mapStyle;
	
	this.format = function(oValue, sFormatString)
	{
		_oOriValue = oValue;
		_sResult = oValue;
		_mapStyle = null;
		try
		{
			if(isDateFormat(sFormatString))
			{
				formatDate(sFormatString);
			}
			else if(isNumberFormat())
			{
				seperateCondition(sFormatString);
				formatNumber();
			}
		}
		catch(ex)
		{
			console.log("Format " + oValue + " use \"" + sFormatString + "\" error. " + ex);
		}
		return _sResult;
	}
	
	/** 一次格式化后解析出来的css键值对 */
	this.getStyle = function()
	{
		return _mapStyle;
	}
	
	var isNumberFormat = function()
	{
		return /^[+-]?\d+\.?\d*$/.test(_oOriValue + "");
	}
	
	var seperateCondition = function(sFormatString)
	{
		_arrConditionFormats = [];
		var arrStrs = sFormatString.split(";");
		//todo 此处可加自定义条件解析
		if(arrStrs.length >= 3)
		{
			_arrConditionFuns = [];
			_arrConditionFuns[0] = function(nValue){return nValue == 0;};
			_arrConditionFuns[1] = function(nValue){return nValue < 0;};
			_arrConditionFuns[2] = null;//function(nValue){return true;};
			//按检查的顺序分123，而不是格式化串的书写顺序 
			_arrConditionFormats[0] = arrStrs[2];
			_arrConditionFormats[1] = arrStrs[1];
			_arrConditionFormats[2] = arrStrs[0];
		}
		else if(arrStrs.length == 2)
		{
			_arrConditionFuns = [];
			_arrConditionFuns[0] = function(nValue){return nValue < 0;};
			_arrConditionFuns[1] = null;
			_arrConditionFormats[0] = arrStrs[1];
			_arrConditionFormats[1] = arrStrs[0];
		}
		else
		{
			_arrConditionFuns = null;
			_arrConditionFormats[0] = sFormatString;
		}
		_arrIgnoreNegativeSign = [false, true, false];
	}
	
	var getConditionFormatString = function()
	{
		for(var i = 0; i < _arrConditionFormats.length; i++)
		{
			if(_arrConditionFuns && _arrConditionFuns[i] && !_arrConditionFuns[i](_oOriValue))
			{
				continue;
			}
			_bIgnoreNegativeSign = _arrIgnoreNegativeSign[i];
			return _arrConditionFormats[i];
		}
	}
	
	var formatNumber = function()
	{
		var sFormatString = getConditionFormatString();

		var iAdjustBit = 0
		
		//与Excel不同的表示方式：{4}表示小数点左移四位，即万为单位。百分数相当于{-2}。
		var iMultiplyIdx = sFormatString.search(/\{-?\d+\}/);
		if(iMultiplyIdx >= 0)
		{
			var iMultiplyEndIdx = sFormatString.indexOf("}", iMultiplyIdx);
			iAdjustBit = parseInt(sFormatString.substring(iMultiplyIdx + 1, iMultiplyEndIdx));
			sFormatString = sFormatString.substring(0, iMultiplyIdx) + sFormatString.substring(iMultiplyEndIdx + 1);
		}
		
		//条件样式
		var iStyleIdx = sFormatString.search(/\[.+\]/);
		if(iStyleIdx >= 0)
		{
			var iStyleEndIdx = sFormatString.indexOf("]", iStyleIdx);
			var sStyleString = sFormatString.substring(iStyleIdx + 1, iStyleEndIdx);
			_mapStyle = {"color":sStyleString};//暂且只支持颜色，可考虑扩展为[color:#ffffff][font-size:20px]...
			sFormatString = sFormatString.substring(0, iStyleIdx) + sFormatString.substring(iStyleEndIdx + 1);
		}

		//只要有百分号认为是百分数
		if(sFormatString.indexOf("%") > 0)
		{
			iAdjustBit -= 2;
		}
		
		var arrIntAndDec = divideIntegerAndDecimal(iAdjustBit);
		var sInteger = arrIntAndDec[0];
		var sDecimal = arrIntAndDec[1];
		
		var arrIntAndDecFormatString = divideIntAndDecFormatString(sFormatString);
		var sIntFormatString = arrIntAndDecFormatString[0];
		var sDecFormatString = arrIntAndDecFormatString[1];
		
		var sDecResult = formatDecimal(sDecimal, sDecFormatString);
		//由于四舍五入的进位，小数先于整数处理
		_sResult = formatInteger(sInteger, sIntFormatString) + sDecResult;
	}
	
	//iAdjustBit大于零是小数点向左移
	var divideIntegerAndDecimal = function(iAdjustBit)
	{
		var sValue = "" + _oOriValue;
		var iDotIdx = sValue.indexOf(".");
		var sInteger;
		var sDecimal;
		if(iDotIdx < 0)
		{
			sInteger = sValue;
			sDecimal = "";
		}
		else
		{
			sInteger = sValue.substring(0, iDotIdx);
			sDecimal = sValue.substring(iDotIdx + 1);
		}
		
		if(sInteger.charAt(0) == "+")
		{
			sInteger = sInteger.substring(1);
		}
		
		if(iAdjustBit < 0)
		{
			for(var i = 0; i < -iAdjustBit; i++)
			{
				if(sDecimal.length == 0)
				{
					sInteger += "0";
				}
				else
				{
					sInteger += sDecimal.charAt(0);
					sDecimal = sDecimal.substring(1);
				}
			}
		}
		else if(iAdjustBit > 0)
		{
			for(var i = 0; i < iAdjustBit; i++)
			{
				if(sInteger.length == 0)
				{
					sDecimal = "0" + sDecimal;
				}
				else
				{
					sDecimal = sInteger.charAt(sInteger.length - 1) + sDecimal;
					sInteger = sInteger.substring(0, sInteger.length - 1);
				}
			}
		}
		return [sInteger, sDecimal];
	}
	
	var divideIntAndDecFormatString = function(sFormatString)
	{
		var iDotIdx = sFormatString.indexOf(".");
		var sIntFormatString;
		var sDecFormatString;
		if(iDotIdx < 0)
		{
			var iZeroIdx = sFormatString.lastIndexOf("0");
			var iWellIdx = sFormatString.lastIndexOf("#");
			var iLastNumBitIdx = Math.max(iZeroIdx, iWellIdx);
			if(iLastNumBitIdx >= 0)
			{
				sIntFormatString = sFormatString.substring(0, iLastNumBitIdx + 1);
				sDecFormatString = sFormatString.substring(iLastNumBitIdx + 1);//把数字位后的字符搞到小数部分当后缀
			}
			else
			{
				sIntFormatString = sFormatString;
				sDecFormatString = "";
			}
		}
		else
		{
			sIntFormatString = sFormatString.substring(0, iDotIdx);
			sDecFormatString = sFormatString.substring(iDotIdx + 1);
		}
		return [sIntFormatString, sDecFormatString];
	}
	
	var formatInteger = function(sValue, sFormatString)
	{
		var sNegativeSign = "";
		if(sValue.charAt(0) == "-")
		{
			sValue = sValue.substring(1);
			sNegativeSign = "-";
		}
		if(_bCarryBitToInteger)
		{
			sValue = parseInt(sValue) + 1 + "";
		}
		var bThousandSplit = (sFormatString.indexOf(",") >= 0);
		var iMinBit = 0;
		for(var i = sFormatString.length - 1; i >= 0; i--)
		{
			if(sFormatString.charAt(i) != "0")
			{
				break;
			}
			iMinBit++;
		}
		var sKeepString = "";
		var bShowNumber;
		for(var i = sFormatString.length - 1; i >= 0; i--)
		{
			var sChar = sFormatString.charAt(i);
			if(sChar != "0" && sChar != "#" && sChar != ",")
			{
				sKeepString = sFormatString.substring(0, i + 1);
				break;
			}
			bShowNumber = true;
		}
		if(!bShowNumber)
		{
			return sKeepString;
		}
		
		var sResult = sValue;
		var iAddZero = iMinBit - sResult.length;
		if(iAddZero > 0)
		{
			sResult = addZeroBefore(sResult, iAddZero);
		}
		else if(iAddZero < 0)
		{
			var iCutCount = 0;
			for(var i = 0; i < -iAddZero; i++)
			{
				if(sResult.charAt(i) != "0")
				{
					break;
				}
				iCutCount++;
			}
			if(iCutCount > 0)
			{
				sResult = sResult.substring(iCutCount);
			}
		}
		
		if(bThousandSplit)
		{
			for(var i = sResult.length - 3; i > 0; i -= 3)
			{
				sResult = sResult.substring(0, i) + "," + sResult.substring(i);
			}
		}
		sResult = sKeepString + (_bIgnoreNegativeSign ? "" : sNegativeSign) + sResult;
		return sResult;
	}
	
	var formatDecimal = function(sValue, sFormatString)
	{
		_bCarryBitToInteger = false;
		var iMinBit = 0;
		for(var i = 0; i < sFormatString.length; i++)
		{
			if(sFormatString.charAt(i) != "0")
			{
				break;
			}
			iMinBit++;
		}
		var iMaxBit = 0;
		var sKeepString = "";
		for(var i = 0; i < sFormatString.length; i++)
		{
			var sChar = sFormatString.charAt(i);
			if(sChar != "0" && sChar != "#")
			{
				sKeepString = sFormatString.substring(i);
				break;
			}
			iMaxBit++;
		}
		var sResult = sValue;
		var iAddZero = iMinBit - sResult.length;
		if(iAddZero > 0)
		{
			sResult = addZeroAfter(sResult, iAddZero);
		}
		var iCutTail =  sResult.length - iMaxBit;
		if(iCutTail > 0)
		{
			var bCarryBit = (parseInt(sResult.charAt(iMaxBit)) > 4);//四舍五入
			sResult = sResult.substring(0, iMaxBit);
			if(bCarryBit)
			{
				if(iMaxBit == 0)
				{
					_bCarryBitToInteger = true;
				}
				else
				{
					var iOriLen = sResult.length;
					var iResult = parseInt(sResult);
					iResult += 1;
					sResult = "" + iResult;
					if(sResult.length > iOriLen)
					{
						sResult = sResult.substring(1);
						_bCarryBitToInteger = true;
					}
					else if(sResult.length < iOriLen)
					{
						sResult = addZeroBefore(sResult, (iOriLen - sResult.length));
					}
				}
			}
		}
		if(sResult)
		{
			sResult = "." + sResult;
		}
		sResult += sKeepString;
		return sResult;
	}
	
	var addZeroBefore = function(sTarget, iZeroCount)
	{
		var sZeros = "";
		for(var i = 0; i < iZeroCount; i++)
		{
			sZeros += "0";
		}
		return sZeros + sTarget;
	}
	
	var addZeroAfter = function(sTarget, iZeroCount)
	{
		var sZeros = "";
		for(var i = 0; i < iZeroCount; i++)
		{
			sZeros += "0";
		}
		return  sTarget + sZeros;
	}
	
	var isDateFormat = function(sFormatString)
	{
		if(_oOriValue instanceof Date)
		{
			return true;
		}
		if(!/[0#]/.test(sFormatString) && /[ymdhs]/.test(sFormatString))
		{
			if(typeof(_oOriValue) == "string")
			{
				_oOriValue = _oOriValue.replace(/-/g, "/");
				_oOriValue = new Date(_oOriValue);
			}
			else if(typeof(_oOriValue) == "number")
			{
				_oOriValue = new Date(_oOriValue);
			}
			return true;
		}
		return false;
	}
	
	var formatDate = function(sFormatString)
	{
		var arrWords = [];
		var sLastChar;
		var sLastWord = "";
		for(var i = 0; i < sFormatString.length; i++)
		{
			var sChar = sFormatString.charAt(i);
			if(!sLastChar || sChar == sLastChar)
			{
				sLastWord += sChar;
			}
			else
			{
				arrWords.push(sLastWord);
				sLastWord = sChar;
			}
			sLastChar = sChar;
		}
		arrWords.push(sLastWord);
		
		getDateElement(arrWords);
	}
	
	var getDateElement = function(arrWords)
	{
		var oDate = _oOriValue;
		_sResult = "";
		var bTime;//用于就近识别m是分钟还是月
		for(var i = 0; i < arrWords.length; i++)
		{
			var sWord = arrWords[i];
			var iWordLen = sWord.length;
			var sChar = sWord.charAt(0);
			var sWordResult;
			switch(sChar)
			{
				case "y":
					bTime = false;
					sWordResult = "" + oDate.getFullYear();
					if(iWordLen < 4)
					{
						sWordResult = sWordResult.substring(4 - iWordLen);
					}
					break;
				case "m":
					if(bTime || checkMinuteOtherwiseMomth(arrWords, i))
					{
						sWordResult = oDate.getMinutes() + "";
						if(iWordLen > sWordResult.length)
						{
							sWordResult = addZeroBefore(sWordResult, iWordLen - sWordResult.length);
						}
					}
					else
					{
						sWordResult = oDate.getMonth() + 1 + "";
						if(iWordLen > sWordResult.length)
						{
							sWordResult = addZeroBefore(sWordResult, iWordLen - sWordResult.length);
						}
					}
					bTime = false;
					break;
				case "d":
					bTime = false;
					sWordResult = oDate.getDate() + "";
					if(iWordLen > sWordResult.length)
					{
						sWordResult = addZeroBefore(sWordResult, iWordLen - sWordResult.length);
					}
					break;
				case "h":
					bTime = true;
					sWordResult = oDate.getHours() + "";
					if(iWordLen > sWordResult.length)
					{
						sWordResult = addZeroBefore(sWordResult, iWordLen - sWordResult.length);
					}
					break;
				case "s":
					bTime = true;
					sWordResult = oDate.getSeconds() + "";
					if(iWordLen > sWordResult.length)
					{
						sWordResult = addZeroBefore(sWordResult, iWordLen - sWordResult.length);
					}
					break;
				default:
					sWordResult = sWord;
			}
			_sResult += sWordResult;
		}
	}
	
	var checkMinuteOtherwiseMomth = function(arrWords, iCurrentWordIndex)
	{
		for(var i = iCurrentWordIndex + 1; i < arrWords.length; i++)
		{
			var sChar = arrWords[i].charAt(0);
			if(sChar == "h" || sChar == "s")
			{
				return true;
			}
			else if(sChar == "y" || sChar == "m" || sChar == "d")
			{
				return false;
			}
		}
		return false;
	}
})();
