//扩展报表轻应用核心部分
//Copyright (c) 2015 金蝶软件(中国)有限公司
//
//第三方依赖： 
//jQuery 2.1.0 (http://jquery.com)
//jQueryMobile 1.4.2 (http://jquerymobile.com)
//

/** 组织的数据模型 */
function KEXTOrg(sId, sName)
{
	var _sId = sId;
	var _sName = sName;
	
	this.getId = function()
	{
		return _sId;
	}
	
	this.getName = function()
	{
		return _sName;
	}
	
	this.toPersistenceString = function()
	{
		var oJson = {};
		oJson["id"] = _sId;
		oJson["name"] = _sName;
		return JSON.stringify(oJson);
	}
	
	this.fromPersistenceString = function(sPersistence)
	{
		var oJson = JSON.parse(sPersistence);
		this.fromJsonObject(oJson);
	}
	
	this.fromJsonObject = function(oJson)
	{
		_sId = oJson["id"];
		_sName = oJson["name"];
	}
}

/** 报表列表中每一条目（即一个报表）的数据模型 */
function KEXTMainListItem(sReportId, sReportName, sType)
{
	var _sType = sType;
	var _sReportId = sReportId;
	var _sReportName = sReportName;
	
	this.getReportId = function()
	{
		return _sReportId;
	}
	
	this.getReportName = function()
	{
		return _sReportName;
	}
	
	this.getType = function()
	{
		return _sType;
	}
}

/** 页面的抽象基类 */
function KEXTAbstractPage()
{
	var _funFacadeCreator;

	var _funCurrnetJqScrollerGetter;
	
	/** 设置创建facade实例的函数，形如：func(funSuccessCallback, funErrorCallback)，参考KEXTFacade */
	this.setFacadeCreator = function(funFacadeCreator)
	{
		_funFacadeCreator = funFacadeCreator;
	}
	
	var getFacade = function(funCallback, funError)
	{
		return _funFacadeCreator(funCallback, funError);
	}
	
	/** 页面跳转前保存状态 */
	this.keepState = function()
	{
		var jqScroller = getCurrentJqScroller();
		jqScroller.data("myScrollTop", jqScroller.prop("scrollTop") - 1);//减1使与原来不同，防止某些设备不起作用
	}
	
	/** 页面跳转回来后恢复状态 */
	this.restoreState = function()
	{
		var jqScroller = getCurrentJqScroller();
		var iOriValue = jqScroller.data("myScrollTop");
		if(iOriValue || iOriValue == 0)
		{
			jqScroller.prop("scrollTop", iOriValue);
		}
	}
	
	var setCurrentJqScrollerGetter = function(funGetter)
	{
		_funCurrnetJqScrollerGetter = funGetter;
	}
	
	var getCurrentJqScroller = function()
	{
		var jqScroller = (_funCurrnetJqScrollerGetter ? _funCurrnetJqScrollerGetter() : $());
		jqScroller = (jqScroller ? jqScroller : $());
		return jqScroller;
	}
	
	this.destroy = function()
	{
		//Can override when necessary.
	}
	
	this.protectedMethod = 
	{
		"getFacade": getFacade,
		"setCurrentJqScrollerGetter": setCurrentJqScrollerGetter
	}
}

/**
 * 报表列表页面
 */
function KEXTMainListPage()
{
	KEXTAbstractPage.call(this);
	
	var LocalStorageKey_CurrentTab = "com.kingdee.bos.ext.light.MainList_currentTab";
	var LocalStorageKey_AppearedTabs = "com.kingdee.bos.ext.light.MainList_appearedTabs";
	var LocalStorageKey_ItemOrder = "com.kingdee.bos.ext.light.MainList_itemOrder";
	
	var LIST_LINE_HEIGHT = 46;
	
	var _super = this.protectedMethod;
	
	var _sSubjectId;
	var _funRunReport;

	var _jqOwner;
	var _oTab;
	var _jqSingleTabOwner;
	
	var _bMouseDown;
	var _bEditing;

	var _funRequestFullScreenListener;
	
	(function()
	{
		_super.setCurrentJqScrollerGetter(
			function()
			{
				return (_oTab ? _oTab.getTabContent(_oTab.getCurrentTabName()) : _jqSingleTabOwner); 
			}
		);
	})();
	
	this.setSubjectId = function(sSubjectId)
	{
		_sSubjectId = sSubjectId;
	}
		
	/** funCallback like: func(sReportName, sReportId) */
	this.setRunReportListener = function(funCallback)
	{
		_funRunReport = funCallback;
	}

	/** funListener like: func(bFullScreen) */
	this.setRequestFullScreenListener = function(funListener)
	{
		_funRequestFullScreenListener = funListener;
	}
	
	this.createUi = function(jqOwner)
	{
		_jqOwner = jqOwner;
		var oFacade = _super.getFacade(
			function(oData)
			{
				loadLastStateAndCreateList(jqOwner, oData);
			});
		oFacade.getReportsList(0, -1);
	}
	
	var wrapLocalStorageKey = function(sKey)
	{
		return sKey + "_" + _sSubjectId;
	}
	
	var loadLastStateAndCreateList = function(jqOwner, oData)
	{
		loadState(
			function(sSelectedTabName, arrAppearedTabNamesLastTime, mapItemIdsLastTime)
			{
				createTabs(jqOwner, oData, sSelectedTabName, arrAppearedTabNamesLastTime, mapItemIdsLastTime);
			});
	}
	
	var createTabs = function(jqOwner, oData, sSelectedTabName, arrAppearedTabNamesLastTime, mapItemIdsLastTime)
	{
		var arrAllTabNames = [];
		var mapItems = {};
		for(var i = 0; i < oData.length; i++)
		{
			var oJson = oData[i];
			var sType = oJson["type"];
			sType = (sType ? sType : "未命名");
			var oModel = new KEXTMainListItem(oJson["id"], oJson["name"], sType);
			
			var arrTabItems = mapItems[sType];
			if(!arrTabItems)
			{
				arrAllTabNames.push(sType);
				arrTabItems = [];
				mapItems[sType] = arrTabItems;
			}
			arrTabItems.push(oModel);
		}
		var arrAppearedTabNames = arrAllTabNames;
		if(arrAppearedTabNamesLastTime && arrAppearedTabNamesLastTime.length > 0)
		{
			arrAppearedTabNames = sortTabs(arrAllTabNames, arrAppearedTabNamesLastTime);
		}
		if(mapItemIdsLastTime)
		{
			sortItems(mapItems, mapItemIdsLastTime);
		}

		var jqSub;
		if(arrAllTabNames.length > 1)
		{
			_oTab = new kdlight.CustomTabContainer();
			_oTab.setMoreItemTitle("选择不超过三个目录：");
			_oTab.setTabNames(arrAllTabNames, arrAppearedTabNames.slice(0, 3));
			for(var i = 0; i < arrAllTabNames.length; i++)
			{
				var sTabName = arrAllTabNames[i];
				var arrItems = mapItems[sTabName];
				var jqPanel = $("<div>");
				createList(jqPanel, arrItems);
				_oTab.setTabContent(sTabName, jqPanel);
				KEXTUtil.setSimScrollbar(jqPanel, jqPanel.parent());
			}
			if(!_oTab.setCurrentTabName(sSelectedTabName))
			{
				_oTab.setCurrentTabName(arrAppearedTabNames[0]);
			}
			_oTab.setAppearedChangeListener(doTabsChange);
			_oTab.setSelectedChangeListener(doCurrentTabChange);
			_oTab.setMoreItemShowListener(_funRequestFullScreenListener);
			
			jqSub = _oTab.getJqUi();
		}
		else
		{
			_oTab = null;
			jqSub = $("<div>");
			createList(jqSub, mapItems[arrAllTabNames[0]]);
			_jqSingleTabOwner = jqSub;
			KEXTUtil.setSimScrollbar(jqSub, jqOwner);
		}
		jqSub.css({
			"position": "absolute",
			"left": 0,
			"right":0,
			"top": 0,
			"bottom": 0});
		jqOwner.append(jqSub);
	}
	
	//用上次的页签顺序重新排序这次的页签
	var sortTabs = function(arrAllTabNames, arrAppearedTabNamesLastTime)
	{
		var arrTabNames = arrAllTabNames.slice(0);
		var arrSorted = [];
		var bAllExist = true;
		for(var i = 0; i < arrAppearedTabNamesLastTime.length; i++)
		{
			var sName = arrAppearedTabNamesLastTime[i];
			var bAccepted = false;
			for(var j = 0; j < arrTabNames.length; j++)
			{
				if(sName == arrTabNames[j])
				{
					arrTabNames.splice(j, 1);
					bAccepted = true;
					break;
				}
			}
			if(bAccepted)
			{
				arrSorted.push(sName);
			}
			else
			{
				bAllExist = false;
			}
		}
		if(!bAllExist)
		{
			arrSorted = arrSorted.concat(arrTabNames);
		}
		return arrSorted;
	}
	
	//用上次的条目顺序重新排序这次的报表，注意两个参数的结构不同
	//mapItems = {"type1":[oModel1, oModel2]}
	//mapItemIdsLastTime = {"type1":["id1", "id2"]}
	var sortItems = function(mapItems, mapItemIdsLastTime)
	{
		for(var sType in mapItems)
		{
			var arrItemIdsLastTime = mapItemIdsLastTime[sType];
			if(!arrItemIdsLastTime || arrItemIdsLastTime.length == 0)
			{
				continue;
			}
			var mapIndex = {};
			for(var sIndex in arrItemIdsLastTime)
			{
				var iIndex = parseInt(sIndex);
				var sId = arrItemIdsLastTime[iIndex];
				mapIndex[sId] = iIndex;
			}
			var arrItems = mapItems[sType];
			arrItems.sort(
				function(oItem1, oItem2)
				{
					var iIdx1 = mapIndex[oItem1.getReportId()];
					iIdx1 = (typeof(iIdx1) == "undefinded" ? 65535 : iIdx1);
					var iIdx2 = mapIndex[oItem2.getReportId()];
					iIdx2 = (typeof(iIdx2) == "undefinded" ? 65535 : iIdx2);
					return (iIdx1 == iIdx2 ? 0 : (iIdx1 < iIdx2 ? -1 : 1));
				}
			);
		}
	}
	
	var createList = function(jqOwner, arrTabItems)
	{
		jqOwner.addClass("center-list");
		if(!arrTabItems || arrTabItems.length == 0)
		{
			jqOwner.text("管理员未向您授权任何报表");
			jqOwner.css("text-align", "center");
			jqOwner.css("line-height", "60px");
			jqOwner.css("color", "#999999");
			return;
		}
		for(var i = 0; i < arrTabItems.length; i++)
		{
			var oModel = arrTabItems[i];
			var jqItem = createListItem(oModel);
			jqItem.css("position", "absolute");
			jqItem.css("top", i * LIST_LINE_HEIGHT);
			jqItem.css("height", LIST_LINE_HEIGHT - 1);
			jqOwner.append(jqItem);
		}
		updateOddEvenLineStyle(jqOwner);
		
		jqOwner.on("click", doItemClick);
		jqOwner.on("vmousedown", doItemMouseDown);
		jqOwner.on("vmouseup", doItemMouseUp);
		jqOwner.on("taphold", doItemLongPress);

		var jqTail = $('<div style="position:absolute; height:80px; width:100%">');
		jqTail.css("top", i * LIST_LINE_HEIGHT);
		jqOwner.append(jqTail);
		KEXTUtil.bindProgramerMenuListener(jqTail, 
			function()
			{
				KEXTLocalStorageManager.popup();
			});
	}

	var createListItem = function(oModel)
	{
		var jqItem = $("<div>");
		jqItem.addClass("center-item");
		setItemModel(jqItem, oModel);

		var jqImg = $("<div>");
		jqImg.addClass("center-item-img");
		jqItem.append(jqImg);
		
		var jqText = $("<span>");
		jqText.addClass("center-item-text");
		jqText.text(oModel.getReportName());
		jqItem.append(jqText);
		
		return jqItem;
	}
	
	var updateOddEvenLineStyle = function(jqPanel)
	{
		var jqOdd = jqPanel.find(".center-item:odd");
		jqOdd.addClass("center-item_odd");
		jqOdd.removeClass("center-item_even");

		var jqEven = jqPanel.find(".center-item:even");
		jqEven.addClass("center-item_even");
		jqEven.removeClass("center-item_odd");
	}
	
	var setItemModel = function(jqItem, oModel)
	{
		jqItem.data("model", oModel);
	}
	
	var getItemModel = function(jqItem)
	{
		return jqItem.data("model");
	}
	
	var searchSelectingItem = function(evt)
	{
		var jqTarget = $(evt.target);
		while(jqTarget[0] != evt.currentTarget && !jqTarget.hasClass("center-item"))
		{
			jqTarget = jqTarget.parent();
		}
		return (jqTarget.hasClass("center-item") ? jqTarget : null);
	}
	
	var doItemClick = function(evt)
	{
		if(_bEditing)
		{
			return;
		}
		var jqItem = searchSelectingItem(evt);	
		if(jqItem)
		{
			var oModel = getItemModel(jqItem);
			runReport(oModel);
		}
	}
	
	var runReport = function(oItemModel)
	{
		var sReportName = oItemModel.getReportName();
		var sReportId = oItemModel.getReportId();
		_funRunReport(sReportName, sReportId);
	}
	
	var doItemMouseDown = function(evt)
	{
		if(_bEditing)
		{
			return;
		}
		var jqItem = searchSelectingItem(evt);	
		if(jqItem)
		{
			jqItem.addClass("center-item_selected");
			_bMouseDown = true;
		}
	}
	
	var doItemMouseUp = function(evt)
	{
		if(!_bMouseDown)
		{
			return;
		}
		var jqPanel = $(evt.currentTarget);
		jqPanel.find(".center-item_selected").removeClass("center-item_selected");
		_bMouseDown = false;
	}

	var doItemLongPress = function(evt)
	{
		if(_bEditing)
		{
			return;
		}
		doItemMouseUp(evt);
		
		var jqLiOrder = $('<li><a href="#">调整顺序</a></li>');
		jqLiOrder.on("click", 
			function()
			{
				_bEditing = true;
				jqPopup.popup("close");
				doChangeOrder();
			});

		var jqUL = $('<ul data-role="listview" data-inset="true" style="min-width:200px">');
		jqUL.append($('<li data-role="list-divider">选择一项操作</li>'));
		jqUL.append(jqLiOrder);
		jqUL.listview();
		
		var jqPopup = $('<div data-role="popup" data-theme="a">');
		jqPopup.append(jqUL);
		jqPopup.popup();
		jqPopup.popup("open");
	}

	var doChangeOrder = function()
	{
		_funRequestFullScreenListener && _funRequestFullScreenListener(true);
		if(_oTab)
		{
			_oTab.getJqUi().animate({"top": -44, "bottom": 44});
			movingButtonAppended(_oTab.getTabContent(_oTab.getCurrentTabName()));
		}
		else
		{
			_jqSingleTabOwner.css("bottom", 44);
			movingButtonAppended(_jqSingleTabOwner);
		}
		var oConfirmBar = new kdlight.ConfirmBar();
		oConfirmBar.setCancelVisible(false);
		oConfirmBar.getJqUi().find(".kdlight-confirmbar-btn-ok").text("完成");
		oConfirmBar.setActionListener(
			function(bOk)
			{
				if(_oTab)
				{
					_oTab.getJqUi().animate({"top": 0, "bottom": 0});
					movingButtonRemoved(_oTab.getTabContent(_oTab.getCurrentTabName()));
				}
				else
				{
					_jqSingleTabOwner.css("bottom", 0);
					movingButtonRemoved(_jqSingleTabOwner);
				}
				oConfirmBar.getJqUi().remove();
				_bEditing = false;
				saveStateForItemOrder();
				_funRequestFullScreenListener && _funRequestFullScreenListener(false);
			});
		_jqOwner.append(oConfirmBar.getJqUi());
	}
	
	var movingButtonAppended = function(jqContainer)
	{
		jqContainer.animate({"left": -44});//jqContainer本身就是.center-list
		var jqItems = jqContainer.find(".center-item");
		for(var i = 0; i < jqItems.length; i++)
		{
			var jqItem = $(jqItems[i]);
			jqItem.append(createMovingButton("下移", "./resource/btn_down.png", doMoveDown));
			jqItem.append(createMovingButton("上移", "./resource/btn_up.png", doMoveUp));
			jqItem.append(createMovingButton("最下", "./resource/btn_bottom.png", doMoveToBottom));
			jqItem.append(createMovingButton("最上", "./resource/btn_top.png", doMoveToTop));
		}
	}
	
	var movingButtonRemoved = function(jqContainer)
	{
		jqContainer.animate({"left": 0});
		jqContainer.find(".center-item-movebtn").remove();
	}
	
	var createMovingButton = function(sText, sImg, funAction)
	{
		var jqBtn = $("<div>");
		jqBtn.addClass("center-item-movebtn");
		jqBtn.css("background-image", "url(" + sImg + ")");
		jqBtn.text(sText);
		jqBtn.on("click", funAction);
		return jqBtn;
	}
	
	var doMoveDown = function(evt)
	{
		var jqItem = $(evt.currentTarget).parent();
		changeItemPosition(jqItem, 1);
	}
	
	var doMoveUp = function(evt)
	{
		var jqItem = $(evt.currentTarget).parent();
		changeItemPosition(jqItem, -1);
	}
	
	var doMoveToBottom = function(evt)
	{
		var jqItem = $(evt.currentTarget).parent();
		changeItemPosition(jqItem, 0xffff);
	}
	
	var doMoveToTop = function(evt)
	{
		var jqItem = $(evt.currentTarget).parent();
		changeItemPosition(jqItem, 0);
	}
	
	var changeItemPosition = function(jqItem, iPosDelta)
	{
		var jqParent = jqItem.parent();
		var jqChildren = jqParent.children(".center-item");
		var iOldPos;
		for(var i = 0; i < jqChildren.length; i++)
		{
			if(jqChildren[i] == jqItem[0])
			{
				iOldPos = i;
				break;
			}
		}
		var iPos;
		switch(iPosDelta)
		{
			case 1:
				iPos = iOldPos + 1;
				$(jqChildren[iPos]).after(jqItem);
				break;
			case -1:
				iPos = iOldPos - 1;
				$(jqChildren[iPos]).before(jqItem);
				break;
			case 0:
				iPos = 0;
				$(jqChildren[iPos]).before(jqItem);
				break;
			case 0xffff:
				iPos = jqChildren.length - 1;
				$(jqChildren[iPos]).after(jqItem);
				break;
			default:
				throw new Error("Illegal argument iPosDelta: " + iPosDelta);
		}
		if(iPos < 0 || iPos >= jqChildren.length || iPos == iOldPos)
		{
			return;
		}
		
		if(jqItem.data("myDelayTag"))
		{
			clearTimeout(jqItem.data("myDelayTag"));
		}
		jqItem.addClass("center-item_moving");
		var iNewTop = LIST_LINE_HEIGHT * iPos;
		if(iNewTop < jqParent.prop("scrollTop"))
		{
			jqParent.animate({"scrollTop": iNewTop}, 200);
		}
		else if(iNewTop + LIST_LINE_HEIGHT > jqParent.prop("scrollTop") + jqParent.prop("clientHeight"))
		{
			console.log(iNewTop + ", " + LIST_LINE_HEIGHT + ", " +  jqParent.prop("scrollTop") + ", " + jqParent.prop("clientHeight"));
			jqParent.animate({"scrollTop": (iNewTop + LIST_LINE_HEIGHT - jqParent.prop("clientHeight"))}, 200);
		}
		jqItem.animate({"top": iNewTop}, 400, 
			function()
			{
				jqChildren = jqParent.children(".center-item");
				var iStart = Math.min(iOldPos, iPos);
				var iEnd = Math.max(iOldPos, iPos);
				for(var j = iStart; j <= iEnd; j++)
				{
					$(jqChildren[j]).css("top", LIST_LINE_HEIGHT * j);
				}
				var iDelayTag = setTimeout(
					function()
					{
						jqItem.removeClass("center-item_moving");
						jqItem.removeData("myDelayTag");
					},
					1000);
				jqItem.data("myDelayTag", iDelayTag);
			});
		
		updateOddEvenLineStyle(jqParent);
	}
	
	var doTabsChange = function()
	{
		saveStateForAppearedTabs();
	}
	
	var doCurrentTabChange = function(sTabNameOld, sTabName)
	{
		saveStateForCurrentTab();

		var jqOldTabPanel = _oTab.getTabContent(sTabNameOld);
		jqOldTabPanel.data("myScrollTop", jqOldTabPanel.prop("scrollTop") - 1);		
		var jqNewTabPanel = _oTab.getTabContent(sTabName);
		var iOriValue = jqNewTabPanel.data("myScrollTop");
		if(iOriValue || iOriValue == 0)
		{
			setTimeout(
				function()
				{
					jqNewTabPanel.prop("scrollTop", iOriValue);
				},
				400);
		}
	}
	
	var saveStateForCurrentTab = function()
	{
		var sCurrentTabName = _oTab.getCurrentTabName();
		var sPersistence = JSON.stringify(sCurrentTabName);
		KEXTLocalStorage.save(wrapLocalStorageKey(LocalStorageKey_CurrentTab), sPersistence);
	}
	
	var saveStateForAppearedTabs = function()
	{
		var arrTabNames = _oTab.getAppearedTabNames();
		var sPersistence = JSON.stringify(arrTabNames);
		KEXTLocalStorage.save(wrapLocalStorageKey(LocalStorageKey_AppearedTabs), sPersistence);
	}	
	
	var saveStateForItemOrder = function()
	{
		var mapItemsOrder = {};
		if(_oTab)
		{
			arrAllTabNames = _oTab.getAllTabNames();
			for(var i = 0; i < arrAllTabNames.length; i++)
			{
				var sTabName = arrAllTabNames[i];
				var jqPanel = _oTab.getTabContent(sTabName);
				var arrOrder = pickListOrderState(jqPanel);
				mapItemsOrder[sTabName] = arrOrder;
			}
		}
		else
		{
			var jqOwner = $.mobile.activePage;
			var oFirstItemModel = getItemModel(jqOwner.find("div.center-item").first());
			var sType = oFirstItemModel.getType();
			var arrOrder = pickListOrderState(jqOwner);
			mapItemsOrder[sType] = arrOrder;
		}
		var sPersistence = JSON.stringify(mapItemsOrder);
		KEXTLocalStorage.save(wrapLocalStorageKey(LocalStorageKey_ItemOrder), sPersistence);
	}
	
	var pickListOrderState = function(jqOwner)
	{
		var arrOrder = [];
		var jqItems = jqOwner.find("div.center-item");
		for(var i = 0; i < jqItems.length; i++)
		{
			var jqItem = $(jqItems[i]);
			var oModel = getItemModel(jqItem);
			arrOrder.push(oModel.getReportId());
		}
		return arrOrder;
	}
	
	var loadState = function(funCallback)
	{
		var sCurrentTabName;
		var arrTabNames = [];
		var mapItemsOrder = {};
		var fun1 = function()
		{
			var sKeyCurrentTab = wrapLocalStorageKey(LocalStorageKey_CurrentTab);
			KEXTLocalStorage.load(sKeyCurrentTab, 
				function(sPersistence)
				{
					if(sPersistence)
					{
						sCurrentTabName = JSON.parse(sPersistence);
					}
					funCallback(sCurrentTabName, arrTabNames, mapItemsOrder);
				});			
		}
		var fun2 = function()
		{
			var sKeyAppearedTabs = wrapLocalStorageKey(LocalStorageKey_AppearedTabs);
			KEXTLocalStorage.load(sKeyAppearedTabs, 
				function(sPersistence)
				{
					if(sPersistence)
					{
						arrTabNames = JSON.parse(sPersistence);
					}
					fun1();
				});
		}
		var sKeyItemOrder = wrapLocalStorageKey(LocalStorageKey_ItemOrder);
		KEXTLocalStorage.load(sKeyItemOrder, 
			function(sPersistence)
			{
				if(sPersistence)
				{
					mapItemsOrder = JSON.parse(sPersistence);
				}
				fun2();
			});			
	}
}
	
/**
 * 报表内容页面的抽象基类
 */
function KEXTAbstractReportPage()
{
	KEXTAbstractPage.call(this);
	
	var STORAGE_KEY_PARAM_PREFIX = "com.kingdee.bos.ext.light_report_pv_";
	var STORAGE_KEY_ORG_PREFIX = "com.kingdee.bos.ext.light_report_org_";
	
	var _this = this;
	var _super = this.protectedMethod;
	
	var _funBackward;
	
	var _funProtectedImplForForwardFilter;
	var _funProtectedImplForGetFilterOtherInfo;
	var _funProtectedImplForRefresh;
	var _funProtectedImplForReportContentBeforeUpdate;
	
	var _oReport = new KEXTReport();
	var _jqContentOwner;
	var _oToolbar;
	var _oTopFilterBar;
	var _oInfoRoller;
	
	var _sSubjectId;
	var _sTitle;
	var _sReportId;
	
	var _oOrg;
	var _bMoreOrgs = false;

	var _arrParamsDescs;
	var _oParamsValues;
	var _oAssociateModel;

	var _oCloudReportSupporter;
	
	var _sOutParams; // 外部集成参数
	
	(function()
	{
		_super.setCurrentJqScrollerGetter(
			function()
			{
				return _oReport.getCurrentJqScroller();
			}
		);
	})();
	
	var setOutParams = function(sOutParams)
	{
		_sOutParams = sOutParams;
	}
	
	var getOutParams = function()
	{
		return _sOutParams;
	}
	
	this.destroy = function()
	{
		_oReport.destroy();
	}

	/** funCallback like: func() */
	this.setBackwardListener = function(funCallback)
	{
		_funBackward = funCallback;
	}

	/**
	 * 从过滤界面获取参数值后，调用此接口更新报表内容
	 */
	this.update = function(bApplyParamsValuesAndRefresh, oParamsValues)
	{
		if(bApplyParamsValuesAndRefresh)
		{
			_oParamsValues = oParamsValues;
			if(_bMoreOrgs)
			{
				disjoinOrgFromFilter();
			}
			var sStorageKeyForParamValue = getStorageKeyParamPrefix() + _sReportId;
			var sStorageKeyForOrg = getStorageKeyOrgPrefix() + _sReportId;
			KEXTLocalStorage.save(sStorageKeyForParamValue, _oParamsValues.toJsonStringForPersistence());
			KEXTLocalStorage.save(sStorageKeyForOrg, _oOrg.toPersistenceString());
			KEXTLocalStorage.save(KEXT_STORAGE_KEY_CLIENT_IS_USE_LASTSAVE_PARAM_PREFIX+_sReportId, _oParamsValues.isSaveAsScheme());
			_oTopFilterBar.clearCurrentCtrl();
			_oTopFilterBar.updateValues(_oParamsValues);
			remoteGetReportContent();
		}
		else
		{
			_oTopFilterBar.updateValues(_oParamsValues);
		}
	}
	
	this.setSubjectId = function(sSubjectId)
	{
		_sSubjectId = sSubjectId;
	}
	
	var getStorageKeyParamPrefix = function()
	{
		return STORAGE_KEY_PARAM_PREFIX + (_sSubjectId ? _sSubjectId + "_" : "");
	}
	
	var getStorageKeyOrgPrefix = function()
	{
		return STORAGE_KEY_ORG_PREFIX + (_sSubjectId ? _sSubjectId + "_" : "");
	}
	
	this.getTitle = function()
	{
		return _sTitle;
	}
	
	var setTitle = function(sTitle)
	{
		_sTitle = sTitle;
	}
	
	var getReport = function()
	{
		return _oReport;
	}
	
	var setReportId = function(sReportId)
	{
		_sReportId = sReportId;
	}
	
	var getReportId = function()
	{
		return _sReportId;
	}
	
	var setOrg = function(oOrg)
	{
		if(oOrg && !(oOrg instanceof KEXTOrg))
		{
			throw new Error("The arguments must be KEXTOrg");
		}
		_oOrg = oOrg;
	}
	
	var getOrg = function()
	{
		return _oOrg;
	}
	
	this.getOrgId = function()
	{
		return (_oOrg ? _oOrg.getId() : null);
	}
	
	var setMoreOrgs = function(bMoreOrgs)
	{
		_bMoreOrgs = bMoreOrgs;
	}
	
	this.isMoreOrgs = function()
	{
		return _bMoreOrgs;
	}
	
	var setAssociate = function(mapAssociate, arrAssociateWithOrg)
	{
		if(mapAssociate || arrAssociateWithOrg)
		{
			_oAssociateModel = new KEXTParamsAssociateModel();
		}
		if(mapAssociate)
		{
			for(var sParam in mapAssociate)
			{
				var arrAffected = mapAssociate[sParam];
				for(var i = 0; i < arrAffected.length; i++)
				{
					_oAssociateModel.addOneAffectAnother(sParam, arrAffected[i]);
				}
			}
		}
		if(arrAssociateWithOrg)
		{
			for(var j = 0; j < arrAssociateWithOrg.length; j++)
			{
				_oAssociateModel.addOneAffectAnother(KEXTFilterPage.ID_FOR_ORG, arrAssociateWithOrg[i]);
			}
		}
	}
	
	var getAssociate = function()
	{
		return _oAssociateModel;
	}
	
	var setParamsDescs = function(arrParamsDescs)
	{
		_arrParamsDescs = arrParamsDescs;
		if(_bMoreOrgs && _oOrg)
		{
			if(!_arrParamsDescs || _arrParamsDescs.length == 0)
			{
				_arrParamsDescs = [];
			}
			joinOrgInFilter();
		}
	}
	
	var getParamsDescs = function()
	{
		return _arrParamsDescs;
	}
	
	var setParamsValues = function(oParamsValues)
	{
		_oParamsValues = oParamsValues;
	}
	
	var getParamsValues = function()
	{
		return _oParamsValues;
	}
	
	var initPage = function(jqOwner)
	{
		if(_jqContentOwner)
		{
			showLoadingBackground(true);
			return;
		}
		
		var oBar = new kdlight.Toolbar();
		if(_funBackward)
		{
			oBar.addButton(kdlight.Toolbar.POS_LEFT, "btnBack", "返回", doBackwardClick);
			oBar.addSeperator(kdlight.Toolbar.POS_LEFT);
		}
		if(_funProtectedImplForRefresh)
		{
			if(KEXTUtil.hasEnterFromStatus([KEXTUtil.CONSTANTS.Enter_From_Snapshot]))
				oBar.addButton(kdlight.Toolbar.POS_RIGHT, "btnRefresh", "./resource/btn_refresh.png", _funProtectedImplForRefresh);
			oBar.addButton(kdlight.Toolbar.POS_RIGHT, "btnFilter", "./resource/btn_filter.png", doFilterClick);
			oBar.setButtonVisible("btnFilter", false);
		}
		oBar.getJqUi().css("z-index", 1);
		oBar.getJqUi().css("display", "none");
		jqOwner.append(oBar.getJqUi());
				
		_oToolbar = oBar;
		KEXTUtil.bindProgramerMenuListener(oBar.getJqUi(), 
			function()
			{
				KEXTLocalStorageManager.popup();
			});

		_oInfoRoller = new KEXTInfoRoller();
		_oInfoRoller.getJqUi().css("z-index", 2);
		jqOwner.append(_oInfoRoller.getJqUi());
				
		_jqContentOwner = $("<div>");
		//内部出滚动条
		_jqContentOwner.css("position", "absolute");
		_jqContentOwner.css("right", 0);
		_jqContentOwner.css("left", 0);
		_jqContentOwner.css("top", oBar.getJqUi().height()+"px");
		_jqContentOwner.css("bottom", 0);
		_jqContentOwner.css("overflow", "hidden");
		_jqContentOwner.css("z-index", 0);
		showLoadingBackground(true);
		jqOwner.append(_jqContentOwner);
		
		_oTopFilterBar = new KEXTTopFilterBar(_jqContentOwner);
		_oTopFilterBar.setForwardFilterListener(_funProtectedImplForForwardFilter);
		jqOwner.append(_oTopFilterBar.getJqUiBar());
		jqOwner.append(_oTopFilterBar.getJqUiContent());
	}
	
	var getToolbar = function()
	{
		return _oToolbar;
	}
	
	this.getTopFilterBar = function()
	{
		return _oTopFilterBar;
	}
	
	var showFilterButtonAtToolbar = function(bShow)
	{
		_oToolbar.setButtonVisible("btnFilter", bShow);
	}
	
	var showLoadingBackground = function(bShow)
	{
		_jqContentOwner.children().remove();
		if(bShow)
		{
			var jqImg = $("<div>");
			jqImg.width("100%");
			jqImg.height("100%");
			jqImg.css("background-image", "url(resource/loading.png)");
			jqImg.css("background-repeat", "no-repeat");
			jqImg.css("background-position", "center top");
			_jqContentOwner.append(jqImg);
		}
	}
	
	var showInfo = function(sText, iDurationMs)
	{
		if(sText)
		{
			_oInfoRoller.pushInfo(sText, null, iDurationMs);
		}
		else
		{
			_oInfoRoller.clearInfos();
		}
	}
	
	//取报表参数描述
	var remoteGetReportParamDesc = function(funCallback, iCallbackMark)
	{
		var oFacade = _super.getFacade(
			function(oData)
			{
				setAssociate(oData["associate"], oData["associateWithOrg"]);
				var arrParamsDesc = oData["params"];
				setParamsDescs(arrParamsDesc ? arrParamsDesc : null);
				funCallback(iCallbackMark);
			});
		oFacade.getFilter(_oOrg.getId(), _sReportId, getOutParams());
	}
		
	//执行报表
	var remoteGetReportContent = function()
	{
		var oParamsValues = new KEXTParamsValues();
		oParamsValues.setSaveAsScheme(false);
		KEXTLocalStorage.save(KEXT_STORAGE_KEY_TOP_PARAM_PREFIX+_sReportId, oParamsValues.toJsonStringForPersistence());
		
		showInfo(null);
		var oFacade = _super.getFacade(remoteGetReportContentCallback);
		var sParamsValues = (_oParamsValues ? _oParamsValues.toJsonStringForExecute() : null);
		oFacade.getReportContent(_sReportId, _oOrg.getId(), sParamsValues, _sOutParams);
	}
	
	var remoteGetReportContentCallback = function(oData)
	{
		if(_funProtectedImplForReportContentBeforeUpdate)
		{
			_funProtectedImplForReportContentBeforeUpdate();
		}
		showReportContent(oData);
		_oCloudReportSupporter && _oCloudReportSupporter.reportExecuted();
	}
	
	var showReportContent = function(oJsonReportContent)
	{
		showLoadingBackground(false);
		_oReport.setModel(oJsonReportContent);
		_oReport.draw(_jqContentOwner, KEXTUtil.getDeviceWidth());
		_oToolbar.getJqUi().css("display", "");
		if(_oReport.hasColumnBeCut())
		{
			showInfo("报表宽度超过628像素，超过部分被截掉无法显示。");
		}
	}
	
	var doBackwardClick = function()
	{
		if(_funBackward)
		{
			_funBackward();
			return true;
		}
		return false;
	}
	
	var doFilterClick = function()
	{
		if(_arrParamsDescs)
		{
			_funProtectedImplForForwardFilter();
		}
		else
		{
			var iCallbackMark = 0;
			var iMarkForGetParamDesc = 0x01;
			var iMarkForOthers = 0x02;
			var funSequence = function(iMark)
			{
				iCallbackMark = iCallbackMark | iMark;
				if(iCallbackMark == (iMarkForGetParamDesc | iMarkForOthers))
				{
					_funProtectedImplForForwardFilter();
				}
			}
			remoteGetReportParamDesc(funSequence, iMarkForGetParamDesc);
			if(_funProtectedImplForGetFilterOtherInfo)
			{
				_funProtectedImplForGetFilterOtherInfo(funSequence, iMarkForOthers);
			}
			else
			{
				funSequence(iMarkForOthers);
			}
		}
	}
	
	var joinOrgInFilter = function()
	{
		var funSuppliedValueGetter = function(sModel, funCallbak)
		{
			var oFacade = _super.getFacade(
				function(oJsonOrgs)
				{
					var arrRows = [];
					for(var i = 0; i < oJsonOrgs.length; i++)
					{
						var oJsonOrg = oJsonOrgs[i];
						arrRows.push([oJsonOrg["id"], oJsonOrg["name"]]);
					}
					var oRowset = {};
					oRowset["meta"] = {"colNames": ["value", "text"]}
					oRowset["rows"] = arrRows;
					funCallbak(oRowset);
				});
			oFacade.getReportOrgs(_sReportId);
		}
		
		var oJsonParamDesc = {};
		oJsonParamDesc["name"] = KEXTFilterPage.ID_FOR_ORG;
		oJsonParamDesc["text"] = "组织";
		oJsonParamDesc["required"] = true;
		oJsonParamDesc["dataType"] = "string";
		oJsonParamDesc["ctrlType"] = "f7";
		oJsonParamDesc["multiSelectable"] = false;
		oJsonParamDesc["defaultValue"] = createParamDescDefaultValueForOrg();
		oJsonParamDesc["suppliedValueDescription"] = {"function": funSuppliedValueGetter};
		
		_arrParamsDescs.unshift(oJsonParamDesc);
	}
	
	var disjoinOrgFromFilter = function()
	{
		var arrValues = _oParamsValues.disjoinParam(KEXTFilterPage.ID_FOR_ORG);
		var oValue = arrValues[0];
		var sNewOrgId = oValue.getValue();
		var sNewOrgName = oValue.getText();
		if(sNewOrgId != _oOrg.getId() || sNewOrgName != _oOrg.getName())
		{
			_oOrg = new KEXTOrg(sNewOrgId, sNewOrgName);
			_arrParamsDescs[0]["defaultValue"] =  createParamDescDefaultValueForOrg();//再打开过滤器时用
		}
	}
	
	var createParamDescDefaultValueForOrg = function()
	{
		return [{"value":_oOrg.getId(), "text":_oOrg.getName()}];
	}
	
	//param like: func()
	var setProtectedImplForForwardFilter = function(funForwardFilter)
	{
		_funProtectedImplForForwardFilter = funForwardFilter;
	}
	
	//param like: func(funCallback, iCallbackMark), and funCallback like: func(iCallbackMark)
	var setProtectedImplForGetFilterOtherInfo = function(funGetFilterOtherInfo)
	{
		_funProtectedImplForGetFilterOtherInfo = funGetFilterOtherInfo;
	}
	
	//param like: func()
	var setProtectedImplForRefresh = function(funRefresh)
	{
		_funProtectedImplForRefresh = funRefresh;
	}
	
	//param like: func()
	var setProtectedImplForReportContentBeforeUpdate = function(func)
	{
		_funProtectedImplForReportContentBeforeUpdate = func;
	}
	
	var _superKeepState = this.keepState;
	this.keepState = function()
	{
		_superKeepState();
		KEXTUtil.bindHardwareBackwardActionForLight(doBackwardClick, false);
	}
	
	var _superRestoreState = this.restoreState;
	this.restoreState = function()
	{
		_superRestoreState();
		KEXTUtil.bindHardwareBackwardActionForLight(doBackwardClick, true);
	}
	
	var initForCloudReport = function(oJson)
	{
		var sCloudReportId = oJson["cloudRptId"];
		var bCloudReport = (sCloudReportId ? true : false);
		if(bCloudReport)
		{
			_oCloudReportSupporter = new KEXTCloudReportSupporter();
			_oCloudReportSupporter.setContextInfo(sCloudReportId, oJson["isAccredited"], oJson["isTemplateModified"]);
			_oCloudReportSupporter.setRejectJoiningListener(
				function()
				{
					if(!doBackwardClick())
					{
						//没有回退的回调函数，即不可回退的情形
						var jqOwner = _jqContentOwner.parent();
						jqOwner.children().remove();
						jqOwner.text("您未同意加入“金蝶云报表共享计划”。");
					}
				});
			_oCloudReportSupporter.setFacadeCreator(_super.getFacade);
			_oCloudReportSupporter.initUi(_jqContentOwner.parent());

			getToolbar().addButton(kdlight.Toolbar.POS_RIGHT, "btnComment", "./resource/btn_logo.png", 
				function(sBtnName)
				{
					var jqBtn = getToolbar().getButton(sBtnName);			
					_oCloudReportSupporter.showComment(jqBtn);
				});
		}
		return _oCloudReportSupporter;
	}
	
	this.protectedMethod = 
	{
		"initPage": initPage,
		"getFacade": _super.getFacade,
		"getReport": getReport,
		"setTitle": setTitle,
		"getReportId": getReportId,
		"setReportId": setReportId,
		"getOrg": getOrg,
		"setOrg": setOrg,
		"setMoreOrgs": setMoreOrgs,
		"setAssociate": setAssociate,
		"getAssociate": getAssociate,
		"getParamsDescs": getParamsDescs,
		"setParamsDescs": setParamsDescs,
		"getParamsValues": getParamsValues,
		"setParamsValues": setParamsValues,
		"remoteGetReportContent": remoteGetReportContent,
		"showReportContent": showReportContent,
		"showFilterButtonAtToolbar": showFilterButtonAtToolbar,
		"getToolbar": getToolbar,
		"doBackwardClick": doBackwardClick,
		"showInfo": showInfo,
		"setProtectedImplForForwardFilter": setProtectedImplForForwardFilter,
		"setProtectedImplForGetFilterOtherInfo": setProtectedImplForGetFilterOtherInfo,
		"setProtectedImplForRefresh": setProtectedImplForRefresh,
		"setProtectedImplForReportContentBeforeUpdate": setProtectedImplForReportContentBeforeUpdate,
		"getStorageKeyParamPrefix": getStorageKeyParamPrefix,
		"getStorageKeyOrgPrefix": getStorageKeyOrgPrefix,
		"initForCloudReport": initForCloudReport,
		"setOutParams": setOutParams,
		"getOutParams": getOutParams
	}
}

/**
 * 报表内容页面
 */
function KEXTReportPage()
{
	KEXTAbstractReportPage.call(this);

	var _this = this;
	var _super = this.protectedMethod;

	var _funForwardFilter;
	var _funForwardNextReport;
	var _funForwardHistory;
	
	var _bFromHyperlink;//从联查进入
	
	var _bShowTitleInReportTitle = false;
	
	this.setOutParams = function(sOutParams)
	{
		_super.setOutParams(sOutParams);
	}
	
	/** funCallback like: func(sReportId, arrParamsDescs, oParamsValues, oAssociateModel, oOrg, bShowReportFirstTime) */
	this.setForwardFilterListener = function(funCallback)
	{
		_funForwardFilter = funCallback;

		var funImpl = function(bShowReportFirstTime)
		{
			funCallback(_super.getReportId(), _super.getParamsDescs(), _super.getParamsValues(), _super.getAssociate(), _super.getOrg(), bShowReportFirstTime?bShowReportFirstTime:false);
		};
		_super.setProtectedImplForForwardFilter(funImpl);
	}
	
	this.getReportId = function()
	{
		return _super.getReportId();
	}
	
	/** funCallback like: func(oOrg, sReportName, sReportTag, sParamsValues) */
	this.setForwardNextReportListener = function(funCallback)
	{
		_funForwardNextReport = funCallback;
	}
	
	/** funCallback like: func(sReportId) */
	this.setForwardHistoryListener = function(funCallback)
	{
		_funForwardHistory = funCallback;
	}
	
	/**
	 * 第一次进入报表，可能直接显示报表内容，也可能回调forwardFilter显示过滤界面
	 */
	this.execute = function(jqOwner, sReportName, sReportId, oOrg, oParamsValues)
	{
		_bFromHyperlink = (oOrg ? true : false);
		
		_super.setTitle(sReportName);
		_super.setReportId(sReportId);
		_super.setOrg(oOrg);
		
		_super.getReport().setHyperlinkListener(doHyperlinkClick);
		_super.setProtectedImplForRefresh(doRefreshClick);

		_super.initPage(jqOwner);
		_super.getToolbar().getJqUi().css("display", "none");
		_this.remoteGetLinkDataExcute();
		if(_bFromHyperlink)
		{
			_super.setParamsValues(oParamsValues);
			remoteCompositeExecute();
		}
		else
		{
			loadLastTimeParamsValuesAndThen(remoteCompositeExecute);
		}
	}
	
	this.showTitleInReportToolbar = function(b)
	{
		_bShowTitleInReportTitle = b;	
	}
	
	var loadLastTimeParamsValuesAndThen = function(funNextStep)
	{
		_super.setParamsValues(null);
		var sStorageKeyForParamValue = _super.getStorageKeyParamPrefix() + _super.getReportId();
		KEXTLocalStorage.load(sStorageKeyForParamValue, 
			function(sValue)
			{
				if(sValue)
				{
					var oParamsValues = new KEXTParamsValues();
					oParamsValues.fromPersistenceJsonString(sValue);
					_super.setParamsValues(oParamsValues);
				}
				var sStorageKeyForOrg = _super.getStorageKeyOrgPrefix() + _super.getReportId();
				KEXTLocalStorage.load(sStorageKeyForOrg, 
					function(sValue)
					{
						if(sValue)
						{
							var oOrg = new KEXTOrg();
							oOrg.fromPersistenceString(sValue);
							_super.setOrg(oOrg);
						}
						funNextStep();
					});
			});
	}
	
	this.remoteGetLinkDataExcute = function(){
		var oFacade = _super.getFacade(
				function(rev)
				{
					_super.getReport().ChartsLinkHandler(rev);
		});
		var oParamsValues = _super.getParamsValues();
		var sParamsValues = (oParamsValues ? oParamsValues.toJsonStringForExecute() : null);
		sParamsValues = (sParamsValues == "[]" ? null : sParamsValues);//服务端有bug，临时先这样
		KEXTInnerLinkController.setExcuteInnerLink(function(params){
			if(params.srcType == "cell")
				oFacade.getCellInnerLinkData( _this.getOrgId(), _super.getReportId(),_super.getReport().getCurrentSheetName(),sParamsValues, params);
			else //if(params.srcType == "chart")
				oFacade.getChartInnerLinkData( _this.getOrgId(), _super.getReportId(), _super.getReport().getCurrentSheetName(), sParamsValues, params);
		});
	}
	
	var remoteCompositeExecute = function()
	{
		var oParamsValues = new KEXTParamsValues();
		oParamsValues.setSaveAsScheme(false);
		KEXTLocalStorage.save(KEXT_STORAGE_KEY_TOP_PARAM_PREFIX+_this.getReportId(), oParamsValues.toJsonStringForPersistence());
		
		var oFacade = _super.getFacade(remoteCompositeExecuteCallback, remoteCompositeExecuteError);
		var oParamsValues = _super.getParamsValues();
		var sParamsValues = (oParamsValues ? oParamsValues.toJsonStringForExecute() : null);
		sParamsValues = (sParamsValues == "[]" ? null : sParamsValues);//服务端有bug，临时先这样
		oFacade.compositeExecute(_super.getReportId(), _this.getOrgId(), sParamsValues, _super.getOutParams());
	}
	
	var remoteCompositeExecuteCallback = function(oData)
	{
		
		var oJsonOrg = oData["currentOrg"];
		if(oJsonOrg)
		{
			var oOrg = new KEXTOrg();
			oOrg.fromJsonObject(oJsonOrg);
			_super.setOrg(oOrg);
		}
		
		var bMoreOrgs = false;
		if(!_bFromHyperlink)
		{
			var bMoreOrgs = oData["moreOrgs"];
			_super.setMoreOrgs(bMoreOrgs);
		}
		
		var bHasFilter = oData["hasFilter"];
		var bIsAllCommonParams = oData["isAllCommonParams"];
		_super.showFilterButtonAtToolbar((bMoreOrgs || bHasFilter) && !bIsAllCommonParams);
		if(bHasFilter)
		{
			var oTopFilterBar;
			var oJsonFilter = oData["filter"];
			_super.setAssociate(oJsonFilter["associate"], oJsonFilter["associateWithOrg"]);
			var arrParamsDescs = oJsonFilter["params"];
			_super.setParamsDescs(arrParamsDescs);
			var isUseLastSaveParam = oData["isUseLastSaveParam"];
			KEXTLocalStorage.save(KEXT_STORAGE_KEY_SERVER_IS_USE_LASTSAVE_PARAM_PREFIX+_super.getReportId(), isUseLastSaveParam);
			if (oData["commonParams"] && oData["commonParams"].length > 0)
			{
				oTopFilterBar = _this.getTopFilterBar();
				oTopFilterBar.setFacadeCreator(_super.getFacade);
				oTopFilterBar.setConfirmListener(_this.update);
				oTopFilterBar.setCurrentOrgGetter(
							function()
							{
								if(_this.isMoreOrgs())
								{
									return null;
								}
								return _this.getOrgId();
							});
				oTopFilterBar.updateUi(_super.getReportId(),arrParamsDescs,_super.getParamsValues(),_super.getAssociate(), oData["firstPlaceHolder"],oData["commonParams"],oData["lastPlaceholder"]);
			}
			
			if(oData["isRequiredEmpty"])
			{
				if (oTopFilterBar)
				{
					_super.getToolbar().getJqUi().show();
					//在顶部过滤器中，选择参数
					oTopFilterBar.forwardToInputCtrl();
				}
				else
				{
					_funForwardFilter(_super.getReportId(), arrParamsDescs, _super.getParamsValues(), _super.getAssociate(), _super.getOrg(), true);
				}
			}
			else
			{
				_super.showReportContent(oData["reportContent"]);
			}
		}
		else
		{
			_super.setParamsDescs(null);
			_super.showReportContent(oData["reportContent"]);
		}
		
		var oCloudReportSupporter =  _super.initForCloudReport(oData);
		oCloudReportSupporter && oCloudReportSupporter.reportExecuted();
		
		if(_funForwardHistory)
		{
			_super.getToolbar().addButton(kdlight.Toolbar.POS_RIGHT, "btnHistory", "历史快照", 
				function()
				{
					_funForwardHistory(_super.getReportId());
				});
		}

		if(_bShowTitleInReportTitle)
		{
			_super.getToolbar().addTitle(_this.getTitle());
			
			if(KEXTUtil.hasEnterFromStatus([KEXTUtil.CONSTANTS.Enter_From_Preview]))
			{
				$(".kdlight-toolbar-title").removeClass("fontWeightBold");
			}
		}
	}
	
	var remoteCompositeExecuteError = function(iErrorCode, sErrorInfo)
	{
		_super.doBackwardClick();
	}

	var doRefreshClick = function()
	{
		_super.remoteGetReportContent();
	}
	
	var doHyperlinkClick = function(sReportName, sReportTag, oParamsValues)
	{
		_funForwardNextReport(_super.getOrg(), sReportName, sReportTag, oParamsValues, _super.getOutParams());
	}
}

/**
 * 快照内容页面
 */
function KEXTSnapshotPage()
{
	KEXTAbstractReportPage.call(this);

	var _this = this;
	var _super = this.protectedMethod;
	
	var _jqPrompt;
	var _sSnapshotTag;
	var _funForwardNextReport;
	var _bNoRefreshMode = false;
	
	/** funCallback like: func(sReportId, arrParamsDescs, oParamsValues, oAssociateModel) */
	this.setForwardFilterListener = function(funCallback)
	{
		if(funCallback)
		{
			var funImpl = function()
			{
				funCallback(_super.getReportId(), _super.getParamsDescs(), _super.getParamsValues(), _super.getAssociate());
			};
			_super.setProtectedImplForForwardFilter(funImpl);
		}
		else
		{
			_bNoRefreshMode = true;
		}
	}
	
	/** funCallback like: func(oOrg, sReportName, sReportTag, sParamsValues) */
	this.setForwardNextReportListener = function(funCallback)
	{
		_funForwardNextReport = funCallback;
	}
	
	/**
	 * 第一次进入显示快照
	 */
	this.execute = function(jqOwner, sTitle, sReportId, sSnapshotTag, sSnapshotPrompt, bPromptTextAway)
	{
		_super.setTitle(sTitle);
		_super.setReportId(sReportId);
		_sSnapshotTag = sSnapshotTag;

		_super.setProtectedImplForGetFilterOtherInfo(remoteGetSnapshotParamValue);
		_super.setProtectedImplForRefresh(_bNoRefreshMode ? null : doRefreshClick);
		_super.setProtectedImplForReportContentBeforeUpdate(hidePrompt);
		_super.getReport().setHyperlinkListener(doHyperlinkClick);//TODO 无联查的场景
		
		_super.initPage(jqOwner)
		initCustom(jqOwner, bPromptTextAway);

		showPrompt(sSnapshotPrompt);
		remoteGetSnapshot();
	}
	
	//取快照内容
	var remoteGetSnapshot = function()
	{
		var oFacade = _super.getFacade(remoteGetSnapshotCallback, remoteGetSnapshotError);
		oFacade.getSnapshotContent(_super.getReportId(), _sSnapshotTag);
	}
	
	var remoteGetSnapshotCallback = function(oData)
	{
		var oParamsValues = new KEXTParamsValues();
		oParamsValues.setSaveAsScheme(false);
		KEXTLocalStorage.save(KEXT_STORAGE_KEY_TOP_PARAM_PREFIX+_super.getReportId, oParamsValues.toJsonStringForPersistence());
		
		var bHasFilter = oData["hasFilter"];
		_super.showFilterButtonAtToolbar(bHasFilter && !_bNoRefreshMode);
		_super.setOrg(new KEXTOrg(oData["org"]["value"], oData["org"]["text"]));
		if(bHasFilter)
		{
			var oJsonFilter = oData["filter"];
			_super.setAssociate(oJsonFilter["associate"], oJsonFilter["associateWithOrg"]);
			var arrParamsDescs = oJsonFilter["params"];
			_super.setParamsDescs(arrParamsDescs);
			var arrJsonParamsValues = oData["values"];
			var oParamsValues = new KEXTParamsValues();
			oParamsValues.fromPersistenceJsonObject(arrJsonParamsValues);
			_super.setParamsValues(oParamsValues);
			var isUseLastSaveParam = oData["isUseLastSaveParam"];
			KEXTLocalStorage.save(KEXT_STORAGE_KEY_SERVER_IS_USE_LASTSAVE_PARAM_PREFIX+_super.getReportId(), isUseLastSaveParam);
			if (oData["commonParams"] && oData["commonParams"].length > 0)
			{	
				var oTopFilterBar = _this.getTopFilterBar();
				oTopFilterBar.setFacadeCreator(_super.getFacade);
				oTopFilterBar.setConfirmListener(_this.update);
				oTopFilterBar.setCurrentOrgGetter(
							function()
							{
								if(_this.isMoreOrgs())
								{
									return null;
								}
								return _this.getOrgId();
							});
				oTopFilterBar.updateUi(_super.getReportId(),arrParamsDescs,_super.getParamsValues(),_super.getAssociate(), oData["firstPlaceHolder"],oData["commonParams"],oData["lastPlaceholder"]);
			}
		}else
		{
			_super.setParamsDescs(null);
		}
		
		_super.showReportContent(oData["reportContent"]);
		
		_super.initForCloudReport(oData);
	}
	
	var remoteGetSnapshotError = function(iErrorCode, sErrorInfo)
	{
		_super.doBackwardClick();
	}
	
	//取快照执行时的参数值
	var remoteGetSnapshotParamValue = function(funCallback, iCallbackMark)
	{
		var oFacade = _super.getFacade(
			function(oData)
			{
				var arrJsonParamsValues = oData["params"];
				var oParamsValues = new KEXTParamsValues();
				oParamsValues.fromPersistenceJsonObject(arrJsonParamsValues);
				_super.setParamsValues(oParamsValues);
				funCallback(iCallbackMark);
			});
		oFacade.getSnapshotParamValue(_super.getReportId(), _sSnapshotTag);
	}

	var initCustom = function(jqOwner, bPromptTextAway)
	{
		_jqPrompt = $("<div>");
		if(bPromptTextAway)
		{
			_jqPrompt.css("left", 60);
		}
		_jqPrompt.addClass("snapshot-prompt");
		_jqPrompt.css("z-index", -1);
		_super.getToolbar().getJqUi().append(_jqPrompt);
		KEXTUtil.bindProgramerMenuListener(_jqPrompt, 
			function()
			{
				var jqText = $('<textarea style="position:absolute; left:10px; right:10px; top:20px; bottom:80px; z-index:99999">');
				jqText.text(window.location);
				
				var jqBtn = $('<div style="position:absolute; left:10px; right:10px; height:50px; bottom:20px; z-index:99999; background:#369; line-height:50px; text-align:center">Quit</div>');
				jqBtn.on("click", 
					function()
					{
						jqText.remove();
						jqBtn.remove();
					});
				
				jqOwner.append(jqText);
				jqOwner.append(jqBtn);
			});
	}
	
	var doRefreshClick = function()
	{
		if(!_super.getParamsValues())
		{
			remoteGetSnapshotParamValue(
				function()
				{
					_super.remoteGetReportContent();
				});
		}
		else
		{
			_super.remoteGetReportContent();
		}
	}
	
	var showPrompt = function(sText)
	{
		_jqPrompt.text(sText);
	}
	
	var hidePrompt = function()
	{
		if(_jqPrompt)
		{
			_jqPrompt.remove();
			_jqPrompt = null;
			_super.showInfo("已更新为实时数据");
		}
	}

	var doHyperlinkClick = function(sReportName, sReportTag, oParamsValues)
	{
		_funForwardNextReport && _funForwardNextReport(_super.getOrg(), sReportName, sReportTag, oParamsValues);
	}
}

function KEXTTopFilterBar(_jqContentOwner)
{
	KEXTAbstractPage.call(this);
	var _this = this;
	var _super = this.protectedMethod;
	var _jqContentOwner = _jqContentOwner;
	var _jqFilterBar = $("<div class='kdlight-top-filter-bar'></div>");
	var _jqFilterContent = $("<div class='kdlight-top-filter-content'></div>");
	var _bIsFirstUpdate = true;
	var _funCurrentOrgGetter;
	var _oFilter = new KEXTReportTopFilter();
	var _funForwardFilterListener;
	this.setForwardFilterListener = function(funCallback)
	{
		_oFilter.setForwardToFilterPageListener(funCallback);
	}
	
	this.getSelecteds = function()
	{
		return _oFilter.getSelecteds();
	}
	
	this.show  = function (bIsShow)
	{
		var iFilterBarHeight = parseInt($(_jqFilterBar).css("height"));
		var iToolBarHeight = parseInt($(".kdlight-toolbar:first").css("height"))+parseInt($(".kdlight-toolbar:first").css("border-bottom-width"));
		if (bIsShow)
		{
			$(_jqFilterBar).show();
			$(_jqContentOwner).css("top",iFilterBarHeight+iToolBarHeight+"px");
			$(_jqFilterContent).css("top",iFilterBarHeight+iToolBarHeight+"px");
		}
		else
		{
			$(_jqFilterBar).hide();
			$(_jqContentOwner).css("top",iToolBarHeight+"px");
		}
	}
	
	this.updateUi = function(sReportId, arrParamDescs, oParamsValues, oAssociateModel,iFirstPlace,commonParams,iLastPlace)
	{
		//服务端标志位
		KEXTLocalStorage.load(KEXT_STORAGE_KEY_SERVER_IS_USE_LASTSAVE_PARAM_PREFIX+sReportId, function(bServerValueInner)
		{
			//客户端标志位
			KEXTLocalStorage.load(KEXT_STORAGE_KEY_CLIENT_IS_USE_LASTSAVE_PARAM_PREFIX+sReportId, function(bClientValueInner)
			{
				if (oParamsValues)
				{
					if (bClientValueInner)
					{
						oParamsValues.setSaveAsScheme(bClientValueInner=="true"?true:false);
					}
					else
					{
						oParamsValues.setSaveAsScheme(bServerValueInner=="true"?true:false);
					}
				}
				else
				{
					oParamsValues = new KEXTParamsValues();
					oParamsValues.setSaveAsScheme(bServerValueInner=="true"?true:false);
				}
				
				if (_bIsFirstUpdate)
				{
					_this.show(true);
					_oFilter.setReportId(sReportId);
					_oFilter.setFirstPlace(iFirstPlace);
					_oFilter.setLastPlace(iLastPlace);
					_oFilter.setAssociate(oAssociateModel);
					_oFilter.setModel(commonParams,arrParamDescs);
					_oFilter.setDelayedSuppliedValueGetter(
						function(sParamName, sDatasetXml, sJsonParamsValues, funCallback)
						{
							getDelaySuppliedValue(sReportId, sParamName, sDatasetXml, sJsonParamsValues, funCallback);
						});
					_oFilter.setLastTimeValue(oParamsValues);
					_oFilter.draw(_jqFilterBar);
					_bIsFirstUpdate = false;
				}
				else
				{
					_oFilter.setLastTimeValue(oParamsValues);
				}
			});
		});
	}
	
	this.updateValues = function(oParamsValues)
	{
		if (!_bIsFirstUpdate)
		{
			_oFilter.setLastTimeValue(oParamsValues);
		}
	}
	
	/** funGetter like: func() return orgId，如果组织已合并到过滤界面，则返回null */
	this.setCurrentOrgGetter = function(funGetter)
	{
		_funCurrentOrgGetter = funGetter
	}
	
	var getDelaySuppliedValue = function(sReportId, sParamName, sDatasetXml, sJsonParamsValues, funCallback)
	{
		var sOrgId = _funCurrentOrgGetter();
		if(!sOrgId)
		{
			var arrVTM = _oFilter.getSelectedValueForCtrl(KEXTFilterPage.ID_FOR_ORG);
			var oVTM = arrVTM[0];
			sOrgId = oVTM.getValue();
		}
		var oFacade = _super.getFacade(funCallback);
		oFacade.getFilterDelayData(sOrgId, sReportId, sParamName, sDatasetXml, sJsonParamsValues);
	}
	
	this.forwardToInputCtrl = function()
	{
		_oFilter.forwardToInputCtrl();
	}
	
	this.clearCurrentCtrl = function()
	{
		_oFilter.clearCurrentCtrl();
	}
	
	this.setConfirmListener = function (funCallback)
	{
		_oFilter.setConfirmListener(funCallback);
	}
	
	this.getJqUiBar = function()
	{
		return _jqFilterBar;
	}
	
	this.getJqUiContent = function()
	{
		return _jqFilterContent;
	}
}
/**
 * 过滤器页面
 */
function KEXTFilterPage()
{
	KEXTAbstractPage.call(this);
	var _super = this.protectedMethod;
	
	var _funBackward;
	var _funForward;
	var _funCurrentOrgGetter;
	var _funIntoSubUi;
	var _oFilter = new KEXTReportFilter();
	var _jqScrollContainer;
	var _oConfirmBar;
	var _jqConfirmBar;
	var _jqScrollView;
	var _oInfoRoller;
	
	this.setBackwardListener = function(funCallback)
	{
		_funBackward = funCallback;
	}
	
	this.setForwardListener = function(funCallback)
	{
		_funForward = funCallback;
	}
	
	/** funGetter like: func() return orgId，如果组织已合并到过滤界面，则返回null */
	this.setCurrentOrgGetter = function(funGetter)
	{
		_funCurrentOrgGetter = funGetter
	}
		
	this.updateUi = function(jqOwner, sReportId, arrParamDescs, oParamsValues, oAssociateModel)
	{
		initPage(jqOwner);
		updateCancelVisible();
		
		_oFilter.setAssociate(oAssociateModel);
		_oFilter.setModel(arrParamDescs);
		_oFilter.setDelayedSuppliedValueGetter(
			function(sParamName, sDatasetXml, sJsonParamsValues, funCallback)
			{
				getDelaySuppliedValue(sReportId, sParamName, sDatasetXml, sJsonParamsValues, funCallback);
			});
		KEXTLocalStorage.load(KEXT_STORAGE_KEY_TOP_PARAM_PREFIX+sReportId, 
			function(sValue)
			{
				if(sValue != "NO_SCHEME")
				{
					oParamsValues = new KEXTParamsValues();
					oParamsValues.fromPersistenceJsonString(sValue);
				}
				//服务端标志位
				KEXTLocalStorage.load(KEXT_STORAGE_KEY_SERVER_IS_USE_LASTSAVE_PARAM_PREFIX+sReportId, function(bServerValueInner)
				{
					//客户端标志位
					KEXTLocalStorage.load(KEXT_STORAGE_KEY_CLIENT_IS_USE_LASTSAVE_PARAM_PREFIX+sReportId, function(bClientValueInner)
					{
						if (oParamsValues)
						{
							if (bClientValueInner)
							{
								oParamsValues.setSaveAsScheme(bClientValueInner=="true"?true:false);
							}
							else
							{
								oParamsValues.setSaveAsScheme(bServerValueInner=="true"?true:false);
							}
						}
						else
						{
							oParamsValues = new KEXTParamsValues();
							oParamsValues.setSaveAsScheme(bServerValueInner=="true"?true:false);
						}
						_oFilter.setLastTimeValue(oParamsValues);
						_oFilter.draw(_jqScrollContainer);
						setTimeout(
							function()
							{
								$(document.body).animate(
									{
										scrollTop: 0
									},
									"fast");
							}, 500);
					});
				});
			});
	}
	
	this.setIntoSubUiListener = function(funCallback)
	{
		_funIntoSubUi = funCallback;
	}
	
	var initPage = function(jqOwner)
	{
		if(_jqScrollContainer)
		{
			_jqScrollContainer.children().remove();
			return;
		}
		
		_oConfirmBar = createToolbar();
		_jqConfirmBar = _oConfirmBar.getJqUi();
		jqOwner.append(_jqConfirmBar);		
		_oConfirmBar.addTitle("筛选");
		
		_jqScrollView = $("<div class='scrollView'>");
		_jqScrollView.css("position", "absolute");
		_jqScrollView.css("top", "45px");
		_jqScrollView.css("bottom", "0");
		_jqScrollView.css("left", "0");
		_jqScrollView.css("right", "0");	
		_jqScrollView.css("background-color", "#FFFFFF");
		jqOwner.append(_jqScrollView);
		
		_jqScrollContainer = $("<div class='scrollContainer'>");
		_jqScrollContainer.css("position", "absolute");
		_jqScrollContainer.css("top", "0");
		_jqScrollContainer.css("bottom", "0");
		_jqScrollContainer.css("left", "0");
		_jqScrollContainer.css("right", "0");
		_jqScrollContainer.css("overflow-x", "hidden");
		_jqScrollContainer.css("overflow-y", "auto");
		_jqScrollView.append(_jqScrollContainer);
		KEXTUtil.setSimScrollbar(_jqScrollContainer, _jqScrollView);			
		
		_oInfoRoller = new KEXTInfoRoller();
		_oInfoRoller.getJqUi().css("z-index", 3);
		jqOwner.append(_oInfoRoller.getJqUi());
		
		_jqScrollContainer.on("scroll",jqContentOwnerScrollListener)
	}
	
	var jqContentOwnerScrollListener = function(event)
	{
		var filterCtrlContents = _jqScrollContainer.find(".kdlight-filter-item-content");
		var iConfirmBar_height = _jqConfirmBar.height();
		for (var i = 0;i<filterCtrlContents.length;i++)
		{
			var jqFilterCtrlContent = $(filterCtrlContents[i]);
			var filterCtrlContent_offsettop = jqFilterCtrlContent.offset().top;
			var filterCtrlContent_height = jqFilterCtrlContent.height();
			
			var filterLable = $(jqFilterCtrlContent.parent().find(".kdlight-filter-item-title")[0]);
			if (filterCtrlContent_height > iConfirmBar_height*2)
			{
				if (filterCtrlContent_offsettop < iConfirmBar_height*2-12)//上边界溢出
				{
					if (filterCtrlContent_offsettop+filterCtrlContent_height < iConfirmBar_height*2-12)//下边界溢出
					{
						filterLable.hide();
					}
					else
					{	
						if (!filterLable.hasClass("kdlight-filter-item-title-fixed"))
						{
							filterLable.addClass("kdlight-filter-item-title-fixed");
							jqFilterCtrlContent.css("margin-top",44+"px");
						}
						filterLable.show();
					}
				}				
				else 
				{
					if (filterLable.hasClass("kdlight-filter-item-title-fixed"))
					{
						filterLable.removeClass("kdlight-filter-item-title-fixed");
						jqFilterCtrlContent.css("margin-top",0+"px");
					}
					filterLable.show();
				}
			}
		}
	}
	
	var createToolbar = function()
	{
		var oBar = new kdlight.Toolbar();
		oBar.addButton(kdlight.Toolbar.POS_LEFT, "btnCancel", "< 取消", doBackwardClick);
		//oBar.addSeperator(kdlight.Toolbar.POS_LEFT);
		oBar.addButton(kdlight.Toolbar.POS_RIGHT, "btnOK", "确定", doOkClick);
		_oFilter.setUiChangeListener(
			function(bAllFilterLayer, bSubLayerCanFinish)
			{
				if(bAllFilterLayer)
				{
					updateOkVisible(true);
					updateCancelVisible();
				}
				else
				{
					updateOkVisible(bSubLayerCanFinish);//true for 多选
					if(_funIntoSubUi)
					{
						_funIntoSubUi();
					}
				}
			});
		return oBar;
	}
	
	var updateOkVisible = function(bVisible)
	{
		_oConfirmBar.setButtonVisible("btnOK", bVisible);
	}
	
	var updateCancelVisible = function()
	{
		_oConfirmBar.setButtonVisible("btnBack", _funBackward ? true : false);
	}
	
	var promptRequired = function(sParamName)
	{
		_oInfoRoller.clearInfos();
		_oInfoRoller.pushInfo(sParamName + " 是必填项。", 0);
	}
	
	var doBackwardClick = function()
	{
		if(_oFilter.askBackward() && _funBackward)
		{
			_funBackward();
		}
	}
	
	var doOkClick = function()
	{
		if (!_oFilter.interceptConfirm(_oInfoRoller.pushInfo))
		{
			var arrEmptyParamNames = _oFilter.getRequiredEmpty();
			if(arrEmptyParamNames && arrEmptyParamNames.length > 0)
			{
				_oInfoRoller.clearInfos();
				for(var i = 0; i < arrEmptyParamNames.length; i++)
				{
					_oInfoRoller.pushInfo("“" + arrEmptyParamNames[i] + "”是必填项。", (i == 0 ? 0 : 500), 4000);
				}
			}
			else
			{
				var oParamsValues = _oFilter.getSelecteds();
				_funForward(oParamsValues);
			}
		}
	}
	
	var getDelaySuppliedValue = function(sReportId, sParamName, sDatasetXml, sJsonParamsValues, funCallback)
	{
		var sOrgId = _funCurrentOrgGetter();
		if(!sOrgId)
		{
			var arrVTM = _oFilter.getSelectedValueForCtrl(KEXTFilterPage.ID_FOR_ORG);
			var oVTM = arrVTM[0];
			sOrgId = oVTM.getValue();
		}
		var oFacade = _super.getFacade(funCallback);
		oFacade.getFilterDelayData(sOrgId, sReportId, sParamName, sDatasetXml, sJsonParamsValues);
	}
	
	var _superKeepState = this.keepState;
	this.keepState = function()
	{
		_superKeepState();
		KEXTUtil.bindHardwareBackwardActionForLight(doBackwardClick, false);
	}
	
	var _superRestoreState = this.restoreState;
	this.restoreState = function()
	{
		_superRestoreState();
		KEXTUtil.bindHardwareBackwardActionForLight(doBackwardClick, true);
	}
}
KEXTFilterPage.ID_FOR_ORG = "kdext.system_org_as_filter";


/**
 * 包含报表的应用场景的抽象基类
 * 该类维护一个栈，其节点是报表页面封装类、过滤器页面封装类及它们的页面，该栈使报表联查及回退成为可能。
 */
function KEXTAbstractReportFamily()
{
	var KEY_REPORT = "oReport";
	var KEY_REPORT_UI = "jqReport";
	var KEY_FILTER = "oFilter";
	var KEY_FILTER_UI = "jqFilter";
	
	var _oRemoteCallImpl;
	
	var _arrCoupleStack = [];
	var _iStackCursor = -1;
	
	var getCurrentElement = function()
	{
		return _arrCoupleStack[_iStackCursor];
	}
	
	var getReportPage = function()
	{
		var oElement = getCurrentElement();
		return (oElement ? oElement[KEY_REPORT] : null);
	}
	
	var getFilterPage = function()
	{
		var oElement = getCurrentElement();
		return (oElement ? oElement[KEY_FILTER] : null);
	}
	
	var getReportPageJqUi = function()
	{
		var oElement = getCurrentElement();
		return (oElement ? oElement[KEY_REPORT_UI] : null);
	}
	
	var getFilterPageJqUi = function()
	{
		var oElement = getCurrentElement();
		return (oElement ? oElement[KEY_FILTER_UI] : null);
	}
	
	//param like func(iCurrentLevel), return ReportPage instance.
	var pushNewReport = function(funReportPageCreator)
	{
		if(_iStackCursor < _arrCoupleStack.length - 1)
		{
			destroyOverdue();
		}
		_iStackCursor++;
		var jqReportPage = createPageJqUi();
		var oReportPage = funReportPageCreator(_iStackCursor);
		
		var oElement = {};
		oElement[KEY_REPORT] = oReportPage;
		oElement[KEY_REPORT_UI] = jqReportPage;
		_arrCoupleStack.push(oElement);
	}
	
	var destroyOverdue = function()
	{
		for(var i = _arrCoupleStack.length - 1; i > _iStackCursor; i--)
		{
			var oElement = _arrCoupleStack.pop();
			var jqReportPage = oElement[KEY_REPORT_UI];
			var oReportPage = oElement[KEY_REPORT];
			var jqFilterPage = oElement[KEY_FILTER_UI];
			var oFilterPage = oElement[KEY_FILTER];
			
			oReportPage.destroy();
			jqReportPage.remove();
			if(jqFilterPage)
			{
				oFilterPage.destroy();
				jqFilterPage.remove();
			}
		}
	}
	
	//param like func(oFilterPage)
	var addFilterPage = function(funInitFilterPage)
	{
		var oFilterPage = new KEXTFilterPage();
		funInitFilterPage(oFilterPage);
		var jqFilterPage = createPanelJqUi();
		
		var oElement = getCurrentElement();
		if(!oElement)
		{
			throw new Error("Bad invoking opportunity.");
		}
		oElement[KEY_FILTER] = oFilterPage;
		oElement[KEY_FILTER_UI] = jqFilterPage;
	}
		
	var backwardPreviousReport = function()
	{
		_iStackCursor--;
		return (_iStackCursor >= 0);
	}
	
	var createPageJqUi = function()
	{
		var jqPage = $('<div data-role="page">');
		$(document.body).append(jqPage);
		jqPage.pagecontainer();
		return jqPage;
	}
	
	var createPanelJqUi = function()
	{
		var jqPage = $('<div class="kdlight-filter-panel">');
		jqPage.css({
			"left":"320px"
		});
		jqPage.append('<div class="kdlight-filter-panel-background">');
		if ($(".kdlight-filter-panel-dismiss").length == 0)
		{
			var jqDismiss = $("<div class='kdlight-filter-panel-dismiss'>");
			jqDismiss.css({
				"display":"none"
			});
			$(document.body).append(jqDismiss);
		}
		$(document.body).append(jqPage);
		return jqPage;
	}
	
	var slideToPage = function(oFromPage, oToPage, jqToPage, bBackwardSlide, sTransition)
	{
		var jqTarget = $(document.body);
		oFromPage.keepState();
		var funEvent = function(evt)
		{
			jqTarget.unbind("pagecontainershow", funEvent);
			oToPage.restoreState();
			KEXTUtil.fixJqmPage(jqToPage);//for preview
		};
		jqTarget.bind("pagecontainershow", funEvent);
		if(oToPage.getReportId && oToPage.getReportId())
			oToPage.remoteGetLinkDataExcute();
		var oOptions = {transition: (sTransition ? sTransition : "slide")};
		if(bBackwardSlide)
		{
			oOptions["reverse"] = true;
		}
		oOptions["changeHash"] = false;
		jqTarget.pagecontainer("change", jqToPage, oOptions);
	}
	
	this.setRemoteImpl = function(oImpl)
	{
		_oRemoteCallImpl = oImpl;
	}
	var createRemoteFacade = function(funCallback, funErrorCallback)
	{
		return new KEXTFacade(_oRemoteCallImpl, funCallback, funErrorCallback);
	}
		
	this.protectedMethod =
	{
		"getReportPage": getReportPage,
		"getFilterPage": getFilterPage,
		"getReportPageJqUi": getReportPageJqUi,
		"getFilterPageJqUi": getFilterPageJqUi,
		"pushNewReport": pushNewReport,
		"addFilterPage": addFilterPage,
		"backwardPreviousReport": backwardPreviousReport,
		"createPageJqUi": createPageJqUi,
		"slideToPage": slideToPage,
		"createRemoteFacade": createRemoteFacade
	};
}

/**
 * 报表中心
 */
function KEXTCenter()
{
	KEXTAbstractNavigatorPane.call(this);
	KEXTAbstractReportFamily.call(this);
	
	var _this = this;
	var _super = this.protectedMethod;
	var _jqMainListPage;
	var _oMainListPage;	
	var _sTitle;
	var _sSubjectId;//app叫主题，轻应用叫公共号
	
	var _jqHistoryPage;
	var _oHistoryPage;
	
	var _bHideYZJToolbar = false;
	
	this.createUi = function(jqPage, sTitle, sSubjectId, jqParent, arrPopItems)
	{
		_sTitle = sTitle;
		_sSubjectId = sSubjectId;
		KEXTUtil.setEnvTitle(_sTitle);
		if(arrPopItems)
		{
			KEXTUtil.setEnvPop(arrPopItems);
		}
		_jqMainListPage = jqPage;
		_oMainListPage = new KEXTMainListPage	();
		_oMainListPage.setSubjectId(sSubjectId);
		_oMainListPage.setFacadeCreator(_super.createRemoteFacade);
		_oMainListPage.setRunReportListener(jumpFromListToReport);
		_oMainListPage.createUi(jqParent ? jqParent : jqPage);
	}
	
	this.setHideYZJToolbar = function(b)
	{
		_bHideYZJToolbar = b;	
	}
	
	/** Call after createUi().  funListener like: func(bFullScreen) */
	this.setRequestFullScreenListener = function(funListener)
	{
		_oMainListPage.setRequestFullScreenListener(
			function(bShowMoreItem)
			{
				funListener(bShowMoreItem);
			});
	}
	
	this.keepState = function()
	{
		_oMainListPage.keepState();
	}
	
	this.restoreState = function()
	{
		_oMainListPage.restoreState();
	}
	
	var jumpFromListToReport = function(sReportName, sReportId)
	{
		if(!_super.getReportPage())
		{
			_super.pushNewReport(
				function(iCurrentLevel)
				{
					var oReportPage = new KEXTReportPage();
					oReportPage.setFacadeCreator(_super.createRemoteFacade);
					oReportPage.setBackwardListener(backFromReportToLastPage);
					oReportPage.setForwardFilterListener(jumpFromReportToFilter);
					oReportPage.setForwardNextReportListener(jumpFromReportToNextReport);
					// oReportPage.setForwardHistoryListener(jumpFromReportToHistory);
					return oReportPage;
				});
		}
		KEXTUtil.setEnvTitle(sReportName);
		var jqCurrentReportPage = _super.getReportPageJqUi();
		var oCurrentReportPage = _super.getReportPage();
		try
		{	
			if(_bHideYZJToolbar)
			{
				XuntongJSBridge.call('setWebViewTitleBar',{'isShow':'false'}); //如果在云之家環境，關閉云之家頭部，將標題寫入報表工具欄		
				oCurrentReportPage.showTitleInReportToolbar(true);
			} 
		}
		catch(e)
		{
			
		}
		_super.slideToPage(_oMainListPage, oCurrentReportPage, jqCurrentReportPage);
		oCurrentReportPage.setSubjectId(_sSubjectId);
		oCurrentReportPage.execute(jqCurrentReportPage, sReportName, sReportId, null);
	}
	
	var jumpFromReportToFilter = function(sReportId, arrParamsDescs, oParamsValues, oAssociateModel, oOrg, bShowReportFirstTime)
	{
		if(!_super.getFilterPage())
		{
			_super.addFilterPage(
				function(oFilterPage)
				{
					oFilterPage.setFacadeCreator(_super.createRemoteFacade);
					oFilterPage.setCurrentOrgGetter(
						function()
						{
							if(_super.getReportPage().isMoreOrgs())
							{
								return null;
							}
							return _super.getReportPage().getOrgId();
						});
				});
		}
		var oFilterPage = _super.getFilterPage();
		oFilterPage.setBackwardListener(
			function()
			{
				backFromFilterToReport(bShowReportFirstTime, null);		
				$(".kdlight-filter-panel-dismiss").css("display","none");
				$(jqFilterPage).css("display","none");
				$(jqFilterPage).animate({left: 320},300);
			});
		oFilterPage.setForwardListener(
			function(oParamsValues)
			{
				backFromFilterToReport(bShowReportFirstTime, oParamsValues);
				$(".kdlight-filter-panel-dismiss").css("display","none");
				$(jqFilterPage).css("display","none");
				$(jqFilterPage).animate({left: 320},300);
			});
		var sTransition = (bShowReportFirstTime ? "fade" : null);
		var jqFilterPage = _super.getFilterPageJqUi();
		$(".kdlight-filter-panel-dismiss").css("display","block");
		$(jqFilterPage).css("display","block");
		$(jqFilterPage).animate({left: 0},300);
		oFilterPage.updateUi(jqFilterPage, sReportId, arrParamsDescs, oParamsValues, oAssociateModel);
		
	}
		
	var backFromFilterToReport = function(bFromMainListInto, oParamsValues)
	{
		var bToUpdateReport = (oParamsValues ? true : false);
		if(bFromMainListInto && !bToUpdateReport)
		{
			//从列表进来，但点了回退，进接退回列表
			backFromReportToLastPage();
		}
		else
		{
			var bBackwardSlide = !bFromMainListInto;
			var sTransition = (bFromMainListInto ? "fade" : null);
			_super.slideToPage(_super.getFilterPage(), _super.getReportPage(), _super.getReportPageJqUi(), bBackwardSlide, sTransition);
			_super.getReportPage().update(bToUpdateReport, oParamsValues);
		}
	}
	
	var backFromReportToLastPage = function()
	{
		var oFromReportPage = _super.getReportPage();
		if(_super.backwardPreviousReport())
		{
			var jqReportPage = _super.getReportPageJqUi();
			var oReportPage = _super.getReportPage();
			_super.slideToPage(oFromReportPage, oReportPage, jqReportPage, true);
			KEXTUtil.setEnvTitle(oReportPage.getTitle());
		}
		else
		{
			_super.slideToPage(oFromReportPage, _oMainListPage, _jqMainListPage, true);
			KEXTUtil.setEnvTitle(_sTitle);
			if(_jqHistoryPage)
			{
				_oHistoryPage.destroy();
				_jqHistoryPage.remove();
				_jqHistoryPage = null;
				_oHistoryPage = null;
			}
			
			try
			{
				if(_bHideYZJToolbar)
					XuntongJSBridge.call('setWebViewTitleBar',{'isShow':'true'}); //如果在云之家環境，關閉云之家頭部，將標題寫入報表工具欄
			}
			catch(e)
			{
				
			}
		}
	}
	
	var jumpFromReportToNextReport = function(oOrg, sReportName, sReportTag, oParamsValues)
	{
		var oFromReportPage = _super.getReportPage();
		_super.pushNewReport(
			function(iCurrentLevel)
			{
				var oReportPage = new KEXTReportPage();
				oReportPage.showTitleInReportToolbar(true);
				oReportPage.setFacadeCreator(_super.createRemoteFacade);
				oReportPage.setBackwardListener(backFromReportToLastPage);
				oReportPage.setForwardFilterListener(jumpFromReportToFilter);
				oReportPage.setForwardNextReportListener(jumpFromReportToNextReport);
				return oReportPage;
			});
		KEXTUtil.setEnvTitle(sReportName);
		var jqToReportPage = _super.getReportPageJqUi();
		var oToReportPage = _super.getReportPage();
		_super.slideToPage(oFromReportPage, oToReportPage, jqToReportPage);
		oToReportPage.setSubjectId(_sSubjectId);
		oToReportPage.execute(jqToReportPage, sReportName, sReportTag, oOrg, oParamsValues);
	}
	
	var jumpFromReportToHistory = function(sReportId)
	{
		if(!_jqHistoryPage)
		{
			_jqHistoryPage = _super.createPageJqUi();
			_oHistoryPage = new KEXTHistoryPage();
			_oHistoryPage.setFacadeCreator(_super.createRemoteFacade);
			_oHistoryPage.setBackwardListener(backFromHistoryToReport);
			_oHistoryPage.setForwardSnapshotListener(jumpFromHistoryToSnapshot);
			_oHistoryPage.createUi(_jqHistoryPage, sReportId);
		}
		_super.slideToPage(_super.getReportPage(), _oHistoryPage, _jqHistoryPage);
	}
	
	var backFromHistoryToReport = function()
	{
		var jqReportPage = _super.getReportPageJqUi();
		var oReportPage = _super.getReportPage();
		_super.slideToPage(_oHistoryPage, oReportPage, jqReportPage, true);
	}
	
	var jumpFromHistoryToSnapshot = function(sSnapshotUrl)
	{
		var oSnapshotPage = new KEXTSnapshotPage();
		oSnapshotPage.setFacadeCreator(_super.createRemoteFacade);
		oSnapshotPage.setBackwardListener(function(){backFromSnapshotToHistory(oSnapshotPage)});
		oSnapshotPage.setForwardFilterListener(null);
		oSnapshotPage.setForwardNextReportListener(null);
		var jqPage = _super.createPageJqUi();
		_super.slideToPage(_oHistoryPage, oSnapshotPage, jqPage);
		
		var sReportId = KEXTUtil.decodeParamFromUrl(sSnapshotUrl, "reportId");
		var sSnapshotTag = KEXTUtil.decodeParamFromUrl(sSnapshotUrl, "snapshotTag");
		var sTitle = KEXTUtil.decodeParamFromUrl(sSnapshotUrl, "title");
		var sPrompt = KEXTUtil.decodeParamFromUrl(sSnapshotUrl, "snapshotPrompt");
		sPrompt = (sPrompt ? "快照创建于 " + sPrompt : "快照");
		var bPromptTextAway = true;
		oSnapshotPage.execute(jqPage, sTitle, sReportId, sSnapshotTag, sPrompt, bPromptTextAway);
	}
	
	var backFromSnapshotToHistory = function(oSnapshotPage)
	{
		_super.slideToPage(oSnapshotPage, _oHistoryPage, _jqHistoryPage, true);
	}
}

/**
 * 从预警消息链接到快照
 * 这一层封装与报表中心对等
 */
function KEXTSingleSnapshotWrapper()
{
	KEXTAbstractReportFamily.call(this);
	
	var _this = this;
	var _super = this.protectedMethod;
	var _funBackwardListener;
	
	/** 注：轻应用的没有回退，APP的有回退 */
	this.setBackwardListener = function(funAction)
	{
		_funBackwardListener = funAction;
	}
	
	this.createUi = function(sTitle, sReportId, sSnapshotTag, sSnapshotPrompt)
	{
		KEXTUtil.setEnvTitle(sTitle);
		_super.pushNewReport(
			function()
			{
				var oSnapshotPage = new KEXTSnapshotPage();
				oSnapshotPage.setFacadeCreator(_super.createRemoteFacade);
				oSnapshotPage.setBackwardListener(_funBackwardListener);//maybe null then not show 返回
				oSnapshotPage.setForwardFilterListener(jumpFromReportToFilter);
				oSnapshotPage.setForwardNextReportListener(jumpFromReportToNextReport);
				return oSnapshotPage;
			});
		var bPromptTextAway = (_funBackwardListener ? true : false);
		var jqPage = _super.getReportPageJqUi();
		$(document.body).pagecontainer("change", jqPage, {transition:"none"});
		_super.getReportPage().execute(jqPage, sTitle, sReportId, sSnapshotTag, sSnapshotPrompt, bPromptTextAway);
	}
	
	var jumpFromReportToFilter = function(sReportId, arrParamsDescs, oParamsValues, oAssociateModel)
	{
		if(!_super.getFilterPage())
		{
			_super.addFilterPage(
				function(oFilterPage)
				{
					oFilterPage.setFacadeCreator(_super.createRemoteFacade);
					oFilterPage.setCurrentOrgGetter(
						function()
						{
							return _super.getReportPage().getOrgId();
						});
				}
			);
		}
		var oFilterPage = _super.getFilterPage();
		oFilterPage.setBackwardListener(
			function()
			{
				backFromFilterToReport(null);
				$(".kdlight-filter-panel-dismiss").css("display","none");
				$(jqFilterPage).css("display","none");
				$(jqFilterPage).animate({left: 320},300);
			});
		oFilterPage.setForwardListener(
			function(oParamsValues)
			{
				backFromFilterToReport(oParamsValues);
				$(".kdlight-filter-panel-dismiss").css("display","none");
				$(jqFilterPage).css("display","none");
				$(jqFilterPage).animate({left: 320},300);
			});
		var jqFilterPage = _super.getFilterPageJqUi();
		$(".kdlight-filter-panel-dismiss").css("display","block");
		$(jqFilterPage).css("display","block");
		$(jqFilterPage).animate({left: 0},300);
		//_super.slideToPage(_super.getReportPage(), oFilterPage, jqFilterPage);
		oFilterPage.updateUi(jqFilterPage, sReportId, arrParamsDescs, oParamsValues, oAssociateModel);
	}
	
	var backFromFilterToReport = function(oParamsValues)
	{
		var bToUpdateReport = (oParamsValues ? true : false);
		_super.slideToPage(_super.getFilterPage(), _super.getReportPage(), _super.getReportPageJqUi(), true);
		_super.getReportPage().update(bToUpdateReport, oParamsValues);
	}
	
	var jumpFromReportToNextReport = function(oOrg, sReportName, sReportTag, oParamsValues)
	{
		var oFromReportPage = _super.getReportPage();
		_super.pushNewReport(
			function(iCurrentLevel)
			{
				var oReportPage = new KEXTReportPage();
				oReportPage.setFacadeCreator(_super.createRemoteFacade);
				oReportPage.setBackwardListener(backFromNextReportToLastReport);
				oReportPage.setForwardFilterListener(jumpFromReportToFilter);
				oReportPage.setForwardNextReportListener(jumpFromReportToNextReport);
				return oReportPage;
			});
		KEXTUtil.setEnvTitle(sReportName);
		var jqToReportPage = _super.getReportPageJqUi();
		var oToReportPage = _super.getReportPage();
		_super.slideToPage(oFromReportPage, oToReportPage, jqToReportPage);
		oToReportPage.execute(jqToReportPage, sReportName, sReportTag, oOrg, oParamsValues);
	}

	var backFromNextReportToLastReport = function()
	{
		var oFromReportPage = _super.getReportPage();
		if(_super.backwardPreviousReport())
		{
			var jqReportPage = _super.getReportPageJqUi();
			var oReportPage = _super.getReportPage();
			_super.slideToPage(oFromReportPage, oReportPage, jqReportPage, true);
			KEXTUtil.setEnvTitle(oReportPage.getTitle());
		}
	}
}

/**
 * 执行单个报表的封装
 * 应用场景：
 * 预览，服务于设计期；
 * 轻应用应答单报表执行；
 */
function KEXTSingleReportWrapper()
{
	KEXTAbstractReportFamily.call(this);
	
	var _this = this;
	var _super = this.protectedMethod;
	
	var _callBackFunction = null;
	this.setCallBackFunction = function(callBackFunction)
	{
		_callBackFunction = callBackFunction;
	}

	this.createUi = function(sReportId, sReportName, sOutParams)
	{
		_super.pushNewReport(
			function()
			{
				var oReportPage = new KEXTReportPage();
				oReportPage.showTitleInReportToolbar(true);
				oReportPage.setFacadeCreator(_super.createRemoteFacade);
				oReportPage.setBackwardListener(_callBackFunction);
				oReportPage.setForwardFilterListener(jumpFromReportToFilter);
				oReportPage.setForwardNextReportListener(jumpFromReportToNextReport);
				oReportPage.setOutParams(sOutParams);
				return oReportPage;
			});
		var jqPage = _super.getReportPageJqUi();
		
		//修复jQueryMobile的page，详见KEXTUtil.fixJqmPage()。
		//第一次显示后事件在此（依赖slide），后续的页面切换事件在slideToPage()中。
		var funEvent = function(evt)
		{
			$(document.body).unbind("pagecontainershow", funEvent);
			KEXTUtil.fixJqmPage(jqPage);
		}
		$(document.body).bind("pagecontainershow", funEvent);
		
		$(document.body).pagecontainer("change", jqPage);
		_super.getReportPage().execute(jqPage, sReportName, sReportId, null);
	}
	
	var jumpFromReportToFilter = function(sReportId, arrParamsDescs, oParamsValues, oAssociateModel, oOrg, bShowReportFirstTime)
	{
		if(!_super.getFilterPage())
		{
			_super.addFilterPage(
				function(oFilterPage)
				{
					oFilterPage.setFacadeCreator(_super.createRemoteFacade);
					oFilterPage.setCurrentOrgGetter(
						function()
						{
							if(_super.getReportPage().isMoreOrgs())
							{
								return null;
							}
							return _super.getReportPage().getOrgId();
						});
					oFilterPage.setIntoSubUiListener(
						function()
						{
							fixFuzzyBold(_super.getFilterPageJqUi());
						}
					);
				});
		}
		var oFilterPage = _super.getFilterPage();
		if(bShowReportFirstTime)
		{
			oFilterPage.setBackwardListener(null);
		}
		else
		{
			oFilterPage.setBackwardListener(
				function()
				{
					backFromFilterToReport(bShowReportFirstTime, null);
					$(".kdlight-filter-panel-dismiss").css("display","none");
					$(jqFilterPage).css("display","none");
					$(jqFilterPage).animate({left: 320},300);
				});
		}
		oFilterPage.setForwardListener(
			function(oParamsValues)
			{
				backFromFilterToReport(bShowReportFirstTime, oParamsValues);
				$(".kdlight-filter-panel-dismiss").css("display","none");
				$(jqFilterPage).css("display","none");
				$(jqFilterPage).animate({left: 320},300);
			});
		var sTransition = (bShowReportFirstTime ? "fade" : null);
		var jqFilterPage = _super.getFilterPageJqUi();
		$(".kdlight-filter-panel-dismiss").css("display","block");
		$(jqFilterPage).css("display","block");
		$(jqFilterPage).animate({left: 0},300);
		oFilterPage.updateUi(jqFilterPage, sReportId, arrParamsDescs, oParamsValues, oAssociateModel);
		fixFuzzyBold(jqFilterPage);
	}
	
	var backFromFilterToReport = function(bShowReportFirstTime, oParamsValues)
	{
		var bToUpdateReport = (oParamsValues ? true : false);
		if(bShowReportFirstTime && !bToUpdateReport)
		{
			//nothing
		}
		else
		{
			var bBackwardSlide = !bShowReportFirstTime;
			var sTransition = (bShowReportFirstTime ? "fade" : null);
			_super.slideToPage(_super.getFilterPage(), _super.getReportPage(), _super.getReportPageJqUi(), bBackwardSlide, sTransition);
			_super.getReportPage().update(bToUpdateReport, oParamsValues);
		}
	}

	var jumpFromReportToNextReport = function(oOrg, sReportName, sReportTag, oParamsValues, sOutParams)
	{
		var oFromReportPage = _super.getReportPage();
		_super.pushNewReport(
			function(iCurrentLevel)
			{
				var oReportPage = new KEXTReportPage();
				oReportPage.showTitleInReportToolbar(true);
				oReportPage.setFacadeCreator(_super.createRemoteFacade);
				oReportPage.setBackwardListener(backFromNextReportToLastReport);
				oReportPage.setForwardFilterListener(jumpFromReportToFilter);
				oReportPage.setForwardNextReportListener(jumpFromReportToNextReport);
				oReportPage.setOutParams(sOutParams);
				return oReportPage;
			});
		KEXTUtil.setEnvTitle(sReportName);
		var jqToReportPage = _super.getReportPageJqUi();
		var oToReportPage = _super.getReportPage();
		_super.slideToPage(oFromReportPage, oToReportPage, jqToReportPage);
		oToReportPage.execute(jqToReportPage, sReportName, sReportTag, oOrg, oParamsValues);
	}

	var backFromNextReportToLastReport = function()
	{
		var oFromReportPage = _super.getReportPage();
		if(_super.backwardPreviousReport())
		{
			var jqReportPage = _super.getReportPageJqUi();
			var oReportPage = _super.getReportPage();
			_super.slideToPage(oFromReportPage, oReportPage, jqReportPage, true);
			KEXTUtil.setEnvTitle(oReportPage.getTitle());
		}
	}
	
	//预览用到的浏览器和缩放策略，会出现粗体重影模糊，强行把粗体去掉
	var fixFuzzyBold = function(jqFilterPage)
	{
		setTimeout(
			function()
			{
				//jqFilterPage.find(".ui-btn").css("font-weight", "normal");
				//jqFilterPage.find(".ui-li-divider").css("font-weight", "normal");
				$(".kdlight-toolbar-title").removeClass("fontWeightBold");
			},
			50);
	}
}


function KEXTAbstractNavigatorPane()
{
	this.setRemoteImpl = function(oImpl)
	{
		throw new Error("Override me.");
	}
	
	/** funListener like: func(bFullScreen) */
	this.setRequestFullScreenListener = function(funListener)
	{
		throw new Error("Override me.");
	}
	
	this.keepState = function()
	{
		//Can override
	}
	this.restoreState = function()
	{
		//Can override
	}
}

function KEXTLight()
{
	var TAB_TITLE_ANALYSIS = "分析";
	var TAB_TITLE_REPORT = "报表";
	
	var _oNavigator;
	var _oAnalysis = new KEXTAnalysisHomepage();
	var _oCenter = new KEXTCenter();

	this.setRemoteImpl = function(oImpl)
	{
		_oAnalysis.setRemoteImpl(oImpl);
		_oCenter.setRemoteImpl(oImpl);
	}
	this.hideYZJToolbar = function()
	{
		_oCenter.setHideYZJToolbar(true);
	}
	
	this.createUi = function(jqPage, sTitle, sSubjectId)
	{
		_oNavigator = new kdlight.BottomTabContainer();
		
		var jqPanel1 = _oNavigator.addTab(TAB_TITLE_ANALYSIS, KEXTImg_NavAnalysis, KEXTImg_NavAnalysisSelected);
		var jqPanel2 = _oNavigator.addTab(TAB_TITLE_REPORT, KEXTImg_NavReport, KEXTImg_NavReportSelected);
		_oNavigator.setSelectedIndex(0);//0：快照分析  1：报表中心
		_oNavigator.addTabPreChangeListener(doTabPreChange);
		_oNavigator.addTabChangedListener(doTabChanged);
		
		_oAnalysis.createUi(jqPanel1, sSubjectId);
		_oAnalysis.setRequestFullScreenListener(showNavigatorBar);
		

		_oCenter.createUi(jqPage, sTitle, sSubjectId, jqPanel2, createPopItems(1));
		_oCenter.setRequestFullScreenListener(showNavigatorBar);

		var jqNav = _oNavigator.getJqUi();
		jqPage.append(jqNav);	

		//showNavigatorBar(true);		
		_oNavigator.showTabBar(false);
	}
	
	var createPopItems = function(iItemType)
	{
		var oItem;
		if(iItemType == 1)
		{
			oItem = {'text':'快照分析','callBackId':'snapCallBack','callBackFunc':snapCallBack};
		}
		else if(iItemType == 2)
		{
			oItem = {'text':'报表中心','callBackId':'reportCenterBack','callBackFunc':reportCenterBack};
		}
		return [{'text':'切换主题','callBackId':'themeCallBack','callBackFunc':themeCallBack}, oItem];
	}
	
	var themeCallBack = function()
	{
		KEXTUtil.delCookie("sThemeId");
		KEXTUtil.delCookie("sThemeName");
		var path = location.pathname.replace("extlight", "extlight-home");
		var search = location.search;
		location.href = path + search;
	}
	
	var snapCallBack = function()
	{
		_oNavigator.setSelectedIndex(0);
		KEXTUtil.setEnvPop(createPopItems(2));
	}
	
	var reportCenterBack = function()
	{
		_oNavigator.setSelectedIndex(1);
		KEXTUtil.setEnvPop(createPopItems(1));
	}
	
	var doTabPreChange = function(iOldIndex, sOldTitle, iNewIndex, sNewTitle)
	{
		if(sOldTitle == TAB_TITLE_REPORT)
		{
			_oCenter.keepState();
		}
	}
	
	var doTabChanged = function(iOldIndex, sOldTitle, iNewIndex, sNewTitle)
	{
		if(sNewTitle == TAB_TITLE_REPORT)
		{
			_oCenter.restoreState();
		}
	}
	
	var showNavigatorBar = function(bRequestFullScreen)
	{
		//var bToShowNavBar = !bRequestFullScreen;
		//_oNavigator.showTabBar(bToShowNavBar);
	}
	
	var getNavigator = function()
	{
		return _oNavigator;
	}
	
	this.protectedMethod =
	{
		"showNavigatorBar": showNavigatorBar,
		"getNavigator": getNavigator
	}
}

/** 对云报表的额外支持 */
function KEXTCloudReportSupporter()
{
	var _sCloudReportId;
	var _bAccredited;
	var _bTemplateModified;
	
	var _funRejectJoiningListener;
	var _funFacadeCreator;
	
	var _jqToAccreditPrompt;
	var _jqCommentLayer;	
	
	var _bCallFirstTime = true;
	
	this.setContextInfo = function(sCloudReportId, bAccredited, bTemplateModified)
	{
		_sCloudReportId = sCloudReportId;
		_bAccredited = bAccredited;
		_bTemplateModified = bTemplateModified;
	}
	
	/** 拒绝加入共享计划的回调 */
	this.setRejectJoiningListener = function(funCallback)
	{
		_funRejectJoiningListener = funCallback;
	}
	
	this.setFacadeCreator = function(funCreator)
	{
		_funFacadeCreator = funCreator;
	}
	
	this.initUi = function(jqOwner)
	{
		_jqToAccreditPrompt = $("<div>");
		_jqToAccreditPrompt.css("display", "none");
		_jqToAccreditPrompt.css("z-index", 1);
		_jqToAccreditPrompt.addClass("accredited-prompt");	
		jqOwner.append(_jqToAccreditPrompt);
		
		_jqCommentLayer = $("<div>");
		_jqCommentLayer.css({
			"display": "none",
			"z-index": 65535,
			"position": "absolute",
			"left": 0,
			"top": 0,
			"width": "100%",
			"height": "100%",
			"background-color": "rgba(0, 0, 0, 0.5)",
			"color": "#c00"
		});

		_jqCommentLayer.click(
			function(evt)
			{
				if(evt.target == _jqCommentLayer[0])
				{
					closeCommentLayer();
				}
			}
		);
		jqOwner.append(_jqCommentLayer);
	}
	
	this.reportExecuted = function(sReportName)
	{
		if(_bCallFirstTime)
		{
			_bCallFirstTime = false;
			if(!_bAccredited)//云报表未授权，展示的是演示数据，提示并可查看管理员
			{
				showToAccreditPrompt();
			}
			cloudLog(sReportName);
		}
	}
	
	var showToAccreditPrompt = function()
	{
		var jqBtn = $("<div>");
		jqBtn.addClass("accredited-prompt-btn");
		updateLookupButton(jqBtn);
		jqBtn.click(function(){onLookupManager(jqBtn);});
		
		var jqText = $("<div>");
		jqText.addClass("accredited-prompt-text");
		jqText.text("当前是云报表演示数据。正式使用报表的授权申请流程已提交给管理员。");

		_jqToAccreditPrompt.append(jqBtn);
		_jqToAccreditPrompt.append(jqText);
		_jqToAccreditPrompt.css("display", "block");
	}
	
	var onLookupManager = function(jqBtn)
	{
		var jqListOwner = _jqToAccreditPrompt.find(".accredited-prompt-list");
		var bUnexpanded = updateLookupButton(jqBtn);
		if(bUnexpanded)
		{
			_jqToAccreditPrompt.addClass("accredited-prompt_full");
			jqListOwner && jqListOwner.css("display", "block");
			var sKey = "lookuped";
			if(!_jqToAccreditPrompt.data(sKey))
			{
				_jqToAccreditPrompt.data(sKey, true);
				var jqListOwner = $("<div>");
				jqListOwner.addClass("accredited-prompt-list");
				jqListOwner.appendTo(_jqToAccreditPrompt);
				KEXTUtil.setSimScrollbar(jqListOwner, _jqToAccreditPrompt);
				remoteLookupManager(jqListOwner);
			}
		}
		else
		{
			_jqToAccreditPrompt.removeClass("accredited-prompt_full");
			jqListOwner && jqListOwner.css("display", "none");
		}
	}
	
	var updateLookupButton = function(jqBtn)
	{
		var sKey = "unexpanded";
		var bUnexpanded = (jqBtn.data(sKey) ? true : false);
		if(bUnexpanded)
		{
			jqBtn.data(sKey, false);
			jqBtn.text(" 收起 \r\n∨");
		}
		else
		{
			jqBtn.data(sKey, true);
			jqBtn.text("查看\r\n管理员");
		}
		return bUnexpanded;
	}
	
	var remoteLookupManager = function(jqListOwner)
	{
		var oFacade = _funFacadeCreator(
			function(oData)
			{
				remoteLookupManagerCallback(oData, jqListOwner);
			});
		oFacade.getAccreditingManager();
	}
	
	var remoteLookupManagerCallback = function(oData, jqListOwner)
	{
		if(!oData || oData.length == 0)
		{
			jqListOwner.text("没有【移动报表工具】管理员。企业未购买该模块或未指定管理员。");
			return;		
		}
		var jqSet = $("<div data-role='collapsible-set' data-inset='true'>");
		jqListOwner.append(jqSet);
		for(var i = 0, c = Math.min(100, oData.length); i < c; i++)
		{
			var oJsonItem = oData[i];
			var sAccount = oJsonItem["account"];
			var sName = oJsonItem["pName"];
			var sCellphone = oJsonItem["cellPhone"];
			var sEmail = oJsonItem["email"];
			var sOfficePhone = oJsonItem["officePhone"];
			var sOrgName = oJsonItem["oName"];
			
			var sHead = (sName ? sName : sAccount);
			var jqCollapsible = $("<div data-role='collapsible' data-iconpos='right' >");
			var jqHead = $("<h2>");
			jqHead.text(sHead);
			
			var jqInnerList = $("<div>");
			jqInnerList.append(createManagerItem("帐号", sAccount));
			jqInnerList.append(createManagerItem("用户实名", sName));
			jqInnerList.append(createManagerItem("手机", sCellphone, true));
			jqInnerList.append(createManagerItem("电子邮箱", sEmail));
			jqInnerList.append(createManagerItem("办公电话", sOfficePhone, true));
			jqInnerList.append(createManagerItem("所属组织", sOrgName));
			
			jqSet.append(jqCollapsible);
			jqCollapsible.append(jqHead);
			jqCollapsible.append(jqInnerList);

			jqCollapsible.collapsible();
		}
		jqSet.collapsibleset();
	}
	
	var createManagerItem = function(sTitle, sValue, bPhone)
	{
		var jqTitle = $("<div>");
		jqTitle.addClass("accredited-prompt-item-col1");
		jqTitle.text(sTitle);
		
		var jqValue = $("<div>");
		jqValue.addClass("accredited-prompt-item-col2");
		if(bPhone)
		{
			var jqA = $("<a>");
			jqA.attr("href", "tel:" + sValue);
			jqA.text(sValue);
			jqValue.append(jqA);
		}
		else
		{
			jqValue.text(sValue);
		}
		
		var jqItem = $("<div>");
		jqItem.addClass("accredited-prompt-item");
		jqItem.append(jqTitle);
		jqItem.append(jqValue);
		return jqItem;
	}
	
	this.showComment = function(jqCommentBtn)
	{
		_jqCommentLayer.css("display", "block");
		if(_jqCommentLayer.children().length == 0)
		{
			var iTriangleLeft = jqCommentBtn.prop("offsetLeft") + jqCommentBtn.width() * 0.5;//按钮中线在页面的位置
			var iTriangleTop = 36;//此处应该算按钮下沿在页面的位置		
			prepareForComment(iTriangleLeft, iTriangleTop);
		}
	}
	
	var closeCommentLayer = function()
	{
		if(_jqCommentLayer.data("error"))
		{
			_jqCommentLayer.data("error", false);
			_jqCommentLayer.children().remove();
		}
		_jqCommentLayer.css("display", "none");
	}
	
	var prepareForComment = function(iTriangleLeft, iTriangleTop)
	{
		var oUserInfo = {"cloudReportId" : _sCloudReportId};
		
		var funLoadScript = function()
		{
			KEXTUtil.loadDynamicCloudComment(
				function(bSuccess)
				{
					if(bSuccess)
					{
						var mapExtendInfo = {};
						mapExtendInfo["triangleLeft"] = iTriangleLeft;
						mapExtendInfo["triangleTop"] = iTriangleTop;
						mapExtendInfo["userInfo"] = oUserInfo;
						
						var oDynamic = new KEXTCloudReportComment();
						oDynamic.createUi(_jqCommentLayer, closeCommentLayer, mapExtendInfo);
					}
					else
					{
						_jqCommentLayer.data("error", true);
						_jqCommentLayer.text("不能成功加载云报表中心的内容。");
					}
				});
		};
		
		var oFacade = _funFacadeCreator(
			function(oData)
			{
				oUserInfo["customerId"] = oData["customerId"];
				oUserInfo["customerName"] = oData["customerName"];
				oUserInfo["customerDBCode"] = oData["customerDBCode"];
				oUserInfo["userAccount"] = oData["userAccount"];
				oUserInfo["userName"] = oData["userName"];
				oUserInfo["userTitle"] = oData["userTitle"];
				oUserInfo["userCellPhone"] = oData["userCellPhone"];
				funLoadScript();
			});

		KEXTUserContext.getPersonInfo(
			function(oResult)
			{
				var oData = oResult.data;
				oUserInfo["xtName"] = oData["name"];
				oUserInfo["xtUserName"] = oData["userName"];
				oUserInfo["xtOpenId"] = oData["openId"];
				oUserInfo["xtEmail"] = oData["email"];
				oFacade.getUserInfo();
			});
	}
	
	var cloudLog = function(sReportName)
	{
		var funLog = function(oInfo)
		{
			var sUrl = KEXTUtil.CloudHost + "/crc/rptcenter/resources/rptUsage";
			var oRequest = oInfo;
			oRequest["cloudRptId"] = _sCloudReportId;
			oRequest["rptName"] = sReportName;
			oRequest["isTemplateModified"] = _bTemplateModified;
			oRequest["isAuthed"] = _bAccredited;
			oRequest["executor"] = "MOBILE";
			var oSetting = 
			{
				"type": "GET",
				"dataType": "jsonp",
				"url": sUrl,
				"data": oRequest,
				"success": function(oResponse){cloudCheckCallback(oResponse, oInfo)}
				//error ignored
			};
			$.ajax(oSetting);
		}
		
		var oFacade = _funFacadeCreator(
			function(oData)
			{
				var oInfo = {
					"customerId": 			oData["customerId"],
					"customerName": 		oData["customerName"],
					"customerDBCode": 	oData["customerDBCode"],
					"userAccount": 		oData["userAccount"],
					"userName": 			oData["userName"],
					"userTitle": 				oData["userTitle"]
				};
				funLog(oInfo);
			});
		oFacade.setSilenceMode(true);
		oFacade.getUserInfo();
	}
	
	var cloudCheckCallback = function(oResponse, oInfo)
	{
		if(!oResponse || oResponse["errorCode"] || oResponse["errorCode"] == 0)
		{
			return;
		}
		var oData = oResponse["data"];
		var bAgreed = oData && oData["isAgreed"];
		if(!bAgreed)
		{
			showCloudAgreement(oInfo);
		}
	}
	
	var showCloudAgreement = function(oInfo)
	{
		var funCreateBtn = function(sText)
		{
			var jqBtn = $('<a href="#" class="ui-btn ui-corner-all ui-shadow ui-btn-a">');
			jqBtn.css("display", "inline-block");
			jqBtn.width(90);
			jqBtn.text(sText);
			return jqBtn;
		}
		
		var oPopup = new KEXTPopup();
		var jqPopup = oPopup.createUi();
		jqPopup.width(280);

		var jqTitle = $("<div>");
		jqTitle.text("云报表中心提示");
		jqTitle.height(40);
		jqTitle.css("text-align", "center");
		jqTitle.css("font-size", "20px");
		jqTitle.css("font-weight", "700");
		jqTitle.appendTo(jqPopup);
				
		var jqText = $("<div>");
		jqText.text("　　执行云报表需要您同意加入“金蝶云报表共享计划”。");
		jqText.css("font-size", "20px");
		jqText.appendTo(jqPopup);
		
		var jqHyperlink = $("<span>");
		jqHyperlink.css("display", "inline-block");
		jqHyperlink.css("color", "#36f");
		jqHyperlink.css("border-bottom", "1px solid #36f");
		jqHyperlink.css("margin-top", "20px");
		jqHyperlink.css("margin-bottom", "30px");
		jqHyperlink.text("什么是“金蝶云报表共享计划”？");
		jqHyperlink.appendTo(jqPopup);
		jqHyperlink.click(
			function()
			{
				jqHyperlink.css("display", "none");
				jqDetail.css("display", "block");
				jqPopup.animate({"margin-top": "-60px"});
			});
		
		var jqDetail = $("<div>");
		jqDetail.css("display", "none");
		jqDetail.css("margin-top", "20px");
		jqDetail.css("margin-bottom", "30px");
		jqDetail.text("　　“金蝶云报表中心”是金蝶软件为EAS用户建立的报表共享平台，拥有庞大的报表模板库。加入“金蝶云报表共享计划”，您可以直接使用这些由其他用户共享的高价值报表模板。同时，作为“金蝶云报表共享计划”的一员，您的报表模板（不包含任何用户及客户数据）有可能会被分享至“金蝶云报表中心”。");
		jqDetail.appendTo(jqPopup);
		
		var jqBtnReject = funCreateBtn("拒绝");
		jqBtnReject.on("click", 
			function(evt)
			{
				oPopup.die();
				_funRejectJoiningListener();
			});
		jqBtnReject.appendTo(jqPopup);

		var jqBtnOk = funCreateBtn("同意");
		jqBtnOk.css("float", "right");
		jqBtnOk.on("click", 
			function(evt)
			{
				var sUrl = KEXTUtil.CloudHost + "/crc/rptcenter/resources/updateUserAgreementStatus";
				var oRequest = 
				{
					"licenseId": 		oInfo["customerId"],
					"dbCode": 		oInfo["customerDBCode"],
					"licenseTo": 	oInfo["customerName"],
					"userId": 		oInfo["userAccount"],
					"title": 			oInfo["userTitle"],
					"userName": 	oInfo["userName"],
					"isAgreed": 	true
				}
				var oSetting = 
				{
					"type": "GET",
					"dataType": "jsonp",
					"url": sUrl,
					"data": oRequest,
				};
				$.ajax(oSetting);
				oPopup.die();
			});
		jqBtnOk.appendTo(jqPopup);
		
		oPopup.show();
	}
}
