var KEXTCommonUtil = new (function()
{
	var _this = this;
	var regHexColor = /^#([0-9a-fA-f]{3}|[0-9a-fA-f]{6})$/; //匹配16进制颜色值 
	
	//是否深色值 rgb: [1,2,3] or #123456
	this.isDarkColor = function(rgb)
	{
		if(!rgb)
			return false;
		
		var arrRgb = rgb;
		if(arrRgb.indexOf("#") == 0)
			arrRgb = _this.getRgbIntArr(arrRgb);
		// YUV模式中的Y(明亮度)
		var iY = Math.round(arrRgb[0] * 0.299 + arrRgb[1] * 0.587 + arrRgb[2] * 0.114);
		if (iY <= 128) // 深颜色
			return true;
			
		return false;
	}
	
	this.getRgbaString = function(arrRgb)
	{
		return "RGBA(" + arrRgb.join(",") + ")";
	}
	
	// sHex:#123456;
	this.getRgbIntArr = function(sHex)
	{
		if(!sHex)
			return sHex;
		
    	var sColor = sHex.toLowerCase();  
    	if(sColor && regHexColor.test(sColor))
    	{
        	if(sColor.length === 4)
        	{  
           	 	var sColorNew = "#";  
           	 	for(var i=1; i<4; i++)
           	 	{ 	 
               		sColorNew += sColor.slice(i,i+1).concat(sColor.slice(i,i+1));     
           	 	}  
        		sColor = sColorNew;  
        	}  
	        //处理六位的颜色值  
	        var sColorChange = [];  
	        for(var i=1; i<7; i+=2)
	        {  
	            sColorChange.push(parseInt("0x"+sColor.slice(i,i+2)));    
	        }  
	        return sColorChange;
    	}
    	else
    	{  
       	 	return sColor;    
    	}
	}
})();