/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class JarFileUtil {
    private static Logger logger = Logger.getLogger(JarFileUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] loadFromJar(String jarFileName, String className) throws ClassNotFoundException {
        InputStream clsInputStream;
        JarFile jar;
        block13: {
            String fileName = String.valueOf(className.replace('.', '/')) + ".class";
            jar = null;
            ZipEntry clsEntry = null;
            clsInputStream = null;
            jar = new JarFile(jarFileName);
            clsEntry = jar.getEntry(fileName);
            if (clsEntry == null) break block13;
            clsInputStream = jar.getInputStream(clsEntry);
            byte[] byArray = JarFileUtil.readBytesFromInputStream(clsInputStream);
            JarFileUtil.closeQuietly(clsInputStream);
            if (jar == null) return byArray;
            try {
                jar.close();
                return byArray;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return byArray;
        }
        try {
            try {
                logger.warn((Object)"---------no class find in jarFile---------");
                logger.warn((Object)("---------jarFile:" + jarFileName + "---------"));
                logger.warn((Object)("---------className:" + className + "---------"));
            }
            catch (Throwable th) {
                logger.error((Object)"---------failed to load class from jarFile---------", th);
                JarFileUtil.closeQuietly(clsInputStream);
                if (jar == null) return null;
                try {
                    jar.close();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            JarFileUtil.closeQuietly(clsInputStream);
            if (jar == null) throw throwable;
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        JarFileUtil.closeQuietly(clsInputStream);
        if (jar == null) return null;
        try {
            jar.close();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static byte[] readBytesFromInputStream(InputStream input) throws IOException {
        int j;
        int l = 0;
        byte[] resBytes = new byte[1024];
        while ((j = input.read(resBytes, l, resBytes.length - l)) != -1) {
            if ((l += j) < resBytes.length) continue;
            byte[] abyte1 = new byte[l * 2];
            System.arraycopy(resBytes, 0, abyte1, 0, l);
            resBytes = abyte1;
        }
        if (l != resBytes.length) {
            byte[] abyte2 = new byte[l];
            System.arraycopy(resBytes, 0, abyte2, 0, l);
            resBytes = abyte2;
        }
        return resBytes;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

