/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.servlet;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.ctrl.analysis.web.ext.Browser;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.eas.mobileaccess.ext.scl.ExtRptServiceClassLoader;
import com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExtMobileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object result;
        String sessionId = req.getParameter("ext_salmon_dispatcher_sessionId");
        if (sessionId != null) {
            req.getSession().setAttribute("pureWebContext", (Object)SessionManager.getInstance().getSession(sessionId).getContext());
            EASExtStatisticsInfoService.INST().service(req, resp);
            return;
        }
        ClassLoader source = Thread.currentThread().getContextClassLoader();
        ExtRptServiceClassLoader cl = ExtRptServiceClassLoader.INST(source);
        Thread.currentThread().setContextClassLoader(cl);
        Browser.setCurrentRequest((HttpServletRequest)req);
        try {
            result = cl.loadClass("com.kingdee.eas.mobileaccess.ext.web.ExtMobileRptService").getMethod("action", HttpServletRequest.class).invoke(null, req);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        this.outWriteData(req, resp, result, source);
    }

    protected void outWriteData(HttpServletRequest req, HttpServletResponse resp, Object result, ClassLoader source) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        try {
            JSONObject json = new JSONObject();
            Boolean s = (Boolean)this.access(result, "success");
            json.put("success", (Object)s);
            if (!s.booleanValue()) {
                String callback = req.getParameter("callback");
                Integer errorCode = (Integer)this.access(result, "errorCode");
                String error = (String)this.access(result, "error");
                json.put("errorCode", (Object)errorCode);
                json.put("errorMessage", (Object)error);
                if (callback == null) {
                    resp.setHeader("Content-Type", "application/json; charset=utf-8");
                    out.write(json.toString().getBytes("UTF-8"));
                } else {
                    resp.setContentType("text/javascript; charset=utf-8");
                    out.write(callback.getBytes());
                    out.write("(".getBytes());
                    out.write(json.toString().getBytes("UTF-8"));
                    out.write(")".getBytes());
                }
            } else {
                String dt = (String)this.access(result, "dataType");
                resp.setHeader("Content-Type", dt);
                Object obj = this.access(result, "data");
                if ("application/octet-stream; charset=utf-8".equals(dt)) {
                    if (obj instanceof byte[]) {
                        out.write((byte[])obj);
                    } else if (obj instanceof InputStream) {
                        InputStream in = (InputStream)obj;
                        resp.setContentLength(in.available());
                        byte[] buffer = new byte[1024];
                        int len = in.read(buffer);
                        while (len > 0) {
                            out.write(buffer, 0, len);
                            out.flush();
                            len = in.read(buffer);
                        }
                        in.close();
                    }
                } else if ("text/javascript; charset=utf-8".equals(dt)) {
                    out.write(String.valueOf(obj).getBytes("UTF-8"));
                } else {
                    json.put("data", obj);
                    try {
                        String jsonStr = this.toCompatibleJSONString(json);
                        out.write(jsonStr.getBytes("UTF-8"));
                    }
                    catch (OutOfMemoryError oom) {
                        oom.printStackTrace();
                        resp.setHeader("Content-Type", "application/json; charset=utf-8");
                        json.put("data", null);
                        json.put("success", (Object)false);
                        json.put("errorCode", (Object)9999);
                        json.put("errorMessage", (Object)"\u6570\u636e\u8f83\u591a\uff0c\u8bf7\u51cf\u5c11\u7ed3\u679c\u6570\u636e\u518d\u8bd5");
                        out.write(json.toString().getBytes("UTF-8"));
                    }
                }
            }
        }
        finally {
            out.flush();
            out.close();
            if (source != null) {
                Thread.currentThread().setContextClassLoader(source);
            }
        }
    }

    private String toCompatibleJSONString(Object object) {
        SerializeConfig config = new SerializeConfig();
        config.put(java.util.Date.class, (Object)new JSONLibDataFormatSerializer());
        config.put(Date.class, (Object)new JSONLibDataFormatSerializer());
        SerializerFeature[] features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.BrowserCompatible};
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }

    private <T> T access(Object result, String propertyName) {
        try {
            Class<?> resultClass = Thread.currentThread().getContextClassLoader().loadClass("com.kingdee.eas.mobileaccess.ext.web.model.MobileResult");
            Field property = resultClass.getDeclaredField(propertyName);
            property.setAccessible(true);
            return (T)property.get(result);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

