/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.kingdee.eas.base.uiframe.client.conf.util.StringUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TestDownloadFile
extends JFrame {
    private JPanel panel = null;
    private JScrollPane scrollPane = null;
    private JTextArea jta = null;
    private JButton jbt = null;
    private JLabel jlb = null;
    private static int retryTimes = 10;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TestDownloadFile frame = new TestDownloadFile();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public TestDownloadFile() {
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 450, 150);
        this.panel = new JPanel();
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.setLayout(null);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBounds(5, 5, 420, 60);
        this.panel.add(this.scrollPane);
        this.jta = new JTextArea();
        this.jta.setLineWrap(true);
        this.scrollPane.setViewportView(this.jta);
        this.jlb = new JLabel(".....");
        this.jlb.setBounds(5, 75, 300, 30);
        this.panel.add(this.jlb);
        this.jbt = new JButton("button");
        this.jbt.setBounds(320, 75, 100, 30);
        this.jbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filenameList = TestDownloadFile.this.jta.getText();
                TestDownloadFile.this.downloadFileByName(filenameList);
            }
        });
        this.panel.add(this.jbt);
    }

    protected void downloadFileByName(String filenameList) {
        String[] filenames;
        filenameList = filenameList.trim();
        for (String filename : filenames = filenameList.split(";")) {
            if (StringUtil.isEmptyValue(filename)) continue;
            this.downloadFromeUpdateServer(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testConnection(URL url, int timeout) {
        int retryTimes = 10;
        for (int i = 1; i < retryTimes; ++i) {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Connection", "Close");
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(timeout * 1000);
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (200 != responseCode) {
                    JOptionPane.showMessageDialog(null, "ERROR");
                }
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "ERROR");
                e.printStackTrace();
                continue;
            }
            finally {
                if (null != conn) {
                    conn.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFromeUpdateServer(String filepath) {
        InputStream ins = null;
        FileOutputStream fos = null;
        URL downloadUrl = null;
        HttpURLConnection httpConnection = null;
        String easServer = System.getProperty("UPDATE_SERVER");
        easServer = TestDownloadFile.makePathEndWithSlash(easServer);
        File downloadFile = new File(filepath);
        String filename = downloadFile.getName();
        String url = "http://" + easServer + "easWebClient/" + filepath;
        String logTitle = "[\u4e0b\u8f7d\u6587\u4ef6:" + url + "] ";
        int i = 1;
        if (i < retryTimes) {
            System.out.println(logTitle + "\u4e0b\u8f7d\u5f00\u59cb...");
            try {
                downloadUrl = new URL(url);
                httpConnection = (HttpURLConnection)downloadUrl.openConnection();
                httpConnection.setConnectTimeout(3000);
                httpConnection.setRequestProperty("Connection", "Close");
                httpConnection.setRequestMethod("GET");
                httpConnection.connect();
                int contentLength = httpConnection.getContentLength();
                System.out.println("[download] server return content-length[" + contentLength + "] from [" + url + "], ");
                ins = httpConnection.getInputStream();
                fos = new FileOutputStream(new File("D:/temp/" + filename + System.currentTimeMillis()));
                byte[] buf = new byte[1024];
                int j = 0;
                while ((j = ins.read(buf)) != -1) {
                    fos.write(buf, 0, j);
                }
                ins.close();
                fos.close();
                System.out.println(filename + "\u4e0b\u8f7d\u6210\u529f");
                this.jlb.setText(filename + "\u4e0b\u8f7d\u6210\u529f");
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "\u6587\u4ef6\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
                e.printStackTrace();
                return;
            }
            finally {
                if (httpConnection != null) {
                    try {
                        httpConnection.disconnect();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    if (ins != null) {
                        ins.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String makePathEndWithSlash(String path) {
        if (StringUtil.isEmptyValue(path)) {
            throw new IllegalArgumentException("path is '" + path + "'");
        }
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }
}

