/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.util;

import com.kingdee.eas.base.uiframe.client.conf.killprocess.DeleteFileUtil;
import com.kingdee.eas.base.uiframe.client.conf.ui.UIResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;

public class FileUtil {
    public static boolean isFilePathLegal(String filePath) {
        filePath = filePath.replaceAll("\\\\\\\\", "\\\\").trim();
        System.out.println(filePath);
        filePath = filePath.replaceAll("/", "\\\\").trim();
        System.out.println(filePath);
        Pattern pattern = Pattern.compile("^[a-zA-Z]{1}:{1}(\\\\[a-zA-Z0-9]+)*\\\\?$", 2);
        Matcher matcher = pattern.matcher(filePath);
        if (!matcher.matches()) {
            System.out.println("No matcher");
            return false;
        }
        System.out.println("Matcher:=" + matcher.group());
        return true;
    }

    public static boolean isIPAddress(String str) {
        Pattern pattern = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)", 2);
        Matcher matcher = pattern.matcher(str);
        if (!matcher.matches()) {
            System.out.println("No matcher");
            return false;
        }
        System.out.println("Matcher:=" + matcher.group());
        return true;
    }

    public static void deleteFile(String filePath) {
        try {
            System.out.println("Begin delete files from :=" + filePath);
            File file = new File(filePath);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] fileList = file.listFiles();
                    if (fileList != null && fileList.length > 0) {
                        for (int i = 0; i < fileList.length; ++i) {
                            String path = fileList[i].getCanonicalPath();
                            FileUtil.deleteFile(path);
                        }
                    }
                } else {
                    System.out.println("Delete file :=" + file.getCanonicalPath());
                    DeleteFileUtil.deleteFile(file);
                }
                DeleteFileUtil.deleteFile(file);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void copyFiles(String src, String dest, String newFileName, JLabel lbTips) {
        block8: {
            try {
                System.out.println("**Begin copy files from " + src + " to " + dest + "==========");
                File srcFile = new File(src);
                if (srcFile.exists()) {
                    FileUtil.createDirectory(dest);
                    if (srcFile.isDirectory()) {
                        File[] fileList;
                        String newDest = dest + File.separator + srcFile.getName();
                        File newDestFile = new File(newDest);
                        if (!newDestFile.exists()) {
                            newDestFile.mkdir();
                        }
                        if ((fileList = srcFile.listFiles()) != null && fileList.length > 0) {
                            for (int i = 0; i < fileList.length; ++i) {
                                FileUtil.copyFiles(fileList[i].getCanonicalPath(), newDest, lbTips);
                            }
                        }
                    } else {
                        FileUtil.cpFile(new File(src), new File(dest + File.separator + newFileName), lbTips);
                    }
                    break block8;
                }
                throw new RuntimeException("Source file[" + src + "] does not exsit!");
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public static void copyFiles(String src, String dest, JLabel lbTips) {
        block8: {
            try {
                System.out.println("**Begin copy files from " + src + " to " + dest + "==========");
                File srcFile = new File(src);
                if (srcFile.exists()) {
                    FileUtil.createDirectory(dest);
                    if (srcFile.isDirectory()) {
                        File[] fileList;
                        String newDest = dest + File.separator + srcFile.getName();
                        File newDestFile = new File(newDest);
                        if (!newDestFile.exists()) {
                            newDestFile.mkdir();
                        }
                        if ((fileList = srcFile.listFiles()) != null && fileList.length > 0) {
                            for (int i = 0; i < fileList.length; ++i) {
                                FileUtil.copyFiles(fileList[i].getCanonicalPath(), newDest, lbTips);
                            }
                        }
                    } else {
                        FileUtil.cpFile(new File(src), new File(dest + File.separator + srcFile.getName()), lbTips);
                    }
                    break block8;
                }
                throw new RuntimeException("Source file[" + src + "] does not exsit!");
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public static void copyFileFromDirToDir(String srcDir, String dest, ArrayList filter, JLabel lbTips) throws Exception {
        File[] fileList;
        if (new File(srcDir).exists() && new File(srcDir).exists() && (fileList = new File(srcDir).listFiles()) != null && fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    if (!filter.contains(fileList[i].getName())) {
                        FileUtil.copyFiles(fileList[i].getCanonicalPath(), dest, lbTips);
                        continue;
                    }
                    System.out.println(fileList[i].getName() + " contains in filter");
                    continue;
                }
                FileUtil.cpFile(fileList[i], new File(dest + File.separator + fileList[i].getName()), lbTips);
            }
        }
    }

    public static void copyFileFromDirToDir(String srcDir, String dest, JLabel lbTips) throws Exception {
        File[] fileList;
        if (new File(srcDir).exists() && (fileList = new File(srcDir).listFiles()) != null && fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    FileUtil.copyFiles(fileList[i].getCanonicalPath(), dest, lbTips);
                    continue;
                }
                FileUtil.cpFile(fileList[i], new File(dest + File.separator + fileList[i].getName()), lbTips);
            }
        }
    }

    public static void cpFile(File srcFile, File destFile, JLabel lbTips) {
        if (lbTips != null) {
            lbTips.setText(UIResource.FileUtil_0 + srcFile.getName());
        }
        try {
            FileInputStream fis = new FileInputStream(srcFile);
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            int j = 0;
            while ((j = fis.read(buf)) != -1) {
                fos.write(buf, 0, j);
            }
            fis.close();
            fos.close();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public static void createDirectory(String path) throws Exception {
        File currDirect = new File(path);
        if (currDirect.getParentFile() != null && !currDirect.getParentFile().exists()) {
            FileUtil.createDirectory(currDirect.getParentFile().getCanonicalPath());
        }
        if (!currDirect.exists()) {
            currDirect.mkdir();
        }
    }

    public static boolean isIncludeJarOrZipInRoot(String path) {
        boolean isInclude;
        block3: {
            isInclude = false;
            try {
                File[] fileList;
                File file = new File(path);
                if (!file.exists() || !file.isDirectory() || (fileList = file.listFiles()) == null || fileList.length <= 0) break block3;
                for (int i = 0; i < fileList.length; ++i) {
                    String name = fileList[i].getName();
                    if (!name.endsWith("jar") && !name.endsWith("zip")) continue;
                    isInclude = true;
                    break;
                }
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return isInclude;
    }

    public static void main(String[] args) {
        try {
            System.out.println(FileUtil.isIncludeJarOrZipInRoot("D:\\Kingdee_600sp1\\eas\\server\\industry"));
            System.out.println(FileUtil.isIPAddress("1.1.1.1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

