/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;

public class CheckJDKUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int exeCmd(String shell) throws IOException {
        int success = 0;
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        try {
            System.out.println("Starting to exec{ " + shell + " }. PID is: " + pid);
            Process process = null;
            ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", shell);
            pb.environment();
            pb.redirectErrorStream(true);
            process = pb.start();
            if (process != null) {
                br = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
                process.waitFor();
            } else {
                System.out.println("There is no PID found.");
            }
            String line = null;
            while (br != null) {
                line = br.readLine();
                if (line == null) return success;
                sb.append(line).append("\n");
            }
            return success;
        }
        catch (Exception ioe) {
            sb.append("Error occured when exec cmd\uff1a\n").append(ioe.getMessage()).append("\n");
            return success;
        }
        finally {
            PrintWriter writer = null;
            if (br != null) {
                br.close();
            }
            try {
                writer = new PrintWriter(System.out);
                writer.write(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                writer.close();
            }
            success = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCmdResult(String shell) throws IOException {
        boolean success = false;
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        try {
            System.out.println("Starting to exec{ " + shell + " }. PID is: " + pid);
            Process process = null;
            ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", shell);
            pb.environment();
            pb.redirectErrorStream(true);
            process = pb.start();
            if (process != null) {
                br = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
                process.waitFor();
            } else {
                System.out.println("There is no PID found.");
            }
            String line = null;
            while (br != null && (line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ioe) {
            sb.append("Error occured when exec cmd\uff1a\n").append(ioe.getMessage()).append("\n");
        }
        finally {
            success = true;
        }
        return null;
    }

    public static String checkJDKVersion(File jdkPath) throws IOException {
        if (!jdkPath.isDirectory()) {
            return null;
        }
        File jdkBinPath = new File(jdkPath.getAbsolutePath() + File.separator + "bin");
        if (!jdkBinPath.exists() || jdkBinPath.isFile()) {
            return null;
        }
        String commandResult = CheckJDKUtil.getCmdResult(jdkBinPath + File.separator + "java.exe -version");
        if (commandResult != null) {
            if (commandResult.contains("1.6.0")) {
                return "16";
            }
            if (commandResult.contains("1.7.0")) {
                return "17";
            }
            if (commandResult.contains("1.8.0")) {
                return "18";
            }
        }
        return null;
    }

    public static boolean isJDK64Bit(File jdkPath) throws IOException {
        if (!jdkPath.isDirectory()) {
            return false;
        }
        File jdkBinPath = new File(jdkPath.getAbsolutePath() + File.separator + "bin");
        if (!jdkBinPath.exists() || jdkBinPath.isFile()) {
            return false;
        }
        String commandResult = CheckJDKUtil.getCmdResult(jdkBinPath + File.separator + "java.exe -version");
        return commandResult != null && commandResult.contains("64-Bit");
    }

    public static void main(String[] args) throws IOException {
        System.out.println(CheckJDKUtil.checkJDKVersion(new File("D:\\client\\client0621\\eas\\clientjdk")));
        System.out.println(CheckJDKUtil.isJDK64Bit(new File("D:\\client\\client0621\\eas\\clientjdk")));
    }
}

