/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.ui;

import com.kingdee.eas.base.uiframe.client.conf.ui.AbstractWizardStep;
import com.kingdee.eas.base.uiframe.client.conf.ui.KDWizard;
import com.kingdee.eas.base.uiframe.client.conf.ui.UIResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class KDWizardPanel
extends JPanel
implements AbstractWizardStep.WizardStepButtonListener {
    JButton btnCancel;
    JButton btnPre;
    JButton btnNext;
    JButton btnFinish;
    JButton btnHelp;
    JLabel lbOne;
    JLabel lbTwo;
    JLabel lbThree;
    JLabel lbFour;
    JLabel lbFive;
    Font defaultFont;
    JPanel pnlWorkspace;
    ArrayList<JLabel> labelList = new ArrayList();
    ArrayList listeners = new ArrayList();
    HashMap stepContainer = new HashMap();
    AbstractWizardStep curStep;
    private Window ownerWindow;

    public KDWizardPanel(JDialog dialog) {
        this.ownerWindow = dialog;
        this.initcomponents();
    }

    public KDWizardPanel(KDWizard frame) {
        this.ownerWindow = frame;
        this.initcomponents();
    }

    private JLabel getArrowPic() {
        ImageIcon oneImage = new ImageIcon(this.getClass().getResource("arrow.png"));
        JLabel lblArrowPic = new JLabel(oneImage);
        return lblArrowPic;
    }

    private JPanel generatorTopPanel() {
        JPanel pnlTop = new JPanel();
        pnlTop.setLayout(new BorderLayout());
        JPanel pnlTopMain = new JPanel();
        pnlTopMain.setLayout(new FlowLayout());
        this.lbOne = new JLabel(UIResource.KDWizardPanel_1);
        pnlTopMain.add(this.lbOne);
        this.lbOne.setForeground(new Color(32768));
        this.defaultFont = this.lbOne.getFont();
        this.lbOne.setFont(new Font(this.defaultFont.getName(), 1, this.defaultFont.getSize()));
        pnlTopMain.add(this.getArrowPic());
        this.labelList.add(this.lbOne);
        this.lbTwo = new JLabel(UIResource.KDWizardPanel_2);
        pnlTopMain.add(this.lbTwo);
        pnlTopMain.add(this.getArrowPic());
        this.labelList.add(this.lbTwo);
        this.lbThree = new JLabel(UIResource.KDWizardPanel_3);
        pnlTopMain.add(this.lbThree);
        pnlTopMain.add(this.getArrowPic());
        this.labelList.add(this.lbThree);
        this.lbFour = new JLabel(UIResource.KDWizardPanel_4);
        pnlTopMain.add(this.lbFour);
        pnlTopMain.add(this.getArrowPic());
        this.labelList.add(this.lbFour);
        this.lbFive = new JLabel(UIResource.KDWizardPanel_5);
        pnlTopMain.add(this.lbFive);
        this.labelList.add(this.lbFive);
        JSeparator sp = new JSeparator();
        sp.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        pnlTop.add((Component)sp, "South");
        pnlTop.add((Component)pnlTopMain, "Center");
        return pnlTop;
    }

    private void initcomponents() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 2, 0));
        this.setLayout(new BorderLayout());
        JPanel pnlBottom = new JPanel();
        pnlBottom.setLayout(new BorderLayout());
        JSeparator sp = new JSeparator();
        sp.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        pnlBottom.add((Component)sp, "North");
        JPanel pnlButtons = new JPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(11, 10, 10, 10));
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 0));
        this.btnCancel = new JButton(UIResource.KDWizardPanel_6);
        this.btnPre = new JButton(UIResource.KDWizardPanel_7);
        this.btnNext = new JButton(UIResource.KDWizardPanel_8);
        this.btnFinish = new JButton(UIResource.KDWizardPanel_9);
        this.btnHelp = new JButton(UIResource.KDWizardPanel_10);
        pnlButtons.add(this.btnHelp);
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDWizardPanel.this.doHelp();
            }
        });
        this.btnHelp.setVisible(false);
        pnlButtons.add(Box.createHorizontalGlue());
        pnlButtons.add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDWizardPanel.this.doCancel(false);
            }
        });
        pnlButtons.add(Box.createRigidArea(new Dimension(3, 27)));
        pnlButtons.add(this.btnPre);
        this.btnPre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDWizardPanel.this.doPre();
            }
        });
        pnlButtons.add(Box.createRigidArea(new Dimension(3, 27)));
        pnlButtons.add(this.btnNext);
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDWizardPanel.this.doNext();
            }
        });
        pnlButtons.add(Box.createRigidArea(new Dimension(3, 27)));
        pnlButtons.add(this.btnFinish);
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDWizardPanel.this.doFinish();
            }
        });
        pnlBottom.add((Component)pnlButtons, "South");
        this.pnlWorkspace = new JPanel();
        this.pnlWorkspace.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 10));
        this.pnlWorkspace.setLayout(new BorderLayout());
        this.add((Component)this.generatorTopPanel(), "North");
        this.add((Component)pnlBottom, "South");
        this.add((Component)this.pnlWorkspace, "Center");
        this.btnFinish.setEnabled(false);
        this.btnPre.setEnabled(false);
    }

    public void addWizardStep(AbstractWizardStep step) {
        if (this.curStep == null) {
            this.curStep = step;
            this.pnlWorkspace.add((Component)step, "Center");
        }
        step.setWizardStepButtonListener(this);
        this.stepContainer.put(step.getStepName(), step);
    }

    protected void doFinish() {
        if (this.curStep != null && !this.curStep.doFinish()) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            WizardListener listener = (WizardListener)this.listeners.get(i);
            listener.doFinish();
        }
    }

    protected void doNext() {
        if (this.curStep != null) {
            String nextStepName = this.curStep.doNext();
            this.switchStepPage(nextStepName, true);
        }
    }

    public AbstractWizardStep getCurrentStep() {
        return this.curStep;
    }

    protected void doPre() {
        if (this.curStep != null) {
            String nextStepName = this.curStep.doPre();
            this.switchStepPage(nextStepName, false);
        }
    }

    void switchStepPage(String nextStepName, boolean normalStep) {
        AbstractWizardStep step;
        if (nextStepName != null && (step = (AbstractWizardStep)this.stepContainer.get(nextStepName)) != null) {
            step.beforeShowStep(normalStep);
            this.curStep.setVisible(false);
            this.pnlWorkspace.remove(this.curStep);
            this.curStep = step;
            this.pnlWorkspace.add((Component)this.curStep, "Center");
            this.curStep.setVisible(true);
            if (this.ownerWindow instanceof JDialog) {
                ((JDialog)this.ownerWindow).setTitle(this.curStep.getStepTitle());
            } else if (this.ownerWindow instanceof JFrame) {
                ((JFrame)this.ownerWindow).setTitle(this.curStep.getStepTitle());
            }
            for (int i = 0; i < this.labelList.size(); ++i) {
                JLabel lbTmp = this.labelList.get(i);
                if (step.getStepTitle() != null && step.getStepTitle().indexOf(lbTmp.getText()) >= 0) {
                    lbTmp.setForeground(new Color(0xFF8000));
                    continue;
                }
                lbTmp.setForeground(new Color(51, 51, 51));
            }
            this.repaint();
            this.revalidate();
        }
    }

    protected void doCancel(boolean checkCondition) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            WizardListener listener = (WizardListener)this.listeners.get(i);
            listener.doCancel(checkCondition);
        }
    }

    protected void doHelp() {
    }

    public void setBtnHelpVisible(boolean visible) {
        this.btnHelp.setVisible(visible);
    }

    public void setBtnHelpEnable(boolean enable) {
        this.btnHelp.setEnabled(enable);
    }

    @Override
    public void setBtnCancelVisible(boolean visible) {
        this.btnCancel.setVisible(visible);
    }

    @Override
    public void setBtnCancelEnable(boolean enable) {
        this.btnCancel.setEnabled(enable);
    }

    public void enableColseWindow(boolean enable) {
        if (this.ownerWindow instanceof JDialog) {
            if (enable) {
                ((JDialog)this.ownerWindow).setDefaultCloseOperation(2);
            } else {
                ((JDialog)this.ownerWindow).setDefaultCloseOperation(0);
            }
        } else if (enable) {
            ((JFrame)this.ownerWindow).setDefaultCloseOperation(2);
        } else {
            ((JFrame)this.ownerWindow).setDefaultCloseOperation(0);
        }
    }

    @Override
    public void setBtnPreVisible(boolean visible) {
        this.btnPre.setVisible(visible);
    }

    @Override
    public void setBtnPreEnable(boolean enable) {
        this.btnPre.setEnabled(enable);
    }

    @Override
    public void setBtnNextEnable(boolean enable) {
        this.btnNext.setEnabled(enable);
    }

    @Override
    public void setBtnNextText(String txt) {
        this.btnNext.setText(txt);
    }

    @Override
    public void setBtnNextVisible(boolean visible) {
        this.btnNext.setVisible(visible);
    }

    @Override
    public void setBtnFinishVisible(boolean visible) {
        this.btnFinish.setVisible(visible);
    }

    @Override
    public void setBtnFinishEnable(boolean enable) {
        this.enableColseWindow(enable);
        this.btnFinish.setEnabled(enable);
    }

    public void addWizardListener(WizardListener listener) {
        this.listeners.add(listener);
    }

    public void removeWizardListener(WizardListener listener) {
        this.listeners.remove(listener);
    }

    public static interface WizardListener {
        public void doFinish();

        public void doCancel(boolean var1);
    }
}

