/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    int currentValue = 0;
    boolean enableNegativeNum = false;

    public IntegerDocument(boolean enableNegativeNum) {
        this.enableNegativeNum = enableNegativeNum;
    }

    public IntegerDocument() {
    }

    public int getValue() {
        return this.currentValue;
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        this.currentValue = this.checkInput(newValue, offset);
        super.insertString(offset, string, attributes);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        int currentLength = this.getLength();
        String currentContent = this.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + after;
        this.currentValue = this.checkInput(newValue, offset);
        super.remove(offset, length);
    }

    public int checkInput(String proposedValue, int offset) throws BadLocationException {
        if (this.enableNegativeNum) {
            if (proposedValue.length() == 1 && "-".equalsIgnoreCase(proposedValue)) {
                return 0;
            }
        } else {
            return this.isNumber(proposedValue, offset);
        }
        if (proposedValue.length() > 1) {
            return this.isNumber(proposedValue, offset);
        }
        return 0;
    }

    private int isNumber(String proposedValue, int offset) throws BadLocationException {
        try {
            if (offset == 0 && (proposedValue == null || proposedValue.length() <= 0)) {
                return 0;
            }
            int newValue = Integer.parseInt(proposedValue);
            return newValue;
        }
        catch (NumberFormatException e) {
            throw new BadLocationException(proposedValue, offset);
        }
    }
}

