/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.option;

import com.kingdee.eas.base.uiframe.client.conf.FrmClientConfig;
import com.kingdee.eas.base.uiframe.client.conf.UIFrameRes;
import com.kingdee.eas.base.uiframe.client.conf.util.StringUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DownloadFile
extends JFrame {
    private JPanel panel = null;
    private JScrollPane scrollPane = null;
    private JTextArea jta = null;
    private JButton jbt = null;
    private JLabel jlb = null;
    private String update_server = FrmClientConfig.UPDATE_SERVER;
    private String filenameList = "";
    private String downloadPath = "";
    private final String example_file = "lib/client/bos/bd_org-client.jar";
    private static int retryTimes = 10;
    boolean hasSuccess = false;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadFile frame = new DownloadFile();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public DownloadFile() {
        this.init();
        this.initData();
    }

    private void init() {
        this.setTitle(UIFrameRes.getRes("res_125"));
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/com/kingdee/eas/base/uiframe/client/conf/icon_serverlink.gif"));
            this.setIconImage(icon.getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 450, 150);
        this.panel = new JPanel();
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.setLayout(null);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBounds(5, 5, 420, 60);
        this.panel.add(this.scrollPane);
        this.jta = new JTextArea("lib/client/bos/bd_org-client.jar");
        this.jta.setLineWrap(true);
        this.scrollPane.setViewportView(this.jta);
        this.jlb = new JLabel(".....");
        this.jlb.setBounds(5, 75, 300, 30);
        this.jlb.setCursor(Cursor.getPredefinedCursor(12));
        this.jlb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().open(new File(DownloadFile.this.downloadPath));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.panel.add(this.jlb);
        this.jbt = new JButton(UIFrameRes.getRes("res_98"));
        this.jbt.setBounds(320, 75, 100, 30);
        this.jbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadFile.this.filenameList = DownloadFile.this.jta.getText();
                DownloadFile.this.doHander();
            }
        });
        this.panel.add(this.jbt);
        this.setVisible(true);
    }

    private void initData() {
        this.downloadPath = System.getProperty("EAS_HOME") + "\\client\\bin\\lib";
    }

    protected void downloadFileByName(String filenameList) {
        String[] filenames;
        filenameList = filenameList.trim();
        for (String filename : filenames = filenameList.split(";")) {
            if (StringUtil.isEmptyValue(filename)) continue;
            this.downloadFromeUpdateServer(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testConnection(URL url, int timeout) {
        int retryTimes = 10;
        for (int i = 1; i < retryTimes; ++i) {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Connection", "Close");
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(timeout * 1000);
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (200 != responseCode) {
                    JOptionPane.showMessageDialog(null, "ERROR");
                }
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "ERROR");
                e.printStackTrace();
                continue;
            }
            finally {
                if (null != conn) {
                    conn.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFromeUpdateServer(String filepath) {
        InputStream ins = null;
        FileOutputStream fos = null;
        URL downloadUrl = null;
        HttpURLConnection httpConnection = null;
        String easServer = this.update_server;
        easServer = DownloadFile.makePathEndWithSlash(easServer);
        File downloadFile = new File(filepath);
        String filename = downloadFile.getName();
        String fileType = filename.substring(filename.lastIndexOf(".") + 1);
        String url = "http://" + easServer + "easWebClient/" + filepath;
        String logTitle = "[\u4e0b\u8f7d\u6587\u4ef6:" + url + "] ";
        int i = 1;
        if (i < retryTimes) {
            System.out.println(logTitle + "\u4e0b\u8f7d\u5f00\u59cb...");
            try {
                downloadUrl = new URL(url);
                httpConnection = (HttpURLConnection)downloadUrl.openConnection();
                httpConnection.setConnectTimeout(3000);
                httpConnection.setRequestProperty("Connection", "Close");
                httpConnection.setRequestMethod("GET");
                httpConnection.connect();
                int contentLength = httpConnection.getContentLength();
                System.out.println("[download] server return content-length[" + contentLength + "] from [" + url + "], ");
                ins = httpConnection.getInputStream();
                fos = new FileOutputStream(new File(this.downloadPath + "/" + filename + this.getDateFormatTime() + "." + fileType));
                byte[] buf = new byte[1024];
                int j = 0;
                while ((j = ins.read(buf)) != -1) {
                    fos.write(buf, 0, j);
                }
                ins.close();
                fos.close();
                System.out.println(filename + "\u4e0b\u8f7d\u6210\u529f");
                this.setInfo(filename);
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "\u6587\u4ef6\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
                e.printStackTrace();
                return;
            }
            finally {
                if (httpConnection != null) {
                    try {
                        httpConnection.disconnect();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    if (ins != null) {
                        ins.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHander() {
        this.jbt.setEnabled(false);
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        DownloadFile.this.hasSuccess = DownloadFile.this.doTask();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        DownloadFile.this.hasSuccess = false;
                    }
                    if (DownloadFile.this.hasSuccess) {
                        // empty if block
                    }
                }
            };
            new Thread(r, "Body guard work thread").start();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.hasSuccess = false;
        }
        finally {
            this.jbt.setEnabled(true);
        }
    }

    public boolean doTask() {
        this.downloadFileByName(this.filenameList);
        return false;
    }

    private void setInfo(String filename) {
        this.jlb.setText("<html>eas/client/bin/lib/<U>" + filename + "</U>\u4e0b\u8f7d\u6210\u529f</html>");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String makePathEndWithSlash(String path) {
        if (StringUtil.isEmptyValue(path)) {
            throw new IllegalArgumentException("path is '" + path + "'");
        }
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }

    private String getDateFormatTime() {
        Date date = new Date();
        System.out.println(date.toString());
        SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd-HH-mm-ss");
        String dateStr = sdf.format(date);
        return dateStr;
    }
}

