/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.option;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatFile {
    private File batFile;
    private String fileName;
    private Properties props;

    public BatFile(String fileName) {
        this.batFile = new File(fileName);
        this.fileName = fileName;
    }

    public void updateParameter(String paraName, String value) throws Exception {
        try {
            paraName = paraName.trim();
            StringBuffer strBuffer = new StringBuffer();
            FileInputStream stream = new FileInputStream(this.batFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            String newLine = "";
            String pattern = "^\\s*SET\\s*" + paraName + "\\s*=\\s*(.*)$";
            Pattern p = Pattern.compile(pattern, 2);
            boolean hasFound = false;
            while ((oldLine = buffReader.readLine()) != null) {
                Matcher m;
                newLine = oldLine;
                if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                    hasFound = true;
                    String target = m.group(1);
                    int length = oldLine.indexOf(target);
                    String start = oldLine.substring(0, length);
                    oldLine = newLine = start + value;
                }
                oldLine = oldLine + "\r\n";
                strBuffer.append(oldLine);
            }
            if (!hasFound) {
                strBuffer.append("SET " + paraName + "=" + value + "\r\n");
            }
            FileOutputStream out = new FileOutputStream(this.batFile);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buffWriter = new BufferedWriter(writer);
            buffWriter.write(strBuffer.toString());
            buffWriter.flush();
            buffWriter.close();
            if (this.props != null) {
                this.props.setProperty(paraName, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getParameter(String paraName) throws Exception {
        Properties p = this.getParameters();
        return p.getProperty(paraName);
    }

    public File getFile() {
        return this.batFile;
    }

    public Properties getParameters() throws Exception {
        if (this.props == null) {
            this.loadProperties();
        }
        return this.props;
    }

    private void loadProperties() throws Exception {
        try {
            Properties temp = new Properties();
            FileInputStream stream = new FileInputStream(this.batFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            ArrayList<String> nameList = new ArrayList<String>();
            String pattern = "^\\s*@?set\\s+([\\S&&[^=]]+)\\s*=\\s*(\\S+)\\s*$";
            Pattern p = Pattern.compile(pattern, 2);
            while ((oldLine = buffReader.readLine()) != null) {
                Matcher m;
                if (oldLine.trim().length() == 0 || !(m = p.matcher(oldLine)).find()) continue;
                String value = m.group(2);
                value = m.group(2).replace('\\', '/');
                value = value.replaceAll("\"\"", "%Double_Quotation_Marks%");
                value = value.replaceAll("\"", "");
                value = value.replaceAll("%Double_Quotation_Marks%", "\"");
                temp.setProperty(m.group(1), value);
                nameList.add(m.group(1));
            }
            for (int i = 0; i < nameList.size(); ++i) {
                String name = (String)nameList.get(i);
                String value = temp.getProperty(name);
                for (int k = i + 1; k < nameList.size(); ++k) {
                    String pName = (String)nameList.get(k);
                    String pValue = temp.getProperty(pName);
                    pValue = pValue.replaceAll("%" + name + "%", value);
                    temp.setProperty(pName, pValue);
                }
            }
            stream.close();
            this.props = temp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeParameter(String paraName) throws Exception {
        try {
            paraName = paraName.trim();
            StringBuffer strBuffer = new StringBuffer();
            FileInputStream stream = new FileInputStream(this.batFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            String pattern = "^\\s*SET\\s*" + paraName + "\\s*=\\s*(.*)$";
            Pattern p = Pattern.compile(pattern, 2);
            while ((oldLine = buffReader.readLine()) != null) {
                Matcher m;
                if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                    oldLine = "@REM " + oldLine;
                }
                oldLine = oldLine + "\r\n";
                strBuffer.append(oldLine);
            }
            FileOutputStream out = new FileOutputStream(this.batFile);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buffWriter = new BufferedWriter(writer);
            buffWriter.write(strBuffer.toString());
            buffWriter.flush();
            buffWriter.close();
            if (this.props != null) {
                this.props.remove(paraName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

