/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf.killprocess;

import com.kingdee.eas.base.uiframe.client.conf.UIFrameRes;
import com.kingdee.eas.base.uiframe.client.conf.killprocess.DOSCommand;
import com.kingdee.eas.base.uiframe.client.conf.killprocess.ShowOwnPID;
import com.kingdee.eas.base.uiframe.client.conf.killprocess.WmicProcess;
import com.kingdee.eas.base.uiframe.client.conf.util.CheckJDKUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class DeleteFileUtil {
    public static void deleteFile(File destFile) throws IOException {
        DeleteFileUtil.deleteFile(destFile, false);
    }

    public static void deleteFile(File destFile, boolean forceKill) throws IOException {
        if (DeleteFileUtil.retryDeleteSuccess(destFile)) {
            return;
        }
        System.out.println("delete " + destFile + " failed, file has been locked.");
        List easClientProcessList = DeleteFileUtil.getOtherEasClientProcessList();
        if (easClientProcessList.size() == 0) {
            JOptionPane.showMessageDialog(null, UIFrameRes.getRes("res_90") + UIFrameRes.getRes("res_10") + "\r\n" + destFile.getAbsolutePath(), UIFrameRes.getRes("res_10"), 1);
        } else if (forceKill) {
            int select = JOptionPane.showConfirmDialog(null, UIFrameRes.getRes("res_90"), UIFrameRes.getRes("res_10"), 0);
            if (0 == select) {
                DeleteFileUtil.killProcesses(easClientProcessList);
            }
            DeleteFileUtil.deleteFile(destFile);
        } else {
            JOptionPane.showMessageDialog(null, UIFrameRes.getRes("res_90"), UIFrameRes.getRes("res_10"), 1);
            DeleteFileUtil.deleteFile(destFile, true);
        }
    }

    private static boolean retryDeleteSuccess(File destFile) {
        for (int i = 0; i < 2; ++i) {
            if (DeleteFileUtil.deteteSuccess(destFile)) {
                return true;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean deteteSuccess(File destFile) {
        if (!destFile.exists()) {
            return true;
        }
        return destFile.delete();
    }

    private static List getOtherEasClientProcessList() throws IOException {
        WmicProcess[] javaProcesses = DeleteFileUtil.getAllJavaProcesses();
        List easClientProcessList = DeleteFileUtil.getOtherEasClientProcessList(javaProcesses);
        System.out.println("\u9700\u8981\u780d\u6740\u7684EAS\u5ba2\u6237\u7aef\u8fdb\u7a0b\u6709" + easClientProcessList.size() + "\u4e2a");
        return easClientProcessList;
    }

    private static void killProcesses(List easClientProcessList) throws IOException {
        for (int i = 0; i < easClientProcessList.size(); ++i) {
            WmicProcess result = (WmicProcess)easClientProcessList.get(i);
            System.out.println("\u6740\u6b7beas\u5ba2\u6237\u7aef\u8fdb\u7a0b" + result.toString());
            DOSCommand cmd = new DOSCommand();
            cmd.executeQuiety("wmic process where ProcessId=\"" + result.getProcessId() + "\"  call terminate");
        }
    }

    private static WmicProcess[] getAllJavaProcesses() throws IOException {
        DOSCommand cmd = new DOSCommand();
        cmd.executeQuiety("wmic process where name=\"javaw.exe\" list full");
        String line = cmd.getOutput();
        System.out.println("wmic list \u547d\u4ee4 \u8fd4\u56de{" + line + "}");
        WmicProcess[] ss = WmicProcess.parseResults(line);
        System.out.println("\u67e5\u5230\u7684java\u8fdb\u7a0b\u6709" + ss.length + "\u4e2a:");
        for (int i = 0; i < ss.length; ++i) {
            System.out.println(ss[i].toString());
        }
        return ss;
    }

    private static List getOtherEasClientProcessList(WmicProcess[] javaProcesses) {
        String selfPid = DeleteFileUtil.getCurrentPid();
        String easHome = System.getProperty("EAS_HOME");
        String easHomeTow = easHome.toLowerCase().replaceAll("\\\\", "/");
        System.out.println("easHomeTow=" + easHomeTow);
        ArrayList<WmicProcess> easClientProcessList = new ArrayList<WmicProcess>();
        for (int i = 0; i < javaProcesses.length; ++i) {
            WmicProcess s = javaProcesses[i];
            if (selfPid.equals(s.getProcessId())) {
                System.out.println("\u8fdb\u7a0b" + selfPid + "\u662f\u81ea\u5df1\uff0c\u5ffd\u7565\uff08\u4e0d\u81ea\u6740\uff09");
                continue;
            }
            String CommandLine = s.getCommandLine().toLowerCase().replaceAll("\\\\", "/");
            if (-1 == CommandLine.indexOf(easHomeTow)) continue;
            easClientProcessList.add(s);
        }
        return easClientProcessList;
    }

    private static String getCurrentPid() {
        String selfPid = String.valueOf(ShowOwnPID.getCurrentPid());
        return selfPid;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String currentJavaHomePath = "D:\\client\\client0621\\eas\\clientjdk";
        File file = new File(currentJavaHomePath);
        File parentFile = null;
        HashMap<String, String> avaiableJDKs = new HashMap<String, String>();
        parentFile = file.getParentFile();
        if (parentFile != null) {
            for (File path : parentFile.listFiles()) {
                String jdkVersion;
                if (path.getAbsolutePath().endsWith("client") || (jdkVersion = CheckJDKUtil.checkJDKVersion(path)) == null) continue;
                avaiableJDKs.put(jdkVersion, path.getAbsolutePath());
                System.out.println(String.format("find one jdk:%s,version:%s", path.getAbsoluteFile(), jdkVersion));
            }
            System.out.println(String.format("total jdk : %d ,path: %s", avaiableJDKs.size(), parentFile.getAbsoluteFile()));
        }
        for (Map.Entry entry : avaiableJDKs.entrySet()) {
            System.out.println((String)entry.getKey() + "===" + (String)entry.getValue());
        }
    }
}

