/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf;

public class OsUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean IS_OS_AIX = OsUtils.getOSMatches(OS_NAME, "AIX");
    public static final boolean IS_OS_HPUNIX = OsUtils.getOSMatches(OS_NAME, "HP-UX");
    public static final boolean IS_OS_LINUX = OsUtils.getOSMatches(OS_NAME, "LINUX");
    public static final boolean IS_OS_400 = OsUtils.getOSMatches(OS_NAME, "OS/400");
    public static final boolean IS_OS_SOLARIS = OsUtils.getOSMatches(OS_NAME, "SUNOS") || OsUtils.getOSMatches(OS_NAME, "SOLARIS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HPUNIX || IS_OS_LINUX || IS_OS_SOLARIS;
    public static final boolean IS_OS_WINDOWS = OsUtils.getOSMatches(OS_NAME, "WINDOWS");
    public static final boolean IS_OS_WINDOWS2000 = OsUtils.getOSMatches(OS_NAME, OS_VERSION, "WINDOWS", "5.0");
    public static final boolean IS_OS_WINDOWSXP = OsUtils.getOSMatches(OS_NAME, OS_VERSION, "WINDOWS", "5.1");
    public static final boolean IS_OS_WINDOWS2003 = OsUtils.getOSMatches(OS_NAME, OS_VERSION, "WINDOWS", "5.2");
    public static final boolean IS_OS_WINDOWSVISTA = OsUtils.getOSMatches(OS_NAME, OS_VERSION, "WINDOWS", "6.0");
    public static final boolean IS_OS_WINDOWS2008 = OsUtils.getOSMatches(OS_NAME, OS_VERSION, new String[]{"WINDOWS", "2008"}, "6.1");
    public static final boolean IS_OS_WINDOWS7 = OsUtils.getOSMatches(OS_NAME, OS_VERSION, new String[]{"WINDOWS", "7"}, "6.1");

    public static boolean getOSMatches(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.toUpperCase().startsWith(osNamePrefix);
    }

    public static boolean getOSMatches(String osName, String osVersion, String osNamePrefix, String osVersionPrefix) {
        if (osName == null || osVersion == null) {
            return false;
        }
        return osName.toUpperCase().startsWith(osNamePrefix) && osVersion.toUpperCase().startsWith(osVersionPrefix);
    }

    public static boolean getOSMatches(String osName, String osVersion, String[] osNamePrefixs, String osVersionPrefix) {
        if (osName == null || osVersion == null) {
            return false;
        }
        if (osVersion.toUpperCase().startsWith(osVersionPrefix)) {
            for (int i = 0; i < osNamePrefixs.length; ++i) {
                if (osName.toUpperCase().indexOf(osNamePrefixs[i]) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

