/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf;

import com.kingdee.eas.base.uiframe.client.conf.ShellFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KShellFile
implements ShellFile {
    private static String LINE_FEED = System.getProperty("line.separator");
    private File kshFile;
    private String fileName;
    private Properties props;

    public KShellFile(String fileName) {
        this.kshFile = new File(fileName);
        this.fileName = fileName;
    }

    @Override
    public void updateParameter(String paraName, String value) throws Exception {
        try {
            paraName = paraName.trim();
            StringBuffer strBuffer = new StringBuffer();
            FileInputStream stream = new FileInputStream(this.kshFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            String newLine = "";
            String pattern = "^\\s*" + paraName + "\\s*=\\s*(.*)$";
            Pattern p = Pattern.compile(pattern);
            while ((oldLine = buffReader.readLine()) != null) {
                Matcher m;
                newLine = oldLine;
                if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                    String target = m.group(1);
                    oldLine = newLine = oldLine.replaceAll(target, value);
                }
                oldLine = oldLine + LINE_FEED;
                strBuffer.append(oldLine);
            }
            FileOutputStream out = new FileOutputStream(this.kshFile);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buffWriter = new BufferedWriter(writer);
            buffWriter.write(strBuffer.toString());
            buffWriter.flush();
            buffWriter.close();
            if (this.props != null) {
                this.props.setProperty(paraName, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParameter(String paraName) throws Exception {
        Properties p = this.getParameters();
        return p.getProperty(paraName);
    }

    @Override
    public File getFile() {
        return this.kshFile;
    }

    @Override
    public Properties getParameters() throws Exception {
        if (this.props == null) {
            this.loadProperties();
        }
        return this.props;
    }

    private void loadProperties() throws Exception {
        try {
            String value;
            Properties temp = new Properties();
            FileInputStream stream = new FileInputStream(this.kshFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            String name = "";
            ArrayList<String> nameList = new ArrayList<String>();
            while ((oldLine = buffReader.readLine()) != null) {
                int index;
                if (oldLine.trim().length() == 0 || oldLine.startsWith("#") || (index = oldLine.indexOf("=")) <= 0 || (name = oldLine.substring(0, index)).trim().indexOf(" ") != -1) continue;
                nameList.add(name.trim());
                value = oldLine.substring(index + 1).trim();
                value = value.replace('\\', '/');
                value = value.replaceAll("\"\"", "%Double_Quotation_Marks%");
                value = value.replaceAll("\"", "");
                value = value.replaceAll("%Double_Quotation_Marks%", "\"");
                temp.setProperty(name.trim(), value);
            }
            for (int i = 0; i < nameList.size(); ++i) {
                name = (String)nameList.get(i);
                value = temp.getProperty(name);
                for (int k = i + 1; k < nameList.size(); ++k) {
                    String pName = (String)nameList.get(k);
                    String pValue = temp.getProperty(pName);
                    pValue = pValue.replaceAll("\\$" + name, value);
                    temp.setProperty(pName, pValue);
                }
            }
            stream.close();
            this.props = temp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeParameter(String paraName) throws Exception {
        try {
            paraName = paraName.trim();
            StringBuffer strBuffer = new StringBuffer();
            FileInputStream stream = new FileInputStream(this.kshFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            String newLine = "";
            String pattern = "^\\s*" + paraName + "\\s*=\\s*(.*)$";
            Pattern p = Pattern.compile(pattern);
            while ((oldLine = buffReader.readLine()) != null) {
                Matcher m;
                newLine = oldLine;
                if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                    oldLine = "# " + newLine;
                }
                oldLine = oldLine + LINE_FEED;
                strBuffer.append(oldLine);
            }
            FileOutputStream out = new FileOutputStream(this.kshFile);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buffWriter = new BufferedWriter(writer);
            buffWriter.write(strBuffer.toString());
            buffWriter.flush();
            buffWriter.close();
            if (this.props != null) {
                this.props.remove(paraName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

