/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf;

import com.kingdee.eas.base.uiframe.client.conf.FileInfo;
import com.kingdee.eas.base.uiframe.client.conf.FileVersionUtil;
import com.kingdee.eas.base.uiframe.client.conf.OsUtils;
import com.kingdee.eas.base.uiframe.client.conf.ui.UIResource;
import com.kingdee.eas.base.uiframe.client.conf.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.prefs.Preferences;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JLabel;

public class InstallClientUtil {
    public static FileInfo dealSpecialFile(String clientHome) {
        String baseFilePath = System.getenv("windir") + "/kingdee";
        Preferences sysProfs = Preferences.systemRoot().node("/kingdee/eas");
        String currentFilePath = sysProfs.get("launcherVersion", null);
        String updateFilePath = FileVersionUtil.getFilePath(clientHome + "/bin", "launcher", ".exe");
        System.out.println("currentFilePath=" + currentFilePath);
        System.out.println("updateFilePath=" + updateFilePath);
        boolean replace = false;
        if (currentFilePath == null || currentFilePath.length() < 1) {
            replace = true;
        } else if (FileVersionUtil.compareFileVersion(currentFilePath, updateFilePath)) {
            replace = true;
        }
        if (replace) {
            String realFilePath = baseFilePath + System.getProperty("file.separator") + "launcher.exe";
            try {
                FileUtil.createDirectory(baseFilePath);
                FileUtil.cpFile(new File(updateFilePath), new File(realFilePath), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new FileInfo(realFilePath, new File(updateFilePath).getName());
        }
        return new FileInfo(null, null);
    }

    public static boolean dealEASService(String clientHome, OsUtils utils, String destFilePath, String serviceName, JLabel lbShowTips, String tip) {
        Preferences sysProfs = Preferences.systemRoot().node("/kingdee/eas");
        String currentFilePath = sysProfs.get(serviceName + "Version", null);
        String updateFilePath = FileVersionUtil.getFilePath(clientHome + "/client/bin", serviceName, ".exe");
        System.out.println("currentFilePath=" + currentFilePath);
        System.out.println("updateFilePath=" + updateFilePath);
        boolean upgrade = false;
        if (currentFilePath == null || currentFilePath.length() < 1) {
            upgrade = true;
        } else if (FileVersionUtil.compareFileVersion(currentFilePath, updateFilePath)) {
            upgrade = true;
        }
        if (upgrade) {
            System.out.println("Real install Service [" + serviceName + "]");
            File file = new File(destFilePath);
            boolean rename = false;
            String name1 = file.getName();
            String name2 = new File(updateFilePath).getName();
            if (!name1.equals(name2)) {
                rename = true;
            }
            if (rename) {
                if (file.exists()) {
                    System.out.println("Find file [" + destFilePath + "] and updateFilePath is [" + updateFilePath + "], try to delete it");
                    if (file.delete()) {
                        System.out.println("Find file [" + destFilePath + "], delete it success");
                    }
                }
                System.out.println("Try to rename [" + updateFilePath + "] to [" + destFilePath + "]");
                new File(updateFilePath).renameTo(file);
            } else if (!file.exists()) {
                FileUtil.cpFile(new File(updateFilePath), file, null);
            }
            if (!InstallClientUtil.installService(utils, destFilePath + " /Service", serviceName, lbShowTips, tip)) {
                return false;
            }
            sysProfs.put(serviceName + "Version", new File(updateFilePath).getName());
            return true;
        }
        System.out.println("Ignore install Service [" + serviceName + "]");
        return true;
    }

    private static boolean installService(OsUtils utils, String cmd, String serviceName, JLabel lbShowTips, String tip) {
        lbShowTips.setText(UIResource.InstallClientUtil_0 + tip + "......");
        try {
            InstallClientUtil.stopOldP2P();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        boolean hasInstalledService = false;
        hasInstalledService = true;
        System.out.println("begin install " + serviceName + "......");
        try {
            System.out.println("try to stop " + serviceName + "......");
            Runtime.getRuntime().exec("net stop " + serviceName);
            System.out.println("finish to stop " + serviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("try to delete " + serviceName + "......");
            Runtime.getRuntime().exec("sc delete " + serviceName);
            System.out.println("finish delete " + serviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("try to install " + serviceName + "......");
            Runtime.getRuntime().exec(cmd);
            System.out.println("finish install " + serviceName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("try to start " + serviceName + "......");
            Runtime.getRuntime().exec("net start " + serviceName);
            System.out.println("finish start " + serviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end install " + serviceName);
        lbShowTips.setText(UIResource.InstallClientUtil_1 + tip + "");
        InstallClientUtil.configWinFirewall();
        return hasInstalledService;
    }

    private static void configWinFirewall() {
        String[] cmds = new String[]{"netsh advfirewall firewall Add rule name=\"EASMsgClient\" dir=in protocol=udp localport=11991 action=allow", "netsh advfirewall firewall Add rule name=\"EASMsgServer\" dir=in protocol=udp localport=11998 action=allow", "netsh advfirewall firewall Add rule name=\"EASHttpServer\" dir=in protocol=TCP localport=11999 action=allow", "netsh advfirewall firewall Add rule name=\"EASMsgClient\" dir=out protocol=udp localport=11991 action=allow", "netsh advfirewall firewall Add rule name=\"EASMsgServer\" dir=out protocol=udp localport=11998 action=allow", "netsh advfirewall firewall Add rule name=\"EASHttpServer\" dir=out protocol=TCP localport=11999 action=allow", "netsh firewall add portopening protocol = UDP port = 11991 name = EASMsgClient mode = ENABLE scope = ALL", "netsh firewall add portopening protocol = UDP port = 11998 name = EASMsgServer mode = ENABLE scope = ALL", "netsh firewall add portopening protocol = TCP port = 11999 name = EASHttpServer mode = ENABLE scope = ALL"};
        if (cmds != null && cmds.length > 0) {
            for (int i = 0; i < cmds.length; ++i) {
                try {
                    System.out.println("try to config firewall [" + cmds[i] + "]......");
                    Runtime.getRuntime().exec(cmds[i]);
                    System.out.println("finish config firewall ");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registryLaunch(FileInfo fileInfo, String launcherFilePath, String clientDir, JLabel lbShowTips) {
        if (launcherFilePath != null && launcherFilePath.length() > 0) {
            lbShowTips.setText(UIResource.InstallClientUtil_2);
            System.out.println("begin registry kdeas protocol......");
            File newFile = new File(clientDir + "/bin/launcher.reg");
            FileOutputStream outStream = null;
            try {
                outStream = new FileOutputStream(newFile);
                OutputStreamWriter writer = new OutputStreamWriter(outStream);
                writer.write("Windows Registry Editor Version 5.00\r\n");
                writer.write("[HKEY_CLASSES_ROOT\\kdeas]\r\n");
                writer.write("\"URL Protocol\" =-\r\n");
                writer.write("[HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Internet Explorer\\Low Rights\\ElevationPolicy\\{58B0E584-100D-4E03-9508-690FD0F675F8}]\r\n");
                writer.write("\"AppPath\"=\" =-\r\n");
                writer.write("\r\n");
                writer.write("[HKEY_CLASSES_ROOT\\kdeas\\shell\\open\\command]\r\n");
                writer.write("@ =-\r\n");
                writer.write("[HKEY_CLASSES_ROOT\\kdeas]\r\n");
                writer.write("\"URL Protocol\"=\"\"\r\n");
                writer.write("[HKEY_CLASSES_ROOT\\kdeas\\shell]\r\n");
                writer.write("[HKEY_CLASSES_ROOT\\kdeas\\shell\\open]\r\n");
                writer.write("[HKEY_CLASSES_ROOT\\kdeas\\shell\\open\\command]\r\n");
                String str = new File(launcherFilePath).getParent().replace('\\', '/');
                String fileName = new File(launcherFilePath).getName();
                str = str.replaceAll("/", "\\\\\\\\");
                writer.write("@=\"\\\"" + str + "\\\\" + fileName + "\\\" \\\"%1\\\" \"" + "\r\n");
                writer.write("[HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\ProtocolExecute\\kdeas]\r\n");
                writer.write("\"WarnOnOpen\"=dword:00000000\r\n");
                writer.write("[HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Internet Explorer\\Low Rights\\ElevationPolicy\\{58B0E584-100D-4E03-9508-690FD0F675F8}]\r\n");
                writer.write("\"AppName\"=\"launcher.exe\"\r\n");
                writer.write("\"AppPath\"=\"" + str + "\"" + "\r\n");
                writer.write("\"Policy\"=dword:00000003\r\n");
                writer.close();
                outStream.close();
                System.out.println("execute file [" + newFile.getPath() + "]....");
                Runtime.getRuntime().exec("regedit /s " + newFile.getPath());
                Preferences sysProfs = Preferences.systemRoot().node("/kingdee/eas");
                sysProfs.put("launcherVersion", fileInfo.getFileVersion());
                lbShowTips.setText(UIResource.InstallClientUtil_3);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            System.out.println("end registry kdeas protocol");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopOldP2P() {
        System.out.println("Try to stop old p2p server....");
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:11011/ProxyServer"));
            System.out.println("Get JMXConnector sucess");
        }
        catch (Exception e) {
            System.out.println("connect error,msg" + e.toString());
        }
        if (connector != null) {
            try {
                ObjectName objectName = new ObjectName(":type=com.kingdee.bos.downloadproxy.ProxyShell");
                System.out.println("Init objectName success");
                MBeanServerConnection cn = connector.getMBeanServerConnection();
                cn.invoke(objectName, "stopProxyServer", null, null);
                System.out.println("Stop old p2P server success");
                return;
            }
            catch (Exception ex) {
                System.out.println("invoke stopProxyServer error,msg:" + ex.toString());
            }
            finally {
                try {
                    connector.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) {
        String updateFilePath = "D:/CLIENT/kingdee820/eas/client/bin/easservice.exe";
        File file = new File("D:/CLIENT/kingdee820/eas/client/bin/easservice.exe");
        new File(updateFilePath).renameTo(file);
        if (!file.exists()) {
            FileUtil.cpFile(new File(updateFilePath), file, null);
        }
    }
}

