/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf;

import com.kingdee.eas.base.uiframe.client.conf.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Properties;

public class FileVersionUtil {
    private static int versionLength = 3;

    public static String getFilePath(String parentPath, final String filePrefix, final String filePostfix) {
        if (parentPath == null) {
            return null;
        }
        File file = new File(parentPath);
        File[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName().toLowerCase();
                if (filePrefix != null && !fileName.startsWith(filePrefix.toLowerCase())) {
                    return false;
                }
                if (filePostfix != null) {
                    return fileName.endsWith(filePostfix.toLowerCase());
                }
                return true;
            }
        });
        String currentFilePath = null;
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (currentFilePath == null) {
                    currentFilePath = files[i].getPath();
                    continue;
                }
                if (!FileVersionUtil.compareFileVersion(currentFilePath, files[i].getPath())) continue;
                currentFilePath = files[i].getPath();
            }
            return currentFilePath;
        }
        return null;
    }

    public static boolean compareFileVersion(String currentFilePath, String updateFilePath) {
        String currentVersion = FileVersionUtil.getFileVersin(currentFilePath, false);
        String updateVersion = FileVersionUtil.getFileVersin(updateFilePath, true);
        return FileVersionUtil.compareTwoVersion(currentVersion, updateVersion);
    }

    public static String getFileVersin(String filePath, boolean fileMustExists) {
        File file = new File(filePath);
        if (file.exists() || !fileMustExists) {
            return file.getName();
        }
        return null;
    }

    private static boolean compareTwoVersion(String currVersion, String updateVersion) {
        int value;
        int numberStartIndex;
        if (currVersion == null && updateVersion == null) {
            return false;
        }
        if (currVersion.equals(updateVersion)) {
            return true;
        }
        if (currVersion != null && currVersion.length() > 0) {
            numberStartIndex = FileVersionUtil.getNumberIndex(currVersion);
            currVersion = FileVersionUtil.getRealVersion(currVersion, numberStartIndex);
            System.out.println("currVersion  =" + currVersion);
        }
        if (updateVersion != null && updateVersion.length() > 0) {
            numberStartIndex = FileVersionUtil.getNumberIndex(updateVersion);
            updateVersion = FileVersionUtil.getRealVersion(updateVersion, numberStartIndex);
            System.out.println("updateVersion=" + updateVersion);
        }
        return (value = updateVersion.compareToIgnoreCase(currVersion)) >= 0;
    }

    public static String getRealVersion(String version, int numberStartIndex) {
        int i;
        if (numberStartIndex == -1) {
            int index = version.lastIndexOf(".");
            String prefix = version;
            prefix = index == -1 ? version : version.substring(0, index);
            for (int i2 = 0; i2 < versionLength; ++i2) {
                prefix = prefix + "0";
            }
            return prefix;
        }
        String prefix = version.substring(0, numberStartIndex);
        String postfix = version.substring(numberStartIndex);
        String postfixAfterTrans = "";
        for (i = 0; i < postfix.length(); ++i) {
            char ch = postfix.charAt(i);
            try {
                Integer.parseInt(String.valueOf(ch));
                postfixAfterTrans = postfixAfterTrans + ch;
                if (postfixAfterTrans.length() != versionLength) continue;
                break;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (i = postfixAfterTrans.length(); i < versionLength; ++i) {
            postfixAfterTrans = postfixAfterTrans + "0";
        }
        String realVersion = prefix + postfixAfterTrans;
        return realVersion;
    }

    private static int getNumberIndex(String version) {
        int numberStartIndex = -1;
        for (int i = 0; i < version.length(); ++i) {
            char ch = version.charAt(i);
            try {
                Integer.parseInt(String.valueOf(ch));
                numberStartIndex = i;
                break;
            }
            catch (Exception ex) {
                continue;
            }
        }
        return numberStartIndex;
    }

    public static void main(String[] args) {
        String version1 = "launcher1.12.exe";
        String version2 = "launcher.exe";
        System.out.println(FileVersionUtil.compareTwoVersion(version1, version2));
        Object s = null;
        System.out.println(FileVersionUtil.dealSpecialFile("G:/kingdee0410/eas/client"));
        Properties props = System.getProperties();
        for (String string : props.keySet()) {
            System.out.println(string + "=" + props.get(string));
        }
    }

    private static String dealSpecialFile(String clientHome) {
        String baseFilePath = System.getenv("windir") + "/kingdee";
        String currentFilePath = FileVersionUtil.getFilePath(baseFilePath, "launcher", ".exe");
        String updateFilePath = FileVersionUtil.getFilePath(clientHome + "/bin", "launcher", ".exe");
        System.out.println("currentFilePath=" + currentFilePath);
        System.out.println("updateFilePath=" + updateFilePath);
        boolean replace = false;
        if (currentFilePath == null || currentFilePath.length() < 1) {
            replace = true;
        } else if (FileVersionUtil.compareFileVersion(currentFilePath, updateFilePath)) {
            replace = true;
        }
        if (replace) {
            String realFilePath = baseFilePath + System.getProperty("file.separator") + new File(updateFilePath).getName();
            try {
                FileUtil.createDirectory(baseFilePath);
                FileUtil.cpFile(new File(updateFilePath), new File(realFilePath), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return realFilePath;
        }
        return currentFilePath;
    }
}

