/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;

public class RegMultiStringValue
extends RegistryValue {
    String[] data;
    int dataLen;

    public RegMultiStringValue(RegistryKey key, String name) {
        super(key, name, 7);
        this.data = null;
        this.dataLen = 0;
    }

    public RegMultiStringValue(RegistryKey key, String name, int type) {
        super(key, name, type);
        this.data = null;
        this.dataLen = 0;
    }

    public RegMultiStringValue(RegistryKey key, String name, String[] data) {
        super(key, name, 7);
        this.setData(data);
    }

    public String[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.dataLen;
    }

    public void setData(String[] data) {
        this.data = data;
        this.dataLen = data.length;
    }

    @Override
    public byte[] getByteData() {
        int len = this.getByteLength();
        int ri = 0;
        byte[] result = new byte[len];
        for (int i = 0; i < this.dataLen; ++i) {
            byte[] strBytes = this.data[i].getBytes();
            for (int j = 0; j < strBytes.length; ++j) {
                result[ri++] = strBytes[j];
            }
            result[ri++] = 0;
        }
        return result;
    }

    @Override
    public int getByteLength() {
        int len = 0;
        for (int i = 0; i < this.dataLen; ++i) {
            len += this.data[i].length() + 1;
        }
        return len;
    }

    @Override
    public void setByteData(byte[] data) {
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            ++count;
        }
        int si = 0;
        String[] newData = new String[count];
        int start = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            newData[si] = new String(data, start, i - start);
            start = si;
        }
        this.setData(newData);
    }

    @Override
    public void export(PrintWriter out) {
        int dataLen = 0;
        out.println("\"" + this.getName() + "\"=hex(7):\\");
        for (int i = 0; i < this.data.length; ++i) {
            dataLen += this.data[i].length() + 1;
        }
        int idx = 0;
        byte[] hexData = new byte[++dataLen];
        for (int i = 0; i < this.data.length; ++i) {
            int strLen = this.data[i].length();
            byte[] strBytes = this.data[i].getBytes();
            System.arraycopy(strBytes, 0, hexData, idx, strLen);
            idx += strLen;
            hexData[idx++] = 0;
        }
        hexData[idx++] = 0;
        RegistryValue.exportHexData(out, hexData);
    }
}

