/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.SessionManagerUtil;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeRegister;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.mobileaccess.ext.web.util.ExtMobileJSONUtils;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LoginHelper {
    private static Logger logger = Logger.getLogger(LoginHelper.class);

    public static boolean checkWX(HttpServletRequest request, String code, String state) throws Exception {
        XtParamsDTO xtParamsDTO;
        HttpSession session = request.getSession();
        Context easContext = (Context)session.getAttribute("XTContext");
        if (easContext != null) {
            return true;
        }
        try {
            xtParamsDTO = WXUtil.getXtParamsDTO((HttpSession)session, (String)code, (String)state);
            session.setAttribute("isWX", (Object)"true");
        }
        catch (Exception e) {
            throw new Exception("\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u5173\u95ed\u540e\u91cd\u8bd5\uff01");
        }
        try {
            easContext = com.kingdee.lightapp.xt.util.LoginHelper.loginByXtId((HttpServletRequest)request, (XtParamsDTO)xtParamsDTO);
            session.setAttribute("XTContext", (Object)easContext);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Context login(HttpServletRequest request) throws ExtRptBizException {
        Context easCtx;
        block17: {
            logger.warn((Object)"---------------easCtx lost try to login---------------");
            easCtx = null;
            try {
                String userPsw;
                String sUserInfo = request.getParameter("userInfo");
                if (sUserInfo == null) {
                    throw ExtRptBizException.newLoginCtxException((Throwable)new NullPointerException("empty userInfo"));
                }
                System.out.println("UserInfo\uff1a" + sUserInfo);
                JSONObject userInfo = new JSONObject(sUserInfo);
                if (!userInfo.isNull("isWX") && "true".equals(userInfo.getString("isWX"))) {
                    String code = userInfo.isNull("code") ? null : userInfo.getString("code");
                    String state = userInfo.isNull("state") ? null : userInfo.getString("state");
                    String pubacctid = userInfo.isNull("pubacctid") ? null : userInfo.getString("pubacctid");
                    String currentEid = userInfo.isNull("eid") ? null : userInfo.getString("eid");
                    Env.set(Env.Key.eid, currentEid);
                    easCtx = (Context)request.getSession().getAttribute("XTContext");
                    if (easCtx != null) {
                        LoginHelper.setup(easCtx, pubacctid, request);
                        return easCtx;
                    }
                    XtParamsDTO xtParamsDTO = null;
                    try {
                        xtParamsDTO = WXUtil.getXtParamsDTO((HttpSession)request.getSession(), (String)code, (String)state);
                        easCtx = com.kingdee.lightapp.xt.util.LoginHelper.loginByXtId((HttpServletRequest)request, (XtParamsDTO)xtParamsDTO);
                        LoginHelper.setup(easCtx, pubacctid, request);
                        break block17;
                    }
                    catch (Exception e) {
                        throw ExtRptBizException.newLoginCtxException((Throwable)e);
                    }
                }
                if (!userInfo.isNull("isBS") && "true".equals(userInfo.getString("isBS"))) {
                    String pubacctid = userInfo.isNull("pubacctid") ? null : userInfo.getString("pubacctid");
                    String currentEid = userInfo.isNull("eid") ? null : userInfo.getString("eid");
                    Env.set(Env.Key.eid, currentEid);
                    request.getSession().setAttribute("eid", (Object)currentEid);
                    if (easCtx == null) {
                        easCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
                    }
                    if (easCtx == null) {
                        easCtx = (Context)request.getSession().getAttribute("XTContext");
                    }
                    if (easCtx != null) {
                        LoginHelper.setup(easCtx, pubacctid, request);
                        return easCtx;
                    }
                    throw ExtRptBizException.newLoginCtxException((Throwable)new RuntimeException("login please\uff01"));
                }
                String pubacctid = userInfo.isNull("pubacctid") ? null : userInfo.getString("pubacctid");
                String currentEid = userInfo.isNull("eid") ? null : userInfo.getString("eid");
                String openId = userInfo.isNull("openId") ? null : userInfo.getString("openId");
                String email = userInfo.isNull("email") ? null : userInfo.getString("email");
                String userName = userInfo.isNull("userAccount") ? null : userInfo.getString("userAccount");
                String string = userPsw = userInfo.isNull("userPsw") ? null : userInfo.getString("userPsw");
                if (openId == null && email == null && userName == null && userPsw == null) {
                    throw ExtRptBizException.newLoginCtxException((Throwable)new NullPointerException("no openId and email information"));
                }
                try {
                    Env.set(Env.Key.eid, currentEid);
                    easCtx = (Context)request.getSession().getAttribute("XTContext");
                    if (easCtx != null && StringUtil.equals((String)LoginHelper.getUser(openId, email, userName, userPsw).getNumber(), (String)easCtx.getUserName())) {
                        LoginHelper.setup(easCtx, pubacctid, request);
                        return easCtx;
                    }
                    easCtx = LoginHelper.loginImpl(openId, email, userName, userPsw);
                    LoginHelper.setup(easCtx, pubacctid, request);
                    LoginHelper.switchForLogin(easCtx);
                    request.setAttribute("isPureWeb", (Object)"true");
                    WebContextUtil.createWebContext((HttpServletRequest)request, (Context)easCtx);
                }
                catch (Exception e) {
                    ExtRptBizException ex = ExtRptBizException.newLoginCtxException((Throwable)e);
                    logger.error((Object)ex.getErrorMessage(), (Throwable)e);
                    throw ex;
                }
            }
            catch (JSONException e) {
                throw ExtRptBizException.newLoginCtxException((Throwable)e);
            }
        }
        request.getSession().setAttribute("XTContext", (Object)easCtx);
        try {
            SessionManagerUtil.removeSession((String)easCtx.getContextID());
        }
        catch (BOSException e) {
            throw ExtRptBizException.newLoginCtxException((Throwable)e);
        }
        logger.warn((Object)"---------------login success---------------");
        return easCtx;
    }

    private static void setup(Context easCtx, String pubAcctId, HttpServletRequest request) throws ExtRptBizException {
        String rptId = request.getParameter("reportId");
        Env.set(Env.Key.easCtx, easCtx);
        Env.set(Env.Key.pubAcctId, pubAcctId);
        if (rptId != null) {
            boolean isHyperlink = false;
            if (ExtMobileJSONUtils.isJson(rptId)) {
                isHyperlink = true;
                rptId = ExtMobileJSONUtils.parseRptIdFromJson(easCtx, rptId);
            }
            Env.set(Env.Key.rptId, rptId);
            Env.set(Env.Key.webParamAdapter, new WebParamAdapter(easCtx, rptId, false));
            Env.set(Env.Key.isHyperlink, isHyperlink);
        }
        Env.set(Env.Key.snapshotTag, request.getParameter("snapshotTag"));
    }

    private static Context loginImpl(String openId, String email, String userName, String userPsw) throws Exception {
        UserInfo user = LoginHelper.getUser(openId, email, userName, userPsw);
        if (user == null) {
            throw ExtRptBizException.newLoginCtxException((Throwable)new NullPointerException("empty user info"));
        }
        return LoginHelper.loginEAS(user);
    }

    private static UserInfo getUser(String openId, String email, String userName, String userPsw) throws Exception {
        UserInfo user = LoginHelper.getUserByEmail(email);
        if (user == null) {
            user = LoginHelper.getUserByXtId(openId);
        }
        if (user == null) {
            user = LoginHelper.getUserByUserName(userName, userPsw);
        }
        return user;
    }

    private static String decodeUserPsw(String urlSafeBase64Psw) throws IOException {
        if (StringUtil.isEmptyString((String)urlSafeBase64Psw)) {
            return "";
        }
        String urlNotSafeBase64Psw = urlSafeBase64Psw.replaceAll("-", "+").replaceAll("_", "/");
        int sufix = urlNotSafeBase64Psw.length() % 4;
        if (sufix != 0) {
            sufix = 4 - sufix;
        }
        for (int i = 0; i < sufix; ++i) {
            urlNotSafeBase64Psw = urlNotSafeBase64Psw + "=";
        }
        return new String(new BASE64Decoder().decodeBuffer(urlNotSafeBase64Psw));
    }

    public static UserInfo getUserByUserName(String userName, String userPsw) throws ExtRptBizException {
        if (StringUtil.isEmptyString((String)userName) || StringUtil.isEmptyString((String)userName.trim())) {
            return null;
        }
        try {
            userPsw = LoginHelper.decodeUserPsw(userPsw);
        }
        catch (IOException e) {
            throw ExtRptBizException.newLoginCtxException((Throwable)e);
        }
        String sql = "select FID,FNAME_L2,FNumber,FPassword from t_pm_user where FNumber=?";
        UserInfo user = null;
        String psw = null;
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)LoginHelper.ctx(), (String)sql, (Object[])new Object[]{userName});
            if (dataSet.next()) {
                user = new UserInfo();
                BOSUuid bosUuid = BOSUuid.read((String)dataSet.getString("FID"));
                user.setId(bosUuid);
                user.setName(dataSet.getString("FNAME_L2"));
                user.setNumber(dataSet.getString("FNumber"));
                userPsw = !StringUtil.isEmptyString((String)userPsw) ? PermissionUtil.encrypt((String)bosUuid.toString(), (String)userPsw) : "";
                psw = dataSet.getString("FPassword");
            }
            if (dataSet.next()) {
                logger.error((Object)"----------------ext mobile auto login module warning----------------");
                logger.error((Object)("----------------multiple users binding current resource[userName]:" + userName + "----------------"));
            }
        }
        catch (Throwable e) {
            logger.error((Object)"-------------getUserByUserName--------------", e);
            throw ExtRptBizException.newLoginCtxException((Throwable)e);
        }
        if (psw == null) {
            psw = "";
        }
        if (!StringUtil.equals((String)userPsw, (String)psw.trim())) {
            throw ExtRptBizException.newLoginCtxException((Throwable)new IllegalArgumentException("invalid password"));
        }
        return user;
    }

    private static UserInfo getUserByXtId(String openId) {
        if (StringUtil.isEmptyString((String)openId) || StringUtil.isEmptyString((String)openId.trim())) {
            return null;
        }
        String sql = "select us.FID,us.FNAME_L2,us.FNumber from t_pm_user us,T_PM_easxtusermap xt  where xt.fxtId=? and xt.fuserId=us.fid and us.fisdelete = 0";
        try {
            return LoginHelper.fillUserInfo(DbUtil.executeQuery((Context)LoginHelper.ctx(), (String)sql, (Object[])new Object[]{openId}), "openId", openId);
        }
        catch (Throwable e) {
            logger.error((Object)"-------------getUserByXtId--------------", e);
            return null;
        }
    }

    private static UserInfo getUserByEmail(String email) {
        if (StringUtil.isEmptyString((String)email) || StringUtil.isEmptyString((String)email.trim())) {
            return null;
        }
        String sql = "select FID,FNAME_L2,FNumber from t_pm_user where fisdelete='0' and fislocked='0' and fforbidden='0' and femail=?";
        try {
            return LoginHelper.fillUserInfo(DbUtil.executeQuery((Context)LoginHelper.ctx(), (String)sql, (Object[])new Object[]{email}), "email", email);
        }
        catch (Throwable e) {
            logger.error((Object)"-------------getUserByEmail--------------", e);
            return null;
        }
    }

    private static UserInfo fillUserInfo(IRowSet dataSet, String resourceName, String resource) throws SQLException {
        UserInfo user = null;
        if (dataSet.next()) {
            user = new UserInfo();
            user.setId(BOSUuid.read((String)dataSet.getString("FID")));
            user.setName(dataSet.getString("FNAME_L2"));
            user.setNumber(dataSet.getString("FNumber"));
        }
        if (dataSet.next()) {
            logger.error((Object)"----------------ext mobile auto login module warning----------------");
            logger.error((Object)("----------------multiple users binding current resource[" + resourceName + "]:" + resource + "----------------"));
        }
        return user;
    }

    private static void switchForLogin(Context ctx) throws EASBizException, BOSException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FullOrgUnitInfo defOrgUnit = currentUserInfo.getDefOrgUnit();
        if (defOrgUnit == null) {
            return;
        }
        String ouId = defOrgUnit.getId().toString();
        OrgTypeRegister.getInstance().initOrgTypeMgrExt();
        HashMap map = (HashMap)ctx.get((Object)"OrgUnits");
        if (map == null) {
            map = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).getOrgs(ouId);
        }
        LoginHelper.updateSysContext(map, ctx);
    }

    private static void updateSysContext(HashMap<?, ?> map, Context ctx) {
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)orgTypeList.get(i);
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get(curOrgType);
            if (orgUnitInfo == null) continue;
            ContextUtil.setCurrentOrgUnit((Context)ctx, (OrgType)curOrgType, (OrgUnitInfo)orgUnitInfo);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        ContextUtil.setCurrentOrgUnit((Context)ctx, (OrgUnitInfo)ouInfo);
        OrgUnitInfo fiInfo = (OrgUnitInfo)map.get(OrgType.Company);
        if (fiInfo != null) {
            ctx.put((Object)"CompanyInfo", (Object)fiInfo);
            ctx.put((Object)"CurCompanyId", (Object)fiInfo.getId().toString());
        }
        if (CacheConfigManager.getConfig() == null) {
            return;
        }
        CacheServiceFactory.getInstance().discardAll();
    }

    private static Context ctx() {
        logger.error((Object)("Login DbCode:" + Config.getDbCode()));
        return new Context(null, "eas", Config.getDbCode(), new Locale("l2"));
    }

    private static Context loginEAS(UserInfo user) throws Exception {
        String userName = user.getNumber();
        String authType = "BaseTrdLtpaToken";
        LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
        String authPassword = token.getTokenStr();
        String encodePwd = CryptoTean.encrypt((String)userName, (String)authPassword);
        Locale locale = new Locale(Config.getLocale());
        String clientIP = "UNKNOW";
        LoginContext loginCtx = new LoginContext(userName, encodePwd, Config.getSlnName(), Config.getDbCode(), locale, clientIP, clientIP);
        loginCtx.put("UserAuthPattern", (Object)authType);
        loginCtx.put("dbTypeCode", (Object)Config.getDbType());
        loginCtx.put("dbType", (Object)DbType.getName((int)Config.getDbType()));
        loginCtx.put("ClientIP", (Object)clientIP);
        loginCtx.setLoginType(LoginType.MOBILE);
        String contextID = (String)loginCtx.get("contextID");
        if (contextID != null) {
            loginCtx.setContextID(contextID);
        }
        Context userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
        loginCtx.setContextID(userContext.getContextID());
        WebContextUtil.initRpcConfig((Context)userContext);
        return LoginModuleFactory.getRemoteInstance().fullLogin(loginCtx);
    }

    private static class Config {
        private static boolean isNew = false;
        private static Object provider;
        private static String[] clazzs;

        private Config() {
        }

        static String getDbCode() {
            if (isNew) {
                return (String)Config.access("getDbCode");
            }
            return (String)Config.access("getDcCode");
        }

        static String getLocale() {
            return (String)Config.access("getLocale");
        }

        static String getSlnName() {
            return (String)Config.access("getSlnName");
        }

        static int getDbType() {
            return (Integer)Config.access("getDbType");
        }

        static Object access(String method) {
            try {
                if (isNew) {
                    String eid = (String)Env.get(Env.Key.eid);
                    return provider.getClass().getMethod(method, String.class).invoke(provider, eid);
                }
                return provider.getClass().getMethod(method, new Class[0]).invoke(provider, new Object[0]);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        static {
            for (String clazz : clazzs = new String[]{"com.kingdee.lightapp.xt.util.MobileConfig", "com.kingdee.lightapp.xt.XTServiceConfig"}) {
                try {
                    provider = Class.forName(clazz).getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable ex) {
                    logger.error((Object)ex);
                }
                if (provider != null) break;
                isNew = true;
            }
            if (provider == null) {
                throw new RuntimeException("no XTConfig Provider");
            }
        }
    }
}

