/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.rpt.snapshot;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.ext.web.common.IResourceMethodHandler;
import com.kingdee.eas.mobileaccess.ext.web.lisence.ExtLightRptLisenceScavenger;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightFilterHandler;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightReportContentHandler;
import com.kingdee.eas.mobileaccess.ext.web.rpt.snapshot.ExtLightSnapshotParamValueHandler;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.MobileSnapshotDAO;
import com.kingdee.eas.rpts.web.man.MobileReportImpl;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ExtLightSnapshotContentHandler
implements IResourceMethodHandler {
    private static Logger logger = Logger.getLogger(ExtLightSnapshotContentHandler.class);

    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        ExtLightRptLisenceScavenger.checkModuleLisence(easCtx);
        String snapshotTag = (String)Env.get(Env.Key.snapshotTag);
        String rptId = (String)Env.get(Env.Key.rptId);
        WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
        MobileReportImpl snapshot = MobileReportImpl.createSnapshotImpl((Context)easCtx, (String)rptId, (String)snapshotTag);
        snapshot.setContext(easCtx);
        snapshot.setCurrentSheetName(snapshot.getBook().getActiveSheet().getSheetName());
        BeanFactory.makeupReportModelBhv().behaviour((ReportImpl)snapshot);
        ReportInfo info = BeanFactory.outputReportBhv().behaviour((ReportImpl)snapshot);
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            if (DefineReportBO.getReportInfo((Context)easCtx, (String)rptId) == null) {
                data.put("hasFilter", false);
            } else {
                data.put("hasFilter", !ExtLightReportContentHandler.loadDefault().isEmpty());
            }
        }
        catch (Exception e) {
            throw ExtRptBizException.newSnapshotFilterVisitException((Throwable)e);
        }
        String sfilter = MobileSnapshotDAO.fetchSnapFilterValues((Context)easCtx, (String)snapshotTag);
        if (sfilter != null) {
            ArrayList mobileCommParams;
            Element root = ExtLightSnapshotParamValueHandler.parse(sfilter);
            data.put("org", this.loadOrg(root));
            data.put("values", ExtLightSnapshotParamValueHandler.loadParams(root.getChildren()));
            data.put("filter", ExtLightFilterHandler.loadFilter(easCtx, rptId));
            data.put("firstPlaceHolder", adapter.getFirstPlaceHolder());
            data.put("lastPlaceholder", adapter.getLastPlaceHolder());
            data.put("isUseLastSaveParam", adapter.isUseLastSaveParam());
            boolean bFilter = false;
            boolean isAllCommonParam = false;
            try {
                bFilter = !adapter.mobileEmptyFilter();
                mobileCommParams = adapter.mobileCommParams(easCtx, adapter, rptId);
                isAllCommonParam = adapter.isAllCommonParam(mobileCommParams);
            }
            catch (Exception e) {
                throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
            }
            data.put("commonParams", mobileCommParams);
            data.put("isAllCommonParams", isAllCommonParam);
        } else {
            logger.warn((Object)("---------can not load snapshot filter data rptId:" + rptId + ",snapTag:" + snapshotTag + "---------"));
        }
        data.put("reportContent", info);
        DefineReportInfo reportInfo = null;
        try {
            reportInfo = DefineReportBO.getReportInfo((Context)easCtx, (String)rptId);
            if (reportInfo != null) {
                boolean isAccreditedValue = PermissionBO.hasDataPermissionByReportId((Context)easCtx, (String)ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString(), (String)ContextUtil.getCurrentOrgUnit((Context)easCtx).getId().toString(), (String)rptId, (PermissionKind)PermissionKind.VIEW);
                data.put("cloudRptId", reportInfo.getCloudRptCenterId());
                data.put("isAccredited", isAccreditedValue);
                data.put("isTemplateModified", reportInfo.getCloudRptVersion() == 0);
            } else {
                data.put("cloudRptId", "");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            data.put("cloudRptId", "");
        }
        logger.info((Object)("hasFilter\uff1a" + data.get("hasFilter")));
        ExtLightRptLisenceScavenger.requestLisence(easCtx, rptId);
        return new MobileResult(data);
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return null;
    }

    private Map<String, Object> loadOrg(Element root) {
        TreeMap<String, Object> orgItem = new TreeMap<String, Object>();
        orgItem.put("value", root.getAttributeValue("value"));
        orgItem.put("text", root.getAttributeValue("text"));
        return orgItem;
    }
}

