/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.mobileaccess.ext.web.common.IResourceMethodHandler;
import com.kingdee.eas.mobileaccess.ext.web.lisence.ExtLightRptLisenceScavenger;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.mobileaccess.ext.web.util.ExtMobileRptPermissionChecker;
import com.kingdee.eas.mobileaccess.ext.web.util.OrgSwitchHelper;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.web.man.MobileReportImpl;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class ExtLightReportContentHandler
implements IResourceMethodHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        String currentOrgId = ((OrgUnitInfo)easCtx.get((Object)"CurOU")).getId().toString();
        try {
            OrgSwitchHelper.switchOrg(easCtx, args[0]);
            boolean isHyperlink = (Boolean)Env.get(Env.Key.isHyperlink);
            String rptId = (String)Env.get(Env.Key.rptId);
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            adapter.parseOutParam(args[3]);
            MobileResult mobileResult = ExtLightReportContentHandler.executeRpt(isHyperlink, easCtx, rptId, ExtLightReportContentHandler.parseParams(easCtx, rptId, args[2]));
            return mobileResult;
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
        }
        finally {
            OrgSwitchHelper.switchOrg(easCtx, currentOrgId);
        }
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter("orgId"), request.getParameter("reportId"), request.getParameter("paramValues"), request.getParameter("extOutParam")};
    }

    static MobileResult executeHyperlinkRpt(Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        return ExtLightReportContentHandler.executeRpt(true, easCtx, rptId, params);
    }

    static MobileResult executeRpt(Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        return ExtLightReportContentHandler.executeRpt(false, easCtx, rptId, params);
    }

    protected static MobileResult executeRpt(boolean isHyperlink, Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        try {
            MobileReportImpl template = MobileReportImpl.createTemplateImpl((Context)easCtx, (String)rptId);
            template.setContext(easCtx);
            Book book = ExtLightReportContentHandler.getExecutedBook(isHyperlink, easCtx, rptId, params);
            template.setBook(book);
            String curSheetName = book.getActiveSheet().getSheetName();
            template.setCurrentSheetName(curSheetName);
            BeanFactory.makeupReportModelBhv().behaviour((ReportImpl)template);
            ReportInfo data = BeanFactory.outputReportBhv().behaviour((ReportImpl)template);
            ExtLightRptLisenceScavenger.requestLisence(easCtx, rptId);
            return new MobileResult(data);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptExecuteException((Throwable)e);
        }
    }

    protected static Book getExecutedBook(boolean isHyperlink, Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws IOException, KDFException, KDFSAXException, Exception {
        boolean isRawCloudRpt;
        WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
        easCtx.put((Object)"deployType", (Object)9);
        if (adapter.getBook().getCloudRptUuid() != null && !CloudRptCenterControllerFacade.isCloudRptCenterEnable((Context)easCtx)) {
            throw ExtRptBizException.newFailed2CloudRptCenterEnable(null);
        }
        boolean bl = isRawCloudRpt = adapter.getBook().getCloudRptUuid() != null && adapter.getBook().getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
        if (!isHyperlink && !isRawCloudRpt) {
            ExtMobileRptPermissionChecker.checkMobileRptPermission(easCtx, rptId, ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString());
        }
        adapter.executeBook(params);
        return adapter.getBook();
    }

    protected static HashMap<String, DesignParameter> parseJSONParams(Context easCtx, String rptId, String oJson) throws ExtRptBizException {
        HashMap<String, DesignParameter> ret = new HashMap<String, DesignParameter>();
        try {
            JSONArray json = new JSONArray(oJson);
            HashMap<String, DesignParameter> params = ExtLightReportContentHandler.loadDefault();
            int len = json.length();
            for (int i = 0; i < len; ++i) {
                JSONObject param = (JSONObject)json.get(i);
                String name = (String)param.get("paramName");
                JSONArray values = (JSONArray)param.get("paramValues");
                DesignParameter dp = params.remove(name);
                if (dp == null) {
                    dp = new DesignParameter();
                    dp.setDesignDataType(DesignDataType.TXT);
                    dp.setDataType(DataType.STRING);
                    dp.setName(name);
                }
                String currentValue = "";
                if (values != null) {
                    for (int j = 0; j < values.length(); ++j) {
                        currentValue = currentValue + values.getString(j);
                        if (j == values.length() - 1) break;
                        currentValue = currentValue + "0xx1xx";
                    }
                }
                dp.setCurentValue(currentValue);
                ExtLightReportContentHandler.exeMacroValues(easCtx, dp, ret);
                ret.put(name, dp);
            }
            ExtLightReportContentHandler.setCurrentValueEmpty(ret, params);
            return ret;
        }
        catch (Exception e) {
            throw ExtRptBizException.newParamJsonParseException((Throwable)e);
        }
    }

    static HashMap<String, DesignParameter> parseParams(Context easCtx, String rptId, String oJson) throws ExtRptBizException {
        HashMap<String, DesignParameter> ret = new HashMap<String, DesignParameter>();
        RunReportParam.putServerDefalutListParamsMap((Context)easCtx, ret);
        if (StringUtil.isEmptyString((String)oJson)) {
            ArrayList params;
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            try {
                params = adapter.mobileFetchParams();
            }
            catch (Throwable e) {
                throw ExtRptBizException.newParamJsonParseException((Throwable)e);
            }
            if (params != null) {
                for (Object obj : params) {
                    DesignParameter dp = (DesignParameter)obj;
                    dp.setCurentValue(dp.getCurentValue());
                    dp.setCurentValueAlias(dp.getCurentValueAlias());
                    dp.setDefaultValue(dp.getDefaultValue());
                    dp.setDefaultAlias(dp.getDefaultAlias());
                    ret.put(dp.getName(), dp);
                    DesignParameter dp_text = new DesignParameter();
                    dp_text.setDesignDataType(DesignDataType.TXT);
                    dp_text.setName(dp.getName() + "_text");
                    dp_text.setDataType(DataType.STRING);
                    dp_text.setCurentValue(dp.getCurentValueAlias());
                    dp_text.setCurentValueAlias(dp.getCurentValueAlias());
                    dp_text.setDefaultValue(dp.getDefaultValue());
                    dp_text.setDefaultAlias(dp.getDefaultAlias());
                    dp_text.setIgnoreNull(dp.isIgnoreNull());
                    ret.put(dp_text.getName(), dp_text);
                }
            }
        } else {
            ret.putAll(ExtLightReportContentHandler.parseJSONParams(easCtx, rptId, oJson));
        }
        return ret;
    }

    public static void exeMacroValues(Context easCtx, DesignParameter dp, HashMap<String, DesignParameter> sysParams) {
        String value = dp.getCurentValue();
        DesignDataType ddt = dp.getDesignDataType();
        if (DesignDataType.DATE.equals(ddt)) {
            value = RunReportParam.getDateValue((Context)easCtx, (DesignDataType)ddt, (String)value);
        }
        if (value != null && value.startsWith("@ExtRpt")) {
            value = sysParams.get(value.substring(1)).getCurentValue();
        }
        dp.setCurentValue(value);
    }

    public static HashMap<String, DesignParameter> loadDefault() throws Exception {
        HashMap<String, DesignParameter> params = new HashMap<String, DesignParameter>();
        WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
        for (Object obj : adapter.mobileFetchParams()) {
            DesignParameter dp = (DesignParameter)obj;
            params.put(dp.getName(), dp);
        }
        return params;
    }

    public static void setCurrentValueEmpty(HashMap<String, DesignParameter> ret, HashMap<String, DesignParameter> defaultParams) {
        if (!defaultParams.isEmpty()) {
            for (String name : defaultParams.keySet()) {
                DesignParameter dp = defaultParams.get(name);
                dp.setCurentValue("");
                dp.setCurentValueAlias("");
                ret.put(name, dp);
                DesignParameter dp_text = new DesignParameter();
                dp_text.setDesignDataType(DesignDataType.TXT);
                dp_text.setName(dp.getName() + "_text");
                dp_text.setDataType(DataType.STRING);
                dp_text.setCurentValue("");
                dp_text.setCurentValueAlias("");
                dp_text.setIgnoreNull(dp.isIgnoreNull());
                ret.put(dp_text.getName(), dp_text);
            }
        }
    }
}

