/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.mobileaccess.ext.web.common.IResourceMethodHandler;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.mobileaccess.ext.web.util.ExtMobileRptPermissionChecker;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.util.ExtRptContentChecker;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.ReportPermissonUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ExtLightOrgsForReportHandler
implements IResourceMethodHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        String rptId = (String)Env.get(Env.Key.rptId);
        return ExtLightOrgsForReportHandler.listOrgs(easCtx, rptId, null);
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter("reportId")};
    }

    static MobileResult listOrgs(Context easCtx, String rptId, Map<String, Object> reportItem) throws ExtRptBizException {
        ArrayList<HashMap> orgs;
        Map<String, Map<String, HashMap<String, Boolean>>> executeValue = new HashMap();
        Map<String, HashMap<String, Boolean>> cacheReportItem = new HashMap();
        ArrayList orgList = new ArrayList();
        boolean forTest = reportItem != null;
        HashMap<Boolean, Map<String, Map<String, HashMap<String, Boolean>>>> listOrgs = (HashMap<Boolean, Map<String, Map<String, HashMap<String, Boolean>>>>)Env.get(Env.Key.listOrgs);
        if (listOrgs == null) {
            listOrgs = new HashMap<Boolean, Map<String, Map<String, HashMap<String, Boolean>>>>();
            Env.set(Env.Key.listOrgs, listOrgs);
        }
        if (listOrgs.containsKey(forTest)) {
            executeValue = (Map)listOrgs.get(forTest);
            cacheReportItem = (Map)executeValue.get("reportItem");
            orgList = (ArrayList)executeValue.get("list");
            if (reportItem != null) {
                reportItem.putAll(cacheReportItem);
            }
            return new MobileResult(orgList);
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rptId);
        queryValue.add(userId);
        try {
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            adapter.getReportParamXmlString(false);
            if (!adapter.getBook().is4Mobile()) {
                ExtMobileRptPermissionChecker.checkMobileRptPermission(easCtx, rptId, userId);
            }
            ArrayList sourceParams = adapter.mobileFetchParams();
            HashMap<String, DesignParameter> hashMap = new HashMap<String, DesignParameter>();
            for (Object obj : sourceParams) {
                DesignParameter dp = (DesignParameter)obj;
                hashMap.put(dp.getName(), dp);
            }
            if (!forTest || ExtRptContentChecker.needMoreCopy((Context)easCtx, hashMap, (Book)adapter.getBook(), (boolean)false)[1]) {
                List perms = ReportPermissonUtil.getUserOrgPermedByReportId((Context)easCtx, (String)rptId, (String)userId);
                orgs = perms.size() > 0 ? (ArrayList<HashMap>)((HashMap)perms.get(0)).get("orgids") : null;
                if (orgs == null || orgs.isEmpty()) {
                    orgs = new ArrayList<HashMap>();
                    ArrayList orgRange = OrgRangeManage.getOrgRangeDataList((Context)easCtx, (String)userId);
                    if (orgRange != null) {
                        for (HashMap org : orgRange) {
                            orgs.add(org);
                        }
                    }
                }
            } else {
                orgs = new ArrayList<HashMap>(0);
            }
        }
        catch (Throwable e) {
            throw ExtRptBizException.newOrgListSQLExecuteException((Throwable)e);
        }
        HashMap e = new HashMap();
        if (orgs != null && !orgs.isEmpty()) {
            if (forTest) {
                e.put("id", ((Map)orgs.get(0)).get("id"));
                e.put("name", ((Map)orgs.get(0)).get("name"));
                cacheReportItem.put("currentOrg", e);
                if (orgs.size() >= 2) {
                    cacheReportItem.put("moreOrgs", (HashMap<String, Boolean>)true);
                } else {
                    cacheReportItem.put("moreOrgs", (HashMap<String, Boolean>)false);
                }
            } else {
                for (Map map : orgs) {
                    e.put("id", map.get("id"));
                    e.put("name", map.get("name"));
                    orgList.add(e);
                    e = new HashMap();
                }
            }
        } else {
            OrgUnitInfo info = ContextUtil.getCurrentOrgUnit((Context)easCtx);
            e.put("id", info.getId().toString());
            e.put("name", info.getName());
            if (forTest) {
                cacheReportItem.put("currentOrg", e);
                cacheReportItem.put("moreOrgs", (HashMap<String, Boolean>)false);
            } else {
                orgList.add(e);
            }
        }
        if (forTest) {
            reportItem.putAll(cacheReportItem);
        }
        executeValue.put("reportItem", cacheReportItem);
        executeValue.put("list", (Map<String, HashMap<String, Boolean>>)((Object)orgList));
        listOrgs.put(forTest, executeValue);
        Env.set(Env.Key.listOrgs, listOrgs);
        return new MobileResult(orgList);
    }
}

