/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.mobileaccess.ext.web.common.IResourceMethodHandler;
import com.kingdee.eas.mobileaccess.ext.web.lisence.ExtLightRptLisenceScavenger;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightFilterHandler;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightOrgsForReportHandler;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightReportContentHandler;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.mobileaccess.ext.web.util.OrgSwitchHelper;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ExtLightExecuteHandler
implements IResourceMethodHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        ExtLightRptLisenceScavenger.checkModuleLisence(easCtx);
        String currentOrgId = ((OrgUnitInfo)easCtx.get((Object)"CurOU")).getId().toString();
        try {
            String rptId = (String)Env.get(Env.Key.rptId);
            if (!StringUtil.isEmptyString((String)args[0])) {
                OrgSwitchHelper.switchOrg(easCtx, args[0]);
            } else {
                HashMap<String, Object> reportItem = new HashMap<String, Object>();
                ExtLightOrgsForReportHandler.listOrgs(easCtx, rptId, reportItem);
                OrgSwitchHelper.switchOrg(easCtx, (String)((Map)reportItem.get("currentOrg")).get("id"));
            }
            MobileResult mobileResult = ExtLightExecuteHandler.directlyExecute(easCtx, rptId, args[1], args[2]);
            return mobileResult;
        }
        finally {
            OrgSwitchHelper.switchOrg(easCtx, currentOrgId);
        }
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter("orgId"), request.getParameter("paramValues"), request.getParameter("extOutParam")};
    }

    private static MobileResult directlyExecute(Context easCtx, String rptId, String filterJson, String extOutParams) throws ExtRptBizException {
        try {
            DesignParameter dp;
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            adapter.parseOutParam(extOutParams);
            HashMap<String, Object> data = new HashMap<String, Object>();
            HashMap<Object, Object> params = StringUtil.isEmptyString((String)filterJson) ? new HashMap() : ExtLightReportContentHandler.parseJSONParams(easCtx, rptId, filterJson);
            boolean isHyperlink = (Boolean)Env.get(Env.Key.isHyperlink);
            if (isHyperlink) {
                return ExtLightExecuteHandler.hyperlinkTransition(easCtx, rptId, params);
            }
            ArrayList sourceParams = adapter.mobileFetchParams();
            for (Object obj : sourceParams) {
                ArrayList mobileCommParams;
                dp = (DesignParameter)obj;
                if (InputType.LABEL == dp.getInputType() || 2 == dp.getInputState().intValue() || dp.isAllowNull() || params.containsKey(dp.getName()) || dp.getDefaultValue() != null) continue;
                ExtLightExecuteHandler.addCtxOrg(easCtx, data, rptId, false);
                boolean isAllCommonParam = false;
                try {
                    mobileCommParams = adapter.mobileCommParams(easCtx, adapter, rptId);
                    isAllCommonParam = adapter.isAllCommonParam(mobileCommParams);
                }
                catch (Exception e) {
                    throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
                }
                if (adapter.getBook().getCloudRptUuid() != null) {
                    data.put("cloudRptId", adapter.getBook().getCloudRptUuid());
                    data.put("isModifiedTemplate", adapter.getBook().getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") == null);
                    data.put("isAccredited", PermissionBO.hasDataPermissionByReportId((Context)easCtx, (String)ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString(), (String)ContextUtil.getCurrentOrgUnit((Context)easCtx).getId().toString(), (String)rptId, (PermissionKind)PermissionKind.VIEW));
                }
                data.put("firstPlaceHolder", adapter.getFirstPlaceHolder());
                data.put("lastPlaceholder", adapter.getLastPlaceHolder());
                data.put("isUseLastSaveParam", adapter.isUseLastSaveParam());
                data.put("commonParams", mobileCommParams);
                data.put("isAllCommonParams", isAllCommonParam);
                data.put("hasFilter", true);
                data.put("isRequiredEmpty", true);
                data.put("filter", ExtLightFilterHandler.loadFilter(easCtx, rptId));
                return new MobileResult(data);
            }
            for (Object obj : sourceParams) {
                dp = (DesignParameter)obj;
                if (InputType.ALONE_CHECKBOX.equals(dp.getInputType())) {
                    DefObj def;
                    IInputCtrl ctrl = dp.getInputCtrl();
                    if ("1".equals(dp.getDefaultValue())) {
                        def = ctrl.getDefValue();
                        dp.setDefaultValue(def.getName());
                        dp.setDefaultAlias(def.getAlias());
                    } else {
                        def = ctrl.getDefDisplay();
                        dp.setDefaultValue(def.getName());
                        dp.setDefaultAlias(def.getAlias());
                    }
                }
                if (!params.containsKey(dp.getName())) {
                    dp.setCurentValue(dp.getDefaultValue());
                    dp.setCurentValueAlias(dp.getDefaultAlias());
                    params.put(dp.getName(), dp);
                }
                if (params.containsKey(dp.getName() + "_text")) continue;
                DesignParameter dp_text = new DesignParameter();
                dp_text.setDataType(DataType.STRING);
                dp_text.setDesignDataType(DesignDataType.TXT);
                dp_text.setName(dp.getName() + "_text");
                dp_text.setCurentValue(dp.getCurentValueAlias());
                dp_text.setIgnoreNull(dp.isIgnoreNull());
                params.put(dp_text.getName(), dp_text);
            }
            RunReportParam.putServerDefalutListParamsMap((Context)easCtx, params);
            return ExtLightExecuteHandler.execute(easCtx, rptId, params, adapter, false);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptExecuteException((Throwable)e);
        }
    }

    private static MobileResult hyperlinkTransition(Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        RunReportParam.putServerDefalutListParamsMap((Context)easCtx, params);
        WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
        return ExtLightExecuteHandler.execute(easCtx, rptId, params, adapter, true);
    }

    private static MobileResult execute(Context easCtx, String rptId, HashMap<String, DesignParameter> params, WebParamAdapter adapter, boolean isHyperlink) throws ExtRptBizException {
        ArrayList mobileCommParams;
        boolean bFilter = false;
        boolean isAllCommonParam = false;
        try {
            bFilter = !adapter.mobileEmptyFilter();
            mobileCommParams = adapter.mobileCommParams(easCtx, adapter, rptId);
            isAllCommonParam = adapter.isAllCommonParam(mobileCommParams);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (adapter.getBook().getCloudRptUuid() != null) {
            data.put("cloudRptId", adapter.getBook().getCloudRptUuid());
            data.put("isModifiedTemplate", adapter.getBook().getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") == null);
            data.put("isAccredited", PermissionBO.hasDataPermissionByReportId((Context)easCtx, (String)ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString(), (String)ContextUtil.getCurrentOrgUnit((Context)easCtx).getId().toString(), (String)rptId, (PermissionKind)PermissionKind.VIEW));
        }
        data.put("hasFilter", bFilter);
        data.put("commonParams", mobileCommParams);
        data.put("isAllCommonParams", isAllCommonParam);
        data.put("firstPlaceHolder", adapter.getFirstPlaceHolder());
        data.put("lastPlaceholder", adapter.getLastPlaceHolder());
        data.put("isUseLastSaveParam", adapter.isUseLastSaveParam());
        data.put("isRequiredEmpty", false);
        Object info = null;
        info = isHyperlink ? ExtLightReportContentHandler.executeHyperlinkRpt(easCtx, rptId, params).getData() : ExtLightReportContentHandler.executeRpt(easCtx, rptId, params).getData();
        data.put("reportContent", info);
        ExtLightExecuteHandler.addCtxOrg(easCtx, data, rptId, isHyperlink);
        data.put("filter", ExtLightFilterHandler.loadFilter(easCtx, rptId));
        return new MobileResult(data);
    }

    private static void addCtxOrg(Context easCtx, HashMap<String, Object> data, String rptId, boolean isHyperlink) throws ExtRptBizException {
        if (!isHyperlink) {
            ExtLightOrgsForReportHandler.listOrgs(easCtx, rptId, data);
        } else {
            data.put("moreOrgs", false);
        }
        HashMap<String, String> ctxOrg = new HashMap<String, String>();
        OrgUnitInfo org = ContextUtil.getCurrentOrgUnit((Context)easCtx);
        ctxOrg.put("id", org.getId().toString());
        ctxOrg.put("name", org.getName());
        data.put("currentOrg", ctxOrg);
    }
}

