/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.eas.mobileaccess.ext.web.common.IResourceMethodHandler;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;

public class ExtLightChartContentHandler
implements IResourceMethodHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        File file = new File(System.getProperty("java.io.tmpdir"), args[0]);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!file.exists()) {
            throw ExtRptBizException.newNonExistImgFileException();
        }
        try {
            String formatName = ImageUtils.getFormatName((String)file.getName());
            if (!StringUtil.isEmptyString((String)formatName) && "jpeg".equalsIgnoreCase(formatName)) {
                formatName = "png";
                BufferedImage bi = ImageIO.read(file);
                ImageIO.write((RenderedImage)bi, formatName, out);
                out.close();
            } else {
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int len = in.read(buffer);
                while (len > 0) {
                    out.write(buffer, 0, len);
                    len = in.read(buffer);
                }
                out.close();
                in.close();
            }
        }
        catch (Exception e) {
            throw ExtRptBizException.newFailed2LoadImgFileException((Throwable)e);
        }
        MobileResult result = new MobileResult(out.toByteArray());
        result.setDataType("application/octet-stream; charset=utf-8");
        return result;
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter("tmpFileName")};
    }
}

