/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.lisence;

import com.kingdee.bos.Context;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.EXTLicenseService;
import com.kingdee.eas.rpts.base.license.LicenseCheckerFactory;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExtLightRptLisenceScavenger {
    private static Logger logger = Logger.getLogger(ExtLightRptLisenceScavenger.class);
    private static long INTERVAL = 600000L;
    private static HashMap<String, Worker> userLisenceRecoder = new HashMap();
    private static ThreadGroup lisenceGroup = new ThreadGroup("ext mobile rpt lisence scavenger thread group");
    private static boolean isLisenceNeeded = false;

    public static void releaseAll() {
        lisenceGroup.interrupt();
        userLisenceRecoder.clear();
        lisenceGroup = new ThreadGroup("ext mobile rpt lisence scavenger thread group");
    }

    public static void requestLisence(Context easCtx, String rptUuid) throws ExtRptBizException {
        if (!isLisenceNeeded) {
            return;
        }
        String key = easCtx + "-" + rptUuid;
        if (!userLisenceRecoder.containsKey(key)) {
            try {
                LicenseCheckerFactory.getLicenseChecker((DefineReportInfo)DefineReportBO.getReportInfo((Context)easCtx, (String)rptUuid), (Context)easCtx).checkLicense();
            }
            catch (Exception e) {
                if (e instanceof EXTLicenseException) {
                    throw ExtRptBizException.newLisenceShortageException((Throwable)e);
                }
                throw ExtRptBizException.newLisenceCheckException((Throwable)e);
            }
            Worker worker = new Worker(easCtx, rptUuid);
            userLisenceRecoder.put(key, worker);
            worker.start();
        } else {
            Worker worker = userLisenceRecoder.get(key);
            worker.lastAccess = new Date().getTime();
        }
    }

    public static void checkModuleLisence(Context easCtx) throws ExtRptBizException {
        if (ExtLightRptLisenceScavenger.isDateValid()) {
            return;
        }
        try {
            if (!new EXTLicenseService(easCtx).sysLicenseContain("BOS_RPTC_MOBILE_STUDIO")) {
                throw ExtRptBizException.newLisenceShortageException((Throwable)new IllegalStateException("BOS_RPTC_MOBILE_STUDIO module needed"));
            }
        }
        catch (EXTLicenseException e) {
            throw ExtRptBizException.newLisenceCheckException((Throwable)e);
        }
    }

    private static boolean isDateValid() {
        return false;
    }

    private static class Worker
    extends Thread {
        private Context easCtx;
        private String rptUuid;
        private long lastAccess = new Date().getTime();

        private Worker(Context easCtx, String rptUuid) {
            super(lisenceGroup, "ext mobile rpt lisence scavenger worker thread");
            this.easCtx = easCtx;
            this.rptUuid = rptUuid;
        }

        private void releaseLisence() {
            try {
                LicenseCheckerFactory.getLicenseChecker((DefineReportInfo)DefineReportBO.getReportInfo((Context)this.easCtx, (String)this.rptUuid), (Context)this.easCtx).releaseLicense();
            }
            catch (Exception e) {
                logger.error((Object)"release extrpt lisence failed", (Throwable)e);
            }
        }

        @Override
        public void run() {
            long reserveTime = INTERVAL;
            while (reserveTime > 0L) {
                try {
                    Worker.sleep(INTERVAL - reserveTime);
                    reserveTime = INTERVAL - (new Date().getTime() - this.lastAccess);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            userLisenceRecoder.remove(this.easCtx + "-" + this.rptUuid);
            this.releaseLisence();
        }
    }
}

