/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.ExtMobileExecutor;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.kdf.table.KDFSAXException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobileaccess.ext.web.client.MobilePreviewUtil;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightReportContentHandler;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.model.CheckJavaDataSet;
import com.kingdee.eas.rpts.ctrlreport.model.CheckJavaDataSetException;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.industry.InnerParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.util.BosContextUtil;
import com.kingdee.eas.rpts.tobi.util.ExtSysContext;
import com.kingdee.eas.rpts.web.man.MobileReportImpl;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExtLightPreviewReportContentHandler
extends ExtLightReportContentHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        MobilePreviewUtil.switchOrg(args[0]);
        boolean isHyperlink = (Boolean)Env.get(Env.Key.isHyperlink);
        String rptId = (String)Env.get(Env.Key.rptId);
        return ExtLightPreviewReportContentHandler.executeRpt(isHyperlink, easCtx, rptId, ExtLightPreviewReportContentHandler.parseParams(easCtx, rptId, args[2]));
    }

    static MobileResult executeHyperlinkRpt(Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        return ExtLightPreviewReportContentHandler.executeRpt(true, easCtx, rptId, params);
    }

    static MobileResult executeRpt(Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        return ExtLightPreviewReportContentHandler.executeRpt(false, easCtx, rptId, params);
    }

    protected static MobileResult executeRpt(boolean isHyperlink, Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        SysContext sysContext = SysContext.getSysContext();
        try {
            MobileReportImpl template = MobileReportImpl.createTemplateImpl((Context)easCtx, (String)rptId);
            template.setContext(easCtx);
            Book book = ExtLightPreviewReportContentHandler.getExecutedBook(isHyperlink, easCtx, rptId, params);
            template.setBook(book);
            String curSheetName = book.getActiveSheet().getSheetName();
            template.setCurrentSheetName(curSheetName);
            BeanFactory.makeupReportModelBhv().behaviour((ReportImpl)template);
            String filePath = "/extweb/servlet/MobilePreviewServlet?remoteMethod=extLightChartContent&tmpFileName=";
            for (int i = book.getSheetCount() - 1; i >= 0; --i) {
                SheetImpl sheetImpl = template.getSheet(book.getSheetName(i));
                if (sheetImpl == null) continue;
                sheetImpl.setFilePrefixPath(filePath);
            }
            ReportInfo data = BeanFactory.outputReportBhv().behaviour((ReportImpl)template);
            BosContextUtil.setSysContext(null);
            MobileResult mobileResult = new MobileResult(data);
            return mobileResult;
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptExecuteException((Throwable)e);
        }
        finally {
            SysContext.setSysContext((SysContext)sysContext);
        }
    }

    protected static Book getExecutedBook(boolean isHyperlink, Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws IOException, KDFException, KDFSAXException, Exception {
        Book book = null;
        ExtMobileExecutor executor = null;
        Map<String, IParameter> fetchParams = ExtLightPreviewReportContentHandler.fetchSystemParameters(easCtx, params);
        if (isHyperlink) {
            DefineReportInfo info = DefineReportBO.getReportInfo(null, (String)rptId);
            if (info != null) {
                boolean isLimit = PublishType.isPublished((DefineReportInfo)info);
                executor = new ExtMobileExecutor(info.getContent(), (IExtRuntimeDataProvider)new ExtCallbackImpl(info, isLimit, false), isLimit);
            }
        } else {
            executor = MobilePreviewUtil.getMobileExecutor(rptId);
        }
        book = executor.getBook();
        if (book.getCloudRptUuid() != null && !CloudRptCenterControllerFacade.isCloudRptCenterEnable((Context)easCtx)) {
            throw ExtRptBizException.newFailed2CloudRptCenterEnable(null);
        }
        book.getDataSetManager().getExecutionContext().attachDataSetParameters((Map)ExtRptMacroExecuteFacade.fetchMacroParameters(null, (Book)book));
        ExtLightPreviewReportContentHandler.checkUIType(book, easCtx);
        SysContext.setSysContext((SysContext)ExtSysContext.getSysContext());
        executor.execute(true, fetchParams);
        return executor.getBook();
    }

    protected static HashMap<String, DesignParameter> parseJSONParams(Context easCtx, String rptId, String oJson) throws ExtRptBizException {
        HashMap<String, DesignParameter> ret = new HashMap<String, DesignParameter>();
        try {
            JSONArray json = new JSONArray(oJson);
            HashMap<String, DesignParameter> params = ExtLightPreviewReportContentHandler.loadDefault(easCtx, rptId);
            int len = json.length();
            for (int i = 0; i < len; ++i) {
                JSONObject param = (JSONObject)json.get(i);
                String name = (String)param.get("paramName");
                JSONArray values = (JSONArray)param.get("paramValues");
                DesignParameter dp = params.remove(name);
                if (dp == null) {
                    dp = new DesignParameter();
                    dp.setDesignDataType(DesignDataType.TXT);
                    dp.setDataType(DataType.STRING);
                    dp.setName(name);
                }
                String currentValue = "";
                if (values != null) {
                    for (int j = 0; j < values.length(); ++j) {
                        currentValue = currentValue + values.getString(j);
                        if (j == values.length() - 1) break;
                        currentValue = currentValue + "0xx1xx";
                    }
                }
                dp.setCurentValue(currentValue);
                ExtLightPreviewReportContentHandler.exeMacroValues(easCtx, dp, ret);
                ret.put(name, dp);
            }
            ExtLightPreviewReportContentHandler.setCurrentValueEmpty(ret, params);
            return ret;
        }
        catch (Exception e) {
            throw ExtRptBizException.newParamJsonParseException((Throwable)e);
        }
    }

    static HashMap<String, DesignParameter> parseParams(Context easCtx, String rptId, String oJson) throws ExtRptBizException {
        HashMap<String, DesignParameter> ret = new HashMap<String, DesignParameter>();
        InnerParam.putClientDefalutListParamsMapByMobilePreview(ret);
        if (StringUtil.isEmptyString((String)oJson)) {
            ArrayList params;
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            try {
                Book book = adapter.getBook();
                if (book == null) {
                    book = MobilePreviewUtil.getBook(rptId);
                    adapter.cacheUnionParam(book, easCtx);
                }
                params = adapter.mobileFetchParams();
            }
            catch (Throwable e) {
                throw ExtRptBizException.newParamJsonParseException((Throwable)e);
            }
            if (params != null) {
                for (Object obj : params) {
                    DesignParameter dp = (DesignParameter)obj;
                    dp.setCurentValue(dp.getCurentValue());
                    dp.setCurentValueAlias(dp.getCurentValueAlias());
                    dp.setDefaultValue(dp.getDefaultValue());
                    dp.setDefaultAlias(dp.getDefaultAlias());
                    ret.put(dp.getName(), dp);
                    DesignParameter dp_text = new DesignParameter();
                    dp_text.setDesignDataType(DesignDataType.TXT);
                    dp_text.setName(dp.getName() + "_text");
                    dp_text.setDataType(DataType.STRING);
                    dp_text.setCurentValue(dp.getCurentValueAlias());
                    dp_text.setCurentValueAlias(dp.getCurentValueAlias());
                    dp_text.setDefaultValue(dp.getDefaultValue());
                    dp_text.setDefaultAlias(dp.getDefaultAlias());
                    dp_text.setIgnoreNull(dp.isIgnoreNull());
                    ret.put(dp_text.getName(), dp_text);
                }
            }
        } else {
            ret.putAll(ExtLightPreviewReportContentHandler.parseJSONParams(easCtx, rptId, oJson));
        }
        return ret;
    }

    private static Map<String, IParameter> fetchSystemParameters(Context easCtx, HashMap<String, DesignParameter> params) {
        HashMap<String, IParameter> mapParameterImpl = new HashMap<String, IParameter>();
        for (String name : params.keySet()) {
            DesignParameter dp = params.get(name);
            ExtLightPreviewReportContentHandler.exeMacroValues(easCtx, dp, params);
            String value = dp.getCurentValue();
            String dataType = String.valueOf(dp.getDesignDataType().intValue());
            ParameterImpl p = new ParameterImpl();
            p.setName(name);
            p.setAlias(dp.getAlias());
            p.setValue(RunReportParam.getVariant((String)value, (int)Integer.parseInt(dataType)));
            p.setDataType(Integer.parseInt(dataType));
            p.setIgnoreNull(dp.isIgnoreNull());
            mapParameterImpl.put(name, (IParameter)p);
        }
        return mapParameterImpl;
    }

    public static HashMap<String, DesignParameter> loadDefault(Context easCtx, String rptId) throws Exception {
        HashMap<String, DesignParameter> params = new HashMap<String, DesignParameter>();
        WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
        Book book = adapter.getBook();
        if (book == null) {
            book = MobilePreviewUtil.getBook(rptId);
            adapter.cacheUnionParam(book, easCtx);
        }
        for (Object obj : adapter.mobileFetchParams()) {
            DesignParameter dp = (DesignParameter)obj;
            params.put(dp.getName(), dp);
        }
        return params;
    }

    private static boolean checkUIType(Book book, Context ctx) throws BOSException, CheckJavaDataSetException {
        if (!CheckJavaDataSet.checkUIType((Book)book, (Context)ctx)) {
            throw new CheckJavaDataSetException("\u62a5\u8868\u4e2d\u7684JAVA\u6570\u636e\u96c6\u4f7f\u7528\u4e86\u4ee3\u7801\u7f16\u5199\u7684\u53c2\u6570\u754c\u9762\uff0c\u4e0d\u80fd\u6267\u884c!");
        }
        return true;
    }
}

