/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.mobileaccess.ext.web.client.ExtLightPreviewFilterDelayDataHandler;
import com.kingdee.eas.mobileaccess.ext.web.client.MobilePreviewUtil;
import com.kingdee.eas.mobileaccess.ext.web.client.Node;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightFilterHandler;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.domain.WebReportDomain;
import com.kingdee.eas.rpts.web.filter.ReportParamDescription;
import com.kingdee.eas.rpts.web.filter.impl.ParamSuppliedValueDefineBySQL;
import com.kingdee.eas.rpts.web.vo.Entry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class ExtLightPreviewFilterHandler
extends ExtLightFilterHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        MobilePreviewUtil.switchOrg(args[1]);
        String rptId = (String)Env.get(Env.Key.rptId);
        return new MobileResult(ExtLightPreviewFilterHandler.loadFilter(easCtx, rptId));
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter("reportId"), request.getParameter("orgId")};
    }

    public static TreeMap<String, Object> loadFilter(Context easCtx, String rptId) throws ExtRptBizException {
        try {
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            Book book = adapter.getBook();
            if (book == null) {
                book = MobilePreviewUtil.getBook(rptId);
                adapter.cacheUnionParam(book, easCtx);
            }
            ArrayList sortdParams = adapter.mobileFetchSortedParams();
            List pDefines = WebReportDomain.translateParams((Context)easCtx, (List)sortdParams, (WebParamAdapter)adapter, (String)rptId);
            return ExtLightPreviewFilterHandler.analysis(easCtx, pDefines, rptId);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
        }
    }

    public static TreeMap<String, Object> analysis(Context easCtx, List<?> pDefines, String rptId) throws ExtRptBizException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        ArrayList<String> orgRefParams = new ArrayList<String>();
        TreeMap<String, List> paramRef = new TreeMap<String, List>();
        map.put("associateWithOrg", orgRefParams);
        map.put("associate", paramRef);
        for (Object obj : pDefines) {
            List relations;
            ReportParamDescription define = (ReportParamDescription)obj;
            String name = define.getName();
            if (define.isSuppliedValueOrgRelated()) {
                orgRefParams.add(name);
            }
            if ((relations = define.getRelations()) == null || relations.isEmpty()) continue;
            Iterator iter = relations.iterator();
            while (iter.hasNext()) {
                if (!name.equals(iter.next())) continue;
                iter.remove();
            }
            if (relations.isEmpty()) continue;
            paramRef.put(name, relations);
        }
        map.put("params", pDefines);
        if (pDefines != null) {
            for (Object obj : pDefines) {
                ReportParamDescription param = (ReportParamDescription)obj;
                Object defaultValue = param.getDefaultValue();
                if (defaultValue instanceof Date) {
                    param.setDefaultValue((Object)((Date)defaultValue).getTime());
                    continue;
                }
                ExtLightPreviewFilterHandler.defaultValueProcessor(easCtx, rptId, param);
            }
        }
        return map;
    }

    private static void defaultValueProcessor(Context easCtx, String rptId, ReportParamDescription<Object, ?> param) {
        int textIndex;
        HashMap jsonRowset;
        Object defaultValue = param.getDefaultValue();
        boolean defautValueIsList = defaultValue instanceof List;
        boolean defaultValueIsEntry = defaultValue instanceof Entry;
        if (!defautValueIsList && !defaultValueIsEntry) {
            return;
        }
        if (!(param.getSuppliedValueDescription() instanceof ParamSuppliedValueDefineBySQL)) {
            return;
        }
        ParamSuppliedValueDefineBySQL description = (ParamSuppliedValueDefineBySQL)param.getSuppliedValueDescription();
        try {
            jsonRowset = (HashMap)ExtLightPreviewFilterDelayDataHandler.gainSupplyValues(easCtx, description.getPersistenceModel(), rptId, null, param.getName()).getData();
        }
        catch (ExtRptBizException e) {
            jsonRowset = null;
        }
        if (jsonRowset == null) {
            return;
        }
        ArrayList rowsVO = (ArrayList)jsonRowset.get("rows");
        if (rowsVO == null || rowsVO.isEmpty()) {
            return;
        }
        HashMap metaVO = (HashMap)jsonRowset.get("meta");
        int valueIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getValueFieldName().toUpperCase());
        if (valueIndex == -1) {
            valueIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getValueFieldName());
        }
        if ((textIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getTextFieldName().toUpperCase())) == -1) {
            textIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getTextFieldName());
        }
        ArrayList<Entry> list = null;
        ArrayList<Entry> remove = new ArrayList<Entry>();
        if (defautValueIsList) {
            list = (ArrayList<Entry>)defaultValue;
            if (list.isEmpty()) {
                return;
            }
        } else if (defaultValueIsEntry) {
            if (((Entry)defaultValue).getValue() == null) {
                return;
            }
            list = new ArrayList<Entry>();
            list.add((Entry)defaultValue);
        }
        ArrayList firstRow = null;
        block2: for (Entry entry : list) {
            for (int i = 0; i < rowsVO.size(); ++i) {
                ArrayList row = (ArrayList)rowsVO.get(i);
                if (firstRow == null) {
                    firstRow = row;
                }
                if (ExtLightPreviewFilterHandler.valueEq(entry.getValue(), row.get(valueIndex))) continue block2;
                if (i != rowsVO.size()) continue;
                remove.add(entry);
            }
        }
        if (!remove.isEmpty()) {
            list.removeAll(remove);
        }
        if (list.isEmpty()) {
            if (defaultValueIsEntry) {
                if (firstRow != null) {
                    param.setDefaultValue((Object)new Entry(firstRow.get(valueIndex), firstRow.get(textIndex)));
                } else {
                    param.setDefaultValue(null);
                }
            } else if (defautValueIsList && list.isEmpty() && firstRow != null) {
                list.add(new Entry((Object)String.valueOf(firstRow.get(valueIndex)), (Object)String.valueOf(firstRow.get(textIndex))));
            }
        }
    }

    private static boolean valueEq(Object val1, Object val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        return val1.equals(val2);
    }

    private static List<String> getCircularInfo(TreeMap<String, List<String>> paramRef) {
        if (paramRef == null || paramRef.isEmpty()) {
            return null;
        }
        HashMap<String, Node> mapNodes = ExtLightPreviewFilterHandler.createNodes(paramRef);
        List<String> headers = ExtLightPreviewFilterHandler.searchHeader(paramRef);
        String strPath = "";
        ArrayList<String> keyList = new ArrayList<String>();
        for (String header : headers) {
            List<List<Node>> circularPaths = ExtLightPreviewFilterHandler.checkCircular(mapNodes, mapNodes.get(header));
            if (circularPaths == null) continue;
            for (List<Node> path : circularPaths) {
                for (int i = path.size() - 1; i >= 0; --i) {
                    strPath = strPath + path.get(i).getName();
                    if (i <= 0) continue;
                    strPath = strPath + " - ";
                }
                keyList.add(strPath);
                keyList.add(path.get(1).getName());
                strPath = strPath + "/";
            }
        }
        return keyList.isEmpty() ? null : keyList;
    }

    private static HashMap<String, Node> createNodes(TreeMap<String, List<String>> paramRef) {
        HashMap<String, Node> mapNodes = new HashMap<String, Node>();
        Node nodeRoot = new Node("");
        for (String keyName : paramRef.keySet()) {
            Node nodeKey;
            if (mapNodes.containsKey(keyName)) {
                nodeKey = mapNodes.get(keyName);
            } else {
                nodeKey = new Node(keyName);
                nodeRoot.addNextNode(nodeKey);
                mapNodes.put(keyName, nodeKey);
            }
            for (String valueName : paramRef.get(keyName)) {
                Node nodeValue = new Node(valueName);
                if (mapNodes.containsKey(valueName)) {
                    nodeValue = mapNodes.get(valueName);
                } else {
                    mapNodes.put(valueName, nodeValue);
                }
                nodeKey.addNextNode(nodeValue);
            }
        }
        return mapNodes;
    }

    private static List<String> searchHeader(TreeMap<String, List<String>> paramRef) {
        ArrayList<String> headers = new ArrayList<String>();
        for (String key : paramRef.keySet()) {
            boolean isHeader = true;
            for (List<String> values : paramRef.values()) {
                for (String value : values) {
                    if (!key.equals(value)) continue;
                    isHeader = false;
                    break;
                }
                if (isHeader) continue;
                break;
            }
            if (!isHeader) continue;
            headers.add(key);
        }
        if (headers.isEmpty()) {
            headers.add(paramRef.firstKey());
        }
        return headers;
    }

    private static List<List<Node>> checkCircular(HashMap<String, Node> mapNodes, Node node) {
        if (node.isVisited()) {
            return null;
        }
        if (node.isVisiting()) {
            ArrayList<List<Node>> circularPaths = new ArrayList<List<Node>>();
            ArrayList<Node> circularPath = new ArrayList<Node>();
            circularPath.add(node);
            circularPaths.add(circularPath);
            return circularPaths;
        }
        ArrayList<List<Node>> allCircularPaths = null;
        node.setVisiting(true);
        if (node.hasNextNodes()) {
            for (Node nextNode : node.getNextNodes()) {
                List<List<Node>> paths = ExtLightPreviewFilterHandler.checkCircular(mapNodes, nextNode);
                if (paths == null || paths.isEmpty()) continue;
                for (List<Node> path : paths) {
                    if (path.get(0) != null) {
                        path.add(node);
                    }
                    if (allCircularPaths == null) {
                        allCircularPaths = new ArrayList<List<Node>>();
                    }
                    allCircularPaths.add(path);
                }
            }
        }
        node.setVisited(true);
        return allCircularPaths;
    }
}

