/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.eas.mobileaccess.ext.web.client.ExtLightPreviewFilterHandler;
import com.kingdee.eas.mobileaccess.ext.web.client.ExtLightPreviewOrgsForReportHandler;
import com.kingdee.eas.mobileaccess.ext.web.client.ExtLightPreviewReportContentHandler;
import com.kingdee.eas.mobileaccess.ext.web.client.MobilePreviewUtil;
import com.kingdee.eas.mobileaccess.ext.web.lisence.ExtLightRptLisenceScavenger;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.rpt.ExtLightExecuteHandler;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.industry.InnerParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.util.BosContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ExtLightPreviewExecutorHandler
extends ExtLightExecuteHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        ExtLightRptLisenceScavenger.checkModuleLisence(null);
        String rptId = (String)Env.get(Env.Key.rptId);
        HashMap<String, Object> reportItem = new HashMap<String, Object>();
        ExtLightPreviewOrgsForReportHandler.listOrgs(easCtx, rptId, reportItem);
        MobilePreviewUtil.switchOrg((String)((Map)reportItem.get("currentOrg")).get("id"));
        return ExtLightPreviewExecutorHandler.directlyExecute(easCtx, rptId, args[2]);
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter("orgId"), request.getParameter("reportId"), request.getParameter("paramValues")};
    }

    private static MobileResult directlyExecute(Context easCtx, String rptId, String filterJson) throws ExtRptBizException {
        try {
            DesignParameter dp;
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            HashMap<String, Object> data = new HashMap<String, Object>();
            HashMap<Object, Object> params = StringUtil.isEmptyString((String)filterJson) ? new HashMap() : ExtLightPreviewReportContentHandler.parseJSONParams(easCtx, rptId, filterJson);
            boolean isHyperlink = (Boolean)Env.get(Env.Key.isHyperlink);
            if (isHyperlink) {
                return ExtLightPreviewExecutorHandler.hyperlinkTransition(easCtx, rptId, params);
            }
            Book book = adapter.getBook();
            if (book == null) {
                book = MobilePreviewUtil.getBook(rptId);
                adapter.cacheUnionParam(book, easCtx);
            }
            ArrayList sourceParams = adapter.mobileFetchParams();
            for (Object obj : sourceParams) {
                ArrayList mobileCommParams;
                dp = (DesignParameter)obj;
                if (InputType.LABEL == dp.getInputType() || 2 == dp.getInputState().intValue() || dp.isAllowNull() || params.containsKey(dp.getName()) || dp.getDefaultValue() != null) continue;
                ExtLightPreviewExecutorHandler.addCtxOrg(easCtx, data, rptId, false);
                boolean isAllCommonParam = false;
                try {
                    mobileCommParams = adapter.mobileCommParams(easCtx, adapter, rptId);
                    isAllCommonParam = adapter.isAllCommonParam(mobileCommParams);
                }
                catch (Exception e) {
                    throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
                }
                if (adapter.getBook().getCloudRptUuid() != null) {
                    data.put("cloudRptId", adapter.getBook().getCloudRptUuid());
                    data.put("isModifiedTemplate", adapter.getBook().getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") == null);
                    data.put("isAccredited", true);
                }
                data.put("firstPlaceHolder", adapter.getFirstPlaceHolder());
                data.put("lastPlaceholder", adapter.getLastPlaceHolder());
                data.put("isUseLastSaveParam", adapter.isUseLastSaveParam());
                data.put("commonParams", mobileCommParams);
                data.put("isAllCommonParams", isAllCommonParam);
                data.put("hasFilter", true);
                data.put("isRequiredEmpty", true);
                data.put("filter", ExtLightPreviewFilterHandler.loadFilter(easCtx, rptId));
                return new MobileResult(data);
            }
            for (Object obj : sourceParams) {
                dp = (DesignParameter)obj;
                if (InputType.ALONE_CHECKBOX.equals(dp.getInputType())) {
                    DefObj def;
                    IInputCtrl ctrl = dp.getInputCtrl();
                    if ("1".equals(dp.getDefaultValue())) {
                        def = ctrl.getDefValue();
                        dp.setDefaultValue(def.getName());
                        dp.setDefaultAlias(def.getAlias());
                    } else {
                        def = ctrl.getDefDisplay();
                        dp.setDefaultValue(def.getName());
                        dp.setDefaultAlias(def.getAlias());
                    }
                }
                if (!params.containsKey(dp.getName())) {
                    dp.setCurentValue(dp.getDefaultValue());
                    dp.setCurentValueAlias(dp.getDefaultAlias());
                    params.put(dp.getName(), dp);
                }
                if (params.containsKey(dp.getName() + "_text")) continue;
                DesignParameter dp_text = new DesignParameter();
                dp_text.setDataType(DataType.STRING);
                dp_text.setDesignDataType(DesignDataType.TXT);
                dp_text.setName(dp.getName() + "_text");
                dp_text.setCurentValue(dp.getCurentValueAlias());
                dp_text.setIgnoreNull(dp.isIgnoreNull());
                params.put(dp_text.getName(), dp_text);
            }
            InnerParam.putClientDefalutListParamsMapByMobilePreview(params);
            return ExtLightPreviewExecutorHandler.execute(easCtx, rptId, params, adapter, false);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptExecuteException((Throwable)e);
        }
    }

    private static MobileResult hyperlinkTransition(Context easCtx, String rptId, HashMap<String, DesignParameter> params) throws ExtRptBizException {
        InnerParam.putClientDefalutListParamsMapByMobilePreview(params);
        WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
        return ExtLightPreviewExecutorHandler.execute(easCtx, rptId, params, adapter, true);
    }

    private static MobileResult execute(Context easCtx, String rptId, HashMap<String, DesignParameter> params, WebParamAdapter adapter, boolean isHyperlink) throws ExtRptBizException {
        ArrayList mobileCommParams;
        boolean bFilter = false;
        boolean isAllCommonParam = false;
        try {
            bFilter = !adapter.mobileEmptyFilter();
            mobileCommParams = adapter.mobileCommParams(easCtx, adapter, rptId);
            isAllCommonParam = adapter.isAllCommonParam(mobileCommParams);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptFilterVisitException((Throwable)e);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (adapter.getBook().getCloudRptUuid() != null) {
            data.put("cloudRptId", adapter.getBook().getCloudRptUuid());
            data.put("isModifiedTemplate", adapter.getBook().getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") == null);
            data.put("isAccredited", true);
        }
        if (adapter.getBook() != null) {
            int sheetCount = adapter.getBook().getSheetCount();
            for (int i = 0; i < sheetCount; ++i) {
                Sheet sheet = adapter.getBook().getSheet(i);
                int scale = sheet.getSheetOption().getScale();
                if (scale == 100) continue;
                String name2 = sheet.getSheetName();
                data.put(name2 + "_scale", scale);
            }
        }
        data.put("hasFilter", bFilter);
        data.put("commonParams", mobileCommParams);
        data.put("isAllCommonParams", isAllCommonParam);
        data.put("firstPlaceHolder", adapter.getFirstPlaceHolder());
        data.put("lastPlaceholder", adapter.getLastPlaceHolder());
        data.put("isUseLastSaveParam", adapter.isUseLastSaveParam());
        data.put("isRequiredEmpty", false);
        Object info = null;
        info = isHyperlink ? ExtLightPreviewReportContentHandler.executeHyperlinkRpt(easCtx, rptId, params).getData() : ExtLightPreviewReportContentHandler.executeRpt(easCtx, rptId, params).getData();
        data.put("reportContent", info);
        data.put("filter", ExtLightPreviewFilterHandler.loadFilter(easCtx, rptId));
        ExtLightPreviewExecutorHandler.addCtxOrg(easCtx, data, rptId, isHyperlink);
        BosContextUtil.setSysContext(null);
        return new MobileResult(data);
    }

    private static void addCtxOrg(Context easCtx, HashMap<String, Object> data, String rptId, boolean isHyperlink) throws ExtRptBizException {
        String orgId = BosContextUtil.getCurrentOrgId((Context)easCtx);
        String orgName = BosContextUtil.getCurrentOrgName((Context)easCtx);
        if (!isHyperlink) {
            ExtLightPreviewOrgsForReportHandler.listOrgs(easCtx, rptId, data);
        } else {
            data.put("moreOrgs", false);
        }
        HashMap<String, String> ctxOrg = new HashMap<String, String>();
        ctxOrg.put("id", orgId);
        ctxOrg.put("name", orgName);
        data.put("currentOrg", ctxOrg);
    }
}

