/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web.appAuth;

import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.ext.web.common.IResourceMethodHandler;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.ConfigurationItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class ExtLightAppAuthHandler
implements IResourceMethodHandler {
    private static final String ENC = "UTF-8";
    private static final String OPENAUTH_VERSION = "1.1";
    private static final String APPID = "10680";
    private static final String APPSECRET = "boskffwydbb@2017";
    private static final String APPINFO = "appInfo";
    private static final String APPINFO_SECRET = "appSecret";
    private static final String APPINFO_VERSION = "version";
    private static final String APPINFO_APPID = "appid";
    private static final String APPINFO_TICKET = "ticket";

    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        String appid = args[0];
        String appsecret = APPSECRET;
        String version = OPENAUTH_VERSION;
        if (!APPID.equals(appid)) {
            AppInfo info = this.getAppInfoFromConfig(appid);
            if (info == null) {
                return new MobileResult(null);
            }
            appid = info.appid;
            appsecret = info.appSecret;
            version = info.version;
        }
        String appAuth = null;
        try {
            appAuth = ExtLightAppAuthHandler.appAuth2Treaty(appid, appsecret, version);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new MobileResult(appAuth);
    }

    @Override
    public String[] loadArgs(HttpServletRequest request) {
        return new String[]{request.getParameter(APPINFO_APPID), request.getParameter(APPINFO_TICKET)};
    }

    private AppInfo getAppInfoFromConfig(String appid) {
        AppInfo info = new AppInfo();
        info.setAppid(appid);
        XTServiceConfig xtConfig = XTServiceConfig.getInstance();
        ConfigurationItem configurationItemByPath = xtConfig.getConfigurationItemByPath("appInfo/" + appid);
        if (configurationItemByPath != null) {
            Map properties = configurationItemByPath.getProperties();
            if (properties != null && properties.size() > 0) {
                info.setAppSecret((String)properties.get(APPINFO_SECRET));
                info.setVersion((String)properties.get(APPINFO_VERSION));
            }
            return info;
        }
        return null;
    }

    public static String appAuth2Treaty(String appid, String appSecret, String version) throws UnsupportedEncodingException {
        String authorization = "OpenAuth2 version=\\\"%s\\\", appid=\\\"%s\\\", timestamp=%d, nonce=\\\"%s\\\", sign=\\\"%s\\\"";
        appid = URLEncoder.encode(appid, ENC);
        long timestamp = System.currentTimeMillis();
        String nonce = URLEncoder.encode(UUID.randomUUID().toString(), ENC);
        String sign = ExtLightAppAuthHandler.shaHex(version, appid, timestamp + "", nonce, appSecret);
        sign = URLEncoder.encode(sign, ENC);
        authorization = String.format(authorization, version, appid, timestamp, nonce, sign);
        return authorization;
    }

    public static String shaHex(String ... data) {
        Arrays.sort(data);
        String join = StringUtils.join((Object[])data);
        String sign = DigestUtils.shaHex((String)join);
        return sign;
    }

    class AppInfo {
        String appid;
        String appSecret;
        String version;

        AppInfo() {
        }

        public String getAppid() {
            return this.appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

