/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.ext.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.eas.mobileaccess.ext.web.common.ResourceMethodFactory;
import com.kingdee.eas.mobileaccess.ext.web.model.MobileResult;
import com.kingdee.eas.mobileaccess.ext.web.runtime.Env;
import com.kingdee.eas.mobileaccess.ext.web.util.LoginHelper;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ExtMobileRptService {
    private static Logger logger = Logger.getLogger(ExtMobileRptService.class);

    public static MobileResult action(HttpServletRequest request) throws ServletException, IOException {
        return ExtMobileRptService._action(request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MobileResult _action(HttpServletRequest request, boolean needReTry) throws ServletException, IOException {
        Object handler;
        Locale src = Locale.getDefault();
        Locale.setDefault(Locale.CHINA);
        Env.enter();
        try {
            Context easCtx;
            String methodName = request.getParameter("remoteMethod");
            handler = ResourceMethodFactory.methodHandler(methodName);
            Context context = easCtx = ResourceMethodFactory.isCtxIgnoreMethod(methodName) ? (Context)request.getSession().getAttribute("XTContext") : LoginHelper.login(request);
            if (handler == null) {
                MobileResult mobileResult = new MobileResult("no handler for method\uff1a" + methodName, 9999);
                return mobileResult;
            }
            long start = System.currentTimeMillis();
            logger.info((Object)("-------------client request method[" + methodName + "]-------------"));
            MobileResult ret = handler.handle(easCtx, handler.loadArgs(request));
            logger.info((Object)("-------------" + methodName + " service ok(" + (System.currentTimeMillis() - start) + ")-------------"));
            MobileResult mobileResult = ret;
            return mobileResult;
        }
        catch (ExtRptBizException e) {
            if (needReTry && ExtMobileRptService.isSessionInvalidCause(e)) {
                try {
                    LoginHelper.login(request);
                    handler = ExtMobileRptService._action(request, false);
                    return handler;
                }
                catch (ExtRptBizException loginException) {
                    MobileResult mobileResult = new MobileResult("failed to relogin", 10000);
                    return mobileResult;
                }
            }
            logger.error((Object)"function error", (Throwable)e);
            MobileResult mobileResult = new MobileResult(e.getErrorMessage(), e.getErrorCode());
            return mobileResult;
        }
        finally {
            Locale.setDefault(src);
            Env.exit();
        }
    }

    private static boolean isSessionInvalidCause(ExtRptBizException e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof IllegalSessionStateException)) continue;
            return true;
        }
        return false;
    }
}

